/*
 * Decompiled with CFR 0.152.
 */
package cmu.arktweetnlp.impl;

import edu.berkeley.nlp.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;

public class Vocabulary {
    private HashMap<String, Integer> name2num = new HashMap();
    private ArrayList<String> num2name = new ArrayList();
    private boolean isLocked = false;

    Vocabulary() {
    }

    public void lock() {
        this.isLocked = true;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public int size() {
        assert (this.name2num.size() == this.num2name.size());
        return this.name2num.size();
    }

    public int num(String string) {
        if (!this.name2num.containsKey(string)) {
            if (this.isLocked) {
                return -1;
            }
            int n = this.name2num.size();
            this.name2num.put(string, n);
            this.num2name.add(string);
            return n;
        }
        return this.name2num.get(string);
    }

    public String name(int n) {
        if (this.num2name.size() <= n) {
            throw new RuntimeException("Unknown number for vocab: " + n);
        }
        return this.num2name.get(n);
    }

    public boolean contains(String string) {
        return this.name2num.containsKey(string);
    }

    public String toString() {
        return "[" + StringUtils.join(this.num2name) + "]";
    }

    public int numStrict(String string) {
        assert (this.isLocked);
        int n = this.num(string);
        if (n == -1) {
            throw new RuntimeException("OOV happened");
        }
        return n;
    }
}

