/*
 * Decompiled with CFR 0.152.
 */
package cmu.arktweetnlp.impl.features;

import cmu.arktweetnlp.impl.Model;
import cmu.arktweetnlp.impl.ModelSentence;
import cmu.arktweetnlp.impl.Sentence;
import cmu.arktweetnlp.impl.features.MiscFeatures;
import cmu.arktweetnlp.impl.features.WordClusterPaths;
import cmu.arktweetnlp.impl.features.WordListFeatures;
import cmu.arktweetnlp.util.Util;
import edu.stanford.nlp.util.Pair;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class FeatureExtractor {
    private Model model;
    private ArrayList<FeatureExtractorInterface> allFeatureExtractors;
    public boolean isTrainingTime;
    public boolean dumpMode = false;
    public static Logger log = Logger.getLogger("FeatureExtractor");

    public FeatureExtractor(Model model, boolean bl) throws IOException {
        this.model = model;
        this.isTrainingTime = bl;
        assert (model.labelVocab.isLocked());
        this.initializeFeatureExtractors();
    }

    public void computeFeatures(Sentence sentence, ModelSentence modelSentence) {
        int n = sentence.T();
        assert (sentence.T() > 0);
        this.computeObservationFeatures(sentence, modelSentence);
        if (this.isTrainingTime) {
            for (int i = 0; i < n; ++i) {
                modelSentence.labels[i] = this.model.labelVocab.num(sentence.labels.get(i));
            }
            this.computeCheatingEdgeFeatures(sentence, modelSentence);
        }
    }

    private void computeCheatingEdgeFeatures(Sentence sentence, ModelSentence modelSentence) {
        assert (this.isTrainingTime);
        modelSentence.edgeFeatures[0] = this.model.startMarker();
        for (int i = 1; i < sentence.T(); ++i) {
            modelSentence.edgeFeatures[i] = modelSentence.labels[i - 1];
        }
    }

    private void computeObservationFeatures(Sentence sentence, ModelSentence modelSentence) {
        int n;
        PositionFeaturePairs positionFeaturePairs = new PositionFeaturePairs();
        for (FeatureExtractorInterface featureExtractorInterface : this.allFeatureExtractors) {
            featureExtractorInterface.addFeatures(sentence.tokens, positionFeaturePairs);
        }
        for (n = 0; n < positionFeaturePairs.size(); ++n) {
            int n2 = positionFeaturePairs.labelIndexes.get(n);
            Pair<Integer, Double> pair = positionFeaturePairs.featureNames.get(n);
            int n3 = this.model.featureVocab.num((String)pair);
            if (!this.isTrainingTime && n3 == -1) continue;
            double d = positionFeaturePairs.featureValues.get(n);
            modelSentence.observationFeatures.get(n2).add((Pair<Integer, Double>)new Pair((Object)n3, (Object)d));
        }
        if (this.dumpMode) {
            Util.p("");
            for (n = 0; n < sentence.T(); ++n) {
                System.out.printf("%s\n\t", sentence.tokens.get(n));
                for (Pair<Integer, Double> pair : modelSentence.observationFeatures.get(n)) {
                    System.out.printf("%s ", this.model.featureVocab.name((Integer)pair.first));
                }
                System.out.printf("\n", new Object[0]);
            }
        }
    }

    private void initializeFeatureExtractors() throws IOException {
        this.allFeatureExtractors = new ArrayList();
        this.allFeatureExtractors.add(new WordClusterPaths());
        this.allFeatureExtractors.add(new WordListFeatures.POSTagDict());
        this.allFeatureExtractors.add(new WordListFeatures.MetaphonePOSDict());
        this.allFeatureExtractors.add(new MiscFeatures.NgramSuffix(20));
        this.allFeatureExtractors.add(new MiscFeatures.NgramPrefix(20));
        this.allFeatureExtractors.add(new MiscFeatures.PrevWord());
        this.allFeatureExtractors.add(new MiscFeatures.NextWord());
        this.allFeatureExtractors.add(new MiscFeatures.WordformFeatures());
        this.allFeatureExtractors.add(new MiscFeatures.CapitalizationFeatures());
        this.allFeatureExtractors.add(new MiscFeatures.SimpleOrthFeatures());
        this.allFeatureExtractors.add(new MiscFeatures.PrevNext());
        this.allFeatureExtractors.add(new WordListFeatures.Listofnames("proper_names"));
        this.allFeatureExtractors.add(new WordListFeatures.Listofnames("celebs"));
        this.allFeatureExtractors.add(new WordListFeatures.Listofnames("videogame"));
        this.allFeatureExtractors.add(new WordListFeatures.Listofnames("mobyplaces"));
        this.allFeatureExtractors.add(new WordListFeatures.Listofnames("family"));
        this.allFeatureExtractors.add(new WordListFeatures.Listofnames("male"));
        this.allFeatureExtractors.add(new WordListFeatures.Listofnames("female"));
        this.allFeatureExtractors.add(new MiscFeatures.Positions());
    }

    public static class PositionFeaturePairs {
        public ArrayList<Integer> labelIndexes = new ArrayList();
        public ArrayList<String> featureNames = new ArrayList();
        public ArrayList<Double> featureValues = new ArrayList();

        public void add(int n, String string) {
            this.add(n, string, 1.0);
        }

        public void add(int n, String string, double d) {
            this.labelIndexes.add(n);
            this.featureNames.add(string);
            this.featureValues.add(d);
        }

        public int size() {
            return this.featureNames.size();
        }
    }

    public static interface FeatureExtractorInterface {
        public void addFeatures(List<String> var1, PositionFeaturePairs var2);
    }
}

