/*
 * Decompiled with CFR 0.152.
 */
package cmu.arktweetnlp.impl.features;

import cmu.arktweetnlp.Twokenize;
import com.twitter.Regex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FeatureUtil {
    public static Pattern URL = Pattern.compile(Twokenize.OR(Twokenize.url, Twokenize.Email));
    public static Pattern justbase = Pattern.compile("(?!www\\.|ww\\.|w\\.|@)[a-zA-Z0-9]+\\.[A-Za-z0-9\\.]+");
    static Pattern repeatchar = Pattern.compile("([\\w])\\1{1,}");
    static Pattern repeatvowel = Pattern.compile("(a|e|i|o|u)\\1+");

    public static ArrayList<String> normalize(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (String string : list) {
            arrayList.add(FeatureUtil.normalize(string));
        }
        return arrayList;
    }

    public static String normalize(String string) {
        if (URL.matcher(string = string.toLowerCase()).matches()) {
            String string2 = "";
            Matcher matcher = justbase.matcher(string);
            if (matcher.find()) {
                string2 = matcher.group().toLowerCase();
            }
            return "<URL-" + string2 + ">";
        }
        if (Regex.VALID_MENTION_OR_LIST.matcher(string).matches()) {
            return "<@MENTION>";
        }
        return string;
    }

    public static ArrayList<String> normalizecap(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (String string : list) {
            arrayList.add(FeatureUtil.normalizecap(string));
        }
        return arrayList;
    }

    public static String normalizecap(String string) {
        if (URL.matcher(string).matches()) {
            String string2 = "";
            Matcher matcher = justbase.matcher(string);
            if (matcher.find()) {
                string2 = matcher.group().toLowerCase();
            }
            return "<URL-" + string2 + ">";
        }
        if (Regex.VALID_MENTION_OR_LIST.matcher(string).matches()) {
            return "<@MENTION>";
        }
        return string;
    }

    public static ArrayList<String> fuzztoken(String string, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string.replaceAll("[\u2018\u2019\u00b4`]", "'").replaceAll("[\u201c\u201d]", "\""));
        arrayList.add(string);
        arrayList.add(repeatchar.matcher(string).replaceAll("$1"));
        arrayList.add(repeatchar.matcher(string).replaceAll("$1$1"));
        arrayList.add(repeatvowel.matcher(string).replaceAll("$1"));
        if (bl && !string.startsWith("<URL")) {
            arrayList.add(string.replaceAll("\\p{Punct}", ""));
            arrayList.addAll(Arrays.asList(string.split("\\p{Punct}")));
        }
        return arrayList;
    }
}

