/*
 * Decompiled with CFR 0.152.
 */
package cmu.arktweetnlp.impl.features;

import cmu.arktweetnlp.impl.features.FeatureExtractor;
import java.util.List;
import org.apache.commons.codec.language.DoubleMetaphone;
import org.apache.commons.codec.language.Metaphone;

public class MetaphoneFeatures {
    private static Metaphone _metaphone = null;
    private static DoubleMetaphone dblmetaphone = null;

    public static Metaphone getMetaphone() {
        if (_metaphone == null) {
            _metaphone = new Metaphone();
            _metaphone.setMaxCodeLen(100);
        }
        return _metaphone;
    }

    public static DoubleMetaphone getDblMetaphone() {
        if (dblmetaphone == null) {
            dblmetaphone = new DoubleMetaphone();
            dblmetaphone.setMaxCodeLen(100);
        }
        return dblmetaphone;
    }

    private String MetaphoneNum(String string) {
        StringBuilder stringBuilder = new StringBuilder(string);
        if (string.charAt(string.length() - 1) == '1') {
            stringBuilder.deleteCharAt(string.length() - 1).append("one");
        }
        if (string.charAt(0) == '1') {
            stringBuilder.deleteCharAt(0).insert(0, "one");
        }
        if (string.charAt(0) == '2') {
            stringBuilder.deleteCharAt(0).insert(0, "two");
        } else if (string.charAt(0) == '4') {
            stringBuilder.deleteCharAt(0).insert(0, "four");
        }
        return stringBuilder.toString();
    }

    public static class MetaphoneLexical
    implements FeatureExtractor.FeatureExtractorInterface {
        @Override
        public void addFeatures(List<String> list, FeatureExtractor.PositionFeaturePairs positionFeaturePairs) {
            for (int i = 0; i < list.size(); ++i) {
                String string = list.get(i);
                if (string.length() <= 1) continue;
                String string2 = MetaphoneFeatures.getDblMetaphone().encode(string);
                String string3 = MetaphoneFeatures.getDblMetaphone().doubleMetaphone(string, true);
                positionFeaturePairs.add(i, "metaphone_word|" + string2);
                if (string2.equals(string3)) continue;
                positionFeaturePairs.add(i, "metaphone_word|" + string3);
            }
        }
    }
}

