/*
 * Decompiled with CFR 0.152.
 */
package cmu.arktweetnlp.impl.features;

import cmu.arktweetnlp.Twokenize;
import cmu.arktweetnlp.impl.features.FeatureExtractor;
import cmu.arktweetnlp.impl.features.FeatureUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class MiscFeatures {

    public static class Positions
    implements FeatureExtractor.FeatureExtractorInterface {
        @Override
        public void addFeatures(List<String> list, FeatureExtractor.PositionFeaturePairs positionFeaturePairs) {
            int n;
            for (n = 0; n < Math.min(list.size(), 4); ++n) {
                positionFeaturePairs.add(n, "t=" + n);
            }
            for (n = list.size() - 1; n > Math.max(list.size() - 4, -1); --n) {
                positionFeaturePairs.add(n, "t=-" + n);
            }
        }
    }

    public static class NgramSuffix
    implements FeatureExtractor.FeatureExtractorInterface {
        int ngram = 3;

        public NgramSuffix(int n) {
            this.ngram = n;
        }

        @Override
        public void addFeatures(List<String> list, FeatureExtractor.PositionFeaturePairs positionFeaturePairs) {
            for (int i = 0; i < list.size(); ++i) {
                String string = FeatureUtil.normalize(list.get(i).replaceAll("[\u2018\u2019\u00b4`]", "'").replaceAll("[\u201c\u201d]", "\""));
                int n = string.length();
                for (int j = 1; j <= this.ngram && n >= j; ++j) {
                    positionFeaturePairs.add(i, j + "gramSuff|" + string.substring(n - j, n));
                }
            }
        }
    }

    public static class NgramPrefix
    implements FeatureExtractor.FeatureExtractorInterface {
        int ngram = 3;

        public NgramPrefix(int n) {
            this.ngram = n;
        }

        @Override
        public void addFeatures(List<String> list, FeatureExtractor.PositionFeaturePairs positionFeaturePairs) {
            for (int i = 0; i < list.size(); ++i) {
                String string = FeatureUtil.normalize(list.get(i).replaceAll("[\u2018\u2019\u00b4`]", "'").replaceAll("[\u201c\u201d]", "\""));
                int n = string.length();
                for (int j = 1; j <= this.ngram && n >= j; ++j) {
                    positionFeaturePairs.add(i, j + "gramPref|" + string.substring(0, j));
                }
            }
        }
    }

    public static class WordformFeatures
    implements FeatureExtractor.FeatureExtractorInterface {
        @Override
        public void addFeatures(List<String> list, FeatureExtractor.PositionFeaturePairs positionFeaturePairs) {
            for (int i = 0; i < list.size(); ++i) {
                String string = list.get(i);
                String string2 = string.replaceAll("[\u2018\u2019\u00b4`]", "'").replaceAll("[\u201c\u201d]", "\"");
                positionFeaturePairs.add(i, "Word|" + string2);
                positionFeaturePairs.add(i, "Lower|" + FeatureUtil.normalize(string2));
                positionFeaturePairs.add(i, "Xxdshape|" + this.Xxdshape(string2), 0.5);
                positionFeaturePairs.add(i, "charclass|" + this.charclassshape(string), 0.5);
            }
        }

        private String Xxdshape(String string) {
            String string2 = string.replaceAll("[a-z]", "x").replaceAll("[0-9]", "d").replaceAll("[A-Z]", "X");
            return string2;
        }

        private String charclassshape(String string) {
            StringBuilder stringBuilder = new StringBuilder(3 * string.length());
            for (int i = 0; i < string.length(); ++i) {
                stringBuilder.append(Character.getType(string.codePointAt(i))).append(',');
            }
            return stringBuilder.toString();
        }
    }

    public static class URLFeatures
    implements FeatureExtractor.FeatureExtractorInterface {
        Pattern validURL = Pattern.compile(Twokenize.url);
        Pattern validEmail = Pattern.compile(Twokenize.Email);

        @Override
        public void addFeatures(List<String> list, FeatureExtractor.PositionFeaturePairs positionFeaturePairs) {
            for (int i = 0; i < list.size(); ++i) {
                String string = list.get(i);
                if (this.validURL.matcher(string).matches()) {
                    positionFeaturePairs.add(i, "validURL");
                }
                if (!this.validEmail.matcher(string).matches()) continue;
                positionFeaturePairs.add(i, "validURL");
            }
        }
    }

    public static class SimpleOrthFeatures
    implements FeatureExtractor.FeatureExtractorInterface {
        public Pattern hasDigit = Pattern.compile("[0-9]");
        Pattern allPunct = Pattern.compile("^\\W*$");
        Pattern emoticon = Pattern.compile(Twokenize.emoticon);

        @Override
        public void addFeatures(List<String> list, FeatureExtractor.PositionFeaturePairs positionFeaturePairs) {
            for (int i = 0; i < list.size(); ++i) {
                String[] stringArray;
                String string = list.get(i);
                if (this.hasDigit.matcher(string).find()) {
                    positionFeaturePairs.add(i, "HasDigit");
                }
                if (string.charAt(0) == '@') {
                    positionFeaturePairs.add(i, "InitAt");
                }
                if (string.charAt(0) == '#') {
                    positionFeaturePairs.add(i, "InitHash");
                }
                if (this.emoticon.matcher(string).matches()) {
                    positionFeaturePairs.add(i, "Emoticon");
                }
                if (!string.contains("-")) continue;
                positionFeaturePairs.add(i, "Hyphenated");
                for (String string2 : stringArray = FeatureUtil.normalize(string).split("-", 2)) {
                    positionFeaturePairs.add(i, "hyph|" + string2);
                }
            }
        }
    }

    public static class CapitalizationFeatures
    implements FeatureExtractor.FeatureExtractorInterface {
        @Override
        public void addFeatures(List<String> list, FeatureExtractor.PositionFeaturePairs positionFeaturePairs) {
            for (int i = 0; i < list.size(); ++i) {
                String string;
                boolean bl;
                int n;
                String string2 = list.get(i);
                int n2 = 0;
                int n3 = 0;
                for (n = 0; n < string2.length(); ++n) {
                    n2 += Character.isLetter(string2.charAt(n)) ? 1 : 0;
                    n3 += Character.isUpperCase(string2.charAt(n)) ? 1 : 0;
                }
                n = n2 == n3 ? 1 : 0;
                boolean bl2 = n != 0 && n2 <= 1;
                boolean bl3 = n != 0 && n2 >= 2;
                boolean bl4 = n == 0 && n2 >= 2 && Character.isUpperCase(string2.charAt(0)) && n3 == 1;
                boolean bl5 = bl = n3 >= 1 && n2 >= 2 && string2.charAt(0) != '@' && !string2.startsWith("http://");
                String string3 = bl2 ? "shortcap" : (bl3 ? "longcap" : (bl4 ? "initcap" : (string = bl ? "mixcap" : "nocap")));
                if (string == null || n2 < 1) continue;
                if (string2.endsWith("'s")) {
                    string = "pos-" + string;
                } else if (i == 0) {
                    string = "first-" + string;
                }
                positionFeaturePairs.add(i, string + "");
            }
        }
    }

    public static class PrevNext
    implements FeatureExtractor.FeatureExtractorInterface {
        @Override
        public void addFeatures(List<String> list, FeatureExtractor.PositionFeaturePairs positionFeaturePairs) {
            ArrayList<String> arrayList = FeatureUtil.normalize(list);
            if (list.size() > 1) {
                positionFeaturePairs.add(0, "prevnext|<START>|" + arrayList.get(1));
                for (int i = 1; i < arrayList.size() - 1; ++i) {
                    positionFeaturePairs.add(i, "prevnext|" + arrayList.get(i - 1) + "|" + arrayList.get(i + 1));
                }
                positionFeaturePairs.add(arrayList.size() - 1, "prevnext|" + arrayList.get(list.size() - 2) + "|<END>");
            }
        }
    }

    public static class Prev2Words
    implements FeatureExtractor.FeatureExtractorInterface {
        @Override
        public void addFeatures(List<String> list, FeatureExtractor.PositionFeaturePairs positionFeaturePairs) {
            if (list.size() > 1) {
                ArrayList<String> arrayList = FeatureUtil.normalize(list);
                positionFeaturePairs.add(1, "prev2words|<START>|" + arrayList.get(0) + "|" + arrayList.get(1));
                for (int i = 2; i < list.size(); ++i) {
                    positionFeaturePairs.add(i, "prev2words|" + list.get(i - 2) + "|" + list.get(i - 1));
                    positionFeaturePairs.add(i, "prev2words|" + arrayList.get(i - 2) + "|" + arrayList.get(i - 1));
                }
            }
        }
    }

    public static class PrevWord
    implements FeatureExtractor.FeatureExtractorInterface {
        @Override
        public void addFeatures(List<String> list, FeatureExtractor.PositionFeaturePairs positionFeaturePairs) {
            ArrayList<String> arrayList = FeatureUtil.normalize(list);
            positionFeaturePairs.add(0, "prevword|<START>");
            positionFeaturePairs.add(0, "prevcurr|<START>|" + arrayList.get(0));
            for (int i = 1; i < list.size(); ++i) {
                positionFeaturePairs.add(i, "prevword|" + list.get(i - 1));
                positionFeaturePairs.add(i, "prevword|" + arrayList.get(i - 1));
                positionFeaturePairs.add(i, "prevcurr|" + arrayList.get(i - 1) + "|" + arrayList.get(i));
            }
        }
    }

    public static class Next2Words
    implements FeatureExtractor.FeatureExtractorInterface {
        @Override
        public void addFeatures(List<String> list, FeatureExtractor.PositionFeaturePairs positionFeaturePairs) {
            if (list.size() > 1) {
                ArrayList<String> arrayList = FeatureUtil.normalize(list);
                for (int i = 0; i < list.size() - 2; ++i) {
                    positionFeaturePairs.add(i, "next2words|" + list.get(i + 1) + "|" + list.get(i + 2), 0.5);
                    positionFeaturePairs.add(i, "next2words|" + arrayList.get(i + 1) + "|" + arrayList.get(i + 2), 0.5);
                }
                positionFeaturePairs.add(list.size() - 2, "next2words|" + arrayList.get(list.size() - 1) + "|<END>", 0.5);
                positionFeaturePairs.add(list.size() - 2, "next2words|" + list.get(list.size() - 1) + "|<END>", 0.5);
            }
        }
    }

    public static class NextWord
    implements FeatureExtractor.FeatureExtractorInterface {
        @Override
        public void addFeatures(List<String> list, FeatureExtractor.PositionFeaturePairs positionFeaturePairs) {
            ArrayList<String> arrayList = FeatureUtil.normalize(list);
            for (int i = 0; i < list.size() - 1; ++i) {
                positionFeaturePairs.add(i, "nextword|" + list.get(i + 1), 0.5);
                positionFeaturePairs.add(i, "nextword|" + arrayList.get(i + 1), 0.5);
                positionFeaturePairs.add(i, "currnext|" + arrayList.get(i) + "|" + arrayList.get(i + 1));
            }
            positionFeaturePairs.add(list.size() - 1, "currnext|" + arrayList.get(list.size() - 1) + "|<END>");
            positionFeaturePairs.add(list.size() - 1, "nextword|<END>");
        }
    }
}

