/*
 * Decompiled with CFR 0.152.
 */
package cmu.arktweetnlp.impl.features;

import cmu.arktweetnlp.impl.features.FeatureExtractor;
import cmu.arktweetnlp.impl.features.FeatureUtil;
import cmu.arktweetnlp.util.BasicFileIO;
import edu.stanford.nlp.util.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class WordClusterPaths
implements FeatureExtractor.FeatureExtractorInterface {
    public static String clusterResourceName = "/cmu/arktweetnlp/50mpaths2";
    public static HashMap<String, String> wordToPath;

    public WordClusterPaths() throws IOException {
        BufferedReader bufferedReader = BasicFileIO.getResourceReader(clusterResourceName);
        String[] stringArray = new String[3];
        String string = BasicFileIO.getLine(bufferedReader);
        wordToPath = new HashMap();
        while (string != null) {
            stringArray = string.split("\\t");
            wordToPath.put(stringArray[1], stringArray[0]);
            string = BasicFileIO.getLine(bufferedReader);
        }
    }

    @Override
    public void addFeatures(List<String> list, FeatureExtractor.PositionFeaturePairs positionFeaturePairs) {
        String string = null;
        for (int i = 0; i < list.size(); ++i) {
            int n;
            String string2 = list.get(i);
            String string3 = FeatureUtil.normalize(string2);
            string = wordToPath.get(string3);
            if (string == null) {
                String string4;
                Iterator<String> iterator = FeatureUtil.fuzztoken(string3, true).iterator();
                while (iterator.hasNext() && (string = wordToPath.get(string4 = iterator.next())) == null) {
                }
            }
            if (string == null) continue;
            string = StringUtils.pad((String)string, (int)16).replace(' ', '0');
            for (n = 2; n <= 16; n += 2) {
                positionFeaturePairs.add(i, "BigCluster|" + string.substring(0, n));
            }
            if (i < list.size() - 1) {
                for (n = 4; n <= 12; n += 4) {
                    positionFeaturePairs.add(i + 1, "PrevBigCluster|" + string.substring(0, n));
                }
            }
            if (i <= 0) continue;
            for (n = 4; n <= 12; n += 4) {
                positionFeaturePairs.add(i - 1, "NextBigCluster|" + string.substring(0, n));
            }
        }
    }
}

