/*
 * Decompiled with CFR 0.152.
 */
package cmu.arktweetnlp.impl.features;

import cmu.arktweetnlp.Twokenize;
import cmu.arktweetnlp.impl.features.FeatureExtractor;
import cmu.arktweetnlp.impl.features.FeatureUtil;
import cmu.arktweetnlp.impl.features.MetaphoneFeatures;
import cmu.arktweetnlp.impl.features.TagDictionary;
import cmu.arktweetnlp.util.BasicFileIO;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

public class WordListFeatures {
    private static HashSet<String> initDict(String string) throws IOException {
        BufferedReader bufferedReader = BasicFileIO.getResourceReader("/cmu/arktweetnlp/" + string);
        HashSet<String> hashSet = new HashSet<String>();
        String string2 = BasicFileIO.getLine(bufferedReader);
        while (string2 != null) {
            hashSet.add(string2.toLowerCase());
            string2 = BasicFileIO.getLine(bufferedReader);
        }
        return hashSet;
    }

    public static class MetaphonePOSDict
    implements FeatureExtractor.FeatureExtractorInterface {
        @Override
        public void addFeatures(List<String> list, FeatureExtractor.PositionFeaturePairs positionFeaturePairs) {
            for (int i = 0; i < list.size(); ++i) {
                String string = list.get(i);
                if (string.length() <= 1) continue;
                String string2 = MetaphoneFeatures.getMetaphone().encode(string);
                String string3 = String.format("**MP**%s", string2);
                if (!TagDictionary.WORD_TO_POS.containsKey(string3)) continue;
                List<String> list2 = TagDictionary.WORD_TO_POS.get(string3);
                for (String string4 : list2) {
                    positionFeaturePairs.add(i, "metaph_POSDict|" + string4);
                }
            }
        }
    }

    public static class Listofnames
    implements FeatureExtractor.FeatureExtractorInterface {
        String Listname = "";
        HashSet<String> members;

        public Listofnames(String string) throws IOException {
            this.Listname = string;
            this.members = WordListFeatures.initDict(this.Listname);
        }

        @Override
        public void addFeatures(List<String> list, FeatureExtractor.PositionFeaturePairs positionFeaturePairs) {
            for (int i = 0; i < list.size(); ++i) {
                String string = list.get(i);
                String string2 = string.toLowerCase().replaceAll("[\u2018\u2019\u00b4`]", "'").replaceAll("[\u201c\u201d]", "\"");
                if (!this.members.contains(string2)) continue;
                positionFeaturePairs.add(i, this.Listname);
            }
        }
    }

    public static class POSTagDict
    implements FeatureExtractor.FeatureExtractorInterface {
        Pattern URL = Pattern.compile(Twokenize.url);
        Pattern letter = Pattern.compile("[A-Za-z]{3,}");

        @Override
        public void addFeatures(List<String> list, FeatureExtractor.PositionFeaturePairs positionFeaturePairs) {
            for (int i = 0; i < list.size(); ++i) {
                String string;
                String string2 = list.get(i);
                List<String> list2 = TagDictionary.WORD_TO_POS.get(string2);
                if (list2 == null && this.letter.matcher(string2).find() && !this.URL.matcher(string2).matches() && (list2 = TagDictionary.WORD_TO_POS.get(string = FeatureUtil.normalizecap(string2))) == null) {
                    String string3;
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.addAll(FeatureUtil.fuzztoken(string, true));
                    arrayList.addAll(FeatureUtil.fuzztoken(FeatureUtil.normalize(string2), true));
                    Iterator iterator = arrayList.iterator();
                    while (iterator.hasNext() && (list2 = TagDictionary.WORD_TO_POS.get(string3 = (String)iterator.next())) == null) {
                    }
                }
                if (list2 == null) continue;
                positionFeaturePairs.add(i, "POSTagDict|" + list2.get(0));
                if (i > 0) {
                    positionFeaturePairs.add(i - 1, "NextPOSTag|" + list2.get(0));
                }
                if (i < list.size() - 1) {
                    positionFeaturePairs.add(i + 1, "PrevPOSTag|" + list2.get(0));
                }
                for (int j = 1; j < list2.size(); ++j) {
                    positionFeaturePairs.add(i, "POSTagDict|" + list2.get(j), ((double)list2.size() - (double)j) / (double)list2.size());
                }
            }
        }
    }
}

