/*
 * Decompiled with CFR 0.152.
 */
package cmu.arktweetnlp.util;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class BasicFileIO {
    private static Logger log = Logger.getLogger(BasicFileIO.class.getCanonicalName());

    public static BufferedReader openFileToRead(String string) {
        try {
            BufferedReader bufferedReader = null;
            bufferedReader = string.endsWith(".gz") ? new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(string)))) : new BufferedReader(new FileReader(string));
            return bufferedReader;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            log.severe("Could not open file:" + string);
            System.exit(-1);
            return null;
        }
    }

    public static BufferedReader openFileToReadUTF8(String string) {
        try {
            BufferedReader bufferedReader = null;
            bufferedReader = string.endsWith(".gz") ? new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream(new FileInputStream(string)), "UTF-8")) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), "UTF-8"));
            return bufferedReader;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            log.severe("Could not open file:" + string);
            System.exit(-1);
            return null;
        }
    }

    public static BufferedWriter openFileToWrite(String string) {
        try {
            BufferedWriter bufferedWriter = null;
            bufferedWriter = string.endsWith(".gz") ? new BufferedWriter(new OutputStreamWriter(new GZIPOutputStream(new FileOutputStream(string)))) : new BufferedWriter(new FileWriter(string));
            return bufferedWriter;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            log.severe("Could not open file for writing:" + string);
            System.exit(-1);
            return null;
        }
    }

    public static BufferedWriter openFileToWriteUTF8(String string) {
        try {
            BufferedWriter bufferedWriter = null;
            bufferedWriter = string.endsWith(".gz") ? new BufferedWriter(new OutputStreamWriter((OutputStream)new GZIPOutputStream(new FileOutputStream(string)), "UTF-8")) : new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string), "UTF-8"));
            return bufferedWriter;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            log.severe("Could not open file for writing:" + string);
            System.exit(-1);
            return null;
        }
    }

    public static void closeFileAlreadyRead(BufferedReader bufferedReader) {
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            log.severe("Could not close file.");
            System.exit(-1);
        }
    }

    public static void closeFileAlreadyWritten(BufferedWriter bufferedWriter) {
        try {
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            log.severe("Could not close file.");
            System.exit(-1);
        }
    }

    public static String getLine(BufferedReader bufferedReader) {
        try {
            String string = bufferedReader.readLine();
            return string;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            log.severe("Could not read line from file.");
            System.exit(-1);
            return null;
        }
    }

    public static String getLine(JsonParser jsonParser) {
        try {
            while (jsonParser.getText() != null) {
                if ("hashtags".equals(jsonParser.getCurrentName()) | "retweeted_status".equals(jsonParser.getCurrentName())) {
                    jsonParser.nextToken();
                    jsonParser.skipChildren();
                }
                if ("text".equals(jsonParser.getCurrentName())) {
                    jsonParser.nextToken();
                    String string = jsonParser.getText();
                    jsonParser.nextToken();
                    if (string.length() > 0) {
                        return string;
                    }
                }
                jsonParser.nextToken();
            }
        }
        catch (JsonParseException jsonParseException) {
            jsonParseException.printStackTrace();
            log.severe("Error parsing JSON.");
            System.exit(-1);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            log.severe("Could not read line from file.");
            System.exit(-1);
        }
        return null;
    }

    public static void writeLine(BufferedWriter bufferedWriter, String string) {
        try {
            bufferedWriter.write(string + "\n");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            log.severe("Could not write line to file.");
            System.exit(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeSerializedObject(String string, Object object) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(bufferedOutputStream);){
                objectOutputStream.writeObject(object);
            }
        }
        catch (IOException iOException) {
            log.severe("Cannot perform output.");
            iOException.printStackTrace();
            System.exit(-1);
        }
    }

    public static Object readSerializedObject(String string) {
        try {
            return BasicFileIO.readSerializedObject(new FileInputStream(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            log.severe("Cannot perform input.");
            throw new RuntimeException(fileNotFoundException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object readSerializedObject(InputStream inputStream) {
        Object object = null;
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            try (ObjectInputStream objectInputStream = new ObjectInputStream(bufferedInputStream);){
                object = objectInputStream.readObject();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            log.severe("Cannot perform input.");
            throw new RuntimeException(classNotFoundException);
        }
        catch (IOException iOException) {
            log.severe("Cannot perform input.");
            throw new RuntimeException(iOException);
        }
        return object;
    }

    public static BufferedReader getResourceReader(String string) throws IOException {
        assert (string.startsWith("/")) : "Absolute path needed for resource";
        InputStream inputStream = BasicFileIO.class.getResourceAsStream(string);
        if (inputStream == null) {
            throw new IOException("failed to find resource " + string);
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, Charset.forName("UTF-8")));
        return bufferedReader;
    }

    public static BufferedReader openFileOrResource(String string) throws IOException {
        try {
            if (new File(string).exists()) {
                return BasicFileIO.openFileToReadUTF8(string);
            }
            return BasicFileIO.getResourceReader(string);
        }
        catch (IOException iOException) {
            throw new IOException("Neither file nor resource found for: " + string);
        }
    }
}

