/*
 * Decompiled with CFR 0.152.
 */
package edu.cnu.cs.gooey;

import edu.cnu.cs.gooey.GooeyDisplayable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JTabbedPane;

public class Gooey {
    private static final String BUILD_VERSION = "1.8.0";
    private static final Function<Component, Tree> retrieveComponents = new Function<Component, Tree>(){

        @Override
        public Tree apply(Component component) {
            Tree result = new Tree(component);
            if (component instanceof Container) {
                Container container = (Container)component;
                Stream.of(container.getComponents()).map(c -> this.apply((Component)c)).forEach(t -> result.add((Tree)t));
            }
            return result;
        }
    };
    private static final Function<Component, Tree> retrieveMenus = new Function<Component, Tree>(){

        @Override
        public Tree apply(Component component) {
            Tree result = new Tree(component);
            if (component instanceof Container) {
                Component[] children;
                if (component instanceof JMenu) {
                    JMenu menu = (JMenu)component;
                    children = menu.getMenuComponents();
                } else {
                    Container container = (Container)component;
                    children = container.getComponents();
                }
                Stream.of(children).map(c -> this.apply((Component)c)).forEach(t -> result.add((Tree)t));
            }
            return result;
        }
    };

    public static void main(String[] args) {
        System.out.println(BUILD_VERSION);
    }

    private Gooey() {
    }

    public static final String getVersion() {
        return BUILD_VERSION;
    }

    public static Component getTab(JTabbedPane tabPane, String title) {
        return Gooey.getTab(tabPane, title, Match.BY_LABEL);
    }

    public static Component getTab(JTabbedPane tabPane, String string, Match flag) {
        Supplier<String> notFound = () -> String.format("Tab \"%s\" not found (searched %s)", new Object[]{string, flag});
        Optional<Component> result = IntStream.range(0, tabPane.getTabCount()).filter(i -> string.equals(flag == Match.BY_LABEL ? tabPane.getTitleAt(i) : tabPane.getComponentAt(i).getName())).mapToObj(i -> tabPane.getComponentAt(i)).findAny();
        if (result.isPresent()) {
            return result.get();
        }
        throw new AssertionError((Object)notFound.get());
    }

    public static JLabel getLabel(Container container, String text) {
        return Gooey.getLabel(container, text, Match.BY_LABEL);
    }

    public static JLabel getLabel(Container container, String string, Match flag) {
        Supplier<String> notFound = () -> String.format("Label \"%s\" not found (searched %s)", new Object[]{string, flag});
        return Gooey.getComponent(notFound, container, JLabel.class, l -> string.equals(flag == Match.BY_LABEL ? l.getText() : l.getName()), retrieveComponents);
    }

    public static JButton getButton(Container container, String text) {
        return Gooey.getButton(container, text, Match.BY_LABEL);
    }

    public static JButton getButton(Container container, String string, Match flag) {
        Supplier<String> notFound = () -> String.format("Button \"%s\" not found (searched %s)", new Object[]{string, flag});
        return Gooey.getComponent(notFound, container, JButton.class, b -> string.equals(flag == Match.BY_LABEL ? b.getText() : b.getName()), retrieveComponents);
    }

    public static JMenuBar getMenuBar(JFrame frame) {
        JMenuBar menubar = frame.getJMenuBar();
        if (menubar == null) {
            throw new AssertionError((Object)"Menubar not found");
        }
        return menubar;
    }

    public static JMenu getMenu(JMenuBar menubar, String text) {
        return Gooey.getMenu(menubar, text, Match.BY_LABEL);
    }

    public static JMenu getMenu(JMenuBar menubar, String string, Match flag) {
        return Gooey.getMenu(menubar, JMenu.class, string, flag);
    }

    public static <T extends JMenuItem> T getMenu(JMenu menu, String text) {
        return Gooey.getMenu(menu, text, Match.BY_LABEL);
    }

    public static <T extends JMenuItem> T getMenu(JMenu menu, String string, Match flag) {
        return (T)Gooey.getMenu(menu, JMenuItem.class, string, flag);
    }

    private static <T extends JMenuItem> T getMenu(Container menu, Class<T> type, String string, Match flag) {
        Supplier<String> notFound = () -> String.format("Menu \"%s\" not found (searched %s)", new Object[]{string, flag});
        return (T)Gooey.getComponent(notFound, menu, type, m -> string.equals(flag == Match.BY_LABEL ? m.getText() : m.getName()), retrieveMenus);
    }

    public static List<JMenu> getMenus(JMenuBar menubar) {
        return IntStream.range(0, menubar.getMenuCount()).mapToObj(i -> menubar.getMenu(i)).collect(Collectors.toList());
    }

    public static List<JMenuItem> getMenus(JMenu menu) {
        return Stream.of(menu.getMenuComponents()).filter(c -> c instanceof JMenuItem).map(c -> (JMenuItem)c).collect(Collectors.toList());
    }

    public static <T extends Component> T getComponent(Container container, Class<T> type) {
        Supplier<String> notFound = () -> String.format("Component \"%s\" not found", type.getName());
        return (T)Gooey.getComponent(notFound, container, type, t -> true, retrieveComponents);
    }

    public static <T extends Component> T getComponent(Container container, Class<T> type, String name) {
        Supplier<String> notFound = () -> String.format("No \"%s\" component \"%s\" found (searched %s)", new Object[]{type.getName(), name, Match.BY_NAME});
        return (T)Gooey.getComponent(notFound, container, type, t -> name.equals(t.getName()), retrieveComponents);
    }

    private static <T extends Component> T getComponent(Supplier<String> notFound, Container container, Class<T> type, Predicate<T> criteria, Function<Component, Tree> retrieveFrom) {
        Optional<T> result = Gooey.getComponentStream(container, type, criteria, retrieveFrom).findAny();
        if (result.isPresent()) {
            return (T)((Component)result.get());
        }
        throw new AssertionError((Object)notFound.get());
    }

    public static <T extends Component> List<T> getComponents(Container container, Class<T> type) {
        return Gooey.getComponents(container, type, c -> true);
    }

    public static <T extends Component> List<T> getComponents(Container container, Class<T> type, Predicate<T> criteria) {
        return Gooey.getComponents(container, type, criteria, retrieveComponents);
    }

    private static <T extends Component> List<T> getComponents(Container container, Class<T> type, Predicate<T> criteria, Function<Component, Tree> retrieveFrom) {
        return Gooey.getComponentStream(container, type, criteria, retrieveFrom).collect(Collectors.toList());
    }

    private static <T extends Component> Stream<T> getComponentStream(Container container, Class<T> type, Predicate<T> criteria, Function<Component, Tree> retrieveFrom) {
        Tree tree = retrieveFrom.apply(container);
        return tree.flattened().map(Tree::getComponent).filter(c -> type.isInstance(c)).map(c -> c).filter(criteria);
    }

    public static synchronized <T extends GooeyDisplayable<U>, U extends Window> void capture(T displayable) {
        displayable.capture();
    }

    private static class Tree {
        private Component self;
        private List<Tree> children;

        public Tree(Component self) {
            this.self = self;
            this.children = new LinkedList<Tree>();
        }

        public Component getComponent() {
            return this.self;
        }

        public void add(Tree child) {
            this.children.add(child);
        }

        public Stream<Tree> flattened() {
            return Stream.concat(Stream.of(this), this.children.stream().flatMap(Tree::flattened));
        }
    }

    public static enum Match {
        BY_NAME("by name"),
        BY_LABEL("by label");

        private String string;

        private Match(String string2) {
            this.string = string2;
        }

        public String toString() {
            return this.string;
        }
    }
}

