/*
 * Decompiled with CFR 0.152.
 */
package edu.cnu.cs.gooey;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public abstract class GooeyDisplayable<T> {
    private final String noWindowMessage;
    private static final long TIMEOUT_DEFAULT_FIRST = 3000L;
    private static final long TIMEOUT_DEFAULT = 1000L;
    private static boolean TIMEOUT_FIRST = true;

    public abstract void invoke();

    public abstract void test(T var1);

    protected abstract void close(T var1);

    protected abstract void setEnableCapture(boolean var1);

    protected abstract T getTarget();

    protected GooeyDisplayable(String noWindowMessage) {
        if (noWindowMessage == null) {
            throw new IllegalArgumentException("parameter cannot be null");
        }
        this.noWindowMessage = noWindowMessage;
    }

    protected long getTimeout() {
        if (TIMEOUT_FIRST) {
            TIMEOUT_FIRST = false;
            return 3000L;
        }
        return 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void capture() {
        this.setEnableCapture(true);
        ExecutorService executor = Executors.newCachedThreadPool();
        ExecutorCompletionService<Object> completion = new ExecutorCompletionService<Object>(executor);
        Future<Object> invoke = completion.submit(() -> {
            this.invoke();
            return null;
        });
        Future<Object> capture = completion.submit(() -> this.getTarget());
        Future<Object> timeout = completion.submit(() -> {
            Thread.sleep(this.getTimeout());
            return null;
        });
        try {
            do {
                Future done;
                if (invoke == (done = completion.take())) {
                    invoke.get();
                }
                if (timeout == done) {
                    throw new AssertionError((Object)this.noWindowMessage);
                }
            } while (!capture.isDone());
            Object captured = capture.get();
            try {
                this.test(captured);
            }
            finally {
                Thread.sleep(200L);
                this.close(captured);
            }
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            this.setEnableCapture(false);
        }
    }
}

