/*
 * Decompiled with CFR 0.152.
 */
package edu.cnu.cs.gooey;

import edu.cnu.cs.gooey.GooeyDisplayable;
import edu.cnu.cs.gooey.GooeySwingToolkitListener;
import java.awt.AWTEvent;
import java.awt.Window;
import java.util.function.Predicate;
import javax.swing.SwingUtilities;

public abstract class GooeyWindow<T extends Window>
extends GooeyDisplayable<T> {
    private final GooeySwingToolkitListener<T> listener;

    protected GooeyWindow(Class<T> type, String noWindowMessage) {
        super(noWindowMessage);
        if (type == null) {
            throw new IllegalArgumentException("parameter cannot be null");
        }
        Predicate<AWTEvent> captureCriteria = e -> type.isInstance(e.getSource()) && e.getID() == 200;
        this.listener = new GooeySwingToolkitListener(captureCriteria);
    }

    @Override
    protected final void setEnableCapture(boolean on) {
        this.listener.setEnableCapture(on);
    }

    @Override
    protected void close(T window) {
        SwingUtilities.invokeLater(() -> window.setVisible(false));
    }

    @Override
    protected T getTarget() {
        return (T)((Window)this.listener.getTarget());
    }
}

