/*
 * Decompiled with CFR 0.152.
 */
package edu.fhda.log4j.net;

import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.spi.LoggingEvent;

public class PapertrailAppender
extends AppenderSkeleton {
    public final int MAX_MESSAGE_SIZE = 8192;
    private String papertrailHost;
    private int papertrailPort;
    private boolean appenderInitialized = false;
    private final LinkedBlockingQueue<String> logMessageQueue = new LinkedBlockingQueue();
    private final ExecutorService workerService = Executors.newFixedThreadPool(1);
    private SSLSocketFactory sslSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();

    public PapertrailAppender() {
    }

    public PapertrailAppender(String name, String hostname, int port, Layout layout) {
        this.setName(name);
        this.setLayout(layout);
        this.papertrailHost = hostname;
        this.papertrailPort = port;
    }

    protected void append(LoggingEvent loggingEvent) {
        if (!this.appenderInitialized) {
            this.workerService.submit(new Runnable(){

                public void run() {
                    try {
                        while (true) {
                            String nextWaitingMessage = (String)PapertrailAppender.this.logMessageQueue.take();
                            SSLSocket sslSocket = (SSLSocket)PapertrailAppender.this.sslSocketFactory.createSocket(PapertrailAppender.this.papertrailHost, PapertrailAppender.this.papertrailPort);
                            sslSocket.startHandshake();
                            BufferedWriter socketOut = new BufferedWriter(new OutputStreamWriter(sslSocket.getOutputStream()));
                            socketOut.write(PapertrailAppender.this.truncateMessage(nextWaitingMessage));
                            while (PapertrailAppender.this.logMessageQueue.peek() != null) {
                                nextWaitingMessage = (String)PapertrailAppender.this.logMessageQueue.take();
                                socketOut.write(PapertrailAppender.this.truncateMessage(nextWaitingMessage));
                            }
                            socketOut.flush();
                            socketOut.close();
                            sslSocket.close();
                        }
                    }
                    catch (Exception workerError) {
                        workerError.printStackTrace(System.out);
                        return;
                    }
                }
            });
            this.appenderInitialized = true;
        }
        this.logMessageQueue.add(this.getLayout().format(loggingEvent));
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return true;
    }

    public String getPapertrailHost() {
        return this.papertrailHost;
    }

    public void setPapertrailHost(String papertrailHost) {
        this.papertrailHost = papertrailHost;
    }

    public int getPapertrailPort() {
        return this.papertrailPort;
    }

    public void setPapertrailPort(int papertrailPort) {
        this.papertrailPort = papertrailPort;
    }

    private String truncateMessage(String messageText) {
        return messageText.substring(0, messageText.length() < 8192 ? messageText.length() : 8192);
    }
}

