/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import org.locationtech.jts.algorithm.Orientation$;
import org.locationtech.jts.geom.Coordinate;
import scala.UninitializedFieldError;

public final class Angle$ {
    public static final Angle$ MODULE$ = new Angle$();
    private static final double PI_TIMES_2 = Math.PI * 2;
    private static final double PI_OVER_2;
    private static final double PI_OVER_4;
    private static final int COUNTERCLOCKWISE;
    private static final int CLOCKWISE;
    private static final int NONE;
    private static volatile byte bitmap$init$0;

    static {
        bitmap$init$0 = (byte)(bitmap$init$0 | 1);
        PI_OVER_2 = 1.5707963267948966;
        bitmap$init$0 = (byte)(bitmap$init$0 | 2);
        PI_OVER_4 = 0.7853981633974483;
        bitmap$init$0 = (byte)(bitmap$init$0 | 4);
        COUNTERCLOCKWISE = Orientation$.MODULE$.COUNTERCLOCKWISE();
        bitmap$init$0 = (byte)(bitmap$init$0 | 8);
        CLOCKWISE = Orientation$.MODULE$.CLOCKWISE();
        bitmap$init$0 = (byte)(bitmap$init$0 | 0x10);
        NONE = Orientation$.MODULE$.COLLINEAR();
        bitmap$init$0 = (byte)(bitmap$init$0 | 0x20);
    }

    public double PI_TIMES_2() {
        if ((byte)(bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/algorithm/Angle.scala: 34");
        }
        return PI_TIMES_2;
    }

    public double PI_OVER_2() {
        if ((byte)(bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/algorithm/Angle.scala: 38");
        }
        return PI_OVER_2;
    }

    public double PI_OVER_4() {
        if ((byte)(bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/algorithm/Angle.scala: 42");
        }
        return PI_OVER_4;
    }

    public int COUNTERCLOCKWISE() {
        if ((byte)(bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/algorithm/Angle.scala: 44");
        }
        return COUNTERCLOCKWISE;
    }

    public int CLOCKWISE() {
        if ((byte)(bitmap$init$0 & 0x10) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/algorithm/Angle.scala: 46");
        }
        return CLOCKWISE;
    }

    public int NONE() {
        if ((byte)(bitmap$init$0 & 0x20) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/algorithm/Angle.scala: 48");
        }
        return NONE;
    }

    public double toDegrees(double radians) {
        return radians * (double)180 / Math.PI;
    }

    public double toRadians(double angleDegrees) {
        return angleDegrees * Math.PI / 180.0;
    }

    public double angle(Coordinate p0, Coordinate p1) {
        double dx = p1.x() - p0.x();
        double dy = p1.y() - p0.y();
        return Math.atan2(dy, dx);
    }

    public double angle(Coordinate p) {
        return Math.atan2(p.y(), p.x());
    }

    public boolean isAcute(Coordinate p0, Coordinate p1, Coordinate p2) {
        double dy1;
        double dx0 = p0.x() - p1.x();
        double dy0 = p0.y() - p1.y();
        double dx1 = p2.x() - p1.x();
        double dotprod = dx0 * dx1 + dy0 * (dy1 = p2.y() - p1.y());
        return dotprod > 0.0;
    }

    public boolean isObtuse(Coordinate p0, Coordinate p1, Coordinate p2) {
        double dy1;
        double dx0 = p0.x() - p1.x();
        double dy0 = p0.y() - p1.y();
        double dx1 = p2.x() - p1.x();
        double dotprod = dx0 * dx1 + dy0 * (dy1 = p2.y() - p1.y());
        return dotprod < 0.0;
    }

    public double angleBetween(Coordinate tip1, Coordinate tail, Coordinate tip2) {
        double a1 = this.angle(tail, tip1);
        double a2 = this.angle(tail, tip2);
        return this.diff(a1, a2);
    }

    public double angleBetweenOriented(Coordinate tip1, Coordinate tail, Coordinate tip2) {
        double a1 = this.angle(tail, tip1);
        double a2 = this.angle(tail, tip2);
        double angDel = a2 - a1;
        if (angDel <= -Math.PI) {
            return angDel + this.PI_TIMES_2();
        }
        if (angDel > Math.PI) {
            return angDel - this.PI_TIMES_2();
        }
        return angDel;
    }

    public double interiorAngle(Coordinate p0, Coordinate p1, Coordinate p2) {
        double anglePrev = this.angle(p1, p0);
        double angleNext = this.angle(p1, p2);
        return Math.abs(angleNext - anglePrev);
    }

    public int getTurn(double ang1, double ang2) {
        double crossproduct = Math.sin(ang2 - ang1);
        if (crossproduct > 0.0) {
            return this.COUNTERCLOCKWISE();
        }
        if (crossproduct < 0.0) {
            return this.CLOCKWISE();
        }
        return this.NONE();
    }

    /*
     * WARNING - void declaration
     */
    public double normalize(double angl) {
        void var3_2;
        double angle;
        for (angle = angl; angle > Math.PI; angle -= this.PI_TIMES_2()) {
        }
        while (angle <= -Math.PI) {
            angle += this.PI_TIMES_2();
        }
        return (double)var3_2;
    }

    /*
     * WARNING - void declaration
     */
    public double normalizePositive(double angl) {
        void var3_2;
        block3: {
            double angle;
            block2: {
                angle = angl;
                if (!(angle < 0.0)) break block2;
                while (angle < 0.0) {
                    angle += this.PI_TIMES_2();
                }
                if (!(angle >= this.PI_TIMES_2())) break block3;
                angle = 0.0;
                break block3;
            }
            while (angle >= this.PI_TIMES_2()) {
                angle -= this.PI_TIMES_2();
            }
            if (!(angle < 0.0)) break block3;
            angle = 0.0;
        }
        return (double)var3_2;
    }

    public double diff(double ang1, double ang2) {
        double delAngle;
        block0: {
            delAngle = 0.0;
            delAngle = ang1 < ang2 ? ang2 - ang1 : ang1 - ang2;
            if (!(delAngle > Math.PI)) break block0;
            delAngle = Math.PI * 2 - delAngle;
        }
        return delAngle;
    }

    private Angle$() {
    }
}

