/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import org.locationtech.jts.algorithm.CGAlgorithmsDD$;
import org.locationtech.jts.algorithm.RayCrossingCounter$;
import org.locationtech.jts.algorithm.RobustLineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope$;
import org.locationtech.jts.geom.Location$;
import org.locationtech.jts.math.MathUtil$;
import scala.UninitializedFieldError;

public final class CGAlgorithms$ {
    public static final CGAlgorithms$ MODULE$ = new CGAlgorithms$();
    private static final int CLOCKWISE = -1;
    private static final int RIGHT;
    private static final int COUNTERCLOCKWISE;
    private static final int LEFT;
    private static final int COLLINEAR;
    private static final int STRAIGHT;
    private static volatile byte bitmap$init$0;

    static {
        bitmap$init$0 = (byte)(bitmap$init$0 | 1);
        RIGHT = MODULE$.CLOCKWISE();
        bitmap$init$0 = (byte)(bitmap$init$0 | 2);
        COUNTERCLOCKWISE = 1;
        bitmap$init$0 = (byte)(bitmap$init$0 | 4);
        LEFT = MODULE$.COUNTERCLOCKWISE();
        bitmap$init$0 = (byte)(bitmap$init$0 | 8);
        COLLINEAR = 0;
        bitmap$init$0 = (byte)(bitmap$init$0 | 0x10);
        STRAIGHT = MODULE$.COLLINEAR();
        bitmap$init$0 = (byte)(bitmap$init$0 | 0x20);
    }

    public int CLOCKWISE() {
        if ((byte)(bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/algorithm/CGAlgorithms.scala: 42");
        }
        return CLOCKWISE;
    }

    public int RIGHT() {
        if ((byte)(bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/algorithm/CGAlgorithms.scala: 43");
        }
        return RIGHT;
    }

    public int COUNTERCLOCKWISE() {
        if ((byte)(bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/algorithm/CGAlgorithms.scala: 47");
        }
        return COUNTERCLOCKWISE;
    }

    public int LEFT() {
        if ((byte)(bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/algorithm/CGAlgorithms.scala: 48");
        }
        return LEFT;
    }

    public int COLLINEAR() {
        if ((byte)(bitmap$init$0 & 0x10) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/algorithm/CGAlgorithms.scala: 52");
        }
        return COLLINEAR;
    }

    public int STRAIGHT() {
        if ((byte)(bitmap$init$0 & 0x20) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/algorithm/CGAlgorithms.scala: 53");
        }
        return STRAIGHT;
    }

    public int orientationIndex(Coordinate p1, Coordinate p2, Coordinate q) {
        return CGAlgorithmsDD$.MODULE$.orientationIndex(p1, p2, q);
    }

    public boolean isPointInRing(Coordinate p, Coordinate[] ring) {
        return this.locatePointInRing(p, ring) != Location$.MODULE$.EXTERIOR();
    }

    public int locatePointInRing(Coordinate p, Coordinate[] ring) {
        return RayCrossingCounter$.MODULE$.locatePointInRing(p, ring);
    }

    public boolean isOnLine(Coordinate p, Coordinate[] pt) {
        RobustLineIntersector lineIntersector = new RobustLineIntersector();
        for (int i = 1; i < pt.length; ++i) {
            Coordinate p0 = pt[i - 1];
            Coordinate p1 = pt[i];
            lineIntersector.computeIntersection(p, p0, p1);
            if (!lineIntersector.hasIntersection()) continue;
            return true;
        }
        return false;
    }

    public boolean isCCW(Coordinate[] ring) {
        int nPts = ring.length - 1;
        if (nPts < 3) {
            throw new IllegalArgumentException("Ring has fewer than 4 points, so orientation cannot be determined");
        }
        Coordinate hiPt = ring[0];
        int hiIndex = 0;
        int i = 1;
        while (i <= nPts) {
            Coordinate p = ring[i];
            if (p.y() > hiPt.y()) {
                hiPt = p;
                hiIndex = i;
            }
            int cfr_ignored_0 = ++i - 1;
        }
        int iPrev = hiIndex;
        do {
            if (--iPrev >= 0) continue;
            iPrev = nPts;
        } while (ring[iPrev].equals2D(hiPt) && iPrev != hiIndex);
        int iNext = hiIndex;
        while (ring[iNext = (iNext + 1) % nPts].equals2D(hiPt) && iNext != hiIndex) {
        }
        Coordinate prev = ring[iPrev];
        Coordinate next = ring[iNext];
        if (prev.equals2D(hiPt) || next.equals2D(hiPt) || prev.equals2D(next)) {
            return false;
        }
        int disc = this.computeOrientation(prev, hiPt, next);
        boolean isCCW = false;
        isCCW = disc == 0 ? prev.x() > next.x() : disc > 0;
        return isCCW;
    }

    public int computeOrientation(Coordinate p1, Coordinate p2, Coordinate q) {
        return this.orientationIndex(p1, p2, q);
    }

    public double distancePointLine(Coordinate p, Coordinate A, Coordinate B) {
        if (A.x() == B.x() && A.y() == B.y()) {
            return p.distance(A);
        }
        double len2 = (B.x() - A.x()) * (B.x() - A.x()) + (B.y() - A.y()) * (B.y() - A.y());
        double r = ((p.x() - A.x()) * (B.x() - A.x()) + (p.y() - A.y()) * (B.y() - A.y())) / len2;
        if (r <= 0.0) {
            return p.distance(A);
        }
        if (r >= 1.0) {
            return p.distance(B);
        }
        double s = ((A.y() - p.y()) * (B.x() - A.x()) - (A.x() - p.x()) * (B.y() - A.y())) / len2;
        return Math.abs(s) * Math.sqrt(len2);
    }

    public double distancePointLinePerpendicular(Coordinate p, Coordinate A, Coordinate B) {
        double len2 = (B.x() - A.x()) * (B.x() - A.x()) + (B.y() - A.y()) * (B.y() - A.y());
        double s = ((A.y() - p.y()) * (B.x() - A.x()) - (A.x() - p.x()) * (B.y() - A.y())) / len2;
        return Math.abs(s) * Math.sqrt(len2);
    }

    /*
     * WARNING - void declaration
     */
    public double distancePointLine(Coordinate p, Coordinate[] line) {
        void var3_3;
        if (line.length == 0) {
            throw new IllegalArgumentException("Line array must contain at least one vertex");
        }
        double minDistance = p.distance(line[0]);
        for (int i = 0; i < line.length - 1; ++i) {
            double dist = this.distancePointLine(p, line[i], line[i + 1]);
            if (!(dist < minDistance)) continue;
            minDistance = dist;
        }
        return (double)var3_3;
    }

    public double distanceLineLine(Coordinate A, Coordinate B, Coordinate C, Coordinate D) {
        Coordinate coordinate = A;
        Coordinate coordinate2 = B;
        if (!(coordinate != null ? !((Object)coordinate).equals(coordinate2) : coordinate2 != null)) {
            return this.distancePointLine(A, C, D);
        }
        Coordinate coordinate3 = C;
        Coordinate coordinate4 = D;
        if (!(coordinate3 != null ? !((Object)coordinate3).equals(coordinate4) : coordinate4 != null)) {
            return this.distancePointLine(D, A, B);
        }
        boolean noIntersection = false;
        if (!Envelope$.MODULE$.intersects(A, B, C, D)) {
            noIntersection = true;
        } else {
            double denom = (B.x() - A.x()) * (D.y() - C.y()) - (B.y() - A.y()) * (D.x() - C.x());
            if (denom == 0.0) {
                noIntersection = true;
            } else {
                double r_num = (A.y() - C.y()) * (D.x() - C.x()) - (A.x() - C.x()) * (D.y() - C.y());
                double s_num = (A.y() - C.y()) * (B.x() - A.x()) - (A.x() - C.x()) * (B.y() - A.y());
                double s = s_num / denom;
                double r = r_num / denom;
                if (r < 0.0 || r > 1.0 || s < 0.0 || s > 1.0) {
                    noIntersection = true;
                }
            }
        }
        if (noIntersection) {
            return MathUtil$.MODULE$.min(this.distancePointLine(A, C, D), this.distancePointLine(B, C, D), this.distancePointLine(C, A, B), this.distancePointLine(D, A, B));
        }
        return 0.0;
    }

    public double signedArea(Coordinate[] ring) {
        if (ring.length < 3) {
            return 0.0;
        }
        double sum = 0.0;
        double x0 = ring[0].x();
        for (int i = 1; i < ring.length - 1; ++i) {
            double x = ring[i].x() - x0;
            double y1 = ring[i + 1].y();
            double y2 = ring[i - 1].y();
            sum += x * (y2 - y1);
        }
        return sum / 2.0;
    }

    public double signedArea(CoordinateSequence ring) {
        int n = ring.size();
        if (n < 3) {
            return 0.0;
        }
        Coordinate p0 = new Coordinate();
        Coordinate p1 = new Coordinate();
        Coordinate p2 = new Coordinate();
        ring.getCoordinate(0, p1);
        ring.getCoordinate(1, p2);
        double x0 = p1.x();
        p2.x_$eq(p2.x() - x0);
        double sum = 0.0;
        for (int i = 1; i < n - 1; ++i) {
            p0.y_$eq(p1.y());
            p1.x_$eq(p2.x());
            p1.y_$eq(p2.y());
            ring.getCoordinate(i + 1, p2);
            p2.x_$eq(p2.x() - x0);
            sum += p1.x() * (p0.y() - p2.y());
        }
        return sum / 2.0;
    }

    /*
     * WARNING - void declaration
     */
    public double length(CoordinateSequence pts) {
        void var3_3;
        int n = pts.size();
        if (n <= 1) {
            return 0.0;
        }
        double len = 0.0;
        Coordinate p = new Coordinate();
        pts.getCoordinate(0, p);
        double x0 = p.x();
        double y0 = p.y();
        for (int i = 1; i < n; ++i) {
            pts.getCoordinate(i, p);
            double x1 = p.x();
            double y1 = p.y();
            double dx = x1 - x0;
            double dy = y1 - y0;
            len += Math.sqrt(dx * dx + dy * dy);
            x0 = x1;
            y0 = y1;
        }
        return (double)var3_3;
    }

    private CGAlgorithms$() {
    }
}

