/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.math.DD;
import org.locationtech.jts.math.DD$;
import scala.UninitializedFieldError;

public final class CGAlgorithmsDD$ {
    public static final CGAlgorithmsDD$ MODULE$ = new CGAlgorithmsDD$();
    private static final double DP_SAFE_EPSILON = 1.0E-15;
    private static volatile boolean bitmap$init$0 = true;

    public int orientationIndex(Coordinate p1, Coordinate p2, Coordinate q) {
        int index = this.orientationIndexFilter(p1, p2, q);
        if (index <= 1) {
            return index;
        }
        DD dx1 = DD$.MODULE$.valueOf(p2.x()).selfAdd(-p1.x());
        DD dy1 = DD$.MODULE$.valueOf(p2.y()).selfAdd(-p1.y());
        DD dx2 = DD$.MODULE$.valueOf(q.x()).selfAdd(-p2.x());
        DD dy2 = DD$.MODULE$.valueOf(q.y()).selfAdd(-p2.y());
        return dx1.selfMultiply(dy2).selfSubtract(dy1.selfMultiply(dx2)).signum();
    }

    public int signOfDet2x2(DD x1, DD y1, DD x2, DD y2) {
        DD det = x1.multiply(y2).selfSubtract(y1.multiply(x2));
        return det.signum();
    }

    public int signOfDet2x2(double dx1, double dy1, double dx2, double dy2) {
        DD x1 = DD$.MODULE$.valueOf(dx1);
        DD y1 = DD$.MODULE$.valueOf(dy1);
        DD x2 = DD$.MODULE$.valueOf(dx2);
        DD y2 = DD$.MODULE$.valueOf(dy2);
        DD det = x1.multiply(y2).selfSubtract(y1.multiply(x2));
        return det.signum();
    }

    private double DP_SAFE_EPSILON() {
        if (!bitmap$init$0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/algorithm/CGAlgorithmsDD.scala: 87");
        }
        return DP_SAFE_EPSILON;
    }

    private int orientationIndexFilter(Coordinate pa, Coordinate pb, Coordinate pc) {
        double detsum = 0.0;
        double detleft = (pa.x() - pc.x()) * (pb.y() - pc.y());
        double detright = (pa.y() - pc.y()) * (pb.x() - pc.x());
        double det = detleft - detright;
        if (detleft > 0.0) {
            if (detright <= 0.0) {
                return this.signum(det);
            }
            detsum = detleft + detright;
        } else if (detleft < 0.0) {
            if (detright >= 0.0) {
                return this.signum(det);
            }
            detsum = -detleft - detright;
        } else {
            return this.signum(det);
        }
        double errbound = this.DP_SAFE_EPSILON() * detsum;
        if (det >= errbound || -det >= errbound) {
            return this.signum(det);
        }
        return 2;
    }

    private int signum(double x) {
        if (x > 0.0) {
            return 1;
        }
        if (x < 0.0) {
            return -1;
        }
        return 0;
    }

    public Coordinate intersection(Coordinate p1, Coordinate p2, Coordinate q1, Coordinate q2) {
        DD px = new DD(p1.y()).selfSubtract(p2.y());
        DD py = new DD(p2.x()).selfSubtract(p1.x());
        DD pw = new DD(p1.x()).selfMultiply(p2.y()).selfSubtract(new DD(p2.x()).selfMultiply(p1.y()));
        DD qx = new DD(q1.y()).selfSubtract(q2.y());
        DD qy = new DD(q2.x()).selfSubtract(q1.x());
        DD qw = new DD(q1.x()).selfMultiply(q2.y()).selfSubtract(new DD(q2.x()).selfMultiply(q1.y()));
        DD x = py.multiply(qw).selfSubtract(qy.multiply(pw));
        DD y = qx.multiply(pw).selfSubtract(px.multiply(qw));
        DD w = px.multiply(qy).selfSubtract(qx.multiply(py));
        double xInt = x.selfDivide(w).doubleValue();
        double yInt = y.selfDivide(w).doubleValue();
        if (Double.isNaN(xInt) || Double.isInfinite(xInt) || Double.isNaN(yInt) || Double.isInfinite(yInt)) {
            return null;
        }
        return new Coordinate(xInt, yInt);
    }

    private CGAlgorithmsDD$() {
    }
}

