/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import org.locationtech.jts.algorithm.Centroid$;
import org.locationtech.jts.algorithm.Orientation$;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import scala.UninitializedFieldError;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005t!B\u0014)\u0011\u0003\td!B\u001a)\u0011\u0003!\u0004\"B\u001e\u0002\t\u0003a\u0004\"B\u001f\u0002\t\u0003q\u0004\"B%\u0002\t\u0013Q\u0005\"\u0002,\u0002\t\u00139f\u0001B\u001a)\u0001yC\u0001B\u0011\u0004\u0003\u0006\u0004%\ta\u0018\u0005\tA\u001a\u0011\t\u0011)A\u0005\r\")1H\u0002C\u0001C\"9AM\u0002a\u0001\n\u0013)\u0007b\u00024\u0007\u0001\u0004%Ia\u001a\u0005\u0007U\u001a\u0001\u000b\u0015B \t\u000f-4!\u0019!C\u0005K\"1AN\u0002Q\u0001\n}Bq!\u001c\u0004A\u0002\u0013%a\u000eC\u0004p\r\u0001\u0007I\u0011\u00029\t\rI4\u0001\u0015)\u0003Y\u0011\u001d\u0019hA1A\u0005\n\u0015Da\u0001\u001e\u0004!\u0002\u0013y\u0004bB;\u0007\u0005\u0004%I!\u001a\u0005\u0007m\u001a\u0001\u000b\u0011B \t\u000f]4\u0001\u0019!C\u0005]\"9\u0001P\u0002a\u0001\n\u0013I\bBB>\u0007A\u0003&\u0001\fC\u0004}\r\u0001\u0007I\u0011B?\t\u0013\u0005\ra\u00011A\u0005\n\u0005\u0015\u0001bBA\u0005\r\u0001\u0006KA \u0005\t\u0003\u00171!\u0019!C\u0005K\"9\u0011Q\u0002\u0004!\u0002\u0013y\u0004bBA\b\r\u0011%\u0011\u0011\u0003\u0005\u0006{\u0019!\t!\u001a\u0005\b\u0003+1A\u0011BA\f\u0011\u001d\tyA\u0002C\u0005\u0003;Aq!!\u000b\u0007\t\u0013\tY\u0003C\u0004\u00028\u0019!I!!\u000f\t\u000f\u0005ub\u0001\"\u0003\u0002@!9\u00111\u000b\u0004\u0005\n\u0005U\u0003bBA-\r\u0011%\u00111L\u0001\t\u0007\u0016tGO]8jI*\u0011\u0011FK\u0001\nC2<wN]5uQ6T!a\u000b\u0017\u0002\u0007)$8O\u0003\u0002.]\u0005aAn\\2bi&|g\u000e^3dQ*\tq&A\u0002pe\u001e\u001c\u0001\u0001\u0005\u00023\u00035\t\u0001F\u0001\u0005DK:$(o\\5e'\t\tQ\u0007\u0005\u00027s5\tqGC\u00019\u0003\u0015\u00198-\u00197b\u0013\tQtG\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003E\n1bZ3u\u0007\u0016tGO]8jIR\u0011q(\u0012\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0003\u0005*\nAaZ3p[&\u0011A)\u0011\u0002\u000b\u0007>|'\u000fZ5oCR,\u0007\"\u0002\"\u0004\u0001\u00041\u0005C\u0001!H\u0013\tA\u0015I\u0001\u0005HK>lW\r\u001e:z\u0003%\u0019WM\u001c;s_&$7\u0007F\u0003L\u001dB\u0013F\u000b\u0005\u00027\u0019&\u0011Qj\u000e\u0002\u0005+:LG\u000fC\u0003P\t\u0001\u0007q(\u0001\u0002qc!)\u0011\u000b\u0002a\u0001\u007f\u0005\u0011\u0001O\r\u0005\u0006'\u0012\u0001\raP\u0001\u0003aNBQ!\u0016\u0003A\u0002}\n\u0011aY\u0001\u0006CJ,\u0017M\r\u000b\u00051ncV\f\u0005\u000273&\u0011!l\u000e\u0002\u0007\t>,(\r\\3\t\u000b=+\u0001\u0019A \t\u000bE+\u0001\u0019A \t\u000bM+\u0001\u0019A \u0014\u0005\u0019)T#\u0001$\u0002\u000b\u001d,w.\u001c\u0011\u0015\u0005\t\u001c\u0007C\u0001\u001a\u0007\u0011\u0015\u0011\u0015\u00021\u0001G\u0003)\t'/Z1CCN,\u0007\u000b^\u000b\u0002\u007f\u0005q\u0011M]3b\u0005\u0006\u001cX\r\u0015;`I\u0015\fHCA&i\u0011\u001dI7\"!AA\u0002}\n1\u0001\u001f\u00132\u0003-\t'/Z1CCN,\u0007\u000b\u001e\u0011\u0002\u001bQ\u0014\u0018.\u00198hY\u0016\u001cUM\u001c;4\u00039!(/[1oO2,7)\u001a8ug\u0001\n\u0001\"\u0019:fCN,XNM\u000b\u00021\u0006a\u0011M]3bgVl'g\u0018\u0013fcR\u00111*\u001d\u0005\bSB\t\t\u00111\u0001Y\u0003%\t'/Z1tk6\u0014\u0004%A\u0002dON\nAaY44A\u0005YA.\u001b8f\u0007\u0016tGoU;n\u00031a\u0017N\\3DK:$8+^7!\u0003-!x\u000e^1m\u0019\u0016tw\r\u001e5\u0002\u001fQ|G/\u00197MK:<G\u000f[0%KF$\"a\u0013>\t\u000f%<\u0012\u0011!a\u00011\u0006aAo\u001c;bY2+gn\u001a;iA\u00059\u0001\u000f^\"pk:$X#\u0001@\u0011\u0005Yz\u0018bAA\u0001o\t\u0019\u0011J\u001c;\u0002\u0017A$8i\\;oi~#S-\u001d\u000b\u0004\u0017\u0006\u001d\u0001bB5\u001b\u0003\u0003\u0005\rA`\u0001\taR\u001cu.\u001e8uA\u0005I\u0001\u000f^\"f]R\u001cV/\\\u0001\u000baR\u001cUM\u001c;Tk6\u0004\u0013aA1eIR\u00191*a\u0005\t\u000b\ts\u0002\u0019\u0001$\u0002!M,G/\u0011:fC\n\u000b7/\u001a)pS:$HcA&\u0002\u001a!1\u00111\u0004\u0011A\u0002}\naAY1tKB#HcA&\u0002 !9\u0011\u0011E\u0011A\u0002\u0005\r\u0012\u0001\u00029pYf\u00042\u0001QA\u0013\u0013\r\t9#\u0011\u0002\b!>d\u0017pZ8o\u0003!\tG\rZ*iK2dGcA&\u0002.!9\u0011q\u0006\u0012A\u0002\u0005E\u0012a\u00019ugB!a'a\r@\u0013\r\t)d\u000e\u0002\u0006\u0003J\u0014\u0018-_\u0001\bC\u0012$\u0007j\u001c7f)\rY\u00151\b\u0005\b\u0003_\u0019\u0003\u0019AA\u0019\u0003-\tG\r\u001a+sS\u0006tw\r\\3\u0015\u0013-\u000b\t%!\u0012\u0002H\u0005%\u0003BBA\"I\u0001\u0007q(\u0001\u0002qa!)q\n\na\u0001\u007f!)\u0011\u000b\na\u0001\u007f!9\u00111\n\u0013A\u0002\u00055\u0013AD5t!>\u001c\u0018\u000e^5wK\u0006\u0013X-\u0019\t\u0004m\u0005=\u0013bAA)o\t9!i\\8mK\u0006t\u0017aD1eI2Kg.Z*fO6,g\u000e^:\u0015\u0007-\u000b9\u0006C\u0004\u00020\u0015\u0002\r!!\r\u0002\u0011\u0005$G\rU8j]R$2aSA/\u0011\u0019\tyF\na\u0001\u007f\u0005\u0011\u0001\u000f\u001e")
public class Centroid {
    private final Geometry geom;
    private Coordinate areaBasePt;
    private final Coordinate triangleCent3;
    private double areasum2;
    private final Coordinate cg3;
    private final Coordinate lineCentSum;
    private double totalLength;
    private int ptCount;
    private final Coordinate ptCentSum;
    private volatile byte bitmap$init$0;

    public Geometry geom() {
        return this.geom;
    }

    private Coordinate areaBasePt() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/algorithm/Centroid.scala: 85");
        }
        return this.areaBasePt;
    }

    private void areaBasePt_$eq(Coordinate x$1) {
        this.areaBasePt = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
    }

    private Coordinate triangleCent3() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/algorithm/Centroid.scala: 86");
        }
        return this.triangleCent3;
    }

    private double areasum2() {
        if ((byte)(this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/algorithm/Centroid.scala: 87");
        }
        return this.areasum2;
    }

    private void areasum2_$eq(double x$1) {
        this.areasum2 = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
    }

    private Coordinate cg3() {
        if ((byte)(this.bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/algorithm/Centroid.scala: 89");
        }
        return this.cg3;
    }

    private Coordinate lineCentSum() {
        if ((byte)(this.bitmap$init$0 & 0x10) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/algorithm/Centroid.scala: 91");
        }
        return this.lineCentSum;
    }

    private double totalLength() {
        if ((byte)(this.bitmap$init$0 & 0x20) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/algorithm/Centroid.scala: 92");
        }
        return this.totalLength;
    }

    private void totalLength_$eq(double x$1) {
        this.totalLength = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x20);
    }

    private int ptCount() {
        if ((byte)(this.bitmap$init$0 & 0x40) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/algorithm/Centroid.scala: 93");
        }
        return this.ptCount;
    }

    private void ptCount_$eq(int x$1) {
        this.ptCount = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x40);
    }

    private Coordinate ptCentSum() {
        if ((byte)(this.bitmap$init$0 & 0x80) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/algorithm/Centroid.scala: 94");
        }
        return this.ptCentSum;
    }

    private void add(Geometry geom) {
        if (geom.isEmpty()) {
            return;
        }
        Geometry geometry = geom;
        if (geometry instanceof Point) {
            this.addPoint(geom.getCoordinate());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (geometry instanceof LineString) {
            this.addLineSegments(geom.getCoordinates());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (geometry instanceof Polygon) {
            Polygon polygon = (Polygon)geometry;
            this.add(polygon);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (geometry instanceof GeometryCollection) {
            GeometryCollection geometryCollection = (GeometryCollection)geometry;
            for (int i = 0; i < geometryCollection.getNumGeometries(); ++i) {
                this.add(geometryCollection.getGeometryN(i));
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Coordinate getCentroid() {
        void var1_1;
        Coordinate cent = new Coordinate();
        if (Math.abs(this.areasum2()) > 0.0) {
            cent.x_$eq(this.cg3().x() / (double)3 / this.areasum2());
            cent.y_$eq(this.cg3().y() / (double)3 / this.areasum2());
        } else if (this.totalLength() > 0.0) {
            cent.x_$eq(this.lineCentSum().x() / this.totalLength());
            cent.y_$eq(this.lineCentSum().y() / this.totalLength());
        } else if (this.ptCount() > 0) {
            cent.x_$eq(this.ptCentSum().x() / (double)this.ptCount());
            cent.y_$eq(this.ptCentSum().y() / (double)this.ptCount());
        } else {
            return null;
        }
        return var1_1;
    }

    private void setAreaBasePoint(Coordinate basePt) {
        this.areaBasePt_$eq(basePt);
    }

    private void add(Polygon poly) {
        this.addShell(poly.getExteriorRing().getCoordinates());
        for (int i = 0; i < poly.getNumInteriorRing(); ++i) {
            this.addHole(poly.getInteriorRingN(i).getCoordinates());
        }
    }

    private void addShell(Coordinate[] pts) {
        if (pts.length > 0) {
            this.setAreaBasePoint(pts[0]);
        }
        boolean isPositiveArea = !Orientation$.MODULE$.isCCW(pts);
        for (int i = 0; i < pts.length - 1; ++i) {
            this.addTriangle(this.areaBasePt(), pts[i], pts[i + 1], isPositiveArea);
        }
        this.addLineSegments(pts);
    }

    private void addHole(Coordinate[] pts) {
        boolean isPositiveArea = Orientation$.MODULE$.isCCW(pts);
        for (int i = 0; i < pts.length - 1; ++i) {
            this.addTriangle(this.areaBasePt(), pts[i], pts[i + 1], isPositiveArea);
        }
        this.addLineSegments(pts);
    }

    private void addTriangle(Coordinate p0, Coordinate p1, Coordinate p2, boolean isPositiveArea) {
        double sign = isPositiveArea ? 1.0 : -1.0;
        Centroid$.MODULE$.org$locationtech$jts$algorithm$Centroid$$centroid3(p0, p1, p2, this.triangleCent3());
        double area2 = Centroid$.MODULE$.org$locationtech$jts$algorithm$Centroid$$area2(p0, p1, p2);
        this.cg3().x_$eq(this.cg3().x() + sign * area2 * this.triangleCent3().x());
        this.cg3().y_$eq(this.cg3().y() + sign * area2 * this.triangleCent3().y());
        this.areasum2_$eq(this.areasum2() + sign * area2);
    }

    private void addLineSegments(Coordinate[] pts) {
        double lineLen = 0.0;
        int i = 0;
        while (i < pts.length - 1) {
            Object object;
            double segmentLen = pts[i].distance(pts[i + 1]);
            if (segmentLen != 0.0) {
                lineLen += segmentLen;
                double midx = (pts[i].x() + pts[i + 1].x()) / (double)2;
                this.lineCentSum().x_$eq(this.lineCentSum().x() + segmentLen * midx);
                double midy = (pts[i].y() + pts[i + 1].y()) / (double)2;
                this.lineCentSum().y_$eq(this.lineCentSum().y() + segmentLen * midy);
                object = BoxesRunTime.boxToInteger((int)(++i - 1));
            } else {
                object = BoxedUnit.UNIT;
            }
            this.totalLength_$eq(this.totalLength() + lineLen);
            if (lineLen != 0.0 || pts.length <= 0) continue;
            this.addPoint(pts[0]);
        }
    }

    private void addPoint(Coordinate pt) {
        this.ptCount_$eq(this.ptCount() + 1);
        this.ptCentSum().x_$eq(this.ptCentSum().x() + pt.x());
        this.ptCentSum().y_$eq(this.ptCentSum().y() + pt.y());
    }

    public Centroid(Geometry geom) {
        this.geom = geom;
        this.add(geom);
        this.areaBasePt = null;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.triangleCent3 = new Coordinate();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.areasum2 = 0.0;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
        this.cg3 = new Coordinate();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
        this.lineCentSum = new Coordinate();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x10);
        this.totalLength = 0.0;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x20);
        this.ptCount = 0;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x40);
        this.ptCentSum = new Coordinate();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x80);
    }
}

