/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Stack;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import org.locationtech.jts.algorithm.ConvexHull$;
import org.locationtech.jts.algorithm.ConvexHull$RadialComparator$;
import org.locationtech.jts.algorithm.Orientation$;
import org.locationtech.jts.algorithm.PointLocation$;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays$;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.util.Assert$;
import org.locationtech.jts.util.UniqueCoordinateArrayFilter$;
import scala.Array$;
import scala.UninitializedFieldError;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005mu!B\u0012%\u0011\u0003ic!B\u0018%\u0011\u0003\u0001\u0004\"B\u001c\u0002\t\u0003A\u0004\"B\u001d\u0002\t\u0013Qt!\u0002%\u0002\u0011\u0013Ie!B&\u0002\u0011\u0013a\u0005\"B\u001c\u0006\t\u0003i\u0005\"\u0002(\u0006\t\u0013ye\u0001B&\u0002\teC\u0001\u0002\u001b\u0005\u0003\u0002\u0004%\t!\u001b\u0005\tU\"\u0011\t\u0019!C\u0001W\"A\u0011\u000f\u0003B\u0001B\u0003&a\bC\u00038\u0011\u0011\u0005!\u000fC\u0003v\u0011\u0011\u0005cO\u0002\u00030I\u0001Y\b\u0002\u0003?\u000f\u0005\u000b\u0007I\u0011A?\t\u0011yt!\u0011!Q\u0001\nmB\u0011b \b\u0003\u0002\u0004%\t!!\u0001\t\u0015\u0005%aB!a\u0001\n\u0003\tY\u0001\u0003\u0006\u0002\u00109\u0011\t\u0011)Q\u0005\u0003\u0007Aaa\u000e\b\u0005\u0002\u0005E\u0001\u0002CA\r\u001d\t\u0007I\u0011B?\t\u000f\u0005ma\u0002)A\u0005w!1qG\u0004C\u0001\u0003;Aq!a\t\u000f\t\u0003\t)\u0003C\u0004\u0002(9!\t\"!\u000b\t\u000f\u00055c\u0002\"\u0003\u0002P!9\u00111\u000b\b\u0005\n\u0005U\u0003bBA-\u001d\u0011%\u00111\f\u0005\b\u0003?rA\u0011BA1\u0011\u001d\tIG\u0004C\u0005\u0003WBq!a \u000f\t\u0013\t\t\tC\u0004\u0002\u0006:!I!a\"\t\u000f\u0005-e\u0002\"\u0003\u0002\u000e\"9\u00111\u0013\b\u0005\n\u0005U\u0015AC\"p]Z,\u0007\u0010S;mY*\u0011QEJ\u0001\nC2<wN]5uQ6T!a\n\u0015\u0002\u0007)$8O\u0003\u0002*U\u0005aAn\\2bi&|g\u000e^3dQ*\t1&A\u0002pe\u001e\u001c\u0001\u0001\u0005\u0002/\u00035\tAE\u0001\u0006D_:4X\r\u001f%vY2\u001c\"!A\u0019\u0011\u0005I*T\"A\u001a\u000b\u0003Q\nQa]2bY\u0006L!AN\u001a\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tQ&\u0001\nfqR\u0014\u0018m\u0019;D_>\u0014H-\u001b8bi\u0016\u001cHCA\u001eE!\r\u0011DHP\u0005\u0003{M\u0012Q!\u0011:sCf\u0004\"a\u0010\"\u000e\u0003\u0001S!!\u0011\u0014\u0002\t\u001d,w.\\\u0005\u0003\u0007\u0002\u0013!bQ8pe\u0012Lg.\u0019;f\u0011\u0015\t5\u00011\u0001F!\tyd)\u0003\u0002H\u0001\nAq)Z8nKR\u0014\u00180\u0001\tSC\u0012L\u0017\r\\\"p[B\f'/\u0019;peB\u0011!*B\u0007\u0002\u0003\t\u0001\"+\u00193jC2\u001cu.\u001c9be\u0006$xN]\n\u0003\u000bE\"\u0012!S\u0001\ra>d\u0017M]\"p[B\f'/\u001a\u000b\u0005!N+v\u000b\u0005\u00023#&\u0011!k\r\u0002\u0004\u0013:$\b\"\u0002+\b\u0001\u0004q\u0014!A8\t\u000bY;\u0001\u0019\u0001 \u0002\u0003ADQ\u0001W\u0004A\u0002y\n\u0011!]\n\u0004\u0011i\u0013\u0007CA.a\u001b\u0005a&BA/_\u0003\u0011a\u0017M\\4\u000b\u0003}\u000bAA[1wC&\u0011\u0011\r\u0018\u0002\u0007\u001f\nTWm\u0019;\u0011\u0007\r4g(D\u0001e\u0015\t)g,\u0001\u0003vi&d\u0017BA4e\u0005)\u0019u.\u001c9be\u0006$xN]\u0001\u0007_JLw-\u001b8\u0016\u0003y\n!b\u001c:jO&tw\fJ3r)\taw\u000e\u0005\u00023[&\u0011an\r\u0002\u0005+:LG\u000fC\u0004q\u0015\u0005\u0005\t\u0019\u0001 \u0002\u0007a$\u0013'A\u0004pe&<\u0017N\u001c\u0011\u0015\u0005M$\bC\u0001&\t\u0011\u0015AG\u00021\u0001?\u0003\u001d\u0019w.\u001c9be\u0016$2\u0001U<z\u0011\u0015AX\u00021\u0001?\u0003\t\u0001\u0018\u0007C\u0003{\u001b\u0001\u0007a(\u0001\u0002qeM\u0011a\"M\u0001\u0004aR\u001cX#A\u001e\u0002\tA$8\u000fI\u0001\fO\u0016|WNR1di>\u0014\u00180\u0006\u0002\u0002\u0004A\u0019q(!\u0002\n\u0007\u0005\u001d\u0001IA\bHK>lW\r\u001e:z\r\u0006\u001cGo\u001c:z\u0003=9Wm\\7GC\u000e$xN]=`I\u0015\fHc\u00017\u0002\u000e!A\u0001OEA\u0001\u0002\u0004\t\u0019!\u0001\u0007hK>lg)Y2u_JL\b\u0005\u0006\u0004\u0002\u0014\u0005U\u0011q\u0003\t\u0003]9AQ\u0001 \u000bA\u0002mBaa \u000bA\u0002\u0005\r\u0011\u0001C5oaV$\b\u000b^:\u0002\u0013%t\u0007/\u001e;QiN\u0004C\u0003BA\n\u0003?Aa!!\t\u0018\u0001\u0004)\u0015\u0001C4f_6,GO]=\u0002\u001b\u001d,GoQ8om\u0016D\b*\u001e7m+\u0005)\u0015!\u0005;p\u0007>|'\u000fZ5oCR,\u0017I\u001d:bsR\u00191(a\u000b\t\u000f\u00055\u0012\u00041\u0001\u00020\u0005)1\u000f^1dWB\"\u0011\u0011GA\u001e!\u0015\u0019\u00171GA\u001c\u0013\r\t)\u0004\u001a\u0002\u0006'R\f7m\u001b\t\u0005\u0003s\tY\u0004\u0004\u0001\u0005\u0019\u0005u\u00121FA\u0001\u0002\u0003\u0015\t!a\u0010\u0003\u0007}##'\u0005\u0003\u0002B\u0005\u001d\u0003c\u0001\u001a\u0002D%\u0019\u0011QI\u001a\u0003\u000f9{G\u000f[5oOB\u0019!'!\u0013\n\u0007\u0005-3GA\u0002B]f\faA]3ek\u000e,GcA\u001e\u0002R!1\u0011\u0011\u0004\u000eA\u0002m\n\u0011\u0002]1e\u0003J\u0014\u0018-_\u001a\u0015\u0007m\n9\u0006C\u0003}7\u0001\u00071(A\u0004qe\u0016\u001cvN\u001d;\u0015\u0007m\ni\u0006C\u0003}9\u0001\u00071(\u0001\u0006he\u0006D\u0017-\\*dC:$B!a\u0019\u0002fA!1-a\r?\u0011\u0019\t9'\ba\u0001w\u0005\t1-A\u0005jg\n+Go^3f]RA\u0011QNA:\u0003o\nY\bE\u00023\u0003_J1!!\u001d4\u0005\u001d\u0011un\u001c7fC:Da!!\u001e\u001f\u0001\u0004q\u0014AA22\u0011\u0019\tIH\ba\u0001}\u0005\u00111M\r\u0005\u0007\u0003{r\u0002\u0019\u0001 \u0002\u0005\r\u001c\u0014AD2p[B,H/Z(diJKgn\u001a\u000b\u0004w\u0005\r\u0005BBA\r?\u0001\u00071(A\u0007d_6\u0004X\u000f^3PGR\u0004Fo\u001d\u000b\u0004w\u0005%\u0005BBA\rA\u0001\u00071(A\u0007mS:,wJ\u001d)pYf<wN\u001c\u000b\u0004\u000b\u0006=\u0005BBAIC\u0001\u00071(\u0001\u0006d_>\u0014H-\u001b8bi\u0016\f\u0011b\u00197fC:\u0014\u0016N\\4\u0015\u0007m\n9\n\u0003\u0004\u0002\u001a\n\u0002\raO\u0001\t_JLw-\u001b8bY\u0002")
public class ConvexHull {
    private final Coordinate[] pts;
    private GeometryFactory geomFactory;
    private final Coordinate[] inputPts;
    private volatile boolean bitmap$init$0;

    public Coordinate[] pts() {
        return this.pts;
    }

    public GeometryFactory geomFactory() {
        return this.geomFactory;
    }

    public void geomFactory_$eq(GeometryFactory x$1) {
        this.geomFactory = x$1;
    }

    private Coordinate[] inputPts() {
        if (!this.bitmap$init$0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/algorithm/ConvexHull.scala: 122");
        }
        return this.inputPts;
    }

    public Geometry getConvexHull() {
        if (this.inputPts().length == 0) {
            return this.geomFactory().createGeometryCollection();
        }
        if (this.inputPts().length == 1) {
            return this.geomFactory().createPoint(this.inputPts()[0]);
        }
        if (this.inputPts().length == 2) {
            return this.geomFactory().createLineString(this.inputPts());
        }
        Coordinate[] reducedPts = this.inputPts();
        if (this.inputPts().length > 50) {
            reducedPts = this.reduce(this.inputPts());
        }
        Coordinate[] sortedPts = this.preSort(reducedPts);
        Stack<Coordinate> cHS = this.grahamScan(sortedPts);
        Coordinate[] cH = this.toCoordinateArray(cHS);
        return this.lineOrPolygon(cH);
    }

    public Coordinate[] toCoordinateArray(Stack<?> stack) {
        Coordinate[] coordinates = new Coordinate[stack.size()];
        int i = 0;
        while (i < stack.size()) {
            Coordinate coordinate;
            coordinates[i] = coordinate = (Coordinate)stack.get(i);
            int cfr_ignored_0 = ++i - 1;
        }
        return coordinates;
    }

    private Coordinate[] reduce(Coordinate[] inputPts) {
        Coordinate[] polyPts = this.computeOctRing(inputPts);
        if (polyPts == null) {
            return inputPts;
        }
        TreeSet<Coordinate> reducedSet = new TreeSet<Coordinate>();
        int i = 0;
        while (i < polyPts.length) {
            reducedSet.add(polyPts[i]);
            int cfr_ignored_0 = ++i - 1;
        }
        for (i = 0; i < inputPts.length; ++i) {
            Object object = !PointLocation$.MODULE$.isInRing(inputPts[i], polyPts) ? BoxesRunTime.boxToBoolean((boolean)reducedSet.add(inputPts[i])) : BoxedUnit.UNIT;
        }
        Coordinate[] reducedPts = CoordinateArrays$.MODULE$.toCoordinateArray(reducedSet);
        if (reducedPts.length < 3) {
            return this.padArray3(reducedPts);
        }
        return reducedPts;
    }

    /*
     * WARNING - void declaration
     */
    private Coordinate[] padArray3(Coordinate[] pts) {
        void var2_2;
        Coordinate[] pad = new Coordinate[3];
        for (int i = 0; i < pad.length; ++i) {
            pad[i] = i < pts.length ? pts[i] : pts[0];
        }
        return var2_2;
    }

    private Coordinate[] preSort(Coordinate[] pts) {
        Coordinate t = null;
        for (int i = 1; i < pts.length; ++i) {
            if (!(pts[i].y() < pts[0].y()) && (pts[i].y() != pts[0].y() || !(pts[i].x() < pts[0].x()))) continue;
            t = pts[0];
            pts[0] = pts[i];
            pts[i] = t;
        }
        Arrays.sort((Object[])pts, 1, pts.length, new RadialComparator(pts[0]));
        return pts;
    }

    private Stack<Coordinate> grahamScan(Coordinate[] c) {
        Coordinate p = null;
        Stack<Coordinate> ps = new Stack<Coordinate>();
        ps.push(c[0]);
        ps.push(c[1]);
        ps.push(c[2]);
        int i = 3;
        while (i < c.length) {
            p = (Coordinate)ps.pop();
            while (!ps.empty() && Orientation$.MODULE$.index(ps.peek(), p, c[i]) > 0) {
                p = ps.pop();
            }
            ps.push(p);
            ps.push(c[i]);
            int cfr_ignored_0 = ++i - 1;
        }
        ps.push(c[0]);
        return ps;
    }

    private boolean isBetween(Coordinate c1, Coordinate c2, Coordinate c3) {
        if (Orientation$.MODULE$.index(c1, c2, c3) != 0) {
            return false;
        }
        if (c1.x() != c3.x()) {
            if (c1.x() <= c2.x() && c2.x() <= c3.x()) {
                return true;
            }
            if (c3.x() <= c2.x() && c2.x() <= c1.x()) {
                return true;
            }
        }
        if (c1.y() != c3.y()) {
            if (c1.y() <= c2.y() && c2.y() <= c3.y()) {
                return true;
            }
            if (c3.y() <= c2.y() && c2.y() <= c1.y()) {
                return true;
            }
        }
        return false;
    }

    private Coordinate[] computeOctRing(Coordinate[] inputPts) {
        Coordinate[] octPts = this.computeOctPts(inputPts);
        CoordinateList coordList = new CoordinateList((Coordinate[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Coordinate.class)));
        coordList.add(octPts, false);
        if (coordList.size() < 3) {
            return null;
        }
        coordList.closeRing();
        return coordList.toCoordinateArray();
    }

    private Coordinate[] computeOctPts(Coordinate[] inputPts) {
        Coordinate[] pts = new Coordinate[8];
        int j = 0;
        while (j < pts.length) {
            pts[j] = inputPts[0];
            int cfr_ignored_0 = ++j - 1;
        }
        int i = 1;
        while (i < inputPts.length) {
            if (inputPts[i].x() < pts[0].x()) {
                pts[0] = inputPts[i];
            }
            if (inputPts[i].x() - inputPts[i].y() < pts[1].x() - pts[1].y()) {
                pts[1] = inputPts[i];
            }
            if (inputPts[i].y() > pts[2].y()) {
                pts[2] = inputPts[i];
            }
            if (inputPts[i].x() + inputPts[i].y() > pts[3].x() + pts[3].y()) {
                pts[3] = inputPts[i];
            }
            if (inputPts[i].x() > pts[4].x()) {
                pts[4] = inputPts[i];
            }
            if (inputPts[i].x() - inputPts[i].y() > pts[5].x() - pts[5].y()) {
                pts[5] = inputPts[i];
            }
            if (inputPts[i].y() < pts[6].y()) {
                pts[6] = inputPts[i];
            }
            if (inputPts[i].x() + inputPts[i].y() < pts[7].x() + pts[7].y()) {
                pts[7] = inputPts[i];
            }
            int cfr_ignored_1 = ++i - 1;
        }
        return pts;
    }

    private Geometry lineOrPolygon(Coordinate[] coordinate) {
        Coordinate[] coordinates = this.cleanRing(coordinate);
        if (coordinates.length == 3) {
            return this.geomFactory().createLineString((Coordinate[])((Object[])new Coordinate[]{coordinates[0], coordinates[1]}));
        }
        LinearRing linearRing = this.geomFactory().createLinearRing(coordinates);
        return this.geomFactory().createPolygon(linearRing);
    }

    private Coordinate[] cleanRing(Coordinate[] original) {
        Assert$.MODULE$.equals(original[0], original[original.length - 1]);
        ArrayList<Coordinate> cleanedRing = new ArrayList<Coordinate>();
        Coordinate previousDistinctCoordinate = null;
        for (int i = 0; i <= original.length - 2; ++i) {
            Coordinate currentCoordinate = original[i];
            Coordinate nextCoordinate = original[i + 1];
            Coordinate coordinate = currentCoordinate;
            Coordinate coordinate2 = nextCoordinate;
            if (!(coordinate == null ? coordinate2 != null : !((Object)coordinate).equals(coordinate2)) || previousDistinctCoordinate != null && this.isBetween(previousDistinctCoordinate, currentCoordinate, nextCoordinate)) continue;
            cleanedRing.add(currentCoordinate);
            previousDistinctCoordinate = currentCoordinate;
        }
        cleanedRing.add(original[original.length - 1]);
        Coordinate[] cleanedRingCoordinates = new Coordinate[cleanedRing.size()];
        return (Coordinate[])cleanedRing.toArray((Object[])cleanedRingCoordinates);
    }

    public ConvexHull(Coordinate[] pts, GeometryFactory geomFactory) {
        this.pts = pts;
        this.geomFactory = geomFactory;
        this.inputPts = UniqueCoordinateArrayFilter$.MODULE$.filterCoordinates(pts);
        this.bitmap$init$0 = true;
    }

    public ConvexHull(Geometry geometry) {
        this(ConvexHull$.MODULE$.org$locationtech$jts$algorithm$ConvexHull$$extractCoordinates(geometry), geometry.getFactory());
    }

    public static class RadialComparator
    implements Comparator<Coordinate> {
        private Coordinate origin;

        @Override
        public Comparator<Coordinate> reversed() {
            return Comparator.super.reversed();
        }

        @Override
        public Comparator<Coordinate> thenComparing(Comparator<? super Coordinate> x$1) {
            return Comparator.super.thenComparing(x$1);
        }

        @Override
        public <U> Comparator<Coordinate> thenComparing(Function<? super Coordinate, ? extends U> x$1, Comparator<? super U> x$2) {
            return Comparator.super.thenComparing(x$1, x$2);
        }

        @Override
        public <U extends Comparable<? super U>> Comparator<Coordinate> thenComparing(Function<? super Coordinate, ? extends U> x$1) {
            return Comparator.super.thenComparing(x$1);
        }

        @Override
        public Comparator<Coordinate> thenComparingInt(ToIntFunction<? super Coordinate> x$1) {
            return Comparator.super.thenComparingInt(x$1);
        }

        @Override
        public Comparator<Coordinate> thenComparingLong(ToLongFunction<? super Coordinate> x$1) {
            return Comparator.super.thenComparingLong(x$1);
        }

        @Override
        public Comparator<Coordinate> thenComparingDouble(ToDoubleFunction<? super Coordinate> x$1) {
            return Comparator.super.thenComparingDouble(x$1);
        }

        public Coordinate origin() {
            return this.origin;
        }

        public void origin_$eq(Coordinate x$1) {
            this.origin = x$1;
        }

        @Override
        public int compare(Coordinate p1, Coordinate p2) {
            return ConvexHull$RadialComparator$.MODULE$.org$locationtech$jts$algorithm$ConvexHull$RadialComparator$$polarCompare(this.origin(), p1, p2);
        }

        public RadialComparator(Coordinate origin) {
            this.origin = origin;
        }
    }
}

