/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.algorithm.InteriorPointArea$;
import org.locationtech.jts.algorithm.InteriorPointArea$InteriorPointPolygon$;
import org.locationtech.jts.algorithm.InteriorPointArea$ScanLineYOrdinateFinder$;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.util.Assert$;
import scala.UninitializedFieldError;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\tEq!B!C\u0011\u0003Ye!B'C\u0011\u0003q\u0005\"B+\u0002\t\u00031\u0006\"B,\u0002\t\u0003A\u0006\"B2\u0002\t\u0013!w!\u00027\u0002\u0011\u0013ig!B8\u0002\u0011\u0013\u0001\b\"B+\u0007\t\u0003\t\b\"\u0002:\u0007\t\u0013\u0019\b\"B?\u0007\t\u0013q\bbBA\u0004\r\u0011%\u0011\u0011\u0002\u0005\b\u0003\u000f1A\u0011BA\r\r\u0015y\u0017\u0001BA\u0011\u0011)\t\u0019\u0003\u0004BA\u0002\u0013\u0005\u0011Q\u0005\u0005\u000b\u0003[a!\u00111A\u0005\u0002\u0005=\u0002BCA\u001e\u0019\t\u0005\t\u0015)\u0003\u0002(!1Q\u000b\u0004C\u0001\u0003{A\u0011\"a\u0011\r\u0005\u0004%I!!\u0012\t\u000f\u0005\u001dC\u0002)A\u0005K\"I\u0011\u0011\n\u0007A\u0002\u0013%\u0011Q\t\u0005\n\u0003\u0017b\u0001\u0019!C\u0005\u0003\u001bBq!!\u0015\rA\u0003&Q\rC\u0005\u0002T1\u0001\r\u0011\"\u0003\u0002V!I\u0011q\u000b\u0007A\u0002\u0013%\u0011\u0011\f\u0005\b\u0003;b\u0001\u0015)\u0003Z\u0011\u00199F\u0002\"\u0001\u0002V!9\u0011q\f\u0007\u0005\u0002\u0005\u0015\u0003bBA1\u0019\u0011\u0005\u00111\r\u0005\b\u0003KbA\u0011BA4\u0011\u001d\t9\t\u0004C\u0005\u0003\u0013Cq!a%\r\t\u0013\t)jB\u0004\u0002\u001a\u0006AI!a'\u0007\u000f\u0005u\u0015\u0001#\u0003\u0002 \"1Q\u000b\tC\u0001\u0003CCq!a)!\t\u0003\t)K\u0002\u0004\u0002\u001e\u0006!\u00111\u0016\u0005\u000b\u0003S\u001b#\u00111A\u0005\u0002\u0005\u0015\u0002BCAWG\t\u0005\r\u0011\"\u0001\u00020\"Q\u00111W\u0012\u0003\u0002\u0003\u0006K!a\n\t\rU\u001bC\u0011AA[\u0011%\tYl\ta\u0001\n\u0013\t)\u0005C\u0005\u0002>\u000e\u0002\r\u0011\"\u0003\u0002@\"9\u00111Y\u0012!B\u0013)\u0007\"CAcG\u0001\u0007I\u0011BA#\u0011%\t9m\ta\u0001\n\u0013\tI\rC\u0004\u0002N\u000e\u0002\u000b\u0015B3\t\u0013\u0005=7\u00051A\u0005\n\u0005\u0015\u0003\"CAiG\u0001\u0007I\u0011BAj\u0011\u001d\t9n\tQ!\n\u0015Dq!a)$\t\u0003\t)\u0005C\u0004\u0002b\r\"I!!7\t\u000f\u0005\u00158\u0005\"\u0003\u0002h\u001a)QJ\u0011\u0001\u0002l\"Q\u0011Q\u001e\u001b\u0003\u0006\u0004%\t!a<\t\u0013\u0005EHG!A!\u0002\u0013\u0001\u0007BB+5\t\u0003\t\u0019\u0010C\u0005\u0002TQ\u0002\r\u0011\"\u0003\u0002V!I\u0011q\u000b\u001bA\u0002\u0013%\u0011\u0011 \u0005\b\u0003;\"\u0004\u0015)\u0003Z\u0011%\ti\u0010\u000ea\u0001\n\u0013\t)\u0005C\u0005\u0002\u0000R\u0002\r\u0011\"\u0003\u0003\u0002!9!Q\u0001\u001b!B\u0013)\u0007BB,5\t\u0003\t)\u0006C\u0004\u0002bQ\"IAa\u0002\t\u000f\t-A\u0007\"\u0003\u0003\u000e\u0005\t\u0012J\u001c;fe&|'\u000fU8j]R\f%/Z1\u000b\u0005\r#\u0015!C1mO>\u0014\u0018\u000e\u001e5n\u0015\t)e)A\u0002kiNT!a\u0012%\u0002\u00191|7-\u0019;j_:$Xm\u00195\u000b\u0003%\u000b1a\u001c:h\u0007\u0001\u0001\"\u0001T\u0001\u000e\u0003\t\u0013\u0011#\u00138uKJLwN\u001d)pS:$\u0018I]3b'\t\tq\n\u0005\u0002Q'6\t\u0011KC\u0001S\u0003\u0015\u00198-\u00197b\u0013\t!\u0016K\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003-\u000b\u0001cZ3u\u0013:$XM]5peB{\u0017N\u001c;\u0015\u0005e{\u0006C\u0001.^\u001b\u0005Y&B\u0001/E\u0003\u00119Wm\\7\n\u0005y[&AC\"p_J$\u0017N\\1uK\")Al\u0001a\u0001AB\u0011!,Y\u0005\u0003En\u0013\u0001bR3p[\u0016$(/_\u0001\u0004CZ<GcA3iUB\u0011\u0001KZ\u0005\u0003OF\u0013a\u0001R8vE2,\u0007\"B5\u0005\u0001\u0004)\u0017!A1\t\u000b-$\u0001\u0019A3\u0002\u0003\t\fA#\u00138uKJLwN\u001d)pS:$\bk\u001c7zO>t\u0007C\u00018\u0007\u001b\u0005\t!\u0001F%oi\u0016\u0014\u0018n\u001c:Q_&tG\u000fU8ms\u001e|gn\u0005\u0002\u0007\u001fR\tQ.A\u000bjg\u0016#w-Z\"s_N\u001c\u0018N\\4D_VtG/\u001a3\u0015\tQ<\u0018p\u001f\t\u0003!VL!A^)\u0003\u000f\t{w\u000e\\3b]\")\u0001\u0010\u0003a\u00013\u0006\u0011\u0001\u000f\r\u0005\u0006u\"\u0001\r!W\u0001\u0003aFBQ\u0001 \u0005A\u0002\u0015\fQa]2b]f\u000bA\"\u001b8uKJ\u001cXm\u0019;j_:$b!Z@\u0002\u0002\u0005\r\u0001\"\u0002=\n\u0001\u0004I\u0006\"\u0002>\n\u0001\u0004I\u0006BBA\u0003\u0013\u0001\u0007Q-A\u0001Z\u0003aIg\u000e^3sg\u0016\u001cGo\u001d%pe&TxN\u001c;bY2Kg.\u001a\u000b\u0006i\u0006-\u0011Q\u0003\u0005\b\u0003\u001bQ\u0001\u0019AA\b\u0003\r)gN\u001e\t\u00045\u0006E\u0011bAA\n7\nAQI\u001c<fY>\u0004X\r\u0003\u0004\u0002\u0018)\u0001\r!Z\u0001\u0002sR9A/a\u0007\u0002\u001e\u0005}\u0001\"\u0002=\f\u0001\u0004I\u0006\"\u0002>\f\u0001\u0004I\u0006BBA\f\u0017\u0001\u0007Qm\u0005\u0002\r\u001f\u00069\u0001o\u001c7zO>tWCAA\u0014!\rQ\u0016\u0011F\u0005\u0004\u0003WY&a\u0002)pYf<wN\\\u0001\fa>d\u0017pZ8o?\u0012*\u0017\u000f\u0006\u0003\u00022\u0005]\u0002c\u0001)\u00024%\u0019\u0011QG)\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003sq\u0011\u0011!a\u0001\u0003O\t1\u0001\u001f\u00132\u0003!\u0001x\u000e\\=h_:\u0004C\u0003BA \u0003\u0003\u0002\"A\u001c\u0007\t\u000f\u0005\r\u0002\u00031\u0001\u0002(\u0005q\u0011N\u001c;fe&|'\u000fU8j]RLV#A3\u0002\u001f%tG/\u001a:j_J\u0004v.\u001b8u3\u0002\nA#\u001b8uKJLwN]*fGRLwN\\,jIRD\u0017\u0001G5oi\u0016\u0014\u0018n\u001c:TK\u000e$\u0018n\u001c8XS\u0012$\bn\u0018\u0013fcR!\u0011\u0011GA(\u0011!\tI\u0004FA\u0001\u0002\u0004)\u0017!F5oi\u0016\u0014\u0018n\u001c:TK\u000e$\u0018n\u001c8XS\u0012$\b\u000eI\u0001\u000eS:$XM]5peB{\u0017N\u001c;\u0016\u0003e\u000b\u0011#\u001b8uKJLwN\u001d)pS:$x\fJ3r)\u0011\t\t$a\u0017\t\u0011\u0005er#!AA\u0002e\u000ba\"\u001b8uKJLwN\u001d)pS:$\b%\u0001\u0005hKR<\u0016\u000e\u001a;i\u0003\u001d\u0001(o\\2fgN$\"!!\r\u0002\u0011M\u001c\u0017M\u001c*j]\u001e$b!!\r\u0002j\u0005M\u0004bBA69\u0001\u0007\u0011QN\u0001\u0005e&tw\rE\u0002[\u0003_J1!!\u001d\\\u0005)a\u0015N\\3beJKgn\u001a\u0005\b\u0003kb\u0002\u0019AA<\u0003%\u0019'o\\:tS:<7\u000fE\u0003\u0002z\u0005\rU-\u0004\u0002\u0002|)!\u0011QPA@\u0003\u0011)H/\u001b7\u000b\u0005\u0005\u0005\u0015\u0001\u00026bm\u0006LA!!\"\u0002|\t!A*[:u\u0003=\tG\rZ#eO\u0016\u001c%o\\:tS:<GCCA\u0019\u0003\u0017\u000bi)a$\u0002\u0012\")\u00010\ba\u00013\")!0\ba\u00013\")A0\ba\u0001K\"9\u0011QO\u000fA\u0002\u0005]\u0014\u0001\u00054j]\u0012\u0014Um\u001d;NS\u0012\u0004x.\u001b8u)\u0011\t\t$a&\t\u000f\u0005Ud\u00041\u0001\u0002x\u000592kY1o\u0019&tW-W(sI&t\u0017\r^3GS:$WM\u001d\t\u0003]\u0002\u0012qcU2b]2Kg.Z-Pe\u0012Lg.\u0019;f\r&tG-\u001a:\u0014\u0005\u0001zECAAN\u000319W\r^*dC:d\u0015N\\3Z)\r)\u0017q\u0015\u0005\b\u0003S\u0013\u0003\u0019AA\u0014\u0003\u0011\u0001x\u000e\\=\u0014\u0005\rz\u0015\u0001\u00039pYf|F%Z9\u0015\t\u0005E\u0012\u0011\u0017\u0005\n\u0003s)\u0013\u0011!a\u0001\u0003O\tQ\u0001]8ms\u0002\"B!a.\u0002:B\u0011an\t\u0005\b\u0003S;\u0003\u0019AA\u0014\u0003\u001d\u0019WM\u001c;sKf\u000b1bY3oiJ,\u0017l\u0018\u0013fcR!\u0011\u0011GAa\u0011!\tI$KA\u0001\u0002\u0004)\u0017\u0001C2f]R\u0014X-\u0017\u0011\u0002\u0007!L\u0017,A\u0004iSf{F%Z9\u0015\t\u0005E\u00121\u001a\u0005\t\u0003sa\u0013\u0011!a\u0001K\u0006!\u0001.[-!\u0003\raw.W\u0001\bY>Lv\fJ3r)\u0011\t\t$!6\t\u0011\u0005er&!AA\u0002\u0015\fA\u0001\\8ZAQ!\u0011\u0011GAn\u0011\u001d\tiN\ra\u0001\u0003?\fA\u0001\\5oKB\u0019!,!9\n\u0007\u0005\r8L\u0001\u0006MS:,7\u000b\u001e:j]\u001e\fa\"\u001e9eCR,\u0017J\u001c;feZ\fG\u000e\u0006\u0003\u00022\u0005%\bBBA\fg\u0001\u0007Qm\u0005\u00025\u001f\u0006\tq-F\u0001a\u0003\t9\u0007\u0005\u0006\u0003\u0002v\u0006]\bC\u0001'5\u0011\u0019\tio\u000ea\u0001AR!\u0011\u0011GA~\u0011!\tI$OA\u0001\u0002\u0004I\u0016\u0001C7bq^KG\r\u001e5\u0002\u00195\f\u0007pV5ei\"|F%Z9\u0015\t\u0005E\"1\u0001\u0005\t\u0003sa\u0014\u0011!a\u0001K\u0006IQ.\u0019=XS\u0012$\b\u000e\t\u000b\u0005\u0003c\u0011I\u0001C\u0003]\u007f\u0001\u0007\u0001-\u0001\bqe>\u001cWm]:Q_2Lxm\u001c8\u0015\t\u0005E\"q\u0002\u0005\b\u0003G\u0001\u0005\u0019AA\u0014\u0001")
public class InteriorPointArea {
    private final Geometry g;
    private Coordinate interiorPoint;
    private double maxWidth;
    private volatile byte bitmap$init$0;

    public Geometry g() {
        return this.g;
    }

    private Coordinate interiorPoint() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/algorithm/InteriorPointArea.scala: 379");
        }
        return this.interiorPoint;
    }

    private void interiorPoint_$eq(Coordinate x$1) {
        this.interiorPoint = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
    }

    private double maxWidth() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/algorithm/InteriorPointArea.scala: 380");
        }
        return this.maxWidth;
    }

    private void maxWidth_$eq(double x$1) {
        this.maxWidth = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
    }

    public Coordinate getInteriorPoint() {
        return this.interiorPoint();
    }

    private void process(Geometry geom) {
        if (geom.isEmpty()) {
            return;
        }
        if (geom instanceof Polygon) {
            this.processPolygon((Polygon)geom);
        } else if (geom instanceof GeometryCollection) {
            GeometryCollection gc = (GeometryCollection)geom;
            for (int i = 0; i < gc.getNumGeometries(); ++i) {
                this.process(gc.getGeometryN(i));
            }
        }
    }

    private void processPolygon(Polygon polygon) {
        block0: {
            InteriorPointPolygon intPtPoly = new InteriorPointPolygon(polygon);
            intPtPoly.process();
            double width = intPtPoly.getWidth();
            if (!(width > this.maxWidth())) break block0;
            this.maxWidth_$eq(width);
            this.interiorPoint_$eq(intPtPoly.getInteriorPoint());
        }
    }

    public InteriorPointArea(Geometry g) {
        this.g = g;
        this.process(g);
        this.interiorPoint = null;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.maxWidth = -1.0;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
    }

    public static class InteriorPointPolygon {
        private Polygon polygon;
        private final double interiorPointY;
        private double interiorSectionWidth;
        private Coordinate interiorPoint;
        private volatile byte bitmap$init$0;

        public Polygon polygon() {
            return this.polygon;
        }

        public void polygon_$eq(Polygon x$1) {
            this.polygon = x$1;
        }

        private double interiorPointY() {
            if ((byte)(this.bitmap$init$0 & 1) == 0) {
                throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/algorithm/InteriorPointArea.scala: 179");
            }
            return this.interiorPointY;
        }

        private double interiorSectionWidth() {
            if ((byte)(this.bitmap$init$0 & 2) == 0) {
                throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/algorithm/InteriorPointArea.scala: 180");
            }
            return this.interiorSectionWidth;
        }

        private void interiorSectionWidth_$eq(double x$1) {
            this.interiorSectionWidth = x$1;
            this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        }

        private Coordinate interiorPoint() {
            if ((byte)(this.bitmap$init$0 & 4) == 0) {
                throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/algorithm/InteriorPointArea.scala: 181");
            }
            return this.interiorPoint;
        }

        private void interiorPoint_$eq(Coordinate x$1) {
            this.interiorPoint = x$1;
            this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
        }

        public Coordinate getInteriorPoint() {
            return this.interiorPoint();
        }

        public double getWidth() {
            return this.interiorSectionWidth();
        }

        public void process() {
            if (this.polygon().isEmpty()) {
                return;
            }
            this.interiorPoint_$eq(new Coordinate(this.polygon().getCoordinate()));
            ArrayList<Object> crossings = new ArrayList<Object>();
            this.scanRing(this.polygon().getExteriorRing(), crossings);
            for (int i = 0; i < this.polygon().getNumInteriorRing(); ++i) {
                this.scanRing(this.polygon().getInteriorRingN(i), crossings);
            }
            this.findBestMidpoint(crossings);
        }

        private void scanRing(LinearRing ring, List<Object> crossings) {
            if (!InteriorPointArea$InteriorPointPolygon$.MODULE$.org$locationtech$jts$algorithm$InteriorPointArea$InteriorPointPolygon$$intersectsHorizontalLine(ring.getEnvelopeInternal(), this.interiorPointY())) {
                return;
            }
            CoordinateSequence seq = ring.getCoordinateSequence();
            for (int i = 1; i < seq.size(); ++i) {
                Coordinate ptPrev = seq.getCoordinate(i - 1);
                Coordinate pt = seq.getCoordinate(i);
                this.addEdgeCrossing(ptPrev, pt, this.interiorPointY(), crossings);
            }
        }

        private void addEdgeCrossing(Coordinate p0, Coordinate p1, double scanY, List<Object> crossings) {
            if (!InteriorPointArea$InteriorPointPolygon$.MODULE$.org$locationtech$jts$algorithm$InteriorPointArea$InteriorPointPolygon$$intersectsHorizontalLine(p0, p1, scanY)) {
                return;
            }
            if (!InteriorPointArea$InteriorPointPolygon$.MODULE$.org$locationtech$jts$algorithm$InteriorPointArea$InteriorPointPolygon$$isEdgeCrossingCounted(p0, p1, scanY)) {
                return;
            }
            double xInt = InteriorPointArea$InteriorPointPolygon$.MODULE$.org$locationtech$jts$algorithm$InteriorPointArea$InteriorPointPolygon$$intersection(p0, p1, scanY);
            crossings.add(BoxesRunTime.boxToDouble((double)xInt));
        }

        private void findBestMidpoint(List<Object> crossings) {
            if (crossings.size() == 0) {
                return;
            }
            Assert$.MODULE$.isTrue(0 == crossings.size() % 2, "Interior Point robustness failure: odd number of scanline crossings");
            crossings.sort((x$1, x$2) -> InteriorPointPolygon.$anonfun$findBestMidpoint$1(BoxesRunTime.unboxToDouble((Object)x$1), BoxesRunTime.unboxToDouble((Object)x$2)));
            for (int i = 0; i < crossings.size(); i += 2) {
                double x1 = BoxesRunTime.unboxToDouble((Object)crossings.get(i));
                double x2 = BoxesRunTime.unboxToDouble((Object)crossings.get(i + 1));
                double width = x2 - x1;
                if (!(width > this.interiorSectionWidth())) continue;
                this.interiorSectionWidth_$eq(width);
                double interiorPointX = InteriorPointArea$.MODULE$.org$locationtech$jts$algorithm$InteriorPointArea$$avg(x1, x2);
                this.interiorPoint_$eq(new Coordinate(interiorPointX, this.interiorPointY()));
            }
        }

        public static final /* synthetic */ int $anonfun$findBestMidpoint$1(double x$1, double x$2) {
            return Double.compare(x$1, x$2);
        }

        public InteriorPointPolygon(Polygon polygon) {
            this.polygon = polygon;
            this.interiorPointY = InteriorPointArea$ScanLineYOrdinateFinder$.MODULE$.getScanLineY(this.polygon());
            this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
            this.interiorSectionWidth = 0.0;
            this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
            this.interiorPoint = null;
            this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
        }
    }

    public static class ScanLineYOrdinateFinder {
        private Polygon poly;
        private double centreY;
        private double hiY;
        private double loY;
        private volatile byte bitmap$init$0;

        public Polygon poly() {
            return this.poly;
        }

        public void poly_$eq(Polygon x$1) {
            this.poly = x$1;
        }

        private double centreY() {
            if ((byte)(this.bitmap$init$0 & 1) == 0) {
                throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/algorithm/InteriorPointArea.scala: 333");
            }
            return this.centreY;
        }

        private void centreY_$eq(double x$1) {
            this.centreY = x$1;
            this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        }

        private double hiY() {
            if ((byte)(this.bitmap$init$0 & 2) == 0) {
                throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/algorithm/InteriorPointArea.scala: 334");
            }
            return this.hiY;
        }

        private void hiY_$eq(double x$1) {
            this.hiY = x$1;
            this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        }

        private double loY() {
            if ((byte)(this.bitmap$init$0 & 4) == 0) {
                throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/algorithm/InteriorPointArea.scala: 335");
            }
            return this.loY;
        }

        private void loY_$eq(double x$1) {
            this.loY = x$1;
            this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
        }

        /*
         * WARNING - void declaration
         */
        public double getScanLineY() {
            void var2_2;
            this.process(this.poly().getExteriorRing());
            for (int i = 0; i < this.poly().getNumInteriorRing(); ++i) {
                this.process(this.poly().getInteriorRingN(i));
            }
            double scanLineY = InteriorPointArea$.MODULE$.org$locationtech$jts$algorithm$InteriorPointArea$$avg(this.hiY(), this.loY());
            return (double)var2_2;
        }

        private void process(LineString line) {
            CoordinateSequence seq = line.getCoordinateSequence();
            for (int i = 0; i < seq.size(); ++i) {
                double y = seq.getY(i);
                this.updateInterval(y);
            }
        }

        private void updateInterval(double y) {
            block0: {
                block1: {
                    if (!(y <= this.centreY())) break block0;
                    if (!(y > this.loY())) break block1;
                    this.loY_$eq(y);
                    break block0;
                }
                if (!(y > this.centreY()) || !(y < this.hiY())) break block0;
                this.hiY_$eq(y);
            }
        }

        public ScanLineYOrdinateFinder(Polygon poly) {
            this.poly = poly;
            this.centreY = 0.0;
            this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
            this.hiY = Double.MAX_VALUE;
            this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
            this.loY = -Double.MAX_VALUE;
            this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
            this.hiY_$eq(this.poly().getEnvelopeInternal().getMaxY());
            this.loY_$eq(this.poly().getEnvelopeInternal().getMinY());
            this.centreY_$eq(InteriorPointArea$.MODULE$.org$locationtech$jts$algorithm$InteriorPointArea$$avg(this.loY(), this.hiY()));
        }
    }
}

