/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import org.locationtech.jts.algorithm.ConvexHull;
import org.locationtech.jts.algorithm.MinimumDiameter$;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import scala.UninitializedFieldError;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u00055t!B\u0014)\u0011\u0003\td!B\u001a)\u0011\u0003!\u0004\"B\u001e\u0002\t\u0003a\u0004\"B\u001f\u0002\t\u0003q\u0004\"\u0002$\u0002\t\u00039\u0005\"\u0002'\u0002\t\u0013i\u0005\"B.\u0002\t\u0013a\u0006\"\u00024\u0002\t\u00139g\u0001B\u001a)\u0001=D\u0001\u0002\u001d\u0005\u0003\u0006\u0004%\t!\u001d\u0005\te\"\u0011\t\u0011)A\u0005\u007f!A1\u000f\u0003BC\u0002\u0013\u0005A\u000f\u0003\u0005y\u0011\t\u0005\t\u0015!\u0003v\u0011\u0015Y\u0004\u0002\"\u0001z\u0011\u001di\b\u00021A\u0005\nyD\u0001b \u0005A\u0002\u0013%\u0011\u0011\u0001\u0005\b\u0003\u001bA\u0001\u0015)\u0003T\u0011%\ty\u0001\u0003a\u0001\n\u0013\t\t\u0002C\u0005\u0002\u0014!\u0001\r\u0011\"\u0003\u0002\u0016!9\u0011\u0011\u0004\u0005!B\u0013A\u0007\"CA\u000e\u0011\u0001\u0007I\u0011BA\u000f\u0011%\ty\u0002\u0003a\u0001\n\u0013\t\t\u0003C\u0004\u0002&!\u0001\u000b\u0015\u0002,\t\u0013\u0005\u001d\u0002\u00021A\u0005\n\u0005%\u0002\"CA\u0016\u0011\u0001\u0007I\u0011BA\u0017\u0011\u001d\t\t\u0004\u0003Q!\n9C\u0011\"a\r\t\u0001\u0004%I!!\u000e\t\u0013\u0005]\u0002\u00021A\u0005\n\u0005e\u0002bBA\u001f\u0011\u0001\u0006K!\u0018\u0005\u0007w!!\t!a\u0010\t\u000f\u0005\r\u0003\u0002\"\u0001\u00026!9\u0011Q\t\u0005\u0005\u0002\u0005u\u0001bBA$\u0011\u0011\u0005\u0011\u0011\n\u0005\b\u0003\u0017BA\u0011AA%\u0011\u001d\ti\u0005\u0003C\u0005\u0003\u001fBq!!\u0015\t\t\u0013\t\u0019\u0006C\u0004\u0002Z!!I!a\u0017\t\u000f\u0005}\u0003\u0002\"\u0003\u0002b!)Q\b\u0003C\u0001c\u0006yQ*\u001b8j[VlG)[1nKR,'O\u0003\u0002*U\u0005I\u0011\r\\4pe&$\b.\u001c\u0006\u0003W1\n1A\u001b;t\u0015\tic&\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u00010\u0003\ry'oZ\u0002\u0001!\t\u0011\u0014!D\u0001)\u0005=i\u0015N\\5nk6$\u0015.Y7fi\u0016\u00148CA\u00016!\t1\u0014(D\u00018\u0015\u0005A\u0014!B:dC2\f\u0017B\u0001\u001e8\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!M\u0001\u0014O\u0016$X*\u001b8j[Vl'+Z2uC:<G.\u001a\u000b\u0003\u007f\u0015\u0003\"\u0001Q\"\u000e\u0003\u0005S!A\u0011\u0016\u0002\t\u001d,w.\\\u0005\u0003\t\u0006\u0013\u0001bR3p[\u0016$(/\u001f\u0005\u0006\u0005\u000e\u0001\raP\u0001\u0013O\u0016$X*\u001b8j[VlG)[1nKR,'\u000f\u0006\u0002I\u0017B\u0011\u0001)S\u0005\u0003\u0015\u0006\u0013!\u0002T5oKN#(/\u001b8h\u0011\u0015\u0011E\u00011\u0001@\u0003%qW\r\u001f;J]\u0012,\u0007\u0010F\u0002O#f\u0003\"AN(\n\u0005A;$aA%oi\")!+\u0002a\u0001'\u0006\u0019\u0001\u000f^:\u0011\u0007Y\"f+\u0003\u0002Vo\t)\u0011I\u001d:bsB\u0011\u0001iV\u0005\u00031\u0006\u0013!bQ8pe\u0012Lg.\u0019;f\u0011\u0015QV\u00011\u0001O\u0003\u0011Ig\u000eZ3\u0002\u0011\r|W\u000e];uK\u000e#B!\u00181cIB\u0011aGX\u0005\u0003?^\u0012a\u0001R8vE2,\u0007\"B1\u0007\u0001\u0004i\u0016!A1\t\u000b\r4\u0001\u0019A/\u0002\u0003\tDQ!\u001a\u0004A\u0002Y\u000b\u0011\u0001]\u0001\u0016G>l\u0007/\u001e;f'\u0016<W.\u001a8u\r>\u0014H*\u001b8f)\u0011A7\u000e\\7\u0011\u0005\u0001K\u0017B\u00016B\u0005-a\u0015N\\3TK\u001elWM\u001c;\t\u000b\u0005<\u0001\u0019A/\t\u000b\r<\u0001\u0019A/\t\u000b9<\u0001\u0019A/\u0002\u0003\r\u001c\"\u0001C\u001b\u0002\u0013%t\u0007/\u001e;HK>lW#A \u0002\u0015%t\u0007/\u001e;HK>l\u0007%\u0001\u0005jg\u000e{gN^3y+\u0005)\bC\u0001\u001cw\u0013\t9xGA\u0004C_>dW-\u00198\u0002\u0013%\u001c8i\u001c8wKb\u0004Cc\u0001>|yB\u0011!\u0007\u0003\u0005\u0006a6\u0001\ra\u0010\u0005\u0006g6\u0001\r!^\u0001\u000eG>tg/\u001a=Ik2d\u0007\u000b^:\u0016\u0003M\u000b\u0011cY8om\u0016D\b*\u001e7m!R\u001cx\fJ3r)\u0011\t\u0019!!\u0003\u0011\u0007Y\n)!C\u0002\u0002\b]\u0012A!\u00168ji\"A\u00111B\b\u0002\u0002\u0003\u00071+A\u0002yIE\nabY8om\u0016D\b*\u001e7m!R\u001c\b%\u0001\u0006nS:\u0014\u0015m]3TK\u001e,\u0012\u0001[\u0001\u000f[&t')Y:f'\u0016<w\fJ3r)\u0011\t\u0019!a\u0006\t\u0011\u0005-!#!AA\u0002!\f1\"\\5o\u0005\u0006\u001cXmU3hA\u0005QQ.\u001b8XS\u0012$\b\u000e\u0015;\u0016\u0003Y\u000ba\"\\5o/&$G\u000f\u001b)u?\u0012*\u0017\u000f\u0006\u0003\u0002\u0004\u0005\r\u0002\u0002CA\u0006+\u0005\u0005\t\u0019\u0001,\u0002\u00175LgnV5ei\"\u0004F\u000fI\u0001\u000b[&t\u0007\u000b^%oI\u0016DX#\u0001(\u0002\u001d5Lg\u000e\u0015;J]\u0012,\u0007p\u0018\u0013fcR!\u00111AA\u0018\u0011!\tY\u0001GA\u0001\u0002\u0004q\u0015aC7j]B#\u0018J\u001c3fq\u0002\n\u0001\"\\5o/&$G\u000f[\u000b\u0002;\u0006aQ.\u001b8XS\u0012$\bn\u0018\u0013fcR!\u00111AA\u001e\u0011!\tYaGA\u0001\u0002\u0004i\u0016!C7j]^KG\r\u001e5!)\rQ\u0018\u0011\t\u0005\u0006av\u0001\raP\u0001\nO\u0016$H*\u001a8hi\"\f!cZ3u/&$G\u000f[\"p_J$\u0017N\\1uK\u0006!r-\u001a;TkB\u0004xN\u001d;j]\u001e\u001cVmZ7f]R,\u0012\u0001S\u0001\fO\u0016$H)[1nKR,'/\u0001\fd_6\u0004X\u000f^3NS:LW.^7ES\u0006lW\r^3s)\t\t\u0019!\u0001\nd_6\u0004X\u000f^3XS\u0012$\bnQ8om\u0016DH\u0003BA\u0002\u0003+Ba!a\u0016$\u0001\u0004y\u0014AC2p]Z,\u0007pR3p[\u0006a2m\\7qkR,7i\u001c8wKb\u0014\u0016N\\4NS:$\u0015.Y7fi\u0016\u0014H\u0003BA\u0002\u0003;BQA\u0015\u0013A\u0002M\u000b1CZ5oI6\u000b\u0007\u0010U3sa\u0012K7\u000f^1oG\u0016$rATA2\u0003K\nI\u0007C\u0003SK\u0001\u00071\u000b\u0003\u0004\u0002h\u0015\u0002\r\u0001[\u0001\u0004g\u0016<\u0007BBA6K\u0001\u0007a*\u0001\u0006ti\u0006\u0014H/\u00138eKb\u0004")
public class MinimumDiameter {
    private final Geometry inputGeom;
    private final boolean isConvex;
    private Coordinate[] convexHullPts;
    private LineSegment minBaseSeg;
    private Coordinate minWidthPt;
    private int minPtIndex;
    private double minWidth;
    private volatile byte bitmap$init$0;

    public static LineString getMinimumDiameter(Geometry geometry) {
        return MinimumDiameter$.MODULE$.getMinimumDiameter(geometry);
    }

    public Geometry inputGeom() {
        return this.inputGeom;
    }

    public boolean isConvex() {
        return this.isConvex;
    }

    private Coordinate[] convexHullPts() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/algorithm/MinimumDiameter.scala: 101");
        }
        return this.convexHullPts;
    }

    private void convexHullPts_$eq(Coordinate[] x$1) {
        this.convexHullPts = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
    }

    private LineSegment minBaseSeg() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/algorithm/MinimumDiameter.scala: 102");
        }
        return this.minBaseSeg;
    }

    private void minBaseSeg_$eq(LineSegment x$1) {
        this.minBaseSeg = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
    }

    private Coordinate minWidthPt() {
        if ((byte)(this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/algorithm/MinimumDiameter.scala: 103");
        }
        return this.minWidthPt;
    }

    private void minWidthPt_$eq(Coordinate x$1) {
        this.minWidthPt = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
    }

    private int minPtIndex() {
        if ((byte)(this.bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/algorithm/MinimumDiameter.scala: 104");
        }
        return this.minPtIndex;
    }

    private void minPtIndex_$eq(int x$1) {
        this.minPtIndex = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
    }

    private double minWidth() {
        if ((byte)(this.bitmap$init$0 & 0x10) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/algorithm/MinimumDiameter.scala: 105");
        }
        return this.minWidth;
    }

    private void minWidth_$eq(double x$1) {
        this.minWidth = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x10);
    }

    public double getLength() {
        this.computeMinimumDiameter();
        return this.minWidth();
    }

    public Coordinate getWidthCoordinate() {
        this.computeMinimumDiameter();
        return this.minWidthPt();
    }

    public LineString getSupportingSegment() {
        this.computeMinimumDiameter();
        return this.inputGeom().getFactory().createLineString((Coordinate[])((Object[])new Coordinate[]{this.minBaseSeg().p0(), this.minBaseSeg().p1()}));
    }

    public LineString getDiameter() {
        this.computeMinimumDiameter();
        if (this.minWidthPt() == null) {
            return this.inputGeom().getFactory().createLineString();
        }
        Coordinate basePt = this.minBaseSeg().project(this.minWidthPt());
        return this.inputGeom().getFactory().createLineString((Coordinate[])((Object[])new Coordinate[]{basePt, this.minWidthPt()}));
    }

    private void computeMinimumDiameter() {
        if (this.minWidthPt() != null) {
            return;
        }
        if (this.isConvex()) {
            this.computeWidthConvex(this.inputGeom());
        } else {
            Geometry convexGeom = new ConvexHull(this.inputGeom()).getConvexHull();
            this.computeWidthConvex(convexGeom);
        }
    }

    private void computeWidthConvex(Geometry convexGeom) {
        if (convexGeom instanceof Polygon) {
            this.convexHullPts_$eq(((Polygon)convexGeom).getExteriorRing().getCoordinates());
        } else {
            this.convexHullPts_$eq(convexGeom.getCoordinates());
        }
        if (this.convexHullPts().length == 0) {
            this.minWidth_$eq(0.0);
            this.minWidthPt_$eq(null);
            this.minBaseSeg_$eq(null);
        } else if (this.convexHullPts().length == 1) {
            this.minWidth_$eq(0.0);
            this.minWidthPt_$eq(this.convexHullPts()[0]);
            this.minBaseSeg().p0_$eq(this.convexHullPts()[0]);
            this.minBaseSeg().p1_$eq(this.convexHullPts()[0]);
        } else if (this.convexHullPts().length == 2 || this.convexHullPts().length == 3) {
            this.minWidth_$eq(0.0);
            this.minWidthPt_$eq(this.convexHullPts()[0]);
            this.minBaseSeg().p0_$eq(this.convexHullPts()[0]);
            this.minBaseSeg().p1_$eq(this.convexHullPts()[1]);
        } else {
            this.computeConvexRingMinDiameter(this.convexHullPts());
        }
    }

    private void computeConvexRingMinDiameter(Coordinate[] pts) {
        this.minWidth_$eq(Double.MAX_VALUE);
        int currMaxIndex = 1;
        LineSegment seg = new LineSegment();
        for (int i = 0; i < pts.length - 1; ++i) {
            seg.p0_$eq(pts[i]);
            seg.p1_$eq(pts[i + 1]);
            currMaxIndex = this.findMaxPerpDistance(pts, seg, currMaxIndex);
        }
    }

    private int findMaxPerpDistance(Coordinate[] pts, LineSegment seg, int startIndex) {
        int maxIndex;
        block1: {
            double maxPerpDistance;
            double nextPerpDistance = maxPerpDistance = seg.distancePerpendicular(pts[startIndex]);
            int nextIndex = maxIndex = startIndex;
            while (nextPerpDistance >= maxPerpDistance) {
                maxPerpDistance = nextPerpDistance;
                maxIndex = nextIndex;
                nextIndex = MinimumDiameter$.MODULE$.org$locationtech$jts$algorithm$MinimumDiameter$$nextIndex(pts, maxIndex);
                nextPerpDistance = seg.distancePerpendicular(pts[nextIndex]);
            }
            if (!(maxPerpDistance < this.minWidth())) break block1;
            this.minPtIndex_$eq(maxIndex);
            this.minWidth_$eq(maxPerpDistance);
            this.minWidthPt_$eq(pts[this.minPtIndex()]);
            this.minBaseSeg_$eq(new LineSegment(seg));
        }
        return maxIndex;
    }

    public Geometry getMinimumRectangle() {
        this.computeMinimumDiameter();
        if (this.minWidth() == 0.0) {
            if (this.minBaseSeg().p0().equals2D(this.minBaseSeg().p1())) {
                return this.inputGeom().getFactory().createPoint(this.minBaseSeg().p0());
            }
            return this.minBaseSeg().toGeometry(this.inputGeom().getFactory());
        }
        double dx = this.minBaseSeg().p1().x() - this.minBaseSeg().p0().x();
        double dy = this.minBaseSeg().p1().y() - this.minBaseSeg().p0().y();
        double minPara = Double.MAX_VALUE;
        double maxPara = -Double.MAX_VALUE;
        double minPerp = Double.MAX_VALUE;
        double maxPerp = -Double.MAX_VALUE;
        for (int i = 0; i < this.convexHullPts().length; ++i) {
            double perpC;
            double paraC = MinimumDiameter$.MODULE$.org$locationtech$jts$algorithm$MinimumDiameter$$computeC(dx, dy, this.convexHullPts()[i]);
            if (paraC > maxPara) {
                maxPara = paraC;
            }
            if (paraC < minPara) {
                minPara = paraC;
            }
            if ((perpC = MinimumDiameter$.MODULE$.org$locationtech$jts$algorithm$MinimumDiameter$$computeC(-dy, dx, this.convexHullPts()[i])) > maxPerp) {
                maxPerp = perpC;
            }
            if (!(perpC < minPerp)) continue;
            minPerp = perpC;
        }
        LineSegment maxPerpLine = MinimumDiameter$.MODULE$.org$locationtech$jts$algorithm$MinimumDiameter$$computeSegmentForLine(-dx, -dy, maxPerp);
        LineSegment minPerpLine = MinimumDiameter$.MODULE$.org$locationtech$jts$algorithm$MinimumDiameter$$computeSegmentForLine(-dx, -dy, minPerp);
        LineSegment maxParaLine = MinimumDiameter$.MODULE$.org$locationtech$jts$algorithm$MinimumDiameter$$computeSegmentForLine(-dy, dx, maxPara);
        LineSegment minParaLine = MinimumDiameter$.MODULE$.org$locationtech$jts$algorithm$MinimumDiameter$$computeSegmentForLine(-dy, dx, minPara);
        Coordinate p0 = maxParaLine.lineIntersection(maxPerpLine);
        Coordinate p1 = minParaLine.lineIntersection(maxPerpLine);
        Coordinate p2 = minParaLine.lineIntersection(minPerpLine);
        Coordinate p3 = maxParaLine.lineIntersection(minPerpLine);
        LinearRing shell = this.inputGeom().getFactory().createLinearRing((Coordinate[])((Object[])new Coordinate[]{p0, p1, p2, p3, p0}));
        return this.inputGeom().getFactory().createPolygon(shell);
    }

    public MinimumDiameter(Geometry inputGeom, boolean isConvex) {
        this.inputGeom = inputGeom;
        this.isConvex = isConvex;
        this.convexHullPts = null;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.minBaseSeg = new LineSegment();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.minWidthPt = null;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
        this.minPtIndex = 0;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
        this.minWidth = 0.0;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x10);
    }

    public MinimumDiameter(Geometry inputGeom) {
        this(inputGeom, false);
    }
}

