/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import org.locationtech.jts.algorithm.CGAlgorithmsDD$;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import scala.UninitializedFieldError;

public final class Orientation$ {
    public static final Orientation$ MODULE$ = new Orientation$();
    private static final int CLOCKWISE = -1;
    private static final int RIGHT;
    private static final int COUNTERCLOCKWISE;
    private static final int LEFT;
    private static final int COLLINEAR;
    private static final int STRAIGHT;
    private static volatile byte bitmap$init$0;

    static {
        bitmap$init$0 = (byte)(bitmap$init$0 | 1);
        RIGHT = MODULE$.CLOCKWISE();
        bitmap$init$0 = (byte)(bitmap$init$0 | 2);
        COUNTERCLOCKWISE = 1;
        bitmap$init$0 = (byte)(bitmap$init$0 | 4);
        LEFT = MODULE$.COUNTERCLOCKWISE();
        bitmap$init$0 = (byte)(bitmap$init$0 | 8);
        COLLINEAR = 0;
        bitmap$init$0 = (byte)(bitmap$init$0 | 0x10);
        STRAIGHT = MODULE$.COLLINEAR();
        bitmap$init$0 = (byte)(bitmap$init$0 | 0x20);
    }

    public int CLOCKWISE() {
        if ((byte)(bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/algorithm/Orientation.scala: 48");
        }
        return CLOCKWISE;
    }

    public int RIGHT() {
        if ((byte)(bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/algorithm/Orientation.scala: 49");
        }
        return RIGHT;
    }

    public int COUNTERCLOCKWISE() {
        if ((byte)(bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/algorithm/Orientation.scala: 53");
        }
        return COUNTERCLOCKWISE;
    }

    public int LEFT() {
        if ((byte)(bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/algorithm/Orientation.scala: 54");
        }
        return LEFT;
    }

    public int COLLINEAR() {
        if ((byte)(bitmap$init$0 & 0x10) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/algorithm/Orientation.scala: 58");
        }
        return COLLINEAR;
    }

    public int STRAIGHT() {
        if ((byte)(bitmap$init$0 & 0x20) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/algorithm/Orientation.scala: 59");
        }
        return STRAIGHT;
    }

    public int index(Coordinate p1, Coordinate p2, Coordinate q) {
        return CGAlgorithmsDD$.MODULE$.orientationIndex(p1, p2, q);
    }

    public boolean isCCW(Coordinate[] ring) {
        int nPts = ring.length - 1;
        if (nPts < 3) {
            throw new IllegalArgumentException("Ring has fewer than 4 points, so orientation cannot be determined");
        }
        Coordinate hiPt = ring[0];
        int hiIndex = 0;
        int i = 1;
        while (i <= nPts) {
            Coordinate p = ring[i];
            if (p.y() > hiPt.y()) {
                hiPt = p;
                hiIndex = i;
            }
            int cfr_ignored_0 = ++i - 1;
        }
        int iPrev = hiIndex;
        do {
            if (--iPrev >= 0) continue;
            iPrev = nPts;
        } while (ring[iPrev].equals2D(hiPt) && iPrev != hiIndex);
        int iNext = hiIndex;
        while (ring[iNext = (iNext + 1) % nPts].equals2D(hiPt) && iNext != hiIndex) {
        }
        Coordinate prev = ring[iPrev];
        Coordinate next = ring[iNext];
        if (prev.equals2D(hiPt) || next.equals2D(hiPt) || prev.equals2D(next)) {
            return false;
        }
        int disc = this.index(prev, hiPt, next);
        boolean isCCW = false;
        isCCW = disc == 0 ? prev.x() > next.x() : disc > 0;
        return isCCW;
    }

    public boolean isCCW(CoordinateSequence ring) {
        int nPts = ring.size() - 1;
        if (nPts < 3) {
            throw new IllegalArgumentException("Ring has fewer than 4 points, so orientation cannot be determined");
        }
        Coordinate hiPt = ring.getCoordinate(0);
        int hiIndex = 0;
        int i = 1;
        while (i <= nPts) {
            Coordinate p = ring.getCoordinate(i);
            if (p.y() > hiPt.y()) {
                hiPt = p;
                hiIndex = i;
            }
            int cfr_ignored_0 = ++i - 1;
        }
        Coordinate prev = null;
        int iPrev = hiIndex;
        do {
            if (--iPrev >= 0) continue;
            iPrev = nPts;
        } while ((prev = ring.getCoordinate(iPrev)).equals2D(hiPt) && iPrev != hiIndex);
        Coordinate next = null;
        int iNext = hiIndex;
        while ((next = ring.getCoordinate(iNext = (iNext + 1) % nPts)).equals2D(hiPt) && iNext != hiIndex) {
        }
        if (prev.equals2D(hiPt) || next.equals2D(hiPt) || prev.equals2D(next)) {
            return false;
        }
        int disc = this.index(prev, hiPt, next);
        boolean isCCW = false;
        isCCW = disc == 0 ? prev.x() > next.x() : disc > 0;
        return isCCW;
    }

    private Orientation$() {
    }
}

