/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import org.locationtech.jts.algorithm.BoundaryNodeRule;
import org.locationtech.jts.algorithm.PointLocation$;
import org.locationtech.jts.algorithm.PointLocator$;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryCollectionIterator;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Location$;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import scala.UninitializedFieldError;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005}a\u0001B\u000b\u0017\u0001}A\u0001B\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\u0006W\u0001!\t\u0001\f\u0005\b_\u0001\u0001\r\u0011\"\u00031\u0011\u001d!\u0004\u00011A\u0005\nUBaa\u000f\u0001!B\u0013\t\u0004b\u0002\u001f\u0001\u0001\u0004%I!\u0010\u0005\b\u0003\u0002\u0001\r\u0011\"\u0003C\u0011\u0019!\u0005\u0001)Q\u0005}!)Q\t\u0001C\u0001\r\")1\u000b\u0001C\u0001)\")q\u000b\u0001C\u00051\")1\f\u0001C\u00059\")q\f\u0001C\u0005A\")q\r\u0001C\u0005Q\")q\u000e\u0001C\u0005a\")q\u000f\u0001C\u0005q\u001eAqPFA\u0001\u0012\u0003\t\tA\u0002\u0005\u0016-\u0005\u0005\t\u0012AA\u0002\u0011\u0019Y#\u0003\"\u0001\u0002\u0006!I\u0011q\u0001\n\u0012\u0002\u0013\u0005\u0011\u0011\u0002\u0002\r!>Lg\u000e\u001e'pG\u0006$xN\u001d\u0006\u0003/a\t\u0011\"\u00197h_JLG\u000f[7\u000b\u0005eQ\u0012a\u00016ug*\u00111\u0004H\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002;\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\t\t\u0003C\u0011j\u0011A\t\u0006\u0002G\u0005)1oY1mC&\u0011QE\t\u0002\u0007\u0003:L(+\u001a4\u0002\u0019\t|WO\u001c3bef\u0014V\u000f\\3\u0011\u0005!JS\"\u0001\f\n\u0005)2\"\u0001\u0005\"pk:$\u0017M]=O_\u0012,'+\u001e7f\u0003\u0019a\u0014N\\5u}Q\u0011QF\f\t\u0003Q\u0001AqA\n\u0002\u0011\u0002\u0003\u0007q%\u0001\u0003jg&sW#A\u0019\u0011\u0005\u0005\u0012\u0014BA\u001a#\u0005\u001d\u0011un\u001c7fC:\f\u0001\"[:J]~#S-\u001d\u000b\u0003me\u0002\"!I\u001c\n\u0005a\u0012#\u0001B+oSRDqA\u000f\u0003\u0002\u0002\u0003\u0007\u0011'A\u0002yIE\nQ![:J]\u0002\nQB\\;n\u0005>,h\u000eZ1sS\u0016\u001cX#\u0001 \u0011\u0005\u0005z\u0014B\u0001!#\u0005\rIe\u000e^\u0001\u0012]Vl'i\\;oI\u0006\u0014\u0018.Z:`I\u0015\fHC\u0001\u001cD\u0011\u001dQt!!AA\u0002y\naB\\;n\u0005>,h\u000eZ1sS\u0016\u001c\b%\u0001\u0006j]R,'o]3diN$2!M$P\u0011\u0015A\u0015\u00021\u0001J\u0003\u0005\u0001\bC\u0001&N\u001b\u0005Y%B\u0001'\u0019\u0003\u00119Wm\\7\n\u00059[%AC\"p_J$\u0017N\\1uK\")A*\u0003a\u0001!B\u0011!*U\u0005\u0003%.\u0013\u0001bR3p[\u0016$(/_\u0001\u0007Y>\u001c\u0017\r^3\u0015\u0007y*f\u000bC\u0003I\u0015\u0001\u0007\u0011\nC\u0003M\u0015\u0001\u0007\u0001+A\bd_6\u0004X\u000f^3M_\u000e\fG/[8o)\r1\u0014L\u0017\u0005\u0006\u0011.\u0001\r!\u0013\u0005\u0006\u0019.\u0001\r\u0001U\u0001\u0013kB$\u0017\r^3M_\u000e\fG/[8o\u0013:4w\u000e\u0006\u00027;\")a\f\u0004a\u0001}\u0005\u0019An\\2\u0002\u001b1|7-\u0019;f\u001f:\u0004v.\u001b8u)\rq\u0014M\u0019\u0005\u0006\u00116\u0001\r!\u0013\u0005\u0006G6\u0001\r\u0001Z\u0001\u0003aR\u0004\"AS3\n\u0005\u0019\\%!\u0002)pS:$\u0018A\u00057pG\u0006$Xm\u00148MS:,7\u000b\u001e:j]\u001e$2AP5k\u0011\u0015Ae\u00021\u0001J\u0011\u0015Yg\u00021\u0001m\u0003\u0005a\u0007C\u0001&n\u0013\tq7J\u0001\u0006MS:,7\u000b\u001e:j]\u001e\f1\u0003\\8dCR,\u0017J\u001c)pYf<wN\u001c*j]\u001e$2AP9s\u0011\u0015Au\u00021\u0001J\u0011\u0015\u0019x\u00021\u0001u\u0003\u0011\u0011\u0018N\\4\u0011\u0005)+\u0018B\u0001<L\u0005)a\u0015N\\3beJKgnZ\u0001\u0010Y>\u001c\u0017\r^3J]B{G._4p]R\u0019a(\u001f>\t\u000b!\u0003\u0002\u0019A%\t\u000bm\u0004\u0002\u0019\u0001?\u0002\tA|G.\u001f\t\u0003\u0015vL!A`&\u0003\u000fA{G._4p]\u0006a\u0001k\\5oi2{7-\u0019;peB\u0011\u0001FE\n\u0003%\u0001\"\"!!\u0001\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\tYAK\u0002(\u0003\u001bY#!a\u0004\u0011\t\u0005E\u00111D\u0007\u0003\u0003'QA!!\u0006\u0002\u0018\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u00033\u0011\u0013AC1o]>$\u0018\r^5p]&!\u0011QDA\n\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class PointLocator {
    private final BoundaryNodeRule boundaryRule;
    private boolean isIn;
    private int numBoundaries;
    private volatile byte bitmap$init$0;

    public static BoundaryNodeRule $lessinit$greater$default$1() {
        return PointLocator$.MODULE$.$lessinit$greater$default$1();
    }

    private boolean isIn() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/algorithm/PointLocator.scala: 53");
        }
        return this.isIn;
    }

    private void isIn_$eq(boolean x$1) {
        this.isIn = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
    }

    private int numBoundaries() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/algorithm/PointLocator.scala: 54");
        }
        return this.numBoundaries;
    }

    private void numBoundaries_$eq(int x$1) {
        this.numBoundaries = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
    }

    public boolean intersects(Coordinate p, Geometry geom) {
        return this.locate(p, geom) != Location$.MODULE$.EXTERIOR();
    }

    public int locate(Coordinate p, Geometry geom) {
        if (geom.isEmpty()) {
            return Location$.MODULE$.EXTERIOR();
        }
        if (geom instanceof LineString) {
            return this.locateOnLineString(p, (LineString)geom);
        }
        if (geom instanceof Polygon) {
            return this.locateInPolygon(p, (Polygon)geom);
        }
        this.isIn_$eq(false);
        this.numBoundaries_$eq(0);
        this.computeLocation(p, geom);
        if (this.boundaryRule.isInBoundary(this.numBoundaries())) {
            return Location$.MODULE$.BOUNDARY();
        }
        if (this.numBoundaries() > 0 || this.isIn()) {
            return Location$.MODULE$.INTERIOR();
        }
        return Location$.MODULE$.EXTERIOR();
    }

    private void computeLocation(Coordinate p, Geometry geom) {
        block5: {
            block8: {
                block7: {
                    block6: {
                        block4: {
                            if (geom instanceof Point) {
                                this.updateLocationInfo(this.locateOnPoint(p, (Point)geom));
                            }
                            if (!(geom instanceof LineString)) break block4;
                            this.updateLocationInfo(this.locateOnLineString(p, (LineString)geom));
                            break block5;
                        }
                        if (!(geom instanceof Polygon)) break block6;
                        this.updateLocationInfo(this.locateInPolygon(p, (Polygon)geom));
                        break block5;
                    }
                    if (!(geom instanceof MultiLineString)) break block7;
                    MultiLineString ml = (MultiLineString)geom;
                    for (int i = 0; i < ml.getNumGeometries(); ++i) {
                        LineString l = (LineString)ml.getGeometryN(i);
                        this.updateLocationInfo(this.locateOnLineString(p, l));
                    }
                    break block5;
                }
                if (!(geom instanceof MultiPolygon)) break block8;
                MultiPolygon mpoly = (MultiPolygon)geom;
                for (int i = 0; i < mpoly.getNumGeometries(); ++i) {
                    Polygon poly = (Polygon)mpoly.getGeometryN(i);
                    this.updateLocationInfo(this.locateInPolygon(p, poly));
                }
                break block5;
            }
            if (!(geom instanceof GeometryCollection)) break block5;
            GeometryCollectionIterator geomi = new GeometryCollectionIterator((GeometryCollection)geom);
            while (geomi.hasNext()) {
                Geometry g2 = geomi.next();
                if (g2 == geom) continue;
                this.computeLocation(p, g2);
            }
        }
    }

    private void updateLocationInfo(int loc) {
        block1: {
            if (loc == Location$.MODULE$.INTERIOR()) {
                this.isIn_$eq(true);
            }
            if (loc != Location$.MODULE$.BOUNDARY()) break block1;
            this.numBoundaries_$eq(this.numBoundaries() + 1);
        }
    }

    private int locateOnPoint(Coordinate p, Point pt) {
        Coordinate ptCoord = pt.getCoordinate();
        if (ptCoord.equals2D(p)) {
            return Location$.MODULE$.INTERIOR();
        }
        return Location$.MODULE$.EXTERIOR();
    }

    private int locateOnLineString(Coordinate p, LineString l) {
        CoordinateSequence seq;
        block5: {
            block6: {
                if (!l.getEnvelopeInternal().intersects(p)) {
                    return Location$.MODULE$.EXTERIOR();
                }
                seq = l.getCoordinateSequence();
                if (l.isClosed()) break block5;
                Coordinate coordinate = p;
                Coordinate coordinate2 = seq.getCoordinate(0);
                if (!(coordinate == null ? coordinate2 != null : !((Object)coordinate).equals(coordinate2))) break block6;
                Coordinate coordinate3 = p;
                Coordinate coordinate4 = seq.getCoordinate(seq.size() - 1);
                if (coordinate3 != null ? !((Object)coordinate3).equals(coordinate4) : coordinate4 != null) break block5;
            }
            return Location$.MODULE$.BOUNDARY();
        }
        if (PointLocation$.MODULE$.isOnLine(p, seq)) {
            return Location$.MODULE$.INTERIOR();
        }
        return Location$.MODULE$.EXTERIOR();
    }

    private int locateInPolygonRing(Coordinate p, LinearRing ring) {
        if (!ring.getEnvelopeInternal().intersects(p)) {
            return Location$.MODULE$.EXTERIOR();
        }
        return PointLocation$.MODULE$.locateInRing(p, ring.getCoordinates());
    }

    private int locateInPolygon(Coordinate p, Polygon poly) {
        if (poly.isEmpty()) {
            return Location$.MODULE$.EXTERIOR();
        }
        LinearRing shell = poly.getExteriorRing();
        int shellLoc = this.locateInPolygonRing(p, shell);
        if (shellLoc == Location$.MODULE$.EXTERIOR()) {
            return Location$.MODULE$.EXTERIOR();
        }
        if (shellLoc == Location$.MODULE$.BOUNDARY()) {
            return Location$.MODULE$.BOUNDARY();
        }
        for (int i = 0; i < poly.getNumInteriorRing(); ++i) {
            LinearRing hole = poly.getInteriorRingN(i);
            int holeLoc = this.locateInPolygonRing(p, hole);
            if (holeLoc == Location$.MODULE$.INTERIOR()) {
                return Location$.MODULE$.EXTERIOR();
            }
            if (holeLoc != Location$.MODULE$.BOUNDARY()) continue;
            return Location$.MODULE$.BOUNDARY();
        }
        return Location$.MODULE$.INTERIOR();
    }

    public PointLocator(BoundaryNodeRule boundaryRule) {
        this.boundaryRule = boundaryRule;
        this.isIn = false;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.numBoundaries = 0;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
    }
}

