/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import org.locationtech.jts.algorithm.CGAlgorithmsDD$;
import org.locationtech.jts.algorithm.Intersection$;
import org.locationtech.jts.algorithm.LineIntersector;
import org.locationtech.jts.algorithm.LineIntersector$;
import org.locationtech.jts.algorithm.Orientation$;
import org.locationtech.jts.algorithm.RobustLineIntersector$;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Envelope$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005-<Q!\u0004\b\t\u0002]1Q!\u0007\b\t\u0002iAQ!I\u0001\u0005\u0002\tBQaI\u0001\u0005\n\u00112A!\u0007\b\u0001g!)\u0011\u0005\u0002C\u0001o!)\u0011\b\u0002C!u!)!\t\u0002C)\u0007\")1\n\u0002C\u0005\u0019\")\u0011\u000b\u0002C\u0005%\")q\u000b\u0002C\u00011\")q\f\u0002C\u0005A\")Q\r\u0002C\u0005M\u0006)\"k\u001c2vgRd\u0015N\\3J]R,'o]3di>\u0014(BA\b\u0011\u0003%\tGnZ8sSRDWN\u0003\u0002\u0012%\u0005\u0019!\u000e^:\u000b\u0005M!\u0012\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"A\u000b\u0002\u0007=\u0014xm\u0001\u0001\u0011\u0005a\tQ\"\u0001\b\u0003+I{'-^:u\u0019&tW-\u00138uKJ\u001cXm\u0019;peN\u0011\u0011a\u0007\t\u00039}i\u0011!\b\u0006\u0002=\u0005)1oY1mC&\u0011\u0001%\b\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u00059\u0012a\u00048fCJ,7\u000f^#oIB|\u0017N\u001c;\u0015\u000b\u0015ZSfL\u0019\u0011\u0005\u0019JS\"A\u0014\u000b\u0005!\u0002\u0012\u0001B4f_6L!AK\u0014\u0003\u0015\r{wN\u001d3j]\u0006$X\rC\u0003-\u0007\u0001\u0007Q%\u0001\u0002qc!)af\u0001a\u0001K\u0005\u0011\u0001O\r\u0005\u0006a\r\u0001\r!J\u0001\u0003cFBQAM\u0002A\u0002\u0015\n!!\u001d\u001a\u0014\u0005\u0011!\u0004C\u0001\r6\u0013\t1dBA\bMS:,\u0017J\u001c;feN,7\r^8s)\u0005A\u0004C\u0001\r\u0005\u0003M\u0019w.\u001c9vi\u0016Le\u000e^3sg\u0016\u001cG/[8o)\u0011Yd\bQ!\u0011\u0005qa\u0014BA\u001f\u001e\u0005\u0011)f.\u001b;\t\u000b}2\u0001\u0019A\u0013\u0002\u0003ADQ\u0001\f\u0004A\u0002\u0015BQA\f\u0004A\u0002\u0015\n\u0001cY8naV$X-\u00138uKJ\u001cXm\u0019;\u0015\u000b\u0011;\u0005*\u0013&\u0011\u0005q)\u0015B\u0001$\u001e\u0005\rIe\u000e\u001e\u0005\u0006Y\u001d\u0001\r!\n\u0005\u0006]\u001d\u0001\r!\n\u0005\u0006a\u001d\u0001\r!\n\u0005\u0006e\u001d\u0001\r!J\u0001\u001dG>l\u0007/\u001e;f\u0007>dG.\u001b8fCJLe\u000e^3sg\u0016\u001cG/[8o)\u0015!UJT(Q\u0011\u0015a\u0003\u00021\u0001&\u0011\u0015q\u0003\u00021\u0001&\u0011\u0015\u0001\u0004\u00021\u0001&\u0011\u0015\u0011\u0004\u00021\u0001&\u00031Ig\u000e^3sg\u0016\u001cG/[8o)\u0015)3\u000bV+W\u0011\u0015a\u0013\u00021\u0001&\u0011\u0015q\u0013\u00021\u0001&\u0011\u0015\u0001\u0014\u00021\u0001&\u0011\u0015\u0011\u0014\u00021\u0001&\u0003\u001d\u0019\u0007.Z2l\t\u0012#baO-[7rk\u0006\"\u0002\u0017\u000b\u0001\u0004)\u0003\"\u0002\u0018\u000b\u0001\u0004)\u0003\"\u0002\u0019\u000b\u0001\u0004)\u0003\"\u0002\u001a\u000b\u0001\u0004)\u0003\"\u00020\u000b\u0001\u0004)\u0013!B5oiB#\u0018\u0001E5oi\u0016\u00148/Z2uS>t7+\u00194f)\u0015)\u0013MY2e\u0011\u0015a3\u00021\u0001&\u0011\u0015q3\u00021\u0001&\u0011\u0015\u00014\u00021\u0001&\u0011\u0015\u00114\u00021\u0001&\u0003QI7/\u00138TK\u001elWM\u001c;F]Z,Gn\u001c9fgR\u0011qM\u001b\t\u00039!L!![\u000f\u0003\u000f\t{w\u000e\\3b]\")a\f\u0004a\u0001K\u0001")
public class RobustLineIntersector
extends LineIntersector {
    @Override
    public void computeIntersection(Coordinate p, Coordinate p1, Coordinate p2) {
        block2: {
            block4: {
                block3: {
                    this.isProperF_$eq(false);
                    if (!Envelope$.MODULE$.intersects(p1, p2, p) || Orientation$.MODULE$.index(p1, p2, p) != 0 || Orientation$.MODULE$.index(p2, p1, p) != 0) break block2;
                    this.isProperF_$eq(true);
                    Coordinate coordinate = p;
                    Coordinate coordinate2 = p1;
                    if (!(coordinate == null ? coordinate2 != null : !((Object)coordinate).equals(coordinate2))) break block3;
                    Coordinate coordinate3 = p;
                    Coordinate coordinate4 = p2;
                    if (coordinate3 != null ? !((Object)coordinate3).equals(coordinate4) : coordinate4 != null) break block4;
                }
                this.isProperF_$eq(false);
            }
            this.result_$eq(LineIntersector$.MODULE$.POINT_INTERSECTION());
            return;
        }
        this.result_$eq(LineIntersector$.MODULE$.NO_INTERSECTION());
    }

    @Override
    public int computeIntersect(Coordinate p1, Coordinate p2, Coordinate q1, Coordinate q2) {
        boolean collinear;
        this.isProperF_$eq(false);
        if (!Envelope$.MODULE$.intersects(p1, p2, q1, q2)) {
            return LineIntersector$.MODULE$.NO_INTERSECTION();
        }
        int Pq1 = Orientation$.MODULE$.index(p1, p2, q1);
        int Pq2 = Orientation$.MODULE$.index(p1, p2, q2);
        if (Pq1 > 0 && Pq2 > 0 || Pq1 < 0 && Pq2 < 0) {
            return LineIntersector$.MODULE$.NO_INTERSECTION();
        }
        int Qp1 = Orientation$.MODULE$.index(q1, q2, p1);
        int Qp2 = Orientation$.MODULE$.index(q1, q2, p2);
        if (Qp1 > 0 && Qp2 > 0 || Qp1 < 0 && Qp2 < 0) {
            return LineIntersector$.MODULE$.NO_INTERSECTION();
        }
        boolean bl = collinear = Pq1 == 0 && Pq2 == 0 && Qp1 == 0 && Qp2 == 0;
        if (collinear) {
            return this.computeCollinearIntersection(p1, p2, q1, q2);
        }
        if (Pq1 == 0 || Pq2 == 0 || Qp1 == 0 || Qp2 == 0) {
            this.isProperF_$eq(false);
            if (p1.equals2D(q1) || p1.equals2D(q2)) {
                this.intPt()[0] = p1;
            } else if (p2.equals2D(q1) || p2.equals2D(q2)) {
                this.intPt()[0] = p2;
            } else if (Pq1 == 0) {
                this.intPt()[0] = new Coordinate(q1);
            } else if (Pq2 == 0) {
                this.intPt()[0] = new Coordinate(q2);
            } else if (Qp1 == 0) {
                this.intPt()[0] = new Coordinate(p1);
            } else if (Qp2 == 0) {
                this.intPt()[0] = new Coordinate(p2);
            }
        } else {
            this.isProperF_$eq(true);
            this.intPt()[0] = this.intersection(p1, p2, q1, q2);
        }
        return LineIntersector$.MODULE$.POINT_INTERSECTION();
    }

    /*
     * Enabled aggressive block sorting
     */
    private int computeCollinearIntersection(Coordinate p1, Coordinate p2, Coordinate q1, Coordinate q2) {
        int n;
        boolean p1q1p2 = Envelope$.MODULE$.intersects(p1, p2, q1);
        boolean p1q2p2 = Envelope$.MODULE$.intersects(p1, p2, q2);
        boolean q1p1q2 = Envelope$.MODULE$.intersects(q1, q2, p1);
        boolean q1p2q2 = Envelope$.MODULE$.intersects(q1, q2, p2);
        if (p1q1p2 && p1q2p2) {
            this.intPt()[0] = q1;
            this.intPt()[1] = q2;
            return LineIntersector$.MODULE$.COLLINEAR_INTERSECTION();
        }
        if (q1p1q2 && q1p2q2) {
            this.intPt()[0] = p1;
            this.intPt()[1] = p2;
            return LineIntersector$.MODULE$.COLLINEAR_INTERSECTION();
        }
        if (p1q1p2 && q1p1q2) {
            int n2;
            this.intPt()[0] = q1;
            this.intPt()[1] = p1;
            Coordinate coordinate = q1;
            Coordinate coordinate2 = p1;
            if (!(coordinate != null ? !((Object)coordinate).equals(coordinate2) : coordinate2 != null)) {
                if (!p1q2p2 && !q1p2q2) {
                    n2 = LineIntersector$.MODULE$.POINT_INTERSECTION();
                    return n2;
                }
            }
            n2 = LineIntersector$.MODULE$.COLLINEAR_INTERSECTION();
            return n2;
        }
        if (p1q1p2 && q1p2q2) {
            int n3;
            this.intPt()[0] = q1;
            this.intPt()[1] = p2;
            Coordinate coordinate = q1;
            Coordinate coordinate3 = p2;
            if (!(coordinate != null ? !((Object)coordinate).equals(coordinate3) : coordinate3 != null)) {
                if (!p1q2p2 && !q1p1q2) {
                    n3 = LineIntersector$.MODULE$.POINT_INTERSECTION();
                    return n3;
                }
            }
            n3 = LineIntersector$.MODULE$.COLLINEAR_INTERSECTION();
            return n3;
        }
        if (p1q2p2 && q1p1q2) {
            int n4;
            this.intPt()[0] = q2;
            this.intPt()[1] = p1;
            Coordinate coordinate = q2;
            Coordinate coordinate4 = p1;
            if (!(coordinate != null ? !((Object)coordinate).equals(coordinate4) : coordinate4 != null)) {
                if (!p1q1p2 && !q1p2q2) {
                    n4 = LineIntersector$.MODULE$.POINT_INTERSECTION();
                    return n4;
                }
            }
            n4 = LineIntersector$.MODULE$.COLLINEAR_INTERSECTION();
            return n4;
        }
        if (!p1q2p2) return LineIntersector$.MODULE$.NO_INTERSECTION();
        if (!q1p2q2) return LineIntersector$.MODULE$.NO_INTERSECTION();
        this.intPt()[0] = q2;
        this.intPt()[1] = p2;
        Coordinate coordinate = q2;
        Coordinate coordinate5 = p2;
        if (!(coordinate != null ? !((Object)coordinate).equals(coordinate5) : coordinate5 != null)) {
            if (!p1q1p2 && !q1p1q2) {
                n = LineIntersector$.MODULE$.POINT_INTERSECTION();
                return n;
            }
        }
        n = LineIntersector$.MODULE$.COLLINEAR_INTERSECTION();
        return n;
    }

    private Coordinate intersection(Coordinate p1, Coordinate p2, Coordinate q1, Coordinate q2) {
        Coordinate intPt;
        block1: {
            intPt = this.intersectionSafe(p1, p2, q1, q2);
            if (!this.isInSegmentEnvelopes(intPt)) {
                intPt = new Coordinate(RobustLineIntersector$.MODULE$.org$locationtech$jts$algorithm$RobustLineIntersector$$nearestEndpoint(p1, p2, q1, q2));
            }
            if (this.precisionModel() == null) break block1;
            this.precisionModel().makePrecise(intPt);
        }
        return intPt;
    }

    public void checkDD(Coordinate p1, Coordinate p2, Coordinate q1, Coordinate q2, Coordinate intPt) {
        block0: {
            Coordinate intPtDD = CGAlgorithmsDD$.MODULE$.intersection(p1, p2, q1, q2);
            boolean isIn = this.isInSegmentEnvelopes(intPtDD);
            System.out.println(new StringBuilder(36).append("DD in env = ").append(isIn).append("  --------------------- ").append(intPtDD).toString());
            if (!(intPt.distance(intPtDD) > 1.0E-4)) break block0;
            System.out.println(new StringBuilder(11).append("Distance = ").append(intPt.distance(intPtDD)).toString());
        }
    }

    private Coordinate intersectionSafe(Coordinate p1, Coordinate p2, Coordinate q1, Coordinate q2) {
        Coordinate intPt;
        block0: {
            intPt = Intersection$.MODULE$.intersection(p1, p2, q1, q2);
            if (intPt != null) break block0;
            intPt = RobustLineIntersector$.MODULE$.org$locationtech$jts$algorithm$RobustLineIntersector$$nearestEndpoint(p1, p2, q1, q2);
        }
        return intPt;
    }

    private boolean isInSegmentEnvelopes(Coordinate intPt) {
        Envelope env0 = new Envelope(this.inputLines()[0][0], this.inputLines()[0][1]);
        Envelope env1 = new Envelope(this.inputLines()[1][0], this.inputLines()[1][1]);
        return env0.contains(intPt) && env1.contains(intPt);
    }
}

