/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm.construct;

import java.util.PriorityQueue;
import org.locationtech.jts.algorithm.construct.MaximumInscribedCircle$Cell$;
import org.locationtech.jts.algorithm.locate.IndexedPointInAreaLocator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Location$;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.operation.distance.IndexedFacetDistance;
import scala.UninitializedFieldError;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\tUt!B%K\u0011\u0003)f!B,K\u0011\u0003A\u0006\"B0\u0002\t\u0003\u0001\u0007\"B1\u0002\t\u0003\u0011\u0007\"B:\u0002\t\u0003!x!\u0002>\u0002\u0011\u0013Yh!B?\u0002\u0011\u0013q\b\"B0\u0007\t\u0003y\b\"CA\u0001\r\t\u0007I\u0011BA\u0002\u0011\u001d\t)A\u0002Q\u0001\nA4Q!`\u0001\u0005\u0003\u000fA!\"!\b\u000b\u0005\u0003\u0007I\u0011AA\u0002\u0011)\tyB\u0003BA\u0002\u0013\u0005\u0011\u0011\u0005\u0005\n\u0003[Q!\u0011!Q!\nAD!\"a\f\u000b\u0005\u0003\u0007I\u0011AA\u0002\u0011)\t\tD\u0003BA\u0002\u0013\u0005\u00111\u0007\u0005\n\u0003oQ!\u0011!Q!\nAD!\"!\u000f\u000b\u0005\u0003\u0007I\u0011AA\u0002\u0011)\tYD\u0003BA\u0002\u0013\u0005\u0011Q\b\u0005\n\u0003\u0003R!\u0011!Q!\nAD!\"a\u0011\u000b\u0005\u0003\u0007I\u0011AA\u0002\u0011)\t)E\u0003BA\u0002\u0013\u0005\u0011q\t\u0005\n\u0003\u0017R!\u0011!Q!\nADqa\u0018\u0006\u0005\u0002)\u000bi\u0005C\u0005\u0002Z)\u0001\r\u0011\"\u0003\u0002\u0004!I\u00111\f\u0006A\u0002\u0013%\u0011Q\f\u0005\b\u0003CR\u0001\u0015)\u0003q\u0011\u001d\t\u0019G\u0003C\u0001\u0003KBq!!\u001c\u000b\t\u0003\t\u0019\u0001C\u0004\u0002p)!\t!a\u0001\t\u000f\u0005E$\u0002\"\u0001\u0002\u0004!9\u00111\u000f\u0006\u0005\u0002\u0005\r\u0001bBA;\u0015\u0011\u0005\u00111\u0001\u0005\b\u0003oRA\u0011IA=\r\u00159&\nAAC\u0011)\t9I\tBA\u0002\u0013\u0005\u0011\u0011\u0012\u0005\u000b\u0003\u0017\u0013#\u00111A\u0005\u0002\u00055\u0005\"CAIE\t\u0005\t\u0015)\u0003l\u0011%y'E!a\u0001\n\u0003\t\u0019\u0001\u0003\u0006\u0002\u0014\n\u0012\t\u0019!C\u0001\u0003+C\u0011\"!'#\u0005\u0003\u0005\u000b\u0015\u00029\t\r}\u0013C\u0011AAN\u0011%\t\u0019K\ta\u0001\n\u0013\t)\u000bC\u0005\u0002.\n\u0002\r\u0011\"\u0003\u00020\"A\u00111\u0017\u0012!B\u0013\t9\u000bC\u0005\u00026\n\u0012\r\u0011\"\u0003\u00028\"A\u0011Q\u0019\u0012!\u0002\u0013\tI\fC\u0005\u0002H\n\u0012\r\u0011\"\u0003\u0002J\"A\u0011\u0011\u001c\u0012!\u0002\u0013\tY\rC\u0005\u0002\\\n\u0002\r\u0011\"\u0003\u0002^\"I\u0011Q \u0012A\u0002\u0013%\u0011q \u0005\t\u0005\u0007\u0011\u0003\u0015)\u0003\u0002`\"I!Q\u0001\u0012A\u0002\u0013%!q\u0001\u0005\n\u0005\u001f\u0011\u0003\u0019!C\u0005\u0005#A\u0001B!\u0006#A\u0003&!\u0011\u0002\u0005\n\u0005/\u0011\u0003\u0019!C\u0005\u0005\u000fA\u0011B!\u0007#\u0001\u0004%IAa\u0007\t\u0011\t}!\u0005)Q\u0005\u0005\u0013A\u0011B!\t#\u0001\u0004%IAa\t\t\u0013\t\u0015\"\u00051A\u0005\n\t\u001d\u0002b\u0002B\u0016E\u0001\u0006Ka\u0019\u0005\n\u0005[\u0011\u0003\u0019!C\u0005\u0005GA\u0011Ba\f#\u0001\u0004%IA!\r\t\u000f\tU\"\u0005)Q\u0005G\"1\u0011M\tC\u0001\u0005GAqAa\u000e#\t\u0003\u0011\u0019\u0003\u0003\u0004tE\u0011\u0005!\u0011\b\u0005\b\u0005w\u0011C\u0011\u0002B\u001f\u0011\u001d\u0011YD\tC\u0005\u0005\u0007BqA!\u0013#\t\u0013\u0011Y\u0005C\u0004\u0003N\t\"IAa\u0014\t\u000f\t\u0015$\u0005\"\u0003\u0003h!9!q\u000e\u0012\u0005\n\tE\u0014AF'bq&lW/\\%og\u000e\u0014\u0018NY3e\u0007&\u00148\r\\3\u000b\u0005-c\u0015!C2p]N$(/^2u\u0015\tie*A\u0005bY\u001e|'/\u001b;i[*\u0011q\nU\u0001\u0004UR\u001c(BA)S\u00031awnY1uS>tG/Z2i\u0015\u0005\u0019\u0016aA8sO\u000e\u0001\u0001C\u0001,\u0002\u001b\u0005Q%AF'bq&lW/\\%og\u000e\u0014\u0018NY3e\u0007&\u00148\r\\3\u0014\u0005\u0005I\u0006C\u0001.^\u001b\u0005Y&\"\u0001/\u0002\u000bM\u001c\u0017\r\\1\n\u0005y[&AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002+\u0006Iq-\u001a;DK:$XM\u001d\u000b\u0004G&t\u0007C\u00013h\u001b\u0005)'B\u00014O\u0003\u00119Wm\\7\n\u0005!,'!\u0002)pS:$\b\"\u00026\u0004\u0001\u0004Y\u0017!\u00039pYf<wN\\1m!\t!G.\u0003\u0002nK\nAq)Z8nKR\u0014\u0018\u0010C\u0003p\u0007\u0001\u0007\u0001/A\u0005u_2,'/\u00198dKB\u0011!,]\u0005\u0003en\u0013a\u0001R8vE2,\u0017!D4fiJ\u000bG-[;t\u0019&tW\rF\u0002vqf\u0004\"\u0001\u001a<\n\u0005],'A\u0003'j]\u0016\u001cFO]5oO\")!\u000e\u0002a\u0001W\")q\u000e\u0002a\u0001a\u0006!1)\u001a7m!\tah!D\u0001\u0002\u0005\u0011\u0019U\r\u001c7\u0014\u0005\u0019IF#A>\u0002\u000bM\u000b&\u000b\u0016\u001a\u0016\u0003A\faaU)S)J\u00023\u0003\u0002\u0006Z\u0003\u0013\u0001b!a\u0003\u0002\u0016\u0005eQBAA\u0007\u0015\u0011\ty!!\u0005\u0002\t1\fgn\u001a\u0006\u0003\u0003'\tAA[1wC&!\u0011qCA\u0007\u0005)\u0019u.\u001c9be\u0006\u0014G.\u001a\t\u0004\u00037QaB\u0001,\u0001\u0003\u0005A\u0018!\u0002=`I\u0015\fH\u0003BA\u0012\u0003S\u00012AWA\u0013\u0013\r\t9c\u0017\u0002\u0005+:LG\u000f\u0003\u0005\u0002,1\t\t\u00111\u0001q\u0003\rAH%M\u0001\u0003q\u0002\n\u0011!_\u0001\u0006s~#S-\u001d\u000b\u0005\u0003G\t)\u0004\u0003\u0005\u0002,=\t\t\u00111\u0001q\u0003\tI\b%A\u0003i'&$W-A\u0005i'&$Wm\u0018\u0013fcR!\u00111EA \u0011!\tYCEA\u0001\u0002\u0004\u0001\u0018A\u00025TS\u0012,\u0007%\u0001\u0005eSN$\u0018M\\2f\u00031!\u0017n\u001d;b]\u000e,w\fJ3r)\u0011\t\u0019#!\u0013\t\u0011\u0005-R#!AA\u0002A\f\u0011\u0002Z5ti\u0006t7-\u001a\u0011\u0015\u0015\u0005=\u0013\u0011KA*\u0003+\n9\u0006\u0005\u0002}\u0015!1\u0011QD\fA\u0002ADa!a\f\u0018\u0001\u0004\u0001\bBBA\u001d/\u0001\u0007\u0001\u000f\u0003\u0004\u0002D]\u0001\r\u0001]\u0001\b[\u0006DH)[:u\u0003-i\u0017\r\u001f#jgR|F%Z9\u0015\t\u0005\r\u0012q\f\u0005\t\u0003WI\u0012\u0011!a\u0001a\u0006AQ.\u0019=ESN$\b%A\u0006hKR,eN^3m_B,WCAA4!\r!\u0017\u0011N\u0005\u0004\u0003W*'\u0001C#om\u0016dw\u000e]3\u0002\u001d\u001d,G/T1y\t&\u001cH/\u00198dK\u0006Yq-\u001a;ESN$\u0018M\\2f\u0003!9W\r\u001e%TS\u0012,\u0017\u0001B4fib\u000bAaZ3u3\u0006I1m\\7qCJ,Gk\u001c\u000b\u0005\u0003w\n\t\tE\u0002[\u0003{J1!a \\\u0005\rIe\u000e\u001e\u0005\b\u0003\u0007\u000b\u0003\u0019AA\r\u0003\u0005y7C\u0001\u0012Z\u0003%Ig\u000e];u\u000f\u0016|W.F\u0001l\u00035Ig\u000e];u\u000f\u0016|Wn\u0018\u0013fcR!\u00111EAH\u0011!\tY\u0003JA\u0001\u0002\u0004Y\u0017AC5oaV$x)Z8nA\u0005iAo\u001c7fe\u0006t7-Z0%KF$B!a\t\u0002\u0018\"A\u00111F\u0014\u0002\u0002\u0003\u0007\u0001/\u0001\u0006u_2,'/\u00198dK\u0002\"b!!(\u0002 \u0006\u0005\u0006C\u0001,#\u0011\u0019\t9)\u000ba\u0001W\")q.\u000ba\u0001a\u00069a-Y2u_JLXCAAT!\r!\u0017\u0011V\u0005\u0004\u0003W+'aD$f_6,GO]=GC\u000e$xN]=\u0002\u0017\u0019\f7\r^8ss~#S-\u001d\u000b\u0005\u0003G\t\t\fC\u0005\u0002,-\n\t\u00111\u0001\u0002(\u0006Aa-Y2u_JL\b%A\u0005qi2{7-\u0019;feV\u0011\u0011\u0011\u0018\t\u0005\u0003w\u000b\t-\u0004\u0002\u0002>*\u0019\u0011q\u0018'\u0002\r1|7-\u0019;f\u0013\u0011\t\u0019-!0\u00033%sG-\u001a=fIB{\u0017N\u001c;J]\u0006\u0013X-\u0019'pG\u0006$xN]\u0001\u000baRdunY1uKJ\u0004\u0013aD5oI\u0016DX\r\u001a#jgR\fgnY3\u0016\u0005\u0005-\u0007\u0003BAg\u0003+l!!a4\u000b\t\u0005\r\u0013\u0011\u001b\u0006\u0004\u0003't\u0015!C8qKJ\fG/[8o\u0013\u0011\t9.a4\u0003)%sG-\u001a=fI\u001a\u000b7-\u001a;ESN$\u0018M\\2f\u0003AIg\u000eZ3yK\u0012$\u0015n\u001d;b]\u000e,\u0007%\u0001\u0006dK:$XM]\"fY2,\"!a8\u0011\u0007\u0005\u0005(BD\u0002\u0002d\u0002qA!!:\u0002|:!\u0011q]A}\u001d\u0011\tI/a>\u000f\t\u0005-\u0018Q\u001f\b\u0005\u0003[\f\u00190\u0004\u0002\u0002p*\u0019\u0011\u0011\u001f+\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0019\u0016BA)S\u0013\ty\u0005+\u0003\u0002N\u001d&\u00111\nT\u0001\u000fG\u0016tG/\u001a:DK2dw\fJ3r)\u0011\t\u0019C!\u0001\t\u0013\u0005-\"'!AA\u0002\u0005}\u0017aC2f]R,'oQ3mY\u0002\n\u0001bY3oi\u0016\u0014\b\u000b^\u000b\u0003\u0005\u0013\u00012\u0001\u001aB\u0006\u0013\r\u0011i!\u001a\u0002\u000b\u0007>|'\u000fZ5oCR,\u0017\u0001D2f]R,'\u000f\u0015;`I\u0015\fH\u0003BA\u0012\u0005'A\u0011\"a\u000b6\u0003\u0003\u0005\rA!\u0003\u0002\u0013\r,g\u000e^3s!R\u0004\u0013\u0001\u0003:bI&,8\u000f\u0015;\u0002\u0019I\fG-[;t!R|F%Z9\u0015\t\u0005\r\"Q\u0004\u0005\n\u0003WA\u0014\u0011!a\u0001\u0005\u0013\t\u0011B]1eSV\u001c\b\u000b\u001e\u0011\u0002\u0017\r,g\u000e^3s!>Lg\u000e^\u000b\u0002G\u0006y1-\u001a8uKJ\u0004v.\u001b8u?\u0012*\u0017\u000f\u0006\u0003\u0002$\t%\u0002\u0002CA\u0016w\u0005\u0005\t\u0019A2\u0002\u0019\r,g\u000e^3s!>Lg\u000e\u001e\u0011\u0002\u0017I\fG-[;t!>Lg\u000e^\u0001\u0010e\u0006$\u0017.^:Q_&tGo\u0018\u0013fcR!\u00111\u0005B\u001a\u0011!\tYCPA\u0001\u0002\u0004\u0019\u0017\u0001\u0004:bI&,8\u000fU8j]R\u0004\u0013AD4fiJ\u000bG-[;t!>Lg\u000e^\u000b\u0002k\u0006\u0011B-[:uC:\u001cW\rV8C_VtG-\u0019:z)\r\u0001(q\b\u0005\u0007\u0005\u0003\u001a\u0005\u0019A2\u0002\u0003A$R\u0001\u001dB#\u0005\u000fBa!!\bE\u0001\u0004\u0001\bBBA\u0018\t\u0002\u0007\u0001/A\u0004d_6\u0004X\u000f^3\u0015\u0005\u0005\r\u0012!E2sK\u0006$X-\u00138ji&\fGn\u0012:jIR1\u00111\u0005B)\u0005+BqAa\u0015G\u0001\u0004\t9'A\u0002f]ZDqAa\u0016G\u0001\u0004\u0011I&A\u0005dK2d\u0017+^3vKB1!1\fB1\u00033i!A!\u0018\u000b\t\t}\u0013\u0011C\u0001\u0005kRLG.\u0003\u0003\u0003d\tu#!\u0004)sS>\u0014\u0018\u000e^=Rk\u0016,X-\u0001\u0006de\u0016\fG/Z\"fY2$\u0002\"!\u0007\u0003j\t-$Q\u000e\u0005\u0007\u0003;9\u0005\u0019\u00019\t\r\u0005=r\t1\u0001q\u0011\u0019\tId\u0012a\u0001a\u0006\u00112M]3bi\u0016\u001cUM\u001c;s_&$7)\u001a7m)\u0011\tIBa\u001d\t\u000b\u0019D\u0005\u0019A6")
public class MaximumInscribedCircle {
    private Geometry inputGeom;
    private double tolerance;
    private GeometryFactory factory;
    private final IndexedPointInAreaLocator ptLocater;
    private final IndexedFacetDistance indexedDistance;
    private Cell centerCell;
    private Coordinate centerPt;
    private Coordinate radiusPt;
    private Point centerPoint;
    private Point radiusPoint;
    private volatile byte bitmap$init$0;

    public Geometry inputGeom() {
        return this.inputGeom;
    }

    public void inputGeom_$eq(Geometry x$1) {
        this.inputGeom = x$1;
    }

    public double tolerance() {
        return this.tolerance;
    }

    public void tolerance_$eq(double x$1) {
        this.tolerance = x$1;
    }

    private GeometryFactory factory() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/algorithm/construct/MaximumInscribedCircle.scala: 149");
        }
        return this.factory;
    }

    private void factory_$eq(GeometryFactory x$1) {
        this.factory = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
    }

    private IndexedPointInAreaLocator ptLocater() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/algorithm/construct/MaximumInscribedCircle.scala: 150");
        }
        return this.ptLocater;
    }

    private IndexedFacetDistance indexedDistance() {
        if ((byte)(this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/algorithm/construct/MaximumInscribedCircle.scala: 151");
        }
        return this.indexedDistance;
    }

    private Cell centerCell() {
        if ((byte)(this.bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/algorithm/construct/MaximumInscribedCircle.scala: 152");
        }
        return this.centerCell;
    }

    private void centerCell_$eq(Cell x$1) {
        this.centerCell = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
    }

    private Coordinate centerPt() {
        if ((byte)(this.bitmap$init$0 & 0x10) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/algorithm/construct/MaximumInscribedCircle.scala: 153");
        }
        return this.centerPt;
    }

    private void centerPt_$eq(Coordinate x$1) {
        this.centerPt = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x10);
    }

    private Coordinate radiusPt() {
        if ((byte)(this.bitmap$init$0 & 0x20) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/algorithm/construct/MaximumInscribedCircle.scala: 154");
        }
        return this.radiusPt;
    }

    private void radiusPt_$eq(Coordinate x$1) {
        this.radiusPt = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x20);
    }

    private Point centerPoint() {
        if ((byte)(this.bitmap$init$0 & 0x40) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/algorithm/construct/MaximumInscribedCircle.scala: 155");
        }
        return this.centerPoint;
    }

    private void centerPoint_$eq(Point x$1) {
        this.centerPoint = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x40);
    }

    private Point radiusPoint() {
        if ((byte)(this.bitmap$init$0 & 0x80) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/algorithm/construct/MaximumInscribedCircle.scala: 156");
        }
        return this.radiusPoint;
    }

    private void radiusPoint_$eq(Point x$1) {
        this.radiusPoint = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x80);
    }

    public Point getCenter() {
        this.compute();
        return this.centerPoint();
    }

    public Point getRadiusPoint() {
        this.compute();
        return this.radiusPoint();
    }

    /*
     * WARNING - void declaration
     */
    public LineString getRadiusLine() {
        void var1_1;
        this.compute();
        LineString radiusLine = this.factory().createLineString((Coordinate[])((Object[])new Coordinate[]{this.centerPt().copy(), this.radiusPt().copy()}));
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private double distanceToBoundary(Point p) {
        void var2_2;
        boolean isOutide;
        double dist = this.indexedDistance().distance(p);
        boolean bl = isOutide = Location$.MODULE$.EXTERIOR() == this.ptLocater().locate(p.getCoordinate());
        if (isOutide) {
            return -dist;
        }
        return (double)var2_2;
    }

    private double distanceToBoundary(double x, double y) {
        Coordinate coord = new Coordinate(x, y);
        Point pt = this.factory().createPoint(coord);
        return this.distanceToBoundary(pt);
    }

    private void compute() {
        if (this.centerCell() != null) {
            return;
        }
        PriorityQueue<Cell> cellQueue = new PriorityQueue<Cell>();
        this.createInitialGrid(this.inputGeom().getEnvelopeInternal(), cellQueue);
        Cell farthestCell = this.createCentroidCell(this.inputGeom());
        while (!cellQueue.isEmpty()) {
            Object object;
            double potentialIncrease;
            Cell cell = (Cell)cellQueue.remove();
            if (cell.getDistance() > farthestCell.getDistance()) {
                farthestCell = cell;
            }
            if ((potentialIncrease = cell.getMaxDistance() - farthestCell.getDistance()) > this.tolerance()) {
                double h2 = cell.getHSide() / (double)2;
                cellQueue.add(this.createCell(cell.getX() - h2, cell.getY() - h2, h2));
                cellQueue.add(this.createCell(cell.getX() + h2, cell.getY() - h2, h2));
                cellQueue.add(this.createCell(cell.getX() - h2, cell.getY() + h2, h2));
                object = BoxesRunTime.boxToBoolean((boolean)cellQueue.add(this.createCell(cell.getX() + h2, cell.getY() + h2, h2)));
                continue;
            }
            object = BoxedUnit.UNIT;
        }
        this.centerCell_$eq(farthestCell);
        this.centerPt_$eq(new Coordinate(this.centerCell().getX(), this.centerCell().getY()));
        this.centerPoint_$eq(this.factory().createPoint(this.centerPt()));
        Coordinate[] nearestPts = this.indexedDistance().nearestPoints(this.centerPoint());
        this.radiusPt_$eq(nearestPts[0].copy());
        this.radiusPoint_$eq(this.factory().createPoint(this.radiusPt()));
    }

    private void createInitialGrid(Envelope env, PriorityQueue<Cell> cellQueue) {
        double minX = env.getMinX();
        double maxX = env.getMaxX();
        double minY = env.getMinY();
        double maxY = env.getMaxY();
        double width = env.getWidth();
        double height = env.getHeight();
        double cellSize = Math.min(width, height);
        double hSide = cellSize / 2.0;
        for (double x = minX; x < maxX; x += cellSize) {
            for (double y = minY; y < maxY; y += cellSize) {
                cellQueue.add(this.createCell(x + hSide, y + hSide, hSide));
            }
        }
    }

    private Cell createCell(double x, double y, double hSide) {
        return new Cell(x, y, hSide, this.distanceToBoundary(x, y));
    }

    private Cell createCentroidCell(Geometry geom) {
        Point p = geom.getCentroid();
        return new Cell(p.getX(), p.getY(), 0.0, this.distanceToBoundary(p));
    }

    public MaximumInscribedCircle(Geometry inputGeom, double tolerance) {
        this.inputGeom = inputGeom;
        this.tolerance = tolerance;
        if (!(this.inputGeom() instanceof Polygon) && !(this.inputGeom() instanceof MultiPolygon)) {
            throw new IllegalArgumentException("Input geometry must be a Polygon or MultiPolygon");
        }
        if (this.inputGeom().isEmpty()) {
            throw new IllegalArgumentException("Empty input geometry is not supported");
        }
        this.factory = this.inputGeom().getFactory();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.ptLocater = new IndexedPointInAreaLocator(this.inputGeom());
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.indexedDistance = new IndexedFacetDistance(this.inputGeom().getBoundary());
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
        this.centerCell = null;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
        this.centerPt = null;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x10);
        this.radiusPt = null;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x20);
        this.centerPoint = null;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x40);
        this.radiusPoint = null;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x80);
        this.factory_$eq(this.inputGeom().getFactory());
    }

    public static class Cell
    implements Comparable<Cell> {
        private double x;
        private double y;
        private double hSide;
        private double distance;
        private double maxDist;
        private volatile boolean bitmap$init$0;

        public double x() {
            return this.x;
        }

        public void x_$eq(double x$1) {
            this.x = x$1;
        }

        public double y() {
            return this.y;
        }

        public void y_$eq(double x$1) {
            this.y = x$1;
        }

        public double hSide() {
            return this.hSide;
        }

        public void hSide_$eq(double x$1) {
            this.hSide = x$1;
        }

        public double distance() {
            return this.distance;
        }

        public void distance_$eq(double x$1) {
            this.distance = x$1;
        }

        private double maxDist() {
            if (!this.bitmap$init$0) {
                throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/algorithm/construct/MaximumInscribedCircle.scala: 116");
            }
            return this.maxDist;
        }

        private void maxDist_$eq(double x$1) {
            this.maxDist = x$1;
            this.bitmap$init$0 = true;
        }

        public Envelope getEnvelope() {
            return new Envelope(this.x() - this.hSide(), this.x() + this.hSide(), this.y() - this.hSide(), this.y() + this.hSide());
        }

        public double getMaxDistance() {
            return this.maxDist();
        }

        public double getDistance() {
            return this.distance();
        }

        public double getHSide() {
            return this.hSide();
        }

        public double getX() {
            return this.x();
        }

        public double getY() {
            return this.y();
        }

        @Override
        public int compareTo(Cell o) {
            return (int)(o.maxDist() - this.maxDist());
        }

        public Cell(double x, double y, double hSide, double distance) {
            this.x = x;
            this.y = y;
            this.hSide = hSide;
            this.distance = distance;
            this.maxDist = 0.0;
            this.bitmap$init$0 = true;
            this.maxDist_$eq(this.distance() + this.hSide() * MaximumInscribedCircle$Cell$.MODULE$.org$locationtech$jts$algorithm$construct$MaximumInscribedCircle$Cell$$SQRT2());
        }
    }
}

