/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm.distance;

import org.locationtech.jts.algorithm.distance.DistanceToPoint$;
import org.locationtech.jts.algorithm.distance.PointPairDistance;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Geometry;
import scala.UninitializedFieldError;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005mu!B\u001b7\u0011\u0003\te!B\"7\u0011\u0003!\u0005\"B&\u0002\t\u0003a\u0005\"B\u001c\u0002\t\u0003i\u0005\"B\u001c\u0002\t\u0003Yf\u0001\u00021\u0002\u0001\u0005D\u0001BV\u0003\u0003\u0002\u0004%\t!\u001a\u0005\tM\u0016\u0011\t\u0019!C\u0001O\"AQ.\u0002B\u0001B\u0003&1\u000bC\u0003L\u000b\u0011\u0005a\u000eC\u0004s\u000b\t\u0007I\u0011B:\t\r],\u0001\u0015!\u0003u\u0011\u001dAXA1A\u0005\nMDa!_\u0003!\u0002\u0013!\b\"\u0002>\u0006\t\u0003Z\bBBA\u0002\u000b\u0011\u00051O\u0002\u0004\u0002\u0006\u0005\u0001\u0011q\u0001\u0005\t-B\u0011\t\u0019!C\u0001K\"Ia\r\u0005BA\u0002\u0013\u0005\u0011q\u0002\u0005\t[B\u0011\t\u0011)Q\u0005'\"Q\u00111\u0003\t\u0003\u0006\u0004%\t!!\u0006\t\u0013\u0005]\u0001C!A!\u0002\u0013q\u0005BB&\u0011\t\u0003\tI\u0002C\u0004s!\t\u0007I\u0011B:\t\r]\u0004\u0002\u0015!\u0003u\u0011\u001dA\bC1A\u0005\nMDa!\u001f\t!\u0002\u0013!\b\"CA\u0011!\u0001\u0007I\u0011BA\u0012\u0011%\tY\u0003\u0005a\u0001\n\u0013\ti\u0003\u0003\u0005\u00022A\u0001\u000b\u0015BA\u0013\u0011\u0019Q\b\u0003\"\u0011\u00024!9\u00111\t\t\u0005B\u0005\u0015\u0003bBA'!\u0011\u0005\u0013Q\t\u0005\u0007\u0003\u0007\u0001B\u0011A:\u0007\u000b\r3\u0004!a\u0014\t\u0011I\u0013#\u00111A\u0005\u0002\u0015D!\"!\u0015#\u0005\u0003\u0007I\u0011AA*\u0011%\t9F\tB\u0001B\u0003&1\u000b\u0003\u0005[E\t\u0005\r\u0011\"\u0001f\u0011)\tIF\tBA\u0002\u0013\u0005\u00111\f\u0005\n\u0003?\u0012#\u0011!Q!\nMCaa\u0013\u0012\u0005\u0002\u0005\u0005\u0004\u0002CA5E\t\u0007I\u0011B:\t\u000f\u0005-$\u0005)A\u0005i\"AqL\ta\u0001\n\u0013\t)\u0002C\u0005\u0002n\t\u0002\r\u0011\"\u0003\u0002p!9\u00111\u000f\u0012!B\u0013q\u0005bBA;E\u0011\u0005\u0011q\u000f\u0005\u0007o\t\"\t!!\u0006\t\u000f\u0005m$\u0005\"\u0001\u0002\u0016!9\u0011Q\u0010\u0012\u0005\u0002\u0005}\u0004bBADE\u0011%\u0011\u0011\u0012\u0005\b\u0003\u001f\u0013C\u0011BAI\u0003e!\u0015n]2sKR,\u0007*Y;tI>\u0014hM\u001a#jgR\fgnY3\u000b\u0005]B\u0014\u0001\u00033jgR\fgnY3\u000b\u0005eR\u0014!C1mO>\u0014\u0018\u000e\u001e5n\u0015\tYD(A\u0002kiNT!!\u0010 \u0002\u00191|7-\u0019;j_:$Xm\u00195\u000b\u0003}\n1a\u001c:h\u0007\u0001\u0001\"AQ\u0001\u000e\u0003Y\u0012\u0011\u0004R5tGJ,G/\u001a%bkN$wN\u001d4g\t&\u001cH/\u00198dKN\u0011\u0011!\u0012\t\u0003\r&k\u0011a\u0012\u0006\u0002\u0011\u0006)1oY1mC&\u0011!j\u0012\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005\tEc\u0001(R3B\u0011aiT\u0005\u0003!\u001e\u0013a\u0001R8vE2,\u0007\"\u0002*\u0004\u0001\u0004\u0019\u0016AA41!\t!v+D\u0001V\u0015\t1&(\u0001\u0003hK>l\u0017B\u0001-V\u0005!9Um\\7fiJL\b\"\u0002.\u0004\u0001\u0004\u0019\u0016AA42)\u0011qE,\u00180\t\u000bI#\u0001\u0019A*\t\u000bi#\u0001\u0019A*\t\u000b}#\u0001\u0019\u0001(\u0002\u0017\u0011,gn]5gs\u001a\u0013\u0018m\u0019\u0002\u0017\u001b\u0006D\bk\\5oi\u0012K7\u000f^1oG\u00164\u0015\u000e\u001c;feN\u0019Q!\u00122\u0011\u0005Q\u001b\u0017B\u00013V\u0005A\u0019un\u001c:eS:\fG/\u001a$jYR,'/F\u0001T\u0003!9Wm\\7`I\u0015\fHC\u00015l!\t1\u0015.\u0003\u0002k\u000f\n!QK\\5u\u0011\u001daw!!AA\u0002M\u000b1\u0001\u001f\u00132\u0003\u00159Wm\\7!)\ty\u0017\u000f\u0005\u0002q\u000b5\t\u0011\u0001C\u0003W\u0013\u0001\u00071+A\u0005nCb\u0004F\u000fR5tiV\tA\u000f\u0005\u0002Ck&\u0011aO\u000e\u0002\u0012!>Lg\u000e\u001e)bSJ$\u0015n\u001d;b]\u000e,\u0017AC7bqB#H)[:uA\u0005IQ.\u001b8Qi\u0012K7\u000f^\u0001\u000b[&t\u0007\u000b\u001e#jgR\u0004\u0013A\u00024jYR,'\u000f\u0006\u0002iy\")QP\u0004a\u0001}\u0006\u0011\u0001\u000f\u001e\t\u0003)~L1!!\u0001V\u0005)\u0019un\u001c:eS:\fG/Z\u0001\u0014O\u0016$X*\u0019=Q_&tG\u000fR5ti\u0006t7-\u001a\u0002%\u001b\u0006DH)\u001a8tS\u001aLW\r\u001a\"z\rJ\f7\r^5p]\u0012K7\u000f^1oG\u00164\u0015\u000e\u001c;feN!\u0001#RA\u0005!\r!\u00161B\u0005\u0004\u0003\u001b)&\u0001G\"p_J$\u0017N\\1uKN+\u0017/^3oG\u00164\u0015\u000e\u001c;feR\u0019\u0001.!\u0005\t\u000f1\u0014\u0012\u0011!a\u0001'\u0006AaM]1di&|g.F\u0001O\u0003%1'/Y2uS>t\u0007\u0005\u0006\u0004\u0002\u001c\u0005u\u0011q\u0004\t\u0003aBAQA\u0016\fA\u0002MCa!a\u0005\u0017\u0001\u0004q\u0015A\u00038v[N+(mU3hgV\u0011\u0011Q\u0005\t\u0004\r\u0006\u001d\u0012bAA\u0015\u000f\n\u0019\u0011J\u001c;\u0002\u001d9,XnU;c'\u0016<7o\u0018\u0013fcR\u0019\u0001.a\f\t\u00111d\u0012\u0011!a\u0001\u0003K\t1B\\;n'V\u00147+Z4tAQ)\u0001.!\u000e\u0002@!9\u0011q\u0007\u0010A\u0002\u0005e\u0012aA:fcB\u0019A+a\u000f\n\u0007\u0005uRK\u0001\nD_>\u0014H-\u001b8bi\u0016\u001cV-];f]\u000e,\u0007bBA!=\u0001\u0007\u0011QE\u0001\u0006S:$W\r_\u0001\u0012SN<Um\\7fiJL8\t[1oO\u0016$WCAA$!\r1\u0015\u0011J\u0005\u0004\u0003\u0017:%a\u0002\"p_2,\u0017M\\\u0001\u0007SN$uN\\3\u0014\u0005\t*\u0015AB41?\u0012*\u0017\u000fF\u0002i\u0003+Bq\u0001\u001c\u0013\u0002\u0002\u0003\u00071+A\u0002ha\u0001\naaZ\u0019`I\u0015\fHc\u00015\u0002^!9AnJA\u0001\u0002\u0004\u0019\u0016aA42AQ1\u00111MA3\u0003O\u0002\"A\u0011\u0012\t\u000bIK\u0003\u0019A*\t\u000biK\u0003\u0019A*\u0002\rA$H)[:u\u0003\u001d\u0001H\u000fR5ti\u0002\nq\u0002Z3og&4\u0017P\u0012:bG~#S-\u001d\u000b\u0004Q\u0006E\u0004b\u00027.\u0003\u0003\u0005\rAT\u0001\rI\u0016t7/\u001b4z\rJ\f7\rI\u0001\u0013g\u0016$H)\u001a8tS\u001aLhI]1di&|g\u000eF\u0002i\u0003sBQaX\u0018A\u00029\u000b\u0001c\u001c:jK:$X\r\u001a#jgR\fgnY3\u0002\u001d\u001d,GoQ8pe\u0012Lg.\u0019;fgV\u0011\u0011\u0011\u0011\t\u0005\r\u0006\re0C\u0002\u0002\u0006\u001e\u0013Q!\u0011:sCf\fqaY8naV$X\rF\u0003i\u0003\u0017\u000bi\tC\u0003Sg\u0001\u00071\u000bC\u0003[g\u0001\u00071+A\fd_6\u0004X\u000f^3Pe&,g\u000e^3e\t&\u001cH/\u00198dKR9\u0001.a%\u0002\u0018\u0006e\u0005BBAKi\u0001\u00071+\u0001\u0007eSN\u001c'/\u001a;f\u000f\u0016|W\u000eC\u0003Wi\u0001\u00071\u000b\u0003\u0004\u0002jQ\u0002\r\u0001\u001e")
public class DiscreteHausdorffDistance {
    private Geometry g0;
    private Geometry g1;
    private final PointPairDistance ptDist;
    private double densifyFrac;
    private volatile byte bitmap$init$0;

    public Geometry g0() {
        return this.g0;
    }

    public void g0_$eq(Geometry x$1) {
        this.g0 = x$1;
    }

    public Geometry g1() {
        return this.g1;
    }

    public void g1_$eq(Geometry x$1) {
        this.g1 = x$1;
    }

    private PointPairDistance ptDist() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/algorithm/distance/DiscreteHausdorffDistance.scala: 131");
        }
        return this.ptDist;
    }

    private double densifyFrac() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/algorithm/distance/DiscreteHausdorffDistance.scala: 135");
        }
        return this.densifyFrac;
    }

    private void densifyFrac_$eq(double x$1) {
        this.densifyFrac = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
    }

    public void setDensifyFraction(double densifyFrac) {
        if (densifyFrac > 1.0 || densifyFrac <= 0.0) {
            throw new IllegalArgumentException("Fraction is not in range (0.0 - 1.0]");
        }
        this.densifyFrac_$eq(densifyFrac);
    }

    public double distance() {
        this.compute(this.g0(), this.g1());
        return this.ptDist().getDistance();
    }

    public double orientedDistance() {
        this.computeOrientedDistance(this.g0(), this.g1(), this.ptDist());
        return this.ptDist().getDistance();
    }

    public Coordinate[] getCoordinates() {
        return this.ptDist().getCoordinates();
    }

    private void compute(Geometry g0, Geometry g1) {
        this.computeOrientedDistance(g0, g1, this.ptDist());
        this.computeOrientedDistance(g1, g0, this.ptDist());
    }

    private void computeOrientedDistance(Geometry discreteGeom, Geometry geom, PointPairDistance ptDist) {
        block0: {
            MaxPointDistanceFilter distFilter = new MaxPointDistanceFilter(geom);
            discreteGeom.applyF(distFilter);
            ptDist.setMaximum(distFilter.getMaxPointDistance());
            if (!(this.densifyFrac() > 0.0)) break block0;
            MaxDensifiedByFractionDistanceFilter fracFilter = new MaxDensifiedByFractionDistanceFilter(geom, this.densifyFrac());
            discreteGeom.applyF(fracFilter);
            ptDist.setMaximum(fracFilter.getMaxPointDistance());
        }
    }

    public DiscreteHausdorffDistance(Geometry g0, Geometry g1) {
        this.g0 = g0;
        this.g1 = g1;
        this.ptDist = new PointPairDistance();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.densifyFrac = 0.0;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
    }

    public static class MaxDensifiedByFractionDistanceFilter
    implements CoordinateSequenceFilter {
        private Geometry geom;
        private final double fraction;
        private final PointPairDistance maxPtDist;
        private final PointPairDistance minPtDist;
        private int numSubSegs;
        private volatile byte bitmap$init$0;

        public Geometry geom() {
            return this.geom;
        }

        public void geom_$eq(Geometry x$1) {
            this.geom = x$1;
        }

        public double fraction() {
            return this.fraction;
        }

        private PointPairDistance maxPtDist() {
            if ((byte)(this.bitmap$init$0 & 1) == 0) {
                throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/algorithm/distance/DiscreteHausdorffDistance.scala: 93");
            }
            return this.maxPtDist;
        }

        private PointPairDistance minPtDist() {
            if ((byte)(this.bitmap$init$0 & 2) == 0) {
                throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/algorithm/distance/DiscreteHausdorffDistance.scala: 94");
            }
            return this.minPtDist;
        }

        private int numSubSegs() {
            if ((byte)(this.bitmap$init$0 & 4) == 0) {
                throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/algorithm/distance/DiscreteHausdorffDistance.scala: 95");
            }
            return this.numSubSegs;
        }

        private void numSubSegs_$eq(int x$1) {
            this.numSubSegs = x$1;
            this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
        }

        @Override
        public void filter(CoordinateSequence seq, int index) {
            if (index == 0) {
                return;
            }
            Coordinate p0 = seq.getCoordinate(index - 1);
            Coordinate p1 = seq.getCoordinate(index);
            double delx = (p1.x() - p0.x()) / (double)this.numSubSegs();
            double dely = (p1.y() - p0.y()) / (double)this.numSubSegs();
            for (int i = 0; i < this.numSubSegs(); ++i) {
                double x = p0.x() + (double)i * delx;
                double y = p0.y() + (double)i * dely;
                Coordinate pt = new Coordinate(x, y);
                this.minPtDist().initialize();
                DistanceToPoint$.MODULE$.computeDistance(this.geom(), pt, this.minPtDist());
                this.maxPtDist().setMaximum(this.minPtDist());
            }
        }

        @Override
        public boolean isGeometryChanged() {
            return false;
        }

        @Override
        public boolean isDone() {
            return false;
        }

        public PointPairDistance getMaxPointDistance() {
            return this.maxPtDist();
        }

        public MaxDensifiedByFractionDistanceFilter(Geometry geom, double fraction) {
            this.geom = geom;
            this.fraction = fraction;
            this.maxPtDist = new PointPairDistance();
            this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
            this.minPtDist = new PointPairDistance();
            this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
            this.numSubSegs = 0;
            this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
            this.numSubSegs_$eq((int)Math.rint(1.0 / fraction));
        }
    }

    public static class MaxPointDistanceFilter
    implements CoordinateFilter {
        private Geometry geom;
        private final PointPairDistance maxPtDist;
        private final PointPairDistance minPtDist;
        private volatile byte bitmap$init$0;

        public Geometry geom() {
            return this.geom;
        }

        public void geom_$eq(Geometry x$1) {
            this.geom = x$1;
        }

        private PointPairDistance maxPtDist() {
            if ((byte)(this.bitmap$init$0 & 1) == 0) {
                throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/algorithm/distance/DiscreteHausdorffDistance.scala: 79");
            }
            return this.maxPtDist;
        }

        private PointPairDistance minPtDist() {
            if ((byte)(this.bitmap$init$0 & 2) == 0) {
                throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/algorithm/distance/DiscreteHausdorffDistance.scala: 80");
            }
            return this.minPtDist;
        }

        @Override
        public void filter(Coordinate pt) {
            this.minPtDist().initialize();
            DistanceToPoint$.MODULE$.computeDistance(this.geom(), pt, this.minPtDist());
            this.maxPtDist().setMaximum(this.minPtDist());
        }

        public PointPairDistance getMaxPointDistance() {
            return this.maxPtDist();
        }

        public MaxPointDistanceFilter(Geometry geom) {
            this.geom = geom;
            this.maxPtDist = new PointPairDistance();
            this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
            this.minPtDist = new PointPairDistance();
            this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        }
    }
}

