/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm.distance;

import org.locationtech.jts.algorithm.distance.PointPairDistance;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Polygon;
import scala.runtime.BoxedUnit;

public final class DistanceToPoint$ {
    public static final DistanceToPoint$ MODULE$ = new DistanceToPoint$();

    public void computeDistance(Geometry geom, Coordinate pt, PointPairDistance ptDist) {
        Geometry geometry = geom;
        if (geometry instanceof LineString) {
            LineString lineString = (LineString)geometry;
            this.computeDistance(lineString, pt, ptDist);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (geometry instanceof Polygon) {
            Polygon polygon = (Polygon)geometry;
            this.computeDistance(polygon, pt, ptDist);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (geometry instanceof GeometryCollection) {
            GeometryCollection geometryCollection = (GeometryCollection)geometry;
            for (int i = 0; i < geometryCollection.getNumGeometries(); ++i) {
                Geometry g = geometryCollection.getGeometryN(i);
                this.computeDistance(g, pt, ptDist);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            ptDist.setMinimum(geom.getCoordinate(), pt);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void computeDistance(LineString line, Coordinate pt, PointPairDistance ptDist) {
        LineSegment tempSegment = new LineSegment();
        Coordinate[] coords = line.getCoordinates();
        for (int i = 0; i < coords.length - 1; ++i) {
            tempSegment.setCoordinates(coords[i], coords[i + 1]);
            Coordinate closestPt = tempSegment.closestPoint(pt);
            ptDist.setMinimum(closestPt, pt);
        }
    }

    public void computeDistance(LineSegment segment, Coordinate pt, PointPairDistance ptDist) {
        Coordinate closestPt = segment.closestPoint(pt);
        ptDist.setMinimum(closestPt, pt);
    }

    public void computeDistance(Polygon poly, Coordinate pt, PointPairDistance ptDist) {
        this.computeDistance(poly.getExteriorRing(), pt, ptDist);
        for (int i = 0; i < poly.getNumInteriorRing(); ++i) {
            this.computeDistance(poly.getInteriorRingN(i), pt, ptDist);
        }
    }

    private DistanceToPoint$() {
    }
}

