/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm.locate;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.algorithm.RayCrossingCounter;
import org.locationtech.jts.algorithm.locate.PointOnGeometryLocator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygonal;
import org.locationtech.jts.geom.util.LinearComponentExtracter$;
import org.locationtech.jts.index.ArrayListVisitor;
import org.locationtech.jts.index.ItemVisitor;
import org.locationtech.jts.index.intervaltree.SortedPackedIntervalRTree;
import scala.UninitializedFieldError;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005-u!B\u0010!\u0011\u0003Yc!B\u0017!\u0011\u0003q\u0003\"B\u001b\u0002\t\u00031d\u0001B\u001c\u0002\taB\u0001bP\u0002\u0003\u0002\u0004%\t\u0001\u0011\u0005\t\u000b\u000e\u0011\t\u0019!C\u0001\r\"AAj\u0001B\u0001B\u0003&\u0011\tC\u00036\u0007\u0011\u0005Q\nC\u0003R\u0007\u0011\u0005#K\u0002\u0003Y\u0003\u0011I\u0006\u0002\u0003.\n\u0005\u000b\u0007I\u0011A.\t\u0011\u0005L!\u0011!Q\u0001\nqCQ!N\u0005\u0005\u0002\tDq!Z\u0005A\u0002\u0013%a\rC\u0004k\u0013\u0001\u0007I\u0011B6\t\r5L\u0001\u0015)\u0003h\u0011\u001da\u0014B1A\u0005\n9Da!^\u0005!\u0002\u0013y\u0007\"\u0002<\n\t\u00139\b\"B=\n\t\u0013Q\bbBA\u0004\u0013\u0011\u0005\u0011\u0011\u0002\u0005\b\u0003\u000fIA\u0011AA\u001e\r\u0015i\u0003\u0005AA#\u0011!QfC!a\u0001\n\u0003Y\u0006BCA'-\t\u0005\r\u0011\"\u0001\u0002P!A\u0011M\u0006B\u0001B\u0003&A\f\u0003\u00046-\u0011\u0005\u00111\u000b\u0005\tyY\u0001\r\u0011\"\u0003\u0002Z!I\u0011\u0011\u0010\fA\u0002\u0013%\u00111\u0010\u0005\bkZ\u0001\u000b\u0015BA.\u0011\u0019\tc\u0003\"\u0011\u0002\u0000\u0005I\u0012J\u001c3fq\u0016$\u0007k\\5oi&s\u0017I]3b\u0019>\u001c\u0017\r^8s\u0015\t\t#%\u0001\u0004m_\u000e\fG/\u001a\u0006\u0003G\u0011\n\u0011\"\u00197h_JLG\u000f[7\u000b\u0005\u00152\u0013a\u00016ug*\u0011q\u0005K\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002S\u0005\u0019qN]4\u0004\u0001A\u0011A&A\u0007\u0002A\tI\u0012J\u001c3fq\u0016$\u0007k\\5oi&s\u0017I]3b\u0019>\u001c\u0017\r^8s'\t\tq\u0006\u0005\u00021g5\t\u0011GC\u00013\u0003\u0015\u00198-\u00197b\u0013\t!\u0014G\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003-\u0012abU3h[\u0016tGOV5tSR|'oE\u0002\u0004_e\u0002\"AO\u001f\u000e\u0003mR!\u0001\u0010\u0013\u0002\u000b%tG-\u001a=\n\u0005yZ$aC%uK64\u0016n]5u_J\fqaY8v]R,'/F\u0001B!\t\u00115)D\u0001#\u0013\t!%E\u0001\nSCf\u001c%o\\:tS:<7i\\;oi\u0016\u0014\u0018aC2pk:$XM]0%KF$\"a\u0012&\u0011\u0005AB\u0015BA%2\u0005\u0011)f.\u001b;\t\u000f-+\u0011\u0011!a\u0001\u0003\u0006\u0019\u0001\u0010J\u0019\u0002\u0011\r|WO\u001c;fe\u0002\"\"A\u0014)\u0011\u0005=\u001bQ\"A\u0001\t\u000b}:\u0001\u0019A!\u0002\u0013YL7/\u001b;Ji\u0016lGCA$T\u0011\u0015!\u0006\u00021\u0001V\u0003\u0011IG/Z7\u0011\u0005A2\u0016BA,2\u0005\r\te.\u001f\u0002\u0018\u0013:$XM\u001d<bY&sG-\u001a=fI\u001e+w.\\3uef\u001c\"!C\u0018\u0002\t\u001d,w.\\\u000b\u00029B\u0011QlX\u0007\u0002=*\u0011!\fJ\u0005\u0003Az\u0013\u0001bR3p[\u0016$(/_\u0001\u0006O\u0016|W\u000e\t\u000b\u0003G\u0012\u0004\"aT\u0005\t\u000bic\u0001\u0019\u0001/\u0002\u000f%\u001cX)\u001c9usV\tq\r\u0005\u00021Q&\u0011\u0011.\r\u0002\b\u0005>|G.Z1o\u0003-I7/R7qif|F%Z9\u0015\u0005\u001dc\u0007bB&\u000f\u0003\u0003\u0005\raZ\u0001\tSN,U\u000e\u001d;zAU\tq\u000e\u0005\u0002qg6\t\u0011O\u0003\u0002sw\u0005a\u0011N\u001c;feZ\fG\u000e\u001e:fK&\u0011A/\u001d\u0002\u001a'>\u0014H/\u001a3QC\u000e\\W\rZ%oi\u0016\u0014h/\u00197S)J,W-\u0001\u0004j]\u0012,\u0007\u0010I\u0001\u0005S:LG\u000f\u0006\u0002Hq\")!L\u0005a\u00019\u00069\u0011\r\u001a3MS:,GCA$|\u0011\u0015a8\u00031\u0001~\u0003\r\u0001Ho\u001d\t\u0005ay\f\t!\u0003\u0002\u0000c\t)\u0011I\u001d:bsB\u0019Q,a\u0001\n\u0007\u0005\u0015aL\u0001\u0006D_>\u0014H-\u001b8bi\u0016\fQ!];fef$b!a\u0003\u0002.\u0005]\u0002\u0007BA\u0007\u0003C\u0001b!a\u0004\u0002\u001a\u0005uQBAA\t\u0015\u0011\t\u0019\"!\u0006\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003/\tAA[1wC&!\u00111DA\t\u0005\u0011a\u0015n\u001d;\u0011\t\u0005}\u0011\u0011\u0005\u0007\u0001\t-\t\u0019\u0003FA\u0001\u0002\u0003\u0015\t!!\n\u0003\u0007}#\u0013'E\u0002\u0002(U\u00032\u0001MA\u0015\u0013\r\tY#\r\u0002\b\u001d>$\b.\u001b8h\u0011\u001d\ty\u0003\u0006a\u0001\u0003c\t1!\\5o!\r\u0001\u00141G\u0005\u0004\u0003k\t$A\u0002#pk\ndW\rC\u0004\u0002:Q\u0001\r!!\r\u0002\u00075\f\u0007\u0010F\u0004H\u0003{\ty$!\u0011\t\u000f\u0005=R\u00031\u0001\u00022!9\u0011\u0011H\u000bA\u0002\u0005E\u0002BBA\"+\u0001\u0007\u0011(A\u0004wSNLGo\u001c:\u0014\tYy\u0013q\t\t\u0004Y\u0005%\u0013bAA&A\t1\u0002k\\5oi>sw)Z8nKR\u0014\u0018\u0010T8dCR|'/\u0001\u0005hK>lw\fJ3r)\r9\u0015\u0011\u000b\u0005\b\u0017b\t\t\u00111\u0001])\u0011\t)&a\u0016\u0011\u000512\u0002\"\u0002.\u001b\u0001\u0004aVCAA.!\r\ti&\u0003\b\u0004\u0003?\u0002a\u0002BA1\u0003orA!a\u0019\u0002v9!\u0011QMA:\u001d\u0011\t9'!\u001d\u000f\t\u0005%\u0014qN\u0007\u0003\u0003WR1!!\u001c+\u0003\u0019a$o\\8u}%\t\u0011&\u0003\u0002(Q%\u0011QEJ\u0005\u0003G\u0011J!!\t\u0012\u0002\u0013%tG-\u001a=`I\u0015\fHcA$\u0002~!A1\nHA\u0001\u0002\u0004\tY\u0006\u0006\u0003\u0002\u0002\u0006\u001d\u0005c\u0001\u0019\u0002\u0004&\u0019\u0011QQ\u0019\u0003\u0007%sG\u000fC\u0004\u0002\nz\u0001\r!!\u0001\u0002\u0003A\u0004")
public class IndexedPointInAreaLocator
implements PointOnGeometryLocator {
    private Geometry geom;
    private IntervalIndexedGeometry index;
    private volatile boolean bitmap$init$0;

    public Geometry geom() {
        return this.geom;
    }

    public void geom_$eq(Geometry x$1) {
        this.geom = x$1;
    }

    private IntervalIndexedGeometry index() {
        if (!this.bitmap$init$0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/algorithm/locate/IndexedPointInAreaLocator.scala: 126");
        }
        return this.index;
    }

    private void index_$eq(IntervalIndexedGeometry x$1) {
        this.index = x$1;
        this.bitmap$init$0 = true;
    }

    @Override
    public int locate(Coordinate p) {
        if (this.index() == null) {
            this.index_$eq(new IntervalIndexedGeometry(this.geom()));
            this.geom_$eq(null);
        }
        RayCrossingCounter rcc = new RayCrossingCounter(p);
        SegmentVisitor visitor = new SegmentVisitor(rcc);
        this.index().query(p.y(), p.y(), visitor);
        return rcc.getLocation();
    }

    public IndexedPointInAreaLocator(Geometry geom) {
        this.geom = geom;
        if (!(this.geom() instanceof Polygonal) && !(this.geom() instanceof LinearRing)) {
            throw new IllegalArgumentException("Argument must be Polygonal or LinearRing");
        }
        this.index = null;
        this.bitmap$init$0 = true;
    }

    public static class IntervalIndexedGeometry {
        private final Geometry geom;
        private boolean isEmpty;
        private final SortedPackedIntervalRTree index;
        private volatile byte bitmap$init$0;

        public Geometry geom() {
            return this.geom;
        }

        private boolean isEmpty() {
            if ((byte)(this.bitmap$init$0 & 1) == 0) {
                throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/algorithm/locate/IndexedPointInAreaLocator.scala: 70");
            }
            return this.isEmpty;
        }

        private void isEmpty_$eq(boolean x$1) {
            this.isEmpty = x$1;
            this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        }

        private SortedPackedIntervalRTree index() {
            if ((byte)(this.bitmap$init$0 & 2) == 0) {
                throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/algorithm/locate/IndexedPointInAreaLocator.scala: 73");
            }
            return this.index;
        }

        private void init(Geometry geom) {
            ArrayList<Geometry> lines = LinearComponentExtracter$.MODULE$.getLines(geom);
            for (LineString lineString : lines) {
                Coordinate[] pts = lineString.getCoordinates();
                this.addLine(pts);
            }
        }

        private void addLine(Coordinate[] pts) {
            for (int i = 1; i < pts.length; ++i) {
                LineSegment seg = new LineSegment(pts[i - 1], pts[i]);
                double min = Math.min(seg.p0().y(), seg.p1().y());
                double max = Math.max(seg.p0().y(), seg.p1().y());
                this.index().insert(min, max, seg);
            }
        }

        public List<?> query(double min, double max) {
            if (this.isEmpty()) {
                return new ArrayList();
            }
            ArrayListVisitor visitor = new ArrayListVisitor();
            this.index().query(min, max, visitor);
            return visitor.getItems();
        }

        public void query(double min, double max, ItemVisitor visitor) {
            if (this.isEmpty()) {
                return;
            }
            this.index().query(min, max, visitor);
        }

        public IntervalIndexedGeometry(Geometry geom) {
            this.geom = geom;
            this.isEmpty = false;
            this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
            if (geom.isEmpty()) {
                this.isEmpty_$eq(true);
            } else {
                this.init(geom);
            }
            this.index = new SortedPackedIntervalRTree();
            this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        }
    }

    public static class SegmentVisitor
    implements ItemVisitor {
        private RayCrossingCounter counter;

        public RayCrossingCounter counter() {
            return this.counter;
        }

        public void counter_$eq(RayCrossingCounter x$1) {
            this.counter = x$1;
        }

        @Override
        public void visitItem(Object item) {
            LineSegment seg = (LineSegment)item;
            this.counter().countSegment(seg.getCoordinate(0), seg.getCoordinate(1));
        }

        public SegmentVisitor(RayCrossingCounter counter) {
            this.counter = counter;
        }
    }
}

