/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm.locate;

import org.locationtech.jts.algorithm.PointLocation$;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryCollectionIterator;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Location$;
import org.locationtech.jts.geom.Polygon;

public final class SimplePointInAreaLocator$ {
    public static final SimplePointInAreaLocator$ MODULE$ = new SimplePointInAreaLocator$();

    public int locate(Coordinate p, Geometry geom) {
        if (geom.isEmpty()) {
            return Location$.MODULE$.EXTERIOR();
        }
        if (!geom.getEnvelopeInternal().intersects(p)) {
            return Location$.MODULE$.EXTERIOR();
        }
        return this.locateInGeometry(p, geom);
    }

    public boolean isContained(Coordinate p, Geometry geom) {
        return Location$.MODULE$.EXTERIOR() != this.locate(p, geom);
    }

    private int locateInGeometry(Coordinate p, Geometry geom) {
        if (geom instanceof Polygon) {
            return this.locatePointInPolygon(p, (Polygon)geom);
        }
        if (geom instanceof GeometryCollection) {
            GeometryCollectionIterator geomi = new GeometryCollectionIterator((GeometryCollection)geom);
            while (geomi.hasNext()) {
                int loc;
                Geometry g2 = geomi.next();
                if (g2 == geom || (loc = this.locateInGeometry(p, g2)) == Location$.MODULE$.EXTERIOR()) continue;
                return loc;
            }
        }
        return Location$.MODULE$.EXTERIOR();
    }

    public int locatePointInPolygon(Coordinate p, Polygon poly) {
        if (poly.isEmpty()) {
            return Location$.MODULE$.EXTERIOR();
        }
        LinearRing shell = poly.getExteriorRing();
        int shellLoc = this.locatePointInRing(p, shell);
        if (shellLoc != Location$.MODULE$.INTERIOR()) {
            return shellLoc;
        }
        for (int i = 0; i < poly.getNumInteriorRing(); ++i) {
            LinearRing hole = poly.getInteriorRingN(i);
            int holeLoc = this.locatePointInRing(p, hole);
            if (holeLoc == Location$.MODULE$.BOUNDARY()) {
                return Location$.MODULE$.BOUNDARY();
            }
            if (holeLoc != Location$.MODULE$.INTERIOR()) continue;
            return Location$.MODULE$.EXTERIOR();
        }
        return Location$.MODULE$.INTERIOR();
    }

    public boolean containsPointInPolygon(Coordinate p, Polygon poly) {
        return Location$.MODULE$.EXTERIOR() != this.locatePointInPolygon(p, poly);
    }

    private int locatePointInRing(Coordinate p, LinearRing ring) {
        if (!ring.getEnvelopeInternal().intersects(p)) {
            return Location$.MODULE$.EXTERIOR();
        }
        return PointLocation$.MODULE$.locateInRing(p, ring.getCoordinates());
    }

    private SimplePointInAreaLocator$() {
    }
}

