/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import java.io.Serializable;
import java.util.Comparator;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import org.locationtech.jts.geom.Coordinate$;
import org.locationtech.jts.geom.Coordinate$DimensionalComparator$;
import org.locationtech.jts.util.Assert$;
import org.locationtech.jts.util.NumberUtil$;
import scala.MatchError;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\tUr!\u0002 @\u0011\u0003Ae!\u0002&@\u0011\u0003Y\u0005\"\u0002.\u0002\t\u0003Y\u0006b\u0002/\u0002\u0005\u0004%\t!\u0018\u0005\u0007C\u0006\u0001\u000b\u0011\u00020\t\u000f\t\f!\u0019!C\u0001G\"1q-\u0001Q\u0001\n\u0011Dq\u0001[\u0001C\u0002\u0013\u00051\r\u0003\u0004j\u0003\u0001\u0006I\u0001\u001a\u0005\bU\u0006\u0011\r\u0011\"\u0001d\u0011\u0019Y\u0017\u0001)A\u0005I\"9A.\u0001b\u0001\n\u0003\u0019\u0007BB7\u0002A\u0003%A\rC\u0003o\u0003\u0011\u0005qnB\u0003s\u0003!\u00051OB\u0003v\u0003!\u0005a\u000fC\u0003[\u001f\u0011\u0005q\u000fC\u0003y\u001f\u0011\u0005\u0011P\u0002\u0003v\u0003\u0001q\b\"\u0003B\f%\t\u0015\r\u0011\"\u0001d\u0011%\u0011IB\u0005B\u0001B\u0003%A\r\u0003\u0004[%\u0011\u0005!1\u0004\u0005\u00075J!\tA!\t\t\ra\u0014B\u0011\tB\u0012\u0011%\u0011i#AA\u0001\n\u0013\u0011yCB\u0003K\u007f\u0001\tI\u0002\u0003\u0005r3\t\u0005\r\u0011\"\u0001^\u0011)\tI$\u0007BA\u0002\u0013\u0005\u00111\b\u0005\n\u0003\u000fJ\"\u0011!Q!\nyC\u0011\"!\u0013\u001a\u0005\u0003\u0007I\u0011A/\t\u0015\u0005-\u0013D!a\u0001\n\u0003\ti\u0005C\u0005\u0002Re\u0011\t\u0011)Q\u0005=\"I\u00111K\r\u0003\u0002\u0004%\t!\u0018\u0005\u000b\u0003+J\"\u00111A\u0005\u0002\u0005]\u0003\"CA.3\t\u0005\t\u0015)\u0003_\u0011\u0019Q\u0016\u0004\"\u0001\u0002^!1!,\u0007C\u0001\u0003KBaAW\r\u0005\u0002\u0005-\u0004B\u0002.\u001a\t\u0003\t\t\bC\u0004\u0002te!\t!!\u001e\t\r\u0005m\u0014\u0004\"\u0001^\u0011\u001d\ti(\u0007C\u0001\u0003\u007fBa!a!\u001a\t\u0003i\u0006bBAC3\u0011\u0005\u0011q\u0011\u0005\u0007\u0003\u0017KB\u0011A/\t\u000f\u00055\u0015\u0004\"\u0001\u0002\u0010\"1\u00111S\r\u0005\u0002uCq!!&\u001a\t\u0003\t9\nC\u0004\u0002\u001ef!\t!a(\t\u000f\u0005\u0015\u0016\u0004\"\u0001\u0002(\"9\u0011qV\r\u0005\u0002\u0005E\u0006bBAX3\u0011\u0005\u00111\u0018\u0005\b\u0003\u0007LB\u0011AAc\u0011\u001d\tI-\u0007C\u0001\u0003\u0017Dq!!5\u001a\t\u0003\n\u0019\u000eC\u0004\u0002^f!\t%a8\t\u000f\u0005\u0015\u0018\u0004\"\u0011\u0002h\"9\u0011\u0011`\r\u0005B\u0005E\u0004bBA~3\u0011\u0005\u0011Q \u0005\b\u0003\u007fLB\u0011\u0001B\u0001\u0011\u001d\u0011)!\u0007C\u0001\u0005\u000fAaA\\\r\u0005B\t-\u0011AC\"p_J$\u0017N\\1uK*\u0011\u0001)Q\u0001\u0005O\u0016|WN\u0003\u0002C\u0007\u0006\u0019!\u000e^:\u000b\u0005\u0011+\u0015\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"\u0001$\u0002\u0007=\u0014xm\u0001\u0001\u0011\u0005%\u000bQ\"A \u0003\u0015\r{wN\u001d3j]\u0006$XmE\u0002\u0002\u0019J\u0003\"!\u0014)\u000e\u00039S\u0011aT\u0001\u0006g\u000e\fG.Y\u0005\u0003#:\u0013a!\u00118z%\u00164\u0007CA*Y\u001b\u0005!&BA+W\u0003\tIwNC\u0001X\u0003\u0011Q\u0017M^1\n\u0005e#&\u0001D*fe&\fG.\u001b>bE2,\u0017A\u0002\u001fj]&$h\bF\u0001I\u00035qU\u000b\u0014'`\u001fJ#\u0015JT!U\u000bV\ta\f\u0005\u0002N?&\u0011\u0001M\u0014\u0002\u0007\t>,(\r\\3\u0002\u001d9+F\nT0P%\u0012Ke*\u0011+FA\u0005\t\u0001,F\u0001e!\tiU-\u0003\u0002g\u001d\n\u0019\u0011J\u001c;\u0002\u0005a\u0003\u0013!A-\u0002\u0005e\u0003\u0013!\u0001.\u0002\u0005i\u0003\u0013!A'\u0002\u00055\u0003\u0013\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0011\u0004\b\"B9\u000e\u0001\u0004q\u0016!\u0001=\u0002+\u0011KW.\u001a8tS>t\u0017\r\\\"p[B\f'/\u0019;peB\u0011AoD\u0007\u0002\u0003\t)B)[7f]NLwN\\1m\u0007>l\u0007/\u0019:bi>\u00148CA\bM)\u0005\u0019\u0018aB2p[B\f'/\u001a\u000b\u0004Ijd\b\"B>\u0012\u0001\u0004q\u0016!A1\t\u000bu\f\u0002\u0019\u00010\u0002\u0003\t\u001cBAE@\u0002\fA!\u0011\u0011AA\u0004\u001b\t\t\u0019AC\u0002\u0002\u0006Y\u000bA\u0001\\1oO&!\u0011\u0011BA\u0002\u0005\u0019y%M[3diB1\u0011QBA\n\u0003/i!!a\u0004\u000b\u0007\u0005Ea+\u0001\u0003vi&d\u0017\u0002BA\u000b\u0003\u001f\u0011!bQ8na\u0006\u0014\u0018\r^8s!\tI\u0015dE\u0004\u001a\u0019\u0006m\u0011\u0011\u0005*\u0011\r\u0005\u0005\u0011QDA\f\u0013\u0011\ty\"a\u0001\u0003\u0015\r{W\u000e]1sC\ndW\r\u0005\u0003\u0002$\u0005Mb\u0002BA\u0013\u0003_qA!a\n\u0002.5\u0011\u0011\u0011\u0006\u0006\u0004\u0003W9\u0015A\u0002\u001fs_>$h(C\u0001P\u0013\r\t\tDT\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t)$a\u000e\u0003\u0013\rcwN\\3bE2,'bAA\u0019\u001d\u0006)\u0001p\u0018\u0013fcR!\u0011QHA\"!\ri\u0015qH\u0005\u0004\u0003\u0003r%\u0001B+oSRD\u0001\"!\u0012\u001c\u0003\u0003\u0005\rAX\u0001\u0004q\u0012\n\u0014A\u0001=!\u0003\u0005I\u0018!B=`I\u0015\fH\u0003BA\u001f\u0003\u001fB\u0001\"!\u0012\u001f\u0003\u0003\u0005\rAX\u0001\u0003s\u0002\n\u0011A_\u0001\u0006u~#S-\u001d\u000b\u0005\u0003{\tI\u0006\u0003\u0005\u0002F\u0005\n\t\u00111\u0001_\u0003\tQ\b\u0005\u0006\u0005\u0002\u0018\u0005}\u0013\u0011MA2\u0011\u0015\t8\u00051\u0001_\u0011\u0019\tIe\ta\u0001=\"1\u00111K\u0012A\u0002y#B!a\u0006\u0002h!9\u0011\u0011\u000e\u0013A\u0002\u0005]\u0011!A2\u0015\r\u0005]\u0011QNA8\u0011\u0015\tX\u00051\u0001_\u0011\u0019\tI%\na\u0001=R\u0011\u0011qC\u0001\u000eg\u0016$8i\\8sI&t\u0017\r^3\u0015\t\u0005u\u0012q\u000f\u0005\b\u0003s:\u0003\u0019AA\f\u0003\u0015yG\u000f[3s\u0003\u00119W\r\u001e-\u0002\tM,G\u000f\u0017\u000b\u0005\u0003{\t\t\tC\u0003rS\u0001\u0007a,\u0001\u0003hKRL\u0016\u0001B:fif#B!!\u0010\u0002\n\"1\u0011\u0011J\u0016A\u0002y\u000bAaZ3u5\u0006!1/\u001a;[)\u0011\ti$!%\t\r\u0005MS\u00061\u0001_\u0003\u00119W\r^'\u0002\tM,G/\u0014\u000b\u0005\u0003{\tI\n\u0003\u0004\u0002\u001c>\u0002\rAX\u0001\u0002[\u0006Yq-\u001a;Pe\u0012Lg.\u0019;f)\rq\u0016\u0011\u0015\u0005\u0007\u0003G\u0003\u0004\u0019\u00013\u0002\u001b=\u0014H-\u001b8bi\u0016Le\u000eZ3y\u0003-\u0019X\r^(sI&t\u0017\r^3\u0015\r\u0005u\u0012\u0011VAV\u0011\u0019\t\u0019+\ra\u0001I\"1\u0011QV\u0019A\u0002y\u000bQA^1mk\u0016\f\u0001\"Z9vC2\u001c(\u0007\u0012\u000b\u0005\u0003g\u000bI\fE\u0002N\u0003kK1!a.O\u0005\u001d\u0011un\u001c7fC:Dq!!\u001f3\u0001\u0004\t9\u0002\u0006\u0004\u00024\u0006u\u0016q\u0018\u0005\b\u0003S\u001a\u0004\u0019AA\f\u0011\u0019\t\tm\ra\u0001=\u0006IAo\u001c7fe\u0006t7-Z\u0001\tKF,\u0018\r\\:4\tR!\u00111WAd\u0011\u001d\tI\b\u000ea\u0001\u0003/\t\u0001\"Z9vC2LeN\u0017\u000b\u0007\u0003g\u000bi-a4\t\u000f\u0005%T\u00071\u0001\u0002\u0018!1\u0011\u0011Y\u001bA\u0002y\u000ba!Z9vC2\u001cH\u0003BAZ\u0003+Dq!!\u001f7\u0001\u0004\t9\u000eE\u0002N\u00033L1!a7O\u0005\r\te._\u0001\nG>l\u0007/\u0019:f)>$2\u0001ZAq\u0011\u001d\t\u0019o\u000ea\u0001\u0003/\t\u0011a\\\u0001\ti>\u001cFO]5oOR\u0011\u0011\u0011\u001e\t\u0005\u0003W\f\u0019P\u0004\u0003\u0002n\u0006=\bcAA\u0014\u001d&\u0019\u0011\u0011\u001f(\u0002\rA\u0013X\rZ3g\u0013\u0011\t)0a>\u0003\rM#(/\u001b8h\u0015\r\t\tPT\u0001\u0006G2|g.Z\u0001\u0005G>\u0004\u00180\u0006\u0002\u0002\u0018\u0005AA-[:uC:\u001cW\rF\u0002_\u0005\u0007Aq!!\u001b<\u0001\u0004\t9\"\u0001\u0006eSN$\u0018M\\2fg\u0011#2A\u0018B\u0005\u0011\u001d\tI\u0007\u0010a\u0001\u0003/!\u0012\u0001\u001a\u0015\b3\t=\u0011Q\u0016B\u000b!\ri%\u0011C\u0005\u0004\u0005'q%\u0001E*fe&\fGNV3sg&|g.V%E=!av\u0018L\u0012]}bs\u0014\u0001\u00053j[\u0016t7/[8ogR{G+Z:u\u0003E!\u0017.\\3og&|gn\u001d+p)\u0016\u001cH\u000f\t\u000b\u0005\u0005;\u0011y\u0002\u0005\u0002u%!1!qC\u000bA\u0002\u0011$\"A!\b\u0015\u000b\u0011\u0014)C!\u000b\t\u000f\t\u001dr\u00031\u0001\u0002\u0018\u0005\u00111-\r\u0005\b\u0005W9\u0002\u0019AA\f\u0003\t\u0019''\u0001\u0007xe&$XMU3qY\u0006\u001cW\rF\u0001\u0000Q\u001d\t!qBAW\u0005+As\u0001\u0001B\b\u0003[\u0013)\u0002")
public class Coordinate
implements Comparable<Coordinate>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 6683108902428366910L;
    private double x;
    private double y;
    private double z;

    public static int M() {
        return Coordinate$.MODULE$.M();
    }

    public static int Z() {
        return Coordinate$.MODULE$.Z();
    }

    public static int Y() {
        return Coordinate$.MODULE$.Y();
    }

    public static int X() {
        return Coordinate$.MODULE$.X();
    }

    public static double NULL_ORDINATE() {
        return Coordinate$.MODULE$.NULL_ORDINATE();
    }

    public double x() {
        return this.x;
    }

    public void x_$eq(double x$1) {
        this.x = x$1;
    }

    public double y() {
        return this.y;
    }

    public void y_$eq(double x$1) {
        this.y = x$1;
    }

    public double z() {
        return this.z;
    }

    public void z_$eq(double x$1) {
        this.z = x$1;
    }

    public void setCoordinate(Coordinate other) {
        this.x_$eq(other.x());
        this.y_$eq(other.y());
        this.z_$eq(other.getZ());
    }

    public double getX() {
        return this.x();
    }

    public void setX(double x) {
        this.x_$eq(x);
    }

    public double getY() {
        return this.y();
    }

    public void setY(double y) {
        this.y_$eq(y);
    }

    public double getZ() {
        return this.z();
    }

    public void setZ(double z) {
        this.z_$eq(z);
    }

    public double getM() {
        return Double.NaN;
    }

    public void setM(double m) {
        throw new IllegalArgumentException(new StringBuilder(24).append("Invalid ordinate index: ").append(Coordinate$.MODULE$.M()).toString());
    }

    public double getOrdinate(int ordinateIndex) {
        double d;
        int n = ordinateIndex;
        if (Coordinate$.MODULE$.X() == n) {
            d = this.x();
        } else if (Coordinate$.MODULE$.Y() == n) {
            d = this.y();
        } else if (Coordinate$.MODULE$.Z() == n) {
            d = this.getZ();
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
        }
        return d;
    }

    public void setOrdinate(int ordinateIndex, double value) {
        int n = ordinateIndex;
        if (Coordinate$.MODULE$.X() == n) {
            this.x_$eq(value);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (Coordinate$.MODULE$.Y() == n) {
            this.y_$eq(value);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (Coordinate$.MODULE$.Z() == n) {
            this.setZ(value);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new IllegalArgumentException(new StringBuilder(24).append("Invalid ordinate index: ").append(ordinateIndex).toString());
        }
    }

    public boolean equals2D(Coordinate other) {
        if (this.x() != other.x()) {
            return false;
        }
        return this.y() == other.y();
    }

    public boolean equals2D(Coordinate c, double tolerance) {
        if (!NumberUtil$.MODULE$.equalsWithTolerance(this.x(), c.x(), tolerance)) {
            return false;
        }
        return NumberUtil$.MODULE$.equalsWithTolerance(this.y(), c.y(), tolerance);
    }

    public boolean equals3D(Coordinate other) {
        return this.x() == other.x() && this.y() == other.y() && (this.getZ() == other.getZ() || Double.isNaN(this.getZ()) && Double.isNaN(other.getZ()));
    }

    public boolean equalInZ(Coordinate c, double tolerance) {
        return NumberUtil$.MODULE$.equalsWithTolerance(this.getZ(), c.getZ(), tolerance);
    }

    public boolean equals(Object other) {
        if (!(other instanceof Coordinate)) {
            return false;
        }
        return this.equals2D((Coordinate)other);
    }

    @Override
    public int compareTo(Coordinate o) {
        Coordinate other = o;
        if (this.x() < other.x()) {
            return -1;
        }
        if (this.x() > other.x()) {
            return 1;
        }
        if (this.y() < other.y()) {
            return -1;
        }
        if (this.y() > other.y()) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return new StringBuilder(6).append("(").append(this.x()).append(", ").append(this.y()).append(", ").append(this.getZ()).append(")").toString();
    }

    /*
     * WARNING - void declaration
     */
    public Coordinate clone() {
        Coordinate coordinate;
        try {
            void var1_1;
            Coordinate coord = (Coordinate)super.clone();
            coordinate = var1_1;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Assert$.MODULE$.shouldNeverReachHere("this shouldn't happen because this class is Cloneable");
            coordinate = null;
        }
        return coordinate;
    }

    public Coordinate copy() {
        return new Coordinate(this);
    }

    public double distance(Coordinate c) {
        double dx = this.x() - c.x();
        double dy = this.y() - c.y();
        return Math.sqrt(dx * dx + dy * dy);
    }

    public double distance3D(Coordinate c) {
        double dx = this.x() - c.x();
        double dy = this.y() - c.y();
        double dz = this.getZ() - c.getZ();
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var1_1;
        int result = 17;
        result = 37 * result + Coordinate$.MODULE$.hashCode(this.x());
        result = 37 * result + Coordinate$.MODULE$.hashCode(this.y());
        return (int)var1_1;
    }

    public Coordinate(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Coordinate(Coordinate c) {
        this(c.x(), c.y(), c.getZ());
    }

    public Coordinate(double x, double y) {
        this(x, y, Coordinate$.MODULE$.NULL_ORDINATE());
    }

    public Coordinate() {
        this(0.0, 0.0);
    }

    public static class DimensionalComparator
    implements Comparator<Coordinate> {
        private final int dimensionsToTest;

        @Override
        public Comparator<Coordinate> reversed() {
            return Comparator.super.reversed();
        }

        @Override
        public Comparator<Coordinate> thenComparing(Comparator<? super Coordinate> x$1) {
            return Comparator.super.thenComparing(x$1);
        }

        @Override
        public <U> Comparator<Coordinate> thenComparing(Function<? super Coordinate, ? extends U> x$1, Comparator<? super U> x$2) {
            return Comparator.super.thenComparing(x$1, x$2);
        }

        @Override
        public <U extends Comparable<? super U>> Comparator<Coordinate> thenComparing(Function<? super Coordinate, ? extends U> x$1) {
            return Comparator.super.thenComparing(x$1);
        }

        @Override
        public Comparator<Coordinate> thenComparingInt(ToIntFunction<? super Coordinate> x$1) {
            return Comparator.super.thenComparingInt(x$1);
        }

        @Override
        public Comparator<Coordinate> thenComparingLong(ToLongFunction<? super Coordinate> x$1) {
            return Comparator.super.thenComparingLong(x$1);
        }

        @Override
        public Comparator<Coordinate> thenComparingDouble(ToDoubleFunction<? super Coordinate> x$1) {
            return Comparator.super.thenComparingDouble(x$1);
        }

        public int dimensionsToTest() {
            return this.dimensionsToTest;
        }

        @Override
        public int compare(Coordinate c1, Coordinate c2) {
            int compX = Coordinate$DimensionalComparator$.MODULE$.compare(c1.x(), c2.x());
            if (compX != 0) {
                return compX;
            }
            int compY = Coordinate$DimensionalComparator$.MODULE$.compare(c1.y(), c2.y());
            if (compY != 0) {
                return compY;
            }
            if (this.dimensionsToTest() <= 2) {
                return 0;
            }
            int compZ = Coordinate$DimensionalComparator$.MODULE$.compare(c1.getZ(), c2.getZ());
            return compZ;
        }

        public DimensionalComparator(int dimensionsToTest) {
            this.dimensionsToTest = dimensionsToTest;
            if (dimensionsToTest != 2 && dimensionsToTest != 3) {
                throw new IllegalArgumentException("only 2 or 3 dimensions may be specified");
            }
        }

        public DimensionalComparator() {
            this(2);
        }
    }
}

