/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.Coordinates$;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.math.MathUtil$;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.UninitializedFieldError;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class CoordinateArrays$ {
    public static final CoordinateArrays$ MODULE$ = new CoordinateArrays$();
    private static final Coordinate[] coordArrayType = new Coordinate[0];
    private static volatile boolean bitmap$init$0 = true;

    private Coordinate[] coordArrayType() {
        if (!bitmap$init$0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/geom/CoordinateArrays.scala: 27");
        }
        return coordArrayType;
    }

    public int dimension(Coordinate[] pts) {
        if (pts == null || pts.length == 0) {
            return 3;
        }
        IntRef dimension = IntRef.create((int)0);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])pts), (Function1 & Serializable)coordinate -> {
            dimension.elem = Math.max(dimension.elem, Coordinates$.MODULE$.dimension(coordinate));
            return BoxedUnit.UNIT;
        });
        return dimension.elem;
    }

    public int measures(Coordinate[] pts) {
        if (pts == null || pts.length == 0) {
            return 0;
        }
        IntRef measures = IntRef.create((int)0);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])pts), (Function1 & Serializable)coordinate -> {
            measures.elem = Math.max(measures.elem, Coordinates$.MODULE$.measures(coordinate));
            return BoxedUnit.UNIT;
        });
        return measures.elem;
    }

    public boolean isRing(Coordinate[] pts) {
        if (pts.length < 4) {
            return false;
        }
        return pts[0].equals2D(pts[pts.length - 1]);
    }

    public Coordinate ptNotInList(Coordinate[] testPts, Coordinate[] pts) {
        return (Coordinate)ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps((Object[])testPts), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)CoordinateArrays$.$anonfun$ptNotInList$1(pts, x$1))).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public int compare(Coordinate[] pts1, Coordinate[] pts2) {
        int i;
        for (i = 0; i < pts1.length && i < pts2.length; ++i) {
            int compare = pts1[i].compareTo(pts2[i]);
            if (compare == 0) continue;
            return compare;
        }
        if (i < pts2.length) {
            return -1;
        }
        if (i < pts1.length) {
            return 1;
        }
        return 0;
    }

    public int increasingDirection(Coordinate[] pts) {
        for (int i = 0; i < pts.length / 2; ++i) {
            int j = pts.length - 1 - i;
            int comp = pts[i].compareTo(pts[j]);
            if (comp == 0) continue;
            return comp;
        }
        return 1;
    }

    public boolean org$locationtech$jts$geom$CoordinateArrays$$isEqualReversed(Coordinate[] pts1, Coordinate[] pts2) {
        for (int i = 0; i < pts1.length; ++i) {
            Coordinate p1 = pts1[i];
            Coordinate p2 = pts2[pts1.length - i - 1];
            if (p1.compareTo(p2) == 0) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public Coordinate[] copyDeep(Coordinate[] coordinates) {
        void var2_2;
        Coordinate[] copy = new Coordinate[coordinates.length];
        for (int i = 0; i < coordinates.length; ++i) {
            copy[i] = coordinates[i].copy();
        }
        return var2_2;
    }

    public void copyDeep(Coordinate[] src, int srcStart, Coordinate[] dest, int destStart, int length) {
        for (int i = 0; i < length; ++i) {
            dest[destStart + i] = src[srcStart + i].copy();
        }
    }

    public Coordinate[] toCoordinateArray(Collection<?> coordList) {
        return (Coordinate[])coordList.toArray((Object[])this.coordArrayType());
    }

    public boolean hasRepeatedPoints(Coordinate[] coord) {
        for (int i = 1; i < coord.length; ++i) {
            Coordinate coordinate = coord[i - 1];
            Coordinate coordinate2 = coord[i];
            if (coordinate != null ? !((Object)coordinate).equals(coordinate2) : coordinate2 != null) continue;
            return true;
        }
        return false;
    }

    public Coordinate[] atLeastNCoordinatesOrNothing(int n, Coordinate[] c) {
        return c.length >= n ? c : (Coordinate[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(Coordinate.class));
    }

    public Coordinate[] removeRepeatedPoints(Coordinate[] coord) {
        if (!this.hasRepeatedPoints(coord)) {
            return coord;
        }
        CoordinateList coordList = new CoordinateList(coord, false);
        return coordList.toCoordinateArray();
    }

    public Coordinate[] removeNull(Coordinate[] coord) {
        int i;
        int nonNull = 0;
        for (i = 0; i < coord.length; ++i) {
            Object object = coord[i] != null ? BoxesRunTime.boxToInteger((int)(++nonNull - 1)) : BoxedUnit.UNIT;
        }
        Coordinate[] newCoord = new Coordinate[nonNull];
        if (nonNull == 0) {
            return newCoord;
        }
        int j = 0;
        for (i = 0; i < coord.length; ++i) {
            if (coord[i] == null) continue;
            newCoord[++j - 1] = coord[i];
        }
        return newCoord;
    }

    public void reverse(Coordinate[] coord) {
        int last = coord.length - 1;
        int mid = last / 2;
        for (int i = 0; i <= mid; ++i) {
            Coordinate tmp = coord[i];
            coord[i] = coord[last - i];
            coord[last - i] = tmp;
        }
    }

    public boolean equals(Coordinate[] coord1, Coordinate[] coord2) {
        if (coord1 == coord2) {
            return true;
        }
        if (coord1 == null || coord2 == null) {
            return false;
        }
        if (coord1.length != coord2.length) {
            return false;
        }
        for (int i = 0; i < coord1.length; ++i) {
            Coordinate coordinate = coord1[i];
            Coordinate coordinate2 = coord2[i];
            if (!(coordinate == null ? coordinate2 != null : !((Object)coordinate).equals(coordinate2))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Coordinate[] coord1, Coordinate[] coord2, Comparator<Coordinate> coordinateComparator) {
        if (coord1 == coord2) {
            return true;
        }
        if (coord1 == null || coord2 == null) {
            return false;
        }
        if (coord1.length != coord2.length) {
            return false;
        }
        for (int i = 0; i < coord1.length; ++i) {
            if (coordinateComparator.compare(coord1[i], coord2[i]) == 0) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public Coordinate minCoordinate(Coordinate[] coordinates) {
        void var2_2;
        Coordinate minCoord = null;
        for (int i = 0; i < coordinates.length; ++i) {
            if (minCoord != null && minCoord.compareTo(coordinates[i]) <= 0) continue;
            minCoord = coordinates[i];
        }
        return var2_2;
    }

    public void scroll(Coordinate[] coordinates, Coordinate firstCoordinate) {
        int i = this.indexOf(firstCoordinate, coordinates);
        if (i < 0) {
            return;
        }
        Coordinate[] newCoordinates = new Coordinate[coordinates.length];
        System.arraycopy(coordinates, i, newCoordinates, 0, coordinates.length - i);
        System.arraycopy(coordinates, 0, newCoordinates, coordinates.length - i, i);
        System.arraycopy(newCoordinates, 0, coordinates, 0, coordinates.length);
    }

    public int indexOf(Coordinate coordinate, Coordinate[] coordinates) {
        for (int i = 0; i < coordinates.length; ++i) {
            Coordinate coordinate2 = coordinate;
            Coordinate coordinate3 = coordinates[i];
            if (coordinate2 != null ? !((Object)coordinate2).equals(coordinate3) : coordinate3 != null) continue;
            return i;
        }
        return -1;
    }

    public Coordinate[] extract(Coordinate[] pts, int startArg, int endArg) {
        int start = MathUtil$.MODULE$.clamp(startArg, 0, pts.length);
        int end = MathUtil$.MODULE$.clamp(endArg, -1, pts.length);
        int npts = end - start + 1;
        if (end < 0) {
            npts = 0;
        }
        if (start >= pts.length) {
            npts = 0;
        }
        if (end < start) {
            npts = 0;
        }
        Coordinate[] extractPts = new Coordinate[npts];
        if (npts == 0) {
            return extractPts;
        }
        int iPts = 0;
        for (int i = start; i <= end; ++i) {
            extractPts[++iPts - 1] = pts[i];
        }
        return extractPts;
    }

    /*
     * WARNING - void declaration
     */
    public Envelope envelope(Coordinate[] coordinates) {
        void var2_2;
        Envelope env = new Envelope();
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])coordinates), (Function1 & Serializable)p -> {
            env.expandToInclude(p);
            return BoxedUnit.UNIT;
        });
        return var2_2;
    }

    public Coordinate[] intersection(Coordinate[] coordinates, Envelope env) {
        CoordinateList coordList = new CoordinateList((Coordinate[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(Coordinate.class)));
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])coordinates), (Function1 & Serializable)c -> {
            CoordinateArrays$.$anonfun$intersection$1(env, coordList, c);
            return BoxedUnit.UNIT;
        });
        return coordList.toCoordinateArray();
    }

    public static final /* synthetic */ boolean $anonfun$ptNotInList$1(Coordinate[] pts$1, Coordinate x$1) {
        return MODULE$.indexOf(x$1, pts$1) < 0;
    }

    public static final /* synthetic */ void $anonfun$intersection$1(Envelope env$2, CoordinateList coordList$1, Coordinate c) {
        block0: {
            if (!env$2.intersects(c)) break block0;
            coordList$1.add(c, true);
        }
    }

    private CoordinateArrays$() {
    }
}

