/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequence$;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class CoordinateSequences$ {
    public static final CoordinateSequences$ MODULE$ = new CoordinateSequences$();

    public void reverse(CoordinateSequence seq) {
        int last = seq.size() - 1;
        int mid = last / 2;
        for (int i = 0; i <= mid; ++i) {
            this.swap(seq, i, last - i);
        }
    }

    public void swap(CoordinateSequence seq, int i, int j) {
        if (i == j) {
            return;
        }
        for (int dim = 0; dim < seq.getDimension(); ++dim) {
            double tmp = seq.getOrdinate(i, dim);
            seq.setOrdinate(i, dim, seq.getOrdinate(j, dim));
            seq.setOrdinate(j, dim, tmp);
        }
    }

    public void copy(CoordinateSequence src, int srcPos, CoordinateSequence dest, int destPos, int length) {
        for (int i = 0; i < length; ++i) {
            this.copyCoord(src, srcPos + i, dest, destPos + i);
        }
    }

    public void copyCoord(CoordinateSequence src, int srcPos, CoordinateSequence dest, int destPos) {
        int minDim = Math.min(src.getDimension(), dest.getDimension());
        for (int dim = 0; dim < minDim; ++dim) {
            dest.setOrdinate(destPos, dim, src.getOrdinate(srcPos, dim));
        }
    }

    public boolean isRing(CoordinateSequence seq) {
        int n = seq.size();
        if (n == 0) {
            return true;
        }
        if (n <= 3) {
            return false;
        }
        return seq.getOrdinate(0, CoordinateSequence$.MODULE$.X()) == seq.getOrdinate(n - 1, CoordinateSequence$.MODULE$.X()) && seq.getOrdinate(0, CoordinateSequence$.MODULE$.Y()) == seq.getOrdinate(n - 1, CoordinateSequence$.MODULE$.Y());
    }

    public CoordinateSequence ensureValidRing(CoordinateSequenceFactory fact, CoordinateSequence seq) {
        boolean isClosed;
        int n = seq.size();
        if (n == 0) {
            return seq;
        }
        if (n <= 3) {
            return this.createClosedRing(fact, seq, 4);
        }
        boolean bl = isClosed = seq.getOrdinate(0, CoordinateSequence$.MODULE$.X()) == seq.getOrdinate(n - 1, CoordinateSequence$.MODULE$.X()) && seq.getOrdinate(0, CoordinateSequence$.MODULE$.Y()) == seq.getOrdinate(n - 1, CoordinateSequence$.MODULE$.Y());
        if (isClosed) {
            return seq;
        }
        return this.createClosedRing(fact, seq, n + 1);
    }

    private CoordinateSequence createClosedRing(CoordinateSequenceFactory fact, CoordinateSequence seq, int size) {
        CoordinateSequence newseq = fact.create(size, seq.getDimension());
        int n = seq.size();
        this.copy(seq, 0, newseq, 0, n);
        for (int i = n; i < size; ++i) {
            this.copy(seq, 0, newseq, i, 1);
        }
        return newseq;
    }

    public CoordinateSequence extend(CoordinateSequenceFactory fact, CoordinateSequence seq, int size) {
        CoordinateSequence newseq = fact.create(size, seq.getDimension());
        int n = seq.size();
        this.copy(seq, 0, newseq, 0, n);
        if (n > 0) {
            for (int i = n; i < size; ++i) {
                this.copy(seq, n - 1, newseq, i, 1);
            }
        }
        return newseq;
    }

    public String toString(CoordinateSequence cs) {
        int size = cs.size();
        if (size == 0) {
            return "()";
        }
        int dim = cs.getDimension();
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        int i = 0;
        while (i < size) {
            Object object = i > 0 ? builder.append(" ") : BoxedUnit.UNIT;
            int d = 0;
            while (d < dim) {
                Object object2 = d > 0 ? BoxesRunTime.boxToCharacter((char)builder.append(",").apply(++d - 1)) : BoxedUnit.UNIT;
            }
            int cfr_ignored_0 = ++i - 1;
        }
        builder.append(')');
        return builder.toString();
    }

    /*
     * WARNING - void declaration
     */
    public Coordinate minCoordinate(CoordinateSequence seq) {
        void var2_2;
        Coordinate minCoord = null;
        for (int i = 0; i < seq.size(); ++i) {
            Coordinate testCoord = seq.getCoordinate(i);
            if (minCoord != null && minCoord.compareTo(testCoord) <= 0) continue;
            minCoord = testCoord;
        }
        return var2_2;
    }

    public int minCoordinateIndex(CoordinateSequence seq) {
        return this.minCoordinateIndex(seq, 0, seq.size() - 1);
    }

    public int minCoordinateIndex(CoordinateSequence seq, int from, int to) {
        int minCoordIndex = -1;
        Coordinate minCoord = null;
        int i = from;
        while (i <= to) {
            Coordinate testCoord = seq.getCoordinate(i);
            if (minCoord == null || minCoord.compareTo(testCoord) > 0) {
                minCoord = testCoord;
                minCoordIndex = i;
            }
            int cfr_ignored_0 = ++i - 1;
        }
        return minCoordIndex;
    }

    public void scroll(CoordinateSequence seq, Coordinate firstCoordinate) {
        int i = this.indexOf(firstCoordinate, seq);
        if (i <= 0) {
            return;
        }
        this.scroll(seq, i);
    }

    public void scroll(CoordinateSequence seq, int indexOfFirstCoordinate) {
        this.scroll(seq, indexOfFirstCoordinate, this.isRing(seq));
    }

    public void scroll(CoordinateSequence seq, int indexOfFirstCoordinate, boolean ensureRing) {
        int i = indexOfFirstCoordinate;
        if (i <= 0) {
            return;
        }
        CoordinateSequence copy = seq.copy();
        int last = ensureRing ? seq.size() - 1 : seq.size();
        for (int j = 0; j < last; ++j) {
            for (int k = 0; k < seq.getDimension(); ++k) {
                seq.setOrdinate(j, k, copy.getOrdinate((indexOfFirstCoordinate + j) % last, k));
            }
        }
        if (ensureRing) {
            for (int k = 0; k < seq.getDimension(); ++k) {
                seq.setOrdinate(last, k, seq.getOrdinate(0, k));
            }
        }
    }

    public int indexOf(Coordinate coordinate, CoordinateSequence seq) {
        for (int i = 0; i < seq.size(); ++i) {
            if (coordinate.x() != seq.getOrdinate(i, CoordinateSequence$.MODULE$.X()) || coordinate.y() != seq.getOrdinate(i, CoordinateSequence$.MODULE$.Y())) continue;
            return i;
        }
        return -1;
    }

    private CoordinateSequences$() {
    }
}

