/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import org.locationtech.jts.algorithm.Centroid$;
import org.locationtech.jts.algorithm.ConvexHull;
import org.locationtech.jts.algorithm.InteriorPoint$;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.CoordinateSequenceComparator;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry$;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryComponentFilter;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.GeometryFilter;
import org.locationtech.jts.geom.IntersectionMatrix;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.util.GeometryCollectionMapper$;
import org.locationtech.jts.geom.util.GeometryMapper;
import org.locationtech.jts.operation.IsSimpleOp;
import org.locationtech.jts.operation.buffer.BufferOp$;
import org.locationtech.jts.operation.distance.DistanceOp$;
import org.locationtech.jts.operation.overlay.OverlayOp$;
import org.locationtech.jts.operation.overlay.snap.SnapIfNeededOverlayOp$;
import org.locationtech.jts.operation.predicate.RectangleContains$;
import org.locationtech.jts.operation.predicate.RectangleIntersects$;
import org.locationtech.jts.operation.relate.RelateOp$;
import org.locationtech.jts.operation.union.UnaryUnionOp$;
import org.locationtech.jts.operation.valid.IsValidOp$;
import org.locationtech.jts.util.Assert$;
import scala.UninitializedFieldError;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\r]x!B;w\u0011\u0003yhaBA\u0002m\"\u0005\u0011Q\u0001\u0005\b\u0003G\tA\u0011AA\u0013\u0011)\t9#\u0001b\u0001\n\u00031\u0018\u0011\u0006\u0005\t\u0003c\t\u0001\u0015!\u0003\u0002,!Q\u00111G\u0001C\u0002\u0013\u0005a/!\u000b\t\u0011\u0005U\u0012\u0001)A\u0005\u0003WA!\"a\u000e\u0002\u0005\u0004%\tA^A\u0015\u0011!\tI$\u0001Q\u0001\n\u0005-\u0002BCA\u001e\u0003\t\u0007I\u0011\u0001<\u0002*!A\u0011QH\u0001!\u0002\u0013\tY\u0003\u0003\u0006\u0002@\u0005\u0011\r\u0011\"\u0001w\u0003SA\u0001\"!\u0011\u0002A\u0003%\u00111\u0006\u0005\u000b\u0003\u0007\n!\u0019!C\u0001m\u0006%\u0002\u0002CA#\u0003\u0001\u0006I!a\u000b\t\u0015\u0005\u001d\u0013A1A\u0005\u0002Y\fI\u0003\u0003\u0005\u0002J\u0005\u0001\u000b\u0011BA\u0016\u0011)\tY%\u0001b\u0001\n\u00031\u0018\u0011\u0006\u0005\t\u0003\u001b\n\u0001\u0015!\u0003\u0002,!I\u0011qJ\u0001C\u0002\u0013%\u0011\u0011\u000b\u0005\t\u00033\n\u0001\u0015!\u0003\u0002T!9\u0011\u0011M\u0001\u0005\u0002\u0005\r\u0004bBBp\u0003\u0011\u00051\u0011\u001d\u0005\b\u0007S\fA\u0011ABv\u0011%\u0019y/AA\u0001\n\u0013\u0019\tPB\u0004\u0002\u0004Y\f\t!a\u001e\t\u0015\u0005u\u0015D!b\u0001\n\u0003\ty\n\u0003\u0006\u0002(f\u0011\t\u0011)A\u0005\u0003CCq!a\t\u001a\t\u0003\tI\u000bC\u0005\u0002.f\u0001\r\u0011\"\u0005\u00020\"I\u0011qW\rA\u0002\u0013E\u0011\u0011\u0018\u0005\t\u0003\u000bL\u0002\u0015)\u0003\u00022\"I\u0011qY\rA\u0002\u0013E\u0011\u0011\u0006\u0005\n\u0003\u0013L\u0002\u0019!C\t\u0003\u0017D\u0001\"a4\u001aA\u0003&\u00111\u0006\u0005\n\u0003#L\u0002\u0019!C\u0005\u0003'D\u0011\"!6\u001a\u0001\u0004%I!a6\t\u0011\u0005m\u0017\u0004)Q\u0005\u0003\u000fAq!!8\u001a\r\u0003\ty\u000eC\u0004\u0002rf!\t!!\u000b\t\u000f\u0005M\u0018\u0004\"\u0001\u0002v\"9\u0011\u0011`\r\u0005\u0002\u0005}\u0005bBA~3\u0011\u0005\u0011Q \u0005\b\u0005\u000bIB\u0011AA\u0015\u0011\u001d\u00119!\u0007C\u0001\u0005\u0013AqAa\u0004\u001a\t\u0003\u0011\t\u0002C\u0004\u0003\u0016e!\tAa\u0006\t\u000f\t}\u0011D\"\u0001\u0003\"!9!\u0011F\r\u0007\u0002\t-\u0002b\u0002B\u00183\u0019\u0005\u0011\u0011\u0006\u0005\b\u0005cIB\u0011\u0001B\u001a\u0011\u001d\u0011)$\u0007C\u0001\u0005gAqAa\u000e\u001a\r\u0003\u0011\u0019\u0004C\u0004\u0003:e!\tAa\u000f\t\u000f\t\u001d\u0013\u0004\"\u0001\u0003J!9!qJ\r\u0005\u0002\tM\u0002b\u0002B)3\u0011\u0005!1\u000b\u0005\b\u0005+JB\u0011\u0001B*\u0011\u001d\u00119&\u0007C\u0001\u00053BqA!\u0019\u001a\t\u0003\u0011I\u0006C\u0004\u0003de1\t!!\u000b\t\u000f\t\u0015\u0014D\"\u0001\u0003h!9!\u0011N\r\u0007\u0002\u0005%\u0002b\u0002B63\u0011\u0005!q\r\u0005\b\u0005[JB\u0011AAX\u0011\u001d\u0011y'\u0007C\u0001\u0005cBqAa\u001d\u001a\t#\u0011\t\bC\u0004\u0003ve!\tAa\u001e\t\u000f\tm\u0014\u0004\"\u0001\u0003~!9!\u0011Q\r\u0005\u0002\t\r\u0005b\u0002BD3\u0011\u0005!\u0011\u0012\u0005\b\u0005\u001bKB\u0011\u0001BH\u0011\u001d\u0011\u0019*\u0007C\u0001\u0005+CqA!'\u001a\t\u0003\u0011Y\nC\u0004\u0003 f!\tA!)\t\u000f\t\u0015\u0016\u0004\"\u0001\u0003(\"9!1V\r\u0005\u0002\t5\u0006b\u0002BV3\u0011\u0005!Q\u0017\u0005\b\u0005\u007fKB\u0011\u0001Ba\u0011\u001d\u0011)-\u0007C\u0001\u0005\u000fDqAa0\u001a\t\u0003\u0012Y\rC\u0004\u0003Xf!\tE!7\t\u000f\tm\u0017\u0004\"\u0011\u0003^\"9!q\\\r\u0005\u0002\t\u0005\bb\u0002Bp3\u0011\u0005!Q\u001d\u0005\b\u0005?LB\u0011\u0001Bw\u0011\u001d\u001190\u0007C\u0001\u0005OBqA!?\u001a\t\u0003\u00119\u0007C\u0004\u0003|f1\tBa\u001a\t\u000f\tu\u0018\u0004\"\u0001\u0003\u0000\"91QA\r\u0005\u0002\r\u001d\u0001bBB\u00063\u0011\u00051Q\u0002\u0005\b\u0007#IB\u0011AB\n\u0011\u001d\u0019)!\u0007C\u0001\u0005OBqaa\u0006\u001a\r\u0003\u0019I\u0002C\u0004\u0004\u0018e!\ta!\t\t\u000f\r\u0015\u0012\u0004\"\u0001\u0004(!911F\r\u0007\u0002\r5\u0002bBB\u00163\u0019\u00051\u0011\b\u0005\b\u0007WIb\u0011AB\"\u0011\u001d\u0019Y#\u0007D\u0001\u0007\u001bBqa!\u0015\u001a\t\u0003\u001a\u0019\u0006C\u0004\u0004Ve!\tAa\u001a\t\u000f\r]\u0013D\"\u0005\u0003h!91\u0011L\r\u0007\u0002\tE\u0004bBB.3\u0011\u0005!q\r\u0005\b\u0007;JB\u0011IB0\u0011\u001d\u0019i&\u0007C\u0001\u0007GBqa!\u001d\u001a\t#\u0019\u0019\bC\u0004\u0004xe!\tBa\r\t\u000f\re\u0014D\"\u0005\u00020\"911P\r\u0007\u0012\ru\u0004bBB>3\u0019\u00051\u0011\u0011\u0005\b\u0007\u000fKB\u0011ABE\u0011\u001d\u0019Y,\u0007C\t\u0007{Cqa!2\u001a\r#\tI\u0003C\u0004\u0004Hf!Ia!3\u0002\u0011\u001d+w.\\3uefT!a\u001e=\u0002\t\u001d,w.\u001c\u0006\u0003sj\f1A\u001b;t\u0015\tYH0\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001~\u0003\ry'oZ\u0002\u0001!\r\t\t!A\u0007\u0002m\nAq)Z8nKR\u0014\u0018pE\u0003\u0002\u0003\u000f\t\u0019\u0002\u0005\u0003\u0002\n\u0005=QBAA\u0006\u0015\t\ti!A\u0003tG\u0006d\u0017-\u0003\u0003\u0002\u0012\u0005-!AB!osJ+g\r\u0005\u0003\u0002\u0016\u0005}QBAA\f\u0015\u0011\tI\"a\u0007\u0002\u0005%|'BAA\u000f\u0003\u0011Q\u0017M^1\n\t\u0005\u0005\u0012q\u0003\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003}\fqbU(S)&sE)\u0012-`!>Ke\nV\u000b\u0003\u0003W\u0001B!!\u0003\u0002.%!\u0011qFA\u0006\u0005\rIe\u000e^\u0001\u0011'>\u0013F+\u0013(E\u000bb{\u0006kT%O)\u0002\nAcU(S)&sE)\u0012-`\u001bVcE+\u0013)P\u0013:#\u0016!F*P%RKe\nR#Y?6+F\nV%Q\u001f&sE\u000bI\u0001\u0015'>\u0013F+\u0013(E\u000bb{F*\u0013(F'R\u0013\u0016JT$\u0002+M{%\u000bV%O\t\u0016Cv\fT%O\u000bN#&+\u0013(HA\u0005!2k\u0014*U\u0013:#U\tW0M\u0013:+\u0015I\u0015*J\u001d\u001e\u000bQcU(S)&sE)\u0012-`\u0019&sU)\u0011*S\u0013:;\u0005%A\rT\u001fJ#\u0016J\u0014#F1~kU\u000b\u0014+J\u0019&sUi\u0015+S\u0013:;\u0015AG*P%RKe\nR#Y?6+F\nV%M\u0013:+5\u000b\u0016*J\u001d\u001e\u0003\u0013!E*P%RKe\nR#Y?B{E*W$P\u001d\u0006\u00112k\u0014*U\u0013:#U\tW0Q\u001f2Kvi\u0014(!\u0003Y\u0019vJ\u0015+J\u001d\u0012+\u0005lX'V\u0019RK\u0005k\u0014'Z\u000f>s\u0015aF*P%RKe\nR#Y?6+F\nV%Q\u001f2Kvi\u0014(!\u0003q\u0019vJ\u0015+J\u001d\u0012+\u0005lX$F\u001f6+EKU-D\u001f2cUi\u0011+J\u001f:\u000bQdU(S)&sE)\u0012-`\u000f\u0016{U*\u0012+S3\u000e{E\nT#D)&{e\nI\u0001\u0016O\u0016|W.\u001a;ss\u000eC\u0017M\\4fI\u001aKG\u000e^3s+\t\t\u0019F\u0005\u0004\u0002V\u0005\u001d\u00111\f\u0004\u0007\u0003/\"\u0002!a\u0015\u0003\u0019q\u0012XMZ5oK6,g\u000e\u001e \u0002-\u001d,w.\\3uef\u001c\u0005.\u00198hK\u00124\u0015\u000e\u001c;fe\u0002\u0002B!!\u0001\u0002^%\u0019\u0011q\f<\u0003/\u001d+w.\\3uef\u001cu.\u001c9p]\u0016tGOR5mi\u0016\u0014\u0018a\u00055bg:{g.R7qif,E.Z7f]R\u001cH\u0003BA3\u0003W\u0002B!!\u0003\u0002h%!\u0011\u0011NA\u0006\u0005\u001d\u0011un\u001c7fC:Dq!!\u001c\u0016\u0001\u0004\ty'\u0001\u0006hK>lW\r\u001e:jKN\u0004b!!\u0003\u0002r\u0005U\u0014\u0002BA:\u0003\u0017\u0011Q!\u0011:sCf\u00042!!\u0001\u001a'%I\u0012qAA=\u0003#\u000b\u0019\u0002\u0005\u0003\u0002|\u0005-e\u0002BA?\u0003\u000fsA!a \u0002\u00066\u0011\u0011\u0011\u0011\u0006\u0004\u0003\u0007s\u0018A\u0002\u001fs_>$h(\u0003\u0002\u0002\u000e%!\u0011\u0011RA\u0006\u0003\u001d\u0001\u0018mY6bO\u0016LA!!$\u0002\u0010\nI1\t\\8oK\u0006\u0014G.\u001a\u0006\u0005\u0003\u0013\u000bY\u0001\u0005\u0004\u0002\u0014\u0006e\u0015QO\u0007\u0003\u0003+SA!a&\u0002\u001c\u0005!A.\u00198h\u0013\u0011\tY*!&\u0003\u0015\r{W\u000e]1sC\ndW-A\u0004gC\u000e$xN]=\u0016\u0005\u0005\u0005\u0006\u0003BA\u0001\u0003GK1!!*w\u0005=9Um\\7fiJLh)Y2u_JL\u0018\u0001\u00034bGR|'/\u001f\u0011\u0015\t\u0005U\u00141\u0016\u0005\b\u0003;c\u0002\u0019AAQ\u0003!)gN^3m_B,WCAAY!\u0011\t\t!a-\n\u0007\u0005UfO\u0001\u0005F]Z,Gn\u001c9f\u00031)gN^3m_B,w\fJ3r)\u0011\tY,!1\u0011\t\u0005%\u0011QX\u0005\u0005\u0003\u007f\u000bYA\u0001\u0003V]&$\b\"CAb=\u0005\u0005\t\u0019AAY\u0003\rAH%M\u0001\nK:4X\r\\8qK\u0002\nAa\u0015*J\t\u0006A1KU%E?\u0012*\u0017\u000f\u0006\u0003\u0002<\u00065\u0007\"CAbC\u0005\u0005\t\u0019AA\u0016\u0003\u0015\u0019&+\u0013#!\u0003!)8/\u001a:ECR\fWCAA\u0004\u00031)8/\u001a:ECR\fw\fJ3r)\u0011\tY,!7\t\u0013\u0005\rG%!AA\u0002\u0005\u001d\u0011!C;tKJ$\u0015\r^1!\u0003=9W\r^$f_6,GO]=UsB,WCAAq!\u0011\t\u0019/a;\u000f\t\u0005\u0015\u0018q\u001d\t\u0005\u0003\u007f\nY!\u0003\u0003\u0002j\u0006-\u0011A\u0002)sK\u0012,g-\u0003\u0003\u0002n\u0006=(AB*ue&twM\u0003\u0003\u0002j\u0006-\u0011aB4fiN\u0013\u0016\nR\u0001\bg\u0016$8KU%E)\u0011\tY,a>\t\u000f\u0005\u001d\u0007\u00061\u0001\u0002,\u0005Qq-\u001a;GC\u000e$xN]=\u0002\u0017\u001d,G/V:fe\u0012\u000bG/Y\u000b\u0003\u0003\u007f\u0004B!a%\u0003\u0002%!!1AAK\u0005\u0019y%M[3di\u0006\u0001r-\u001a;Ok6<Um\\7fiJLWm]\u0001\rO\u0016$x)Z8nKR\u0014\u0018P\u0014\u000b\u0005\u0003k\u0012Y\u0001C\u0004\u0003\u000e1\u0002\r!a\u000b\u0002\u00039\f1b]3u+N,'\u000fR1uCR!\u00111\u0018B\n\u0011\u001d\t\t.\fa\u0001\u0003\u000f\t\u0011cZ3u!J,7-[:j_:lu\u000eZ3m+\t\u0011I\u0002\u0005\u0003\u0002\u0002\tm\u0011b\u0001B\u000fm\nq\u0001K]3dSNLwN\\'pI\u0016d\u0017!D4fi\u000e{wN\u001d3j]\u0006$X-\u0006\u0002\u0003$A!\u0011\u0011\u0001B\u0013\u0013\r\u00119C\u001e\u0002\u000b\u0007>|'\u000fZ5oCR,\u0017AD4fi\u000e{wN\u001d3j]\u0006$Xm]\u000b\u0003\u0005[\u0001b!!\u0003\u0002r\t\r\u0012\u0001D4fi:+X\u000eU8j]R\u001c\u0018\u0001C5t'&l\u0007\u000f\\3\u0016\u0005\u0005\u0015\u0014aB5t-\u0006d\u0017\u000eZ\u0001\bSN,U\u000e\u001d;z\u0003!!\u0017n\u001d;b]\u000e,G\u0003\u0002B\u001f\u0005\u0007\u0002B!!\u0003\u0003@%!!\u0011IA\u0006\u0005\u0019!u.\u001e2mK\"9!QI\u001bA\u0002\u0005U\u0014!A4\u0002!%\u001cx+\u001b;iS:$\u0015n\u001d;b]\u000e,GCBA3\u0005\u0017\u0012i\u0005\u0003\u0004xm\u0001\u0007\u0011Q\u000f\u0005\b\u0005s1\u0004\u0019\u0001B\u001f\u0003-I7OU3di\u0006tw\r\\3\u0002\u000f\u001d,G/\u0011:fCV\u0011!QH\u0001\nO\u0016$H*\u001a8hi\"\f1bZ3u\u0007\u0016tGO]8jIV\u0011!1\f\t\u0005\u0003\u0003\u0011i&C\u0002\u0003`Y\u0014Q\u0001U8j]R\f\u0001cZ3u\u0013:$XM]5peB{\u0017N\u001c;\u0002\u0019\u001d,G\u000fR5nK:\u001c\u0018n\u001c8\u0002\u0017\u001d,GOQ8v]\u0012\f'/_\u000b\u0003\u0003k\nAcZ3u\u0005>,h\u000eZ1ss\u0012KW.\u001a8tS>t\u0017aC4fi\u0016sg/\u001a7pa\u0016\f1cZ3u\u000b:4X\r\\8qK&sG/\u001a:oC2\fqbZ3p[\u0016$(/_\"iC:<W\r\u001a\u000b\u0003\u0003w\u000bQcZ3p[\u0016$(/_\"iC:<W\rZ!di&|g.\u0001\u0005eSNTw.\u001b8u)\u0011\t)G!\u001f\t\u000f\t\u00153\t1\u0001\u0002v\u00059Ao\\;dQ\u0016\u001cH\u0003BA3\u0005\u007fBqA!\u0012E\u0001\u0004\t)(\u0001\u0006j]R,'o]3diN$B!!\u001a\u0003\u0006\"9!QI#A\u0002\u0005U\u0014aB2s_N\u001cXm\u001d\u000b\u0005\u0003K\u0012Y\tC\u0004\u0003F\u0019\u0003\r!!\u001e\u0002\r]LG\u000f[5o)\u0011\t)G!%\t\u000f\t\u0015s\t1\u0001\u0002v\u0005A1m\u001c8uC&t7\u000f\u0006\u0003\u0002f\t]\u0005b\u0002B#\u0011\u0002\u0007\u0011QO\u0001\t_Z,'\u000f\\1qgR!\u0011Q\rBO\u0011\u001d\u0011)%\u0013a\u0001\u0003k\naaY8wKJ\u001cH\u0003BA3\u0005GCqA!\u0012K\u0001\u0004\t)(A\u0005d_Z,'/\u001a3CsR!\u0011Q\rBU\u0011\u001d\u0011)e\u0013a\u0001\u0003k\naA]3mCR,GCBA3\u0005_\u0013\t\fC\u0004\u0003F1\u0003\r!!\u001e\t\u000f\tMF\n1\u0001\u0002b\u0006\u0019\u0012N\u001c;feN,7\r^5p]B\u000bG\u000f^3s]R!!q\u0017B_!\u0011\t\tA!/\n\u0007\tmfO\u0001\nJ]R,'o]3di&|g.T1ue&D\bb\u0002B#\u001b\u0002\u0007\u0011QO\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005\u0015$1\u0019\u0005\b\u0005\u000br\u0005\u0019AA;\u0003))\u0017/^1mgR{\u0007o\u001c\u000b\u0005\u0003K\u0012I\rC\u0004\u0003F=\u0003\r!!\u001e\u0015\t\u0005\u0015$Q\u001a\u0005\b\u0005\u001f\u0004\u0006\u0019\u0001Bi\u0003\u0005y\u0007\u0003BA\u0005\u0005'LAA!6\u0002\f\t\u0019\u0011I\\=\u0002\u0011!\f7\u000f[\"pI\u0016$\"!a\u000b\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!9\u0002\r\t,hMZ3s)\u0011\t)Ha9\t\u000f\te2\u000b1\u0001\u0003>Q1\u0011Q\u000fBt\u0005SDqA!\u000fU\u0001\u0004\u0011i\u0004C\u0004\u0003lR\u0003\r!a\u000b\u0002!E,\u0018\r\u001a:b]R\u001cVmZ7f]R\u001cH\u0003CA;\u0005_\u0014\tPa=\t\u000f\teR\u000b1\u0001\u0003>!9!1^+A\u0002\u0005-\u0002b\u0002B{+\u0002\u0007\u00111F\u0001\fK:$7)\u00199TifdW-\u0001\u0006d_:4X\r\u001f%vY2\fqA]3wKJ\u001cX-A\bsKZ,'o]3J]R,'O\\1m\u00031Ig\u000e^3sg\u0016\u001cG/[8o)\u0011\t)h!\u0001\t\u000f\r\r\u0011\f1\u0001\u0002v\u0005)q\u000e\u001e5fe\u0006)QO\\5p]R!\u0011QOB\u0005\u0011\u001d\u0019\u0019A\u0017a\u0001\u0003k\n!\u0002Z5gM\u0016\u0014XM\\2f)\u0011\t)ha\u0004\t\u000f\r\r1\f1\u0001\u0002v\u0005i1/_7ES\u001a4WM]3oG\u0016$B!!\u001e\u0004\u0016!911\u0001/A\u0002\u0005U\u0014aC3rk\u0006d7/\u0012=bGR$b!!\u001a\u0004\u001c\ru\u0001bBB\u0002=\u0002\u0007\u0011Q\u000f\u0005\b\u0007?q\u0006\u0019\u0001B\u001f\u0003%!x\u000e\\3sC:\u001cW\r\u0006\u0003\u0002f\r\r\u0002bBB\u0002?\u0002\u0007\u0011QO\u0001\u000bKF,\u0018\r\\:O_JlG\u0003BA3\u0007SAqA!\u0012a\u0001\u0004\t)(\u0001\u0004baBd\u0017P\u0012\u000b\u0005\u0003w\u001by\u0003C\u0004\u00042\u0005\u0004\raa\r\u0002\r\u0019LG\u000e^3s!\u0011\t\ta!\u000e\n\u0007\r]bO\u0001\tD_>\u0014H-\u001b8bi\u00164\u0015\u000e\u001c;feR!\u00111XB\u001e\u0011\u001d\u0019\tD\u0019a\u0001\u0007{\u0001B!!\u0001\u0004@%\u00191\u0011\t<\u00031\r{wN\u001d3j]\u0006$XmU3rk\u0016t7-\u001a$jYR,'\u000f\u0006\u0003\u0002<\u000e\u0015\u0003bBB\u0019G\u0002\u00071q\t\t\u0005\u0003\u0003\u0019I%C\u0002\u0004LY\u0014abR3p[\u0016$(/\u001f$jYR,'\u000f\u0006\u0003\u0002<\u000e=\u0003bBB\u0019I\u0002\u0007\u00111L\u0001\u0006G2|g.\u001a\u000b\u0003\u0003\u000f\tAaY8qs\u0006a1m\u001c9z\u0013:$XM\u001d8bY\u0006Ian\u001c:nC2L'0Z\u0001\u0005]>\u0014X.A\u0005d_6\u0004\u0018M]3U_R!\u00111FB1\u0011\u001d\u0019\u0019A\u001ba\u0001\u0003k\"b!a\u000b\u0004f\r\u001d\u0004bBB\u0002W\u0002\u0007\u0011Q\u000f\u0005\b\u0007SZ\u0007\u0019AB6\u0003\u0011\u0019w.\u001c9\u0011\t\u0005\u00051QN\u0005\u0004\u0007_2(\u0001H\"p_J$\u0017N\\1uKN+\u0017/^3oG\u0016\u001cu.\u001c9be\u0006$xN]\u0001\u0012SN,\u0015/^5wC2,g\u000e^\"mCN\u001cH\u0003BA3\u0007kBqaa\u0001m\u0001\u0004\t)(\u0001\u000bjg\u001e+w.\\3uef\u001cu\u000e\u001c7fGRLwN\\\u0001\u0018G>l\u0007/\u001e;f\u000b:4X\r\\8qK&sG/\u001a:oC2\f!cY8na\u0006\u0014X\rV8TC6,7\t\\1tgR!\u00111FB@\u0011\u001d\u0011ym\u001ca\u0001\u0003k\"b!a\u000b\u0004\u0004\u000e\u0015\u0005b\u0002Bha\u0002\u0007\u0011Q\u000f\u0005\b\u0007S\u0002\b\u0019AB6\u0003\u001d\u0019w.\u001c9be\u0016,Baa#\u0004\"RA\u00111FBG\u0007[\u001b\t\fC\u0004\u0004\u0010F\u0004\ra!%\u0002\u0003\u0005\u0004baa%\u0004\u001a\u000euUBABK\u0015\u0011\u00199*a\u0007\u0002\tU$\u0018\u000e\\\u0005\u0005\u00077\u001b)J\u0001\u0006D_2dWm\u0019;j_:\u0004Baa(\u0004\"2\u0001AaBBRc\n\u00071Q\u0015\u0002\u0002\u0003F!1q\u0015Bi!\u0011\tIa!+\n\t\r-\u00161\u0002\u0002\b\u001d>$\b.\u001b8h\u0011\u001d\u0019y+\u001da\u0001\u0007#\u000b\u0011A\u0019\u0005\b\u0007g\u000b\b\u0019AB[\u0003)\u0019w.\u001c9be\u0006$xN\u001d\t\u0007\u0007'\u001b9l!(\n\t\re6Q\u0013\u0002\u000b\u0007>l\u0007/\u0019:bi>\u0014\u0018!B3rk\u0006dG\u0003CA3\u0007\u007f\u001b\tma1\t\u000f\r=%\u000f1\u0001\u0003$!91q\u0016:A\u0002\t\r\u0002bBB\u0010e\u0002\u0007!QH\u0001\rO\u0016$8k\u001c:u\u0013:$W\r_\u0001\u001dGJ,\u0017\r^3Q_&tGO\u0012:p[&sG/\u001a:oC2\u001cun\u001c:e)\u0019\u0011Yfa3\u0004P\"91Q\u001a;A\u0002\t\r\u0012!B2p_J$\u0007bBBii\u0002\u0007\u0011QO\u0001\tKb,W\u000e\u001d7be\":\u0011d!6\u0004\\\u000eu\u0007\u0003BA\u0005\u0007/LAa!7\u0002\f\t\u00012+\u001a:jC24VM]:j_:,\u0016\nR\u0001\u0006m\u0006dW/\u001a\u0010\tsz%[MICK}\u0005y\u0001.Y:Ok2dW\t\\3nK:$8\u000f\u0006\u0003\u0002f\r\r\bbBBs-\u0001\u00071q]\u0001\u0006CJ\u0014\u0018-\u001f\t\u0007\u0003\u0013\t\t(a\u0002\u00025\rDWmY6O_R<Um\\7fiJL8i\u001c7mK\u000e$\u0018n\u001c8\u0015\t\u0005m6Q\u001e\u0005\b\u0005\u000b:\u0002\u0019AA;\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\ty\u0010K\u0004\u0002\u0007+\u001cYn!8)\u000f\u0001\u0019)na7\u0004^\u0002")
public abstract class Geometry
implements Cloneable,
Comparable<Geometry>,
Serializable {
    private static final long serialVersionUID = 8763622679187376702L;
    private final GeometryFactory factory;
    private Envelope envelope;
    private int SRID;
    private Object userData;
    private volatile byte bitmap$init$0;

    public static void checkNotGeometryCollection(Geometry geometry) {
        Geometry$.MODULE$.checkNotGeometryCollection(geometry);
    }

    public static boolean hasNullElements(Object[] objectArray) {
        return Geometry$.MODULE$.hasNullElements(objectArray);
    }

    public static boolean hasNonEmptyElements(Geometry[] geometryArray) {
        return Geometry$.MODULE$.hasNonEmptyElements(geometryArray);
    }

    public GeometryFactory factory() {
        return this.factory;
    }

    public Envelope envelope() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/geom/Geometry.scala: 238");
        }
        return this.envelope;
    }

    public void envelope_$eq(Envelope x$1) {
        this.envelope = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
    }

    public int SRID() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/geom/Geometry.scala: 242");
        }
        return this.SRID;
    }

    public void SRID_$eq(int x$1) {
        this.SRID = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
    }

    private Object userData() {
        if ((byte)(this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/geom/Geometry.scala: 247");
        }
        return this.userData;
    }

    private void userData_$eq(Object x$1) {
        this.userData = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
    }

    public abstract String getGeometryType();

    public int getSRID() {
        return this.SRID();
    }

    public void setSRID(int SRID) {
        this.SRID_$eq(SRID);
    }

    public GeometryFactory getFactory() {
        return this.factory();
    }

    public Object getUserData() {
        return this.userData();
    }

    public int getNumGeometries() {
        return 1;
    }

    public Geometry getGeometryN(int n) {
        return this;
    }

    public void setUserData(Object userData) {
        this.userData_$eq(userData);
    }

    public PrecisionModel getPrecisionModel() {
        return this.factory().getPrecisionModel();
    }

    public abstract Coordinate getCoordinate();

    public abstract Coordinate[] getCoordinates();

    public abstract int getNumPoints();

    public boolean isSimple() {
        IsSimpleOp op = new IsSimpleOp(this);
        return op.isSimple();
    }

    public boolean isValid() {
        return IsValidOp$.MODULE$.isValid(this);
    }

    public abstract boolean isEmpty();

    public double distance(Geometry g) {
        return DistanceOp$.MODULE$.distance(this, g);
    }

    public boolean isWithinDistance(Geometry geom, double distance) {
        return DistanceOp$.MODULE$.isWithinDistance(this, geom, distance);
    }

    public boolean isRectangle() {
        return false;
    }

    public double getArea() {
        return 0.0;
    }

    public double getLength() {
        return 0.0;
    }

    public Point getCentroid() {
        if (this.isEmpty()) {
            return this.factory().createPoint();
        }
        Coordinate centPt = Centroid$.MODULE$.getCentroid(this);
        return this.createPointFromInternalCoord(centPt, this);
    }

    public Point getInteriorPoint() {
        if (this.isEmpty()) {
            return this.factory().createPoint();
        }
        Coordinate pt = InteriorPoint$.MODULE$.getInteriorPoint(this);
        return this.createPointFromInternalCoord(pt, this);
    }

    public abstract int getDimension();

    public abstract Geometry getBoundary();

    public abstract int getBoundaryDimension();

    public Geometry getEnvelope() {
        return this.getFactory().toGeometry(this.getEnvelopeInternal());
    }

    public Envelope getEnvelopeInternal() {
        if (this.envelope() == null) {
            this.envelope_$eq(this.computeEnvelopeInternal());
        }
        return new Envelope(this.envelope());
    }

    public void geometryChanged() {
        this.applyF(Geometry$.MODULE$.org$locationtech$jts$geom$Geometry$$geometryChangedFilter());
    }

    public void geometryChangedAction() {
        this.envelope_$eq(null);
    }

    public boolean disjoint(Geometry g) {
        return !this.intersects(g);
    }

    public boolean touches(Geometry g) {
        if (!this.getEnvelopeInternal().intersects(g.getEnvelopeInternal())) {
            return false;
        }
        return this.relate(g).isTouches(this.getDimension(), g.getDimension());
    }

    public boolean intersects(Geometry g) {
        if (!this.getEnvelopeInternal().intersects(g.getEnvelopeInternal())) {
            return false;
        }
        if (this.isRectangle()) {
            return RectangleIntersects$.MODULE$.intersects((Polygon)this, g);
        }
        if (g.isRectangle()) {
            return RectangleIntersects$.MODULE$.intersects((Polygon)g, this);
        }
        if (this.isGeometryCollection() || g.isGeometryCollection()) {
            for (int i = 0; i < this.getNumGeometries(); ++i) {
                for (int j = 0; j < g.getNumGeometries(); ++j) {
                    if (!this.getGeometryN(i).intersects(g.getGeometryN(j))) continue;
                    return true;
                }
            }
            return false;
        }
        return this.relate(g).isIntersects();
    }

    public boolean crosses(Geometry g) {
        if (!this.getEnvelopeInternal().intersects(g.getEnvelopeInternal())) {
            return false;
        }
        return this.relate(g).isCrosses(this.getDimension(), g.getDimension());
    }

    public boolean within(Geometry g) {
        return g.contains(this);
    }

    public boolean contains(Geometry g) {
        if (g.getDimension() == 2 && this.getDimension() < 2) {
            return false;
        }
        if (g.getDimension() == 1 && this.getDimension() < 1 && g.getLength() > 0.0) {
            return false;
        }
        if (!this.getEnvelopeInternal().contains(g.getEnvelopeInternal())) {
            return false;
        }
        if (this.isRectangle()) {
            return RectangleContains$.MODULE$.contains((Polygon)this, g);
        }
        return this.relate(g).isContains();
    }

    public boolean overlaps(Geometry g) {
        if (!this.getEnvelopeInternal().intersects(g.getEnvelopeInternal())) {
            return false;
        }
        return this.relate(g).isOverlaps(this.getDimension(), g.getDimension());
    }

    public boolean covers(Geometry g) {
        if (g.getDimension() == 2 && this.getDimension() < 2) {
            return false;
        }
        if (g.getDimension() == 1 && this.getDimension() < 1 && g.getLength() > 0.0) {
            return false;
        }
        if (!this.getEnvelopeInternal().covers(g.getEnvelopeInternal())) {
            return false;
        }
        if (this.isRectangle()) {
            return true;
        }
        return this.relate(g).isCovers();
    }

    public boolean coveredBy(Geometry g) {
        return g.covers(this);
    }

    public boolean relate(Geometry g, String intersectionPattern) {
        return this.relate(g).matches(intersectionPattern);
    }

    public IntersectionMatrix relate(Geometry g) {
        Geometry$.MODULE$.checkNotGeometryCollection(this);
        Geometry$.MODULE$.checkNotGeometryCollection(g);
        return RelateOp$.MODULE$.relate(this, g);
    }

    public boolean equals(Geometry g) {
        if (g == null) {
            return false;
        }
        return this.equalsTopo(g);
    }

    public boolean equalsTopo(Geometry g) {
        Envelope envelope = this.getEnvelopeInternal();
        Envelope envelope2 = g.getEnvelopeInternal();
        if (envelope == null ? envelope2 != null : !((Object)envelope).equals(envelope2)) {
            return false;
        }
        return this.relate(g).isEquals(this.getDimension(), g.getDimension());
    }

    public boolean equals(Object o) {
        if (!(o instanceof Geometry)) {
            return false;
        }
        Geometry g = (Geometry)o;
        return this.equalsExact(g);
    }

    public int hashCode() {
        return this.getEnvelopeInternal().hashCode();
    }

    public String toString() {
        return "toText";
    }

    public Geometry buffer(double distance) {
        return BufferOp$.MODULE$.bufferOp(this, distance);
    }

    public Geometry buffer(double distance, int quadrantSegments) {
        return BufferOp$.MODULE$.bufferOp(this, distance, quadrantSegments);
    }

    public Geometry buffer(double distance, int quadrantSegments, int endCapStyle) {
        return BufferOp$.MODULE$.bufferOp(this, distance, quadrantSegments, endCapStyle);
    }

    public Geometry convexHull() {
        return new ConvexHull(this).getConvexHull();
    }

    /*
     * WARNING - void declaration
     */
    public Geometry reverse() {
        void var1_1;
        Geometry res = this.reverseInternal();
        if (this.envelope() != null) {
            res.envelope_$eq(this.envelope().copy());
        }
        res.setSRID(this.getSRID());
        return var1_1;
    }

    public abstract Geometry reverseInternal();

    public Geometry intersection(Geometry other) {
        if (this.isEmpty() || other.isEmpty()) {
            return OverlayOp$.MODULE$.createEmptyResult(OverlayOp$.MODULE$.INTERSECTION(), this, other, this.factory());
        }
        if (this.isGeometryCollection()) {
            Geometry g2 = other;
            return GeometryCollectionMapper$.MODULE$.map((GeometryCollection)this, new GeometryMapper.MapOp(null, g2){
                private final Geometry g2$1;

                public Geometry map(Geometry g) {
                    return g.intersection(this.g2$1);
                }
                {
                    this.g2$1 = g2$1;
                }
            });
        }
        return SnapIfNeededOverlayOp$.MODULE$.overlayOp(this, other, OverlayOp$.MODULE$.INTERSECTION());
    }

    public Geometry union(Geometry other) {
        if (this.isEmpty() || other.isEmpty()) {
            if (this.isEmpty() && other.isEmpty()) {
                return OverlayOp$.MODULE$.createEmptyResult(OverlayOp$.MODULE$.UNION(), this, other, this.factory());
            }
            if (this.isEmpty()) {
                return other.copy();
            }
            if (other.isEmpty()) {
                return this.copy();
            }
        }
        Geometry$.MODULE$.checkNotGeometryCollection(this);
        Geometry$.MODULE$.checkNotGeometryCollection(other);
        return SnapIfNeededOverlayOp$.MODULE$.overlayOp(this, other, OverlayOp$.MODULE$.UNION());
    }

    public Geometry difference(Geometry other) {
        if (this.isEmpty()) {
            return OverlayOp$.MODULE$.createEmptyResult(OverlayOp$.MODULE$.DIFFERENCE(), this, other, this.factory());
        }
        if (other.isEmpty()) {
            return this.copy();
        }
        Geometry$.MODULE$.checkNotGeometryCollection(this);
        Geometry$.MODULE$.checkNotGeometryCollection(other);
        return SnapIfNeededOverlayOp$.MODULE$.overlayOp(this, other, OverlayOp$.MODULE$.DIFFERENCE());
    }

    public Geometry symDifference(Geometry other) {
        if (this.isEmpty() || other.isEmpty()) {
            if (this.isEmpty() && other.isEmpty()) {
                return OverlayOp$.MODULE$.createEmptyResult(OverlayOp$.MODULE$.SYMDIFFERENCE(), this, other, this.factory());
            }
            if (this.isEmpty()) {
                return other.copy();
            }
            if (other.isEmpty()) {
                return this.copy();
            }
        }
        Geometry$.MODULE$.checkNotGeometryCollection(this);
        Geometry$.MODULE$.checkNotGeometryCollection(other);
        return SnapIfNeededOverlayOp$.MODULE$.overlayOp(this, other, OverlayOp$.MODULE$.SYMDIFFERENCE());
    }

    public Geometry union() {
        return UnaryUnionOp$.MODULE$.union(this);
    }

    public abstract boolean equalsExact(Geometry var1, double var2);

    public boolean equalsExact(Geometry other) {
        return this == other || this.equalsExact(other, 0.0);
    }

    public boolean equalsNorm(Geometry g) {
        if (g == null) {
            return false;
        }
        return this.norm().equalsExact(g.norm());
    }

    public abstract void applyF(CoordinateFilter var1);

    public abstract void applyF(CoordinateSequenceFilter var1);

    public abstract void applyF(GeometryFilter var1);

    public abstract void applyF(GeometryComponentFilter var1);

    /*
     * WARNING - void declaration
     */
    public Object clone() {
        Object v0;
        try {
            void var1_1;
            Geometry clone = (Geometry)super.clone();
            if (clone.envelope() != null) {
                clone.envelope_$eq(new Envelope(clone.envelope()));
            }
            v0 = var1_1;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Assert$.MODULE$.shouldNeverReachHere();
            v0 = null;
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    public Geometry copy() {
        void var1_1;
        Geometry copy = this.copyInternal();
        copy.envelope_$eq(this.envelope() == null ? null : this.envelope().copy());
        copy.SRID_$eq(this.SRID());
        copy.userData_$eq(this.userData());
        return var1_1;
    }

    public abstract Geometry copyInternal();

    public abstract void normalize();

    /*
     * WARNING - void declaration
     */
    public Geometry norm() {
        void var1_1;
        Geometry cop = this.copy();
        cop.normalize();
        return var1_1;
    }

    @Override
    public int compareTo(Geometry other) {
        if (this.getSortIndex() != other.getSortIndex()) {
            return this.getSortIndex() - other.getSortIndex();
        }
        if (this.isEmpty() && other.isEmpty()) {
            return 0;
        }
        if (this.isEmpty()) {
            return -1;
        }
        if (other.isEmpty()) {
            return 1;
        }
        return this.compareToSameClass(other);
    }

    public int compareTo(Geometry other, CoordinateSequenceComparator comp) {
        if (this.getSortIndex() != other.getSortIndex()) {
            return this.getSortIndex() - other.getSortIndex();
        }
        if (this.isEmpty() && other.isEmpty()) {
            return 0;
        }
        if (this.isEmpty()) {
            return -1;
        }
        if (other.isEmpty()) {
            return 1;
        }
        return this.compareToSameClass(other, comp);
    }

    public boolean isEquivalentClass(Geometry other) {
        String string = this.getClass().getName();
        String string2 = other.getClass().getName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public boolean isGeometryCollection() {
        return this.getSortIndex() == Geometry$.MODULE$.SORTINDEX_GEOMETRYCOLLECTION();
    }

    public abstract Envelope computeEnvelopeInternal();

    public abstract int compareToSameClass(Geometry var1);

    public abstract int compareToSameClass(Geometry var1, CoordinateSequenceComparator var2);

    public <A> int compare(Collection<A> a, Collection<A> b, Comparator<A> comparator) {
        Iterator<A> i = a.iterator();
        Iterator<A> j = b.iterator();
        while (i.hasNext() && j.hasNext()) {
            A bElement;
            A aElement = i.next();
            int comparison = comparator.compare(aElement, bElement = j.next());
            if (comparison == 0) continue;
            return comparison;
        }
        if (i.hasNext()) {
            return 1;
        }
        if (j.hasNext()) {
            return -1;
        }
        return 0;
    }

    public boolean equal(Coordinate a, Coordinate b, double tolerance) {
        if (tolerance == 0.0) {
            Coordinate coordinate = a;
            Coordinate coordinate2 = b;
            return !(coordinate != null ? !((Object)coordinate).equals(coordinate2) : coordinate2 != null);
        }
        return a.distance(b) <= tolerance;
    }

    public abstract int getSortIndex();

    private Point createPointFromInternalCoord(Coordinate coord, Geometry exemplar) {
        exemplar.getPrecisionModel().makePrecise(coord);
        return exemplar.getFactory().createPoint(coord);
    }

    public Geometry(GeometryFactory factory) {
        this.factory = factory;
        this.envelope = null;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.SRID = factory.getSRID();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.userData = null;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
    }
}

