/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeSet;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.CoordinateSequenceComparator;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Dimension$;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Geometry$;
import org.locationtech.jts.geom.GeometryComponentFilter;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.GeometryFilter;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.util.Assert$;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005}d\u0001\u0002\u0012$\u00011B\u0001\"\r\u0001\u0003\u0002\u0004%\tA\r\u0005\ts\u0001\u0011\t\u0019!C\u0001u!A\u0001\t\u0001B\u0001B\u0003&1\u0007\u0003\u0005B\u0001\t\u0015\r\u0011\"\u0011C\u0011%1\u0005A!A!\u0002\u0013\u0019u\tC\u0003I\u0001\u0011\u0005\u0011\nC\u0003I\u0001\u0011\u0005Q\nC\u0003Z\u0001\u0011\u0005#\fC\u0003_\u0001\u0011\u0005s\fC\u0003b\u0001\u0011\u0005#\rC\u0003g\u0001\u0011\u0005s\rC\u0003i\u0001\u0011\u0005s\rC\u0003j\u0001\u0011\u0005s\rC\u0003k\u0001\u0011\u00053\u000eC\u0003o\u0001\u0011\u0005s\rC\u0003p\u0001\u0011\u0005\u0003\u000fC\u0003z\u0001\u0011\u0005#\u0010C\u0003|\u0001\u0011\u0005C\u0010\u0003\u0004\u0002\u0002\u0001!\t\u0005 \u0005\b\u0003\u0007\u0001A\u0011IA\u0003\u0011\u001d\ty\u0001\u0001C\u0001\u0003#Aq!a\u0004\u0001\t\u0003\ti\u0002C\u0004\u0002\u0010\u0001!\t!a\n\t\u000f\u0005=\u0001\u0001\"\u0001\u00022!9\u00111\b\u0001\u0005B\u0005u\u0002bBA#\u0001\u0011E\u0013q\t\u0005\b\u0003\u0013\u0002A\u0011IA&\u0011\u001d\ti\u0005\u0001C)\u0003\u001fBq!a\u0016\u0001\t#\tI\u0006C\u0004\u0002X\u0001!\t!a\u0018\t\r\u00055\u0004\u0001\"\u0015h\u0011\u0019\ty\u0007\u0001C!u\"1\u0011\u0011\u000f\u0001\u0005Ri\u0014!cR3p[\u0016$(/_\"pY2,7\r^5p]*\u0011A%J\u0001\u0005O\u0016|WN\u0003\u0002'O\u0005\u0019!\u000e^:\u000b\u0005!J\u0013\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"\u0001\u0016\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001i\u0003C\u0001\u00180\u001b\u0005\u0019\u0013B\u0001\u0019$\u0005!9Um\\7fiJL\u0018AC4f_6,GO]5fgV\t1\u0007E\u00025o5j\u0011!\u000e\u0006\u0002m\u0005)1oY1mC&\u0011\u0001(\u000e\u0002\u0006\u0003J\u0014\u0018-_\u0001\u000fO\u0016|W.\u001a;sS\u0016\u001cx\fJ3r)\tYd\b\u0005\u00025y%\u0011Q(\u000e\u0002\u0005+:LG\u000fC\u0004@\u0005\u0005\u0005\t\u0019A\u001a\u0002\u0007a$\u0013'A\u0006hK>lW\r\u001e:jKN\u0004\u0013a\u00024bGR|'/_\u000b\u0002\u0007B\u0011a\u0006R\u0005\u0003\u000b\u000e\u0012qbR3p[\u0016$(/\u001f$bGR|'/_\u0001\tM\u0006\u001cGo\u001c:zA%\u0011\u0011iL\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007)[E\n\u0005\u0002/\u0001!)\u0011G\u0002a\u0001g!)\u0011I\u0002a\u0001\u0007R!!JT(U\u0011\u0015\tt\u00011\u00014\u0011\u0015\u0001v\u00011\u0001R\u00039\u0001(/Z2jg&|g.T8eK2\u0004\"A\f*\n\u0005M\u001b#A\u0004)sK\u000eL7/[8o\u001b>$W\r\u001c\u0005\u0006+\u001e\u0001\rAV\u0001\u0005'JKE\t\u0005\u00025/&\u0011\u0001,\u000e\u0002\u0004\u0013:$\u0018!D4fi\u000e{wN\u001d3j]\u0006$X-F\u0001\\!\tqC,\u0003\u0002^G\tQ1i\\8sI&t\u0017\r^3\u0002\u001d\u001d,GoQ8pe\u0012Lg.\u0019;fgV\t\u0001\rE\u00025om\u000bq![:F[B$\u00180F\u0001d!\t!D-\u0003\u0002fk\t9!i\\8mK\u0006t\u0017\u0001D4fi\u0012KW.\u001a8tS>tW#\u0001,\u0002)\u001d,GOQ8v]\u0012\f'/\u001f#j[\u0016t7/[8o\u0003A9W\r\u001e(v[\u001e+w.\\3ue&,7/\u0001\u0007hKR<Um\\7fiJLh\n\u0006\u0002.Y\")QN\u0004a\u0001-\u0006\ta.\u0001\u0007hKRtU/\u001c)pS:$8/A\bhKR<Um\\7fiJLH+\u001f9f+\u0005\t\bC\u0001:x\u001b\u0005\u0019(B\u0001;v\u0003\u0011a\u0017M\\4\u000b\u0003Y\fAA[1wC&\u0011\u0001p\u001d\u0002\u0007'R\u0014\u0018N\\4\u0002\u0017\u001d,GOQ8v]\u0012\f'/_\u000b\u0002[\u00059q-\u001a;Be\u0016\fW#A?\u0011\u0005Qr\u0018BA@6\u0005\u0019!u.\u001e2mK\u0006Iq-\u001a;MK:<G\u000f[\u0001\fKF,\u0018\r\\:Fq\u0006\u001cG\u000fF\u0003d\u0003\u000f\tY\u0001\u0003\u0004\u0002\nQ\u0001\r!L\u0001\u0006_RDWM\u001d\u0005\u0007\u0003\u001b!\u0002\u0019A?\u0002\u0013Q|G.\u001a:b]\u000e,\u0017AB1qa2Lh\tF\u0002<\u0003'Aq!!\u0006\u0016\u0001\u0004\t9\"\u0001\u0004gS2$XM\u001d\t\u0004]\u0005e\u0011bAA\u000eG\t\u00012i\\8sI&t\u0017\r^3GS2$XM\u001d\u000b\u0004w\u0005}\u0001bBA\u000b-\u0001\u0007\u0011\u0011\u0005\t\u0004]\u0005\r\u0012bAA\u0013G\tA2i\\8sI&t\u0017\r^3TKF,XM\\2f\r&dG/\u001a:\u0015\u0007m\nI\u0003C\u0004\u0002\u0016]\u0001\r!a\u000b\u0011\u00079\ni#C\u0002\u00020\r\u0012abR3p[\u0016$(/\u001f$jYR,'\u000fF\u0002<\u0003gAq!!\u0006\u0019\u0001\u0004\t)\u0004E\u0002/\u0003oI1!!\u000f$\u0005]9Um\\7fiJL8i\\7q_:,g\u000e\u001e$jYR,'/A\u0003dY>tW\r\u0006\u0002\u0002@A\u0019A'!\u0011\n\u0007\u0005\rSG\u0001\u0004B]f\u0014VMZ\u0001\rG>\u0004\u00180\u00138uKJt\u0017\r\\\u000b\u0002\u0015\u0006Ian\u001c:nC2L'0\u001a\u000b\u0002w\u000592m\\7qkR,WI\u001c<fY>\u0004X-\u00138uKJt\u0017\r\\\u000b\u0003\u0003#\u00022ALA*\u0013\r\t)f\t\u0002\t\u000b:4X\r\\8qK\u0006\u00112m\\7qCJ,Gk\\*b[\u0016\u001cE.Y:t)\r1\u00161\f\u0005\u0007\u0003;j\u0002\u0019A\u0017\u0002\u0003=$RAVA1\u0003GBa!!\u0018\u001f\u0001\u0004i\u0003bBA3=\u0001\u0007\u0011qM\u0001\u0005G>l\u0007\u000fE\u0002/\u0003SJ1!a\u001b$\u0005q\u0019un\u001c:eS:\fG/Z*fcV,gnY3D_6\u0004\u0018M]1u_J\fAbZ3u'>\u0014H/\u00138eKb\fqA]3wKJ\u001cX-A\bsKZ,'o]3J]R,'O\\1mQ\u001d\u0001\u0011QOA>\u0003{\u00022\u0001NA<\u0013\r\tI(\u000e\u0002\u0011'\u0016\u0014\u0018.\u00197WKJ\u001c\u0018n\u001c8V\u0013\u0012\u000bQA^1mk\u0016t\u0002\u0002-}D\u001d\u001eA{%\u001a")
public class GeometryCollection
extends Geometry {
    private static final long serialVersionUID = -5694727726395021467L;
    private Geometry[] geometries;

    public Geometry[] geometries() {
        return this.geometries;
    }

    public void geometries_$eq(Geometry[] x$1) {
        this.geometries = x$1;
    }

    @Override
    public GeometryFactory factory() {
        return super.factory();
    }

    @Override
    public Coordinate getCoordinate() {
        if (this.isEmpty()) {
            return null;
        }
        return this.geometries()[0].getCoordinate();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Coordinate[] getCoordinates() {
        void var1_1;
        Coordinate[] coordinates = new Coordinate[this.getNumPoints()];
        int k = -1;
        for (int i = 0; i < this.geometries().length; ++i) {
            Coordinate[] childCoordinates = this.geometries()[i].getCoordinates();
            for (int j = 0; j < childCoordinates.length; ++j) {
                coordinates[++k] = childCoordinates[j];
            }
        }
        return var1_1;
    }

    @Override
    public boolean isEmpty() {
        for (int i = 0; i < this.geometries().length; ++i) {
            if (this.geometries()[i].isEmpty()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getDimension() {
        void var1_1;
        int dimension = Dimension$.MODULE$.FALSE();
        for (int i = 0; i < this.geometries().length; ++i) {
            dimension = Math.max(dimension, this.geometries()[i].getDimension());
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getBoundaryDimension() {
        void var1_1;
        int dimension = Dimension$.MODULE$.FALSE();
        int i = 0;
        while (i < this.geometries().length) {
            dimension = Math.max(dimension, this.geometries()[i].getBoundaryDimension());
            int cfr_ignored_0 = ++i - 1;
        }
        return (int)var1_1;
    }

    @Override
    public int getNumGeometries() {
        return this.geometries().length;
    }

    @Override
    public Geometry getGeometryN(int n) {
        return this.geometries()[n];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getNumPoints() {
        void var1_1;
        int numPoints = 0;
        for (int i = 0; i < this.geometries().length; ++i) {
            numPoints += this.geometries()[i].getNumPoints();
        }
        return (int)var1_1;
    }

    @Override
    public String getGeometryType() {
        return "GeometryCollection";
    }

    @Override
    public Geometry getBoundary() {
        Geometry$.MODULE$.checkNotGeometryCollection(this);
        Assert$.MODULE$.shouldNeverReachHere();
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double getArea() {
        void var1_1;
        double area = 0.0;
        for (int i = 0; i < this.geometries().length; ++i) {
            area += this.geometries()[i].getArea();
        }
        return (double)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double getLength() {
        void var1_1;
        double sum = 0.0;
        for (int i = 0; i < this.geometries().length; ++i) {
            sum += this.geometries()[i].getLength();
        }
        return (double)var1_1;
    }

    @Override
    public boolean equalsExact(Geometry other, double tolerance) {
        if (!this.isEquivalentClass(other)) {
            return false;
        }
        GeometryCollection otherCollection = (GeometryCollection)other;
        if (this.geometries().length != otherCollection.geometries().length) {
            return false;
        }
        for (int i = 0; i < this.geometries().length; ++i) {
            if (this.geometries()[i].equalsExact(otherCollection.geometries()[i], tolerance)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void applyF(CoordinateFilter filter) {
        for (int i = 0; i < this.geometries().length; ++i) {
            this.geometries()[i].applyF(filter);
        }
    }

    @Override
    public void applyF(CoordinateSequenceFilter filter) {
        block3: {
            if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])this.geometries()))) {
                return;
            }
            int i = 0;
            while (i < this.geometries().length) {
                this.geometries()[i].applyF(filter);
                if (filter.isDone()) {
                    i = this.geometries().length;
                    continue;
                }
                ++i;
            }
            if (!filter.isGeometryChanged()) break block3;
            this.geometryChanged();
        }
    }

    @Override
    public void applyF(GeometryFilter filter) {
        filter.filter(this);
        for (int i = 0; i < this.geometries().length; ++i) {
            this.geometries()[i].applyF(filter);
        }
    }

    @Override
    public void applyF(GeometryComponentFilter filter) {
        filter.filter(this);
        for (int i = 0; i < this.geometries().length; ++i) {
            this.geometries()[i].applyF(filter);
        }
    }

    @Override
    public Object clone() {
        return this.copy();
    }

    @Override
    public GeometryCollection copyInternal() {
        Geometry[] geometries = new Geometry[this.geometries().length];
        for (int i = 0; i < geometries.length; ++i) {
            geometries[i] = this.geometries()[i].copy();
        }
        return new GeometryCollection(geometries, this.factory());
    }

    @Override
    public void normalize() {
        for (int i = 0; i < this.geometries().length; ++i) {
            this.geometries()[i].normalize();
        }
        Arrays.sort((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.geometries()), (Function1 & Serializable)x -> x, ClassTag$.MODULE$.AnyRef()));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Envelope computeEnvelopeInternal() {
        void var1_1;
        Envelope envelope = new Envelope();
        for (int i = 0; i < this.geometries().length; ++i) {
            envelope.expandToInclude(this.geometries()[i].getEnvelopeInternal());
        }
        return var1_1;
    }

    @Override
    public int compareToSameClass(Geometry o) {
        TreeSet<Object> theseElements = new TreeSet<Object>(Arrays.asList((Object[])new Geometry[][]{this.geometries()}));
        TreeSet<Object> otherElements = new TreeSet<Object>(Arrays.asList((Object[])new Geometry[][]{((GeometryCollection)o).geometries()}));
        return this.compare(theseElements, otherElements, null);
    }

    @Override
    public int compareToSameClass(Geometry o, CoordinateSequenceComparator comp) {
        int i;
        GeometryCollection gc = (GeometryCollection)o;
        int n1 = this.getNumGeometries();
        int n2 = gc.getNumGeometries();
        for (i = 0; i < n1 && i < n2; ++i) {
            Geometry otherGeom;
            Geometry thisGeom = this.getGeometryN(i);
            int holeComp = thisGeom.compareToSameClass(otherGeom = gc.getGeometryN(i), comp);
            if (holeComp == 0) continue;
            return holeComp;
        }
        if (i < n1) {
            return 1;
        }
        if (i < n2) {
            return -1;
        }
        return 0;
    }

    @Override
    public int getSortIndex() {
        return Geometry$.MODULE$.SORTINDEX_GEOMETRYCOLLECTION();
    }

    @Override
    public Geometry reverse() {
        return super.reverse();
    }

    @Override
    public Geometry reverseInternal() {
        int numGeometries = this.geometries().length;
        ArrayList<Geometry> reversed = new ArrayList<Geometry>(numGeometries);
        for (int i = 0; i < numGeometries; ++i) {
            reversed.add(this.geometries()[i].reverse());
        }
        return this.getFactory().buildGeometry(reversed);
    }

    public GeometryCollection(Geometry[] geometries, GeometryFactory factory) {
        this.geometries = geometries;
        super(factory);
        if (this.geometries() == null) {
            this.geometries_$eq((Geometry[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Geometry.class)));
        }
        if (Geometry$.MODULE$.hasNullElements((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.geometries()), (Function1 & Serializable)x -> x, ClassTag$.MODULE$.AnyRef()))) {
            throw new IllegalArgumentException("geometries must not contain null elements");
        }
    }

    public GeometryCollection(Geometry[] geometries, PrecisionModel precisionModel, int SRID) {
        this(geometries, new GeometryFactory(precisionModel, SRID));
    }
}

