/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import java.io.Serializable;
import org.locationtech.jts.algorithm.Distance$;
import org.locationtech.jts.algorithm.Intersection$;
import org.locationtech.jts.algorithm.Orientation$;
import org.locationtech.jts.algorithm.RobustLineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineSegment$;
import org.locationtech.jts.geom.LineString;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\t]q!\u0002\u001b6\u0011\u0003qd!\u0002!6\u0011\u0003\t\u0005\"\u0002)\u0002\t\u0003\t\u0006\"\u0002*\u0002\t\u0003\u0019\u0006bB.\u0002\u0003\u0003%I\u0001\u0018\u0004\u0005\u0001V\u0002!\u000e\u0003\u0005Y\u000b\t\u0005\r\u0011\"\u0001p\u0011!\u0001XA!a\u0001\n\u0003\t\b\u0002C<\u0006\u0005\u0003\u0005\u000b\u0015\u0002+\t\u0011i+!\u00111A\u0005\u0002=D\u0001\u0002_\u0003\u0003\u0002\u0004%\t!\u001f\u0005\tw\u0016\u0011\t\u0011)Q\u0005)\")\u0001+\u0002C\u0001y\")\u0001+\u0002C\u0001\u007f\"1\u0001+\u0002C\u0001\u0003/Aa\u0001U\u0003\u0005\u0002\u0005u\u0001bBA\u0010\u000b\u0011\u0005\u0011\u0011\u0005\u0005\b\u0003[)A\u0011AA\u0018\u0011\u001d\ti#\u0002C\u0001\u0003gAq!!\u000f\u0006\t\u0003\tY\u0004C\u0004\u0002>\u0015!\t!a\u000f\t\u000f\u0005}R\u0001\"\u0001\u0002<!9\u0011\u0011I\u0003\u0005\u0002\u0005m\u0002bBA\"\u000b\u0011\u0005\u00111\b\u0005\b\u0003\u000b*A\u0011AA$\u0011\u001d\ty%\u0002C\u0001\u0003\u000fBq!!\u0015\u0006\t\u0003\t\u0019\u0006C\u0004\u0002R\u0015!\t!!\u0017\t\u000f\u0005}S\u0001\"\u0001\u0002b!9\u00111M\u0003\u0005\u0002\u0005\u0005\u0004bBA3\u000b\u0011\u0005\u00111\b\u0005\u0006%\u0016!\ta\u001c\u0005\b\u0003O*A\u0011AA5\u0011\u001d\t9'\u0002C\u0001\u0003[Bq!!\u001d\u0006\t\u0003\t\u0019\bC\u0004\u0002x\u0015!\t!!\u001f\t\u000f\u0005}T\u0001\"\u0001\u0002\u0002\"9\u0011\u0011R\u0003\u0005\u0002\u0005-\u0005bBAH\u000b\u0011\u0005\u0011\u0011\u0013\u0005\b\u0003/+A\u0011AAM\u0011\u001d\t9*\u0002C\u0001\u0003;Cq!!)\u0006\t\u0003\t\u0019\u000bC\u0004\u0002(\u0016!\t!!+\t\u000f\u00055V\u0001\"\u0001\u00020\"9\u00111X\u0003\u0005\u0002\u0005u\u0006bBAa\u000b\u0011\u0005\u00111\u0019\u0005\b\u0003\u000f,A\u0011AAe\u0011\u001d\tY.\u0002C!\u0003;Dq!!;\u0006\t\u0003\nY\u000fC\u0004\u0002n\u0016!\t%a<\t\u000f\u0005UX\u0001\"\u0001\u0002x\"9\u00111`\u0003\u0005B\u0005u\u0018a\u0003'j]\u0016\u001cVmZ7f]RT!AN\u001c\u0002\t\u001d,w.\u001c\u0006\u0003qe\n1A\u001b;t\u0015\tQ4(\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001=\u0003\ry'oZ\u0002\u0001!\ty\u0014!D\u00016\u0005-a\u0015N\\3TK\u001elWM\u001c;\u0014\u0007\u0005\u0011\u0005\n\u0005\u0002D\r6\tAIC\u0001F\u0003\u0015\u00198-\u00197b\u0013\t9EI\u0001\u0004B]f\u0014VM\u001a\t\u0003\u0013:k\u0011A\u0013\u0006\u0003\u00172\u000b!![8\u000b\u00035\u000bAA[1wC&\u0011qJ\u0013\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003y\n\u0001\"\\5e!>Lg\u000e\u001e\u000b\u0004)^K\u0006CA V\u0013\t1VG\u0001\u0006D_>\u0014H-\u001b8bi\u0016DQ\u0001W\u0002A\u0002Q\u000b!\u0001\u001d\u0019\t\u000bi\u001b\u0001\u0019\u0001+\u0002\u0005A\f\u0014\u0001D<sSR,'+\u001a9mC\u000e,G#A/\u0011\u0005y\u000bW\"A0\u000b\u0005\u0001d\u0015\u0001\u00027b]\u001eL!AY0\u0003\r=\u0013'.Z2uQ\u0011\tAm\u001a5\u0011\u0005\r+\u0017B\u00014E\u0005A\u0019VM]5bYZ+'o]5p]VKE)A\u0003wC2,XM\b\u0005.CI\u001cr,Q\u000edQ\u0011\u0001Am\u001a5\u0014\t\u0015\u00115\u000e\u0013\t\u0004=2t\u0017BA7`\u0005)\u0019u.\u001c9be\u0006\u0014G.\u001a\t\u0003\u007f\u0015)\u0012\u0001V\u0001\u0007aBzF%Z9\u0015\u0005I,\bCA\"t\u0013\t!HI\u0001\u0003V]&$\bb\u0002<\b\u0003\u0003\u0005\r\u0001V\u0001\u0004q\u0012\n\u0014a\u000191A\u00051\u0001/M0%KF$\"A\u001d>\t\u000fYT\u0011\u0011!a\u0001)\u0006\u0019\u0001/\r\u0011\u0015\u00079lh\u0010C\u0003Y\u0019\u0001\u0007A\u000bC\u0003[\u0019\u0001\u0007A\u000bF\u0005o\u0003\u0003\tY!a\u0004\u0002\u0014!9\u00111A\u0007A\u0002\u0005\u0015\u0011A\u0001=1!\r\u0019\u0015qA\u0005\u0004\u0003\u0013!%A\u0002#pk\ndW\rC\u0004\u0002\u000e5\u0001\r!!\u0002\u0002\u0005e\u0004\u0004bBA\t\u001b\u0001\u0007\u0011QA\u0001\u0003qFBq!!\u0006\u000e\u0001\u0004\t)!\u0001\u0002zcQ\u0019a.!\u0007\t\r\u0005ma\u00021\u0001o\u0003\ta7\u000fF\u0001o\u000359W\r^\"p_J$\u0017N\\1uKR\u0019A+a\t\t\u000f\u0005\u0015\u0002\u00031\u0001\u0002(\u0005\t\u0011\u000eE\u0002D\u0003SI1!a\u000bE\u0005\rIe\u000e^\u0001\u000fg\u0016$8i\\8sI&t\u0017\r^3t)\r\u0011\u0018\u0011\u0007\u0005\u0007\u00037\t\u0002\u0019\u00018\u0015\u000bI\f)$a\u000e\t\u000ba\u0013\u0002\u0019\u0001+\t\u000bi\u0013\u0002\u0019\u0001+\u0002\t5Lg\u000eW\u000b\u0003\u0003\u000b\tA!\\1y1\u0006!Q.\u001b8Z\u0003\u0011i\u0017\r_-\u0002\u0013\u001d,G\u000fT3oORD\u0017\u0001D5t\u0011>\u0014\u0018N_8oi\u0006dWCAA%!\r\u0019\u00151J\u0005\u0004\u0003\u001b\"%a\u0002\"p_2,\u0017M\\\u0001\u000bSN4VM\u001d;jG\u0006d\u0017\u0001E8sS\u0016tG/\u0019;j_:Le\u000eZ3y)\u0011\t9#!\u0016\t\r\u0005]#\u00041\u0001o\u0003\r\u0019Xm\u001a\u000b\u0005\u0003O\tY\u0006\u0003\u0004\u0002^m\u0001\r\u0001V\u0001\u0002a\u00069!/\u001a<feN,G#\u0001:\u0002\u00139|'/\\1mSj,\u0017!B1oO2,\u0017\u0001\u00033jgR\fgnY3\u0015\t\u0005\u0015\u00111\u000e\u0005\u0007\u00037\u0001\u0003\u0019\u00018\u0015\t\u0005\u0015\u0011q\u000e\u0005\u0007\u0003;\n\u0003\u0019\u0001+\u0002+\u0011L7\u000f^1oG\u0016\u0004VM\u001d9f]\u0012L7-\u001e7beR!\u0011QAA;\u0011\u0019\tiF\ta\u0001)\u0006Q\u0001o\\5oi\u0006cwN\\4\u0015\u0007Q\u000bY\bC\u0004\u0002~\r\u0002\r!!\u0002\u0002+M,w-\\3oi2+gn\u001a;i\rJ\f7\r^5p]\u0006\u0001\u0002o\\5oi\u0006cwN\\4PM\u001a\u001cX\r\u001e\u000b\u0006)\u0006\r\u0015Q\u0011\u0005\b\u0003{\"\u0003\u0019AA\u0003\u0011\u001d\t9\t\na\u0001\u0003\u000b\tab\u001c4gg\u0016$H)[:uC:\u001cW-\u0001\tqe>TWm\u0019;j_:4\u0015m\u0019;peR!\u0011QAAG\u0011\u0019\ti&\na\u0001)\u0006y1/Z4nK:$hI]1di&|g\u000e\u0006\u0003\u0002\u0006\u0005M\u0005BBAKM\u0001\u0007A+A\u0004j]B,H\u000f\u0015;\u0002\u000fA\u0014xN[3diR\u0019A+a'\t\r\u0005us\u00051\u0001U)\rq\u0017q\u0014\u0005\u0007\u0003/B\u0003\u0019\u00018\u0002\u000fI,g\r\\3diR\u0019A+!*\t\r\u0005u\u0013\u00061\u0001U\u00031\u0019Gn\\:fgR\u0004v.\u001b8u)\r!\u00161\u0016\u0005\u0007\u0003;R\u0003\u0019\u0001+\u0002\u001b\rdwn]3tiB{\u0017N\u001c;t)\u0011\t\t,a.\u0011\t\r\u000b\u0019\fV\u0005\u0004\u0003k#%!B!se\u0006L\bBBA]W\u0001\u0007a.\u0001\u0003mS:,\u0017\u0001D5oi\u0016\u00148/Z2uS>tGc\u0001+\u0002@\"1\u0011\u0011\u0018\u0017A\u00029\f\u0001\u0003\\5oK&sG/\u001a:tK\u000e$\u0018n\u001c8\u0015\u0007Q\u000b)\r\u0003\u0004\u0002:6\u0002\rA\\\u0001\u000bi><Um\\7fiJLH\u0003BAf\u0003#\u00042aPAg\u0013\r\ty-\u000e\u0002\u000b\u0019&tWm\u0015;sS:<\u0007bBAj]\u0001\u0007\u0011Q[\u0001\fO\u0016|WNR1di>\u0014\u0018\u0010E\u0002@\u0003/L1!!76\u0005=9Um\\7fiJLh)Y2u_JL\u0018AB3rk\u0006d7\u000f\u0006\u0003\u0002J\u0005}\u0007bBAq_\u0001\u0007\u00111]\u0001\u0002_B\u00191)!:\n\u0007\u0005\u001dHIA\u0002B]f\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003O\t\u0011bY8na\u0006\u0014X\rV8\u0015\t\u0005\u001d\u0012\u0011\u001f\u0005\u0007\u0003g\f\u0004\u0019\u00018\u0002\u000b=$\b.\u001a:\u0002\u0015\u0015\fX/\u00197t)>\u0004x\u000e\u0006\u0003\u0002J\u0005e\bBBAze\u0001\u0007a.\u0001\u0005u_N#(/\u001b8h)\t\ty\u0010\u0005\u0003\u0003\u0002\t=a\u0002\u0002B\u0002\u0005\u0017\u00012A!\u0002E\u001b\t\u00119AC\u0002\u0003\nu\na\u0001\u0010:p_Rt\u0014b\u0001B\u0007\t\u00061\u0001K]3eK\u001aLAA!\u0005\u0003\u0014\t11\u000b\u001e:j]\u001eT1A!\u0004EQ\u0011)Am\u001a5")
public class LineSegment
implements Comparable<LineSegment>,
Serializable {
    private static final long serialVersionUID = 3252005833466256227L;
    private Coordinate p0;
    private Coordinate p1;

    public Coordinate p0() {
        return this.p0;
    }

    public void p0_$eq(Coordinate x$1) {
        this.p0 = x$1;
    }

    public Coordinate p1() {
        return this.p1;
    }

    public void p1_$eq(Coordinate x$1) {
        this.p1 = x$1;
    }

    public Coordinate getCoordinate(int i) {
        if (i == 0) {
            return this.p0();
        }
        return this.p1();
    }

    public void setCoordinates(LineSegment ls) {
        this.setCoordinates(ls.p0(), ls.p1());
    }

    public void setCoordinates(Coordinate p0, Coordinate p1) {
        this.p0().x_$eq(p0.x());
        this.p0().y_$eq(p0.y());
        this.p1().x_$eq(p1.x());
        this.p1().y_$eq(p1.y());
    }

    public double minX() {
        return Math.min(this.p0().x(), this.p1().x());
    }

    public double maxX() {
        return Math.max(this.p0().x(), this.p1().x());
    }

    public double minY() {
        return Math.min(this.p0().y(), this.p1().y());
    }

    public double maxY() {
        return Math.max(this.p0().y(), this.p1().y());
    }

    public double getLength() {
        return this.p0().distance(this.p1());
    }

    public boolean isHorizontal() {
        return this.p0().y() == this.p1().y();
    }

    public boolean isVertical() {
        return this.p0().x() == this.p1().x();
    }

    public int orientationIndex(LineSegment seg) {
        int orient0 = Orientation$.MODULE$.index(this.p0(), this.p1(), seg.p0());
        int orient1 = Orientation$.MODULE$.index(this.p0(), this.p1(), seg.p1());
        if (orient0 >= 0 && orient1 >= 0) {
            return Math.max(orient0, orient1);
        }
        if (orient0 <= 0 && orient1 <= 0) {
            return Math.max(orient0, orient1);
        }
        return 0;
    }

    public int orientationIndex(Coordinate p) {
        return Orientation$.MODULE$.index(this.p0(), this.p1(), p);
    }

    public void reverse() {
        Coordinate temp = this.p0();
        this.p0_$eq(this.p1());
        this.p1_$eq(temp);
    }

    public void normalize() {
        block0: {
            if (this.p1().compareTo(this.p0()) >= 0) break block0;
            this.reverse();
        }
    }

    public double angle() {
        return Math.atan2(this.p1().y() - this.p0().y(), this.p1().x() - this.p0().x());
    }

    public Coordinate midPoint() {
        return LineSegment$.MODULE$.midPoint(this.p0(), this.p1());
    }

    public double distance(LineSegment ls) {
        return Distance$.MODULE$.segmentToSegment(this.p0(), this.p1(), ls.p0(), ls.p1());
    }

    public double distance(Coordinate p) {
        return Distance$.MODULE$.pointToSegment(p, this.p0(), this.p1());
    }

    public double distancePerpendicular(Coordinate p) {
        return Distance$.MODULE$.pointToLinePerpendicular(p, this.p0(), this.p1());
    }

    /*
     * WARNING - void declaration
     */
    public Coordinate pointAlong(double segmentLengthFraction) {
        void var3_2;
        Coordinate coord = new Coordinate();
        coord.x_$eq(this.p0().x() + segmentLengthFraction * (this.p1().x() - this.p0().x()));
        coord.y_$eq(this.p0().y() + segmentLengthFraction * (this.p1().y() - this.p0().y()));
        return var3_2;
    }

    public Coordinate pointAlongOffset(double segmentLengthFraction, double offsetDistance) {
        double segx = this.p0().x() + segmentLengthFraction * (this.p1().x() - this.p0().x());
        double segy = this.p0().y() + segmentLengthFraction * (this.p1().y() - this.p0().y());
        double dx = this.p1().x() - this.p0().x();
        double dy = this.p1().y() - this.p0().y();
        double len = Math.sqrt(dx * dx + dy * dy);
        double ux = 0.0;
        double uy = 0.0;
        if (offsetDistance != 0.0) {
            if (len <= 0.0) {
                throw new IllegalStateException("Cannot compute offset from zero-length line segment");
            }
            ux = offsetDistance * dx / len;
            uy = offsetDistance * dy / len;
        }
        double offsetx = segx - uy;
        double offsety = segy + ux;
        Coordinate coord = new Coordinate(offsetx, offsety);
        return coord;
    }

    public double projectionFactor(Coordinate p) {
        double dy;
        Coordinate coordinate = p;
        Coordinate coordinate2 = this.p0();
        if (!(coordinate != null ? !((Object)coordinate).equals(coordinate2) : coordinate2 != null)) {
            return 0.0;
        }
        Coordinate coordinate3 = p;
        Coordinate coordinate4 = this.p1();
        if (!(coordinate3 != null ? !((Object)coordinate3).equals(coordinate4) : coordinate4 != null)) {
            return 1.0;
        }
        double dx = this.p1().x() - this.p0().x();
        double len = dx * dx + (dy = this.p1().y() - this.p0().y()) * dy;
        if (len <= 0.0) {
            return Double.NaN;
        }
        double r = ((p.x() - this.p0().x()) * dx + (p.y() - this.p0().y()) * dy) / len;
        return r;
    }

    /*
     * WARNING - void declaration
     */
    public double segmentFraction(Coordinate inputPt) {
        void var2_2;
        block1: {
            double segFrac;
            block0: {
                segFrac = this.projectionFactor(inputPt);
                if (!(segFrac < 0.0)) break block0;
                segFrac = 0.0;
                break block1;
            }
            if (!(segFrac > 1.0) && !Double.isNaN(segFrac)) break block1;
            segFrac = 1.0;
        }
        return (double)var2_2;
    }

    public Coordinate project(Coordinate p) {
        block3: {
            block2: {
                Coordinate coordinate = p;
                Coordinate coordinate2 = this.p0();
                if (!(coordinate == null ? coordinate2 != null : !((Object)coordinate).equals(coordinate2))) break block2;
                Coordinate coordinate3 = p;
                Coordinate coordinate4 = this.p1();
                if (coordinate3 != null ? !((Object)coordinate3).equals(coordinate4) : coordinate4 != null) break block3;
            }
            return new Coordinate(p);
        }
        double r = this.projectionFactor(p);
        Coordinate coord = new Coordinate();
        coord.x_$eq(this.p0().x() + r * (this.p1().x() - this.p0().x()));
        coord.y_$eq(this.p0().y() + r * (this.p1().y() - this.p0().y()));
        return coord;
    }

    public LineSegment project(LineSegment seg) {
        double pf0 = this.projectionFactor(seg.p0());
        double pf1 = this.projectionFactor(seg.p1());
        if (pf0 >= 1.0 && pf1 >= 1.0) {
            return null;
        }
        if (pf0 <= 0.0 && pf1 <= 0.0) {
            return null;
        }
        Coordinate newp0 = this.project(seg.p0());
        if (pf0 < 0.0) {
            newp0 = this.p0();
        }
        if (pf0 > 1.0) {
            newp0 = this.p1();
        }
        Coordinate newp1 = this.project(seg.p1());
        if (pf1 < 0.0) {
            newp1 = this.p0();
        }
        if (pf1 > 1.0) {
            newp1 = this.p1();
        }
        return new LineSegment(newp0, newp1);
    }

    public Coordinate reflect(Coordinate p) {
        double A = this.p1().getY() - this.p0().getY();
        double B = this.p0().getX() - this.p1().getX();
        double C = this.p0().getY() * (this.p1().getX() - this.p0().getX()) - this.p0().getX() * (this.p1().getY() - this.p0().getY());
        double A2plusB2 = A * A + B * B;
        double A2subB2 = A * A - B * B;
        double x = p.getX();
        double y = p.getY();
        double rx = (-A2subB2 * x - (double)2 * A * B * y - (double)2 * A * C) / A2plusB2;
        double ry = (A2subB2 * y - (double)2 * A * B * x - (double)2 * B * C) / A2plusB2;
        return new Coordinate(rx, ry);
    }

    public Coordinate closestPoint(Coordinate p) {
        double dist1;
        double factor = this.projectionFactor(p);
        if (factor > 0.0 && factor < 1.0) {
            return this.project(p);
        }
        double dist0 = this.p0().distance(p);
        if (dist0 < (dist1 = this.p1().distance(p))) {
            return this.p0();
        }
        return this.p1();
    }

    /*
     * WARNING - void declaration
     */
    public Coordinate[] closestPoints(LineSegment line) {
        void var3_3;
        block3: {
            Coordinate close11;
            Coordinate close10;
            Coordinate intPt = this.intersection(line);
            if (intPt != null) {
                return (Coordinate[])((Object[])new Coordinate[]{intPt, intPt});
            }
            Coordinate[] closestPt = new Coordinate[2];
            double minDistance = Double.MAX_VALUE;
            double dist = 0.0;
            Coordinate close00 = this.closestPoint(line.p0());
            minDistance = close00.distance(line.p0());
            closestPt[0] = close00;
            closestPt[1] = line.p0();
            Coordinate close01 = this.closestPoint(line.p1());
            dist = close01.distance(line.p1());
            if (dist < minDistance) {
                minDistance = dist;
                closestPt[0] = close01;
                closestPt[1] = line.p1();
            }
            if ((dist = (close10 = line.closestPoint(this.p0())).distance(this.p0())) < minDistance) {
                minDistance = dist;
                closestPt[0] = this.p0();
                closestPt[1] = close10;
            }
            if (!((dist = (close11 = line.closestPoint(this.p1())).distance(this.p1())) < minDistance)) break block3;
            minDistance = dist;
            closestPt[0] = this.p1();
            closestPt[1] = close11;
        }
        return var3_3;
    }

    public Coordinate intersection(LineSegment line) {
        RobustLineIntersector li = new RobustLineIntersector();
        li.computeIntersection(this.p0(), this.p1(), line.p0(), line.p1());
        if (li.hasIntersection()) {
            return li.getIntersection(0);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public Coordinate lineIntersection(LineSegment line) {
        void var2_2;
        Coordinate intPt = Intersection$.MODULE$.intersection(this.p0(), this.p1(), line.p0(), line.p1());
        return var2_2;
    }

    public LineString toGeometry(GeometryFactory geomFactory) {
        return geomFactory.createLineString((Coordinate[])((Object[])new Coordinate[]{this.p0(), this.p1()}));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof LineSegment)) {
            return false;
        }
        LineSegment other = (LineSegment)o;
        Coordinate coordinate = this.p0();
        Coordinate coordinate2 = other.p0();
        if (coordinate == null) {
            if (coordinate2 != null) {
                return false;
            }
        } else if (!((Object)coordinate).equals(coordinate2)) return false;
        Coordinate coordinate3 = this.p1();
        Coordinate coordinate4 = other.p1();
        if (coordinate3 == null) {
            if (coordinate4 == null) return true;
            return false;
        } else {
            if (!((Object)coordinate3).equals(coordinate4)) return false;
            return true;
        }
    }

    public int hashCode() {
        long bits0 = Double.doubleToLongBits(this.p0().x());
        int hash0 = (int)(bits0 ^= Double.doubleToLongBits(this.p0().y()) * 31L) ^ (int)(bits0 >> 32);
        long bits1 = Double.doubleToLongBits(this.p1().x());
        int hash1 = (int)(bits1 ^= Double.doubleToLongBits(this.p1().y()) * 31L) ^ (int)(bits1 >> 32);
        return hash0 ^ hash1;
    }

    @Override
    public int compareTo(LineSegment other) {
        int comp0 = this.p0().compareTo(other.p0());
        if (comp0 != 0) {
            return comp0;
        }
        return this.p1().compareTo(other.p1());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equalsTopo(LineSegment other) {
        Coordinate coordinate = this.p0();
        Coordinate coordinate2 = other.p0();
        if (!(coordinate != null ? !((Object)coordinate).equals(coordinate2) : coordinate2 != null)) {
            Coordinate coordinate3 = this.p1();
            Coordinate coordinate4 = other.p1();
            if (coordinate3 == null) {
                if (coordinate4 == null) return true;
            } else if (((Object)coordinate3).equals(coordinate4)) return true;
        }
        Coordinate coordinate5 = this.p0();
        Coordinate coordinate6 = other.p1();
        if (coordinate5 == null) {
            if (coordinate6 != null) {
                return false;
            }
        } else if (!((Object)coordinate5).equals(coordinate6)) return false;
        Coordinate coordinate7 = this.p1();
        Coordinate coordinate8 = other.p0();
        if (coordinate7 == null) {
            if (coordinate8 == null) return true;
            return false;
        } else {
            if (!((Object)coordinate7).equals(coordinate8)) return false;
            return true;
        }
    }

    public String toString() {
        return new StringBuilder(17).append("LINESTRING( ").append(this.p0().x()).append(" ").append(this.p0().y()).append(", ").append(this.p1().x()).append(" ").append(this.p1().y()).append(")").toString();
    }

    public LineSegment(Coordinate p0, Coordinate p1) {
        this.p0 = p0;
        this.p1 = p1;
    }

    public LineSegment(double x0, double y0, double x1, double y1) {
        this(new Coordinate(x0, y0), new Coordinate(x1, y1));
    }

    public LineSegment(LineSegment ls) {
        this(ls.p0(), ls.p1());
    }

    public LineSegment() {
        this(new Coordinate(), new Coordinate());
    }
}

