/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import org.locationtech.jts.algorithm.Length$;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceComparator;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.CoordinateSequences$;
import org.locationtech.jts.geom.Dimension$;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Geometry$;
import org.locationtech.jts.geom.GeometryComponentFilter;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.GeometryFilter;
import org.locationtech.jts.geom.Lineal;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.operation.BoundaryOp;
import scala.Array$;
import scala.UninitializedFieldError;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005\rg\u0001B\u0015+\u0001MB\u0011b\u000f\u0001\u0003\u0002\u0003\u0006I\u0001P \t\u000b\u0005\u0003A\u0011\u0001\"\t\u000f\u0015\u0003\u0001\u0019!C\t\r\"9!\n\u0001a\u0001\n#Y\u0005B\u0002+\u0001A\u0003&q\tC\u0003B\u0001\u0011\u0005Q\u000bC\u0003B\u0001\u0011\u0005q\rC\u0003k\u0001\u0011%1\u000eC\u0003o\u0001\u0011\u0005s\u000eC\u0003q\u0001\u0011\u0005a\tC\u0003r\u0001\u0011\u0005!\u000fC\u0003v\u0001\u0011\u0005c\u000fC\u0003x\u0001\u0011\u0005\u0003\u0010C\u0003z\u0001\u0011\u0005\u0003\u0010C\u0003{\u0001\u0011\u00053\u0010C\u0003\u0000\u0001\u0011\u0005\u0003\u0010C\u0004\u0002\u0002\u0001!\t!a\u0001\t\u000f\u00055\u0001\u0001\"\u0001\u0002\u0010!9\u0011\u0011\u0003\u0001\u0005\u0002\u0005=\u0001BBA\n\u0001\u0011\u00051\u0010\u0003\u0004\u0002\u0016\u0001!\ta\u001f\u0005\b\u0003/\u0001A\u0011IA\r\u0011\u001d\tY\u0003\u0001C!\u0003[Aq!!\u000e\u0001\t\u0003\n9\u0004C\u0004\u0002:\u0001!\t%a\u000e\t\u000f\u0005m\u0002\u0001\"\u0015\u0002>!9\u0011q\b\u0001\u0005\u0002\u0005\u0005\u0003bBA$\u0001\u0011E\u0013\u0011\n\u0005\b\u0003#\u0002A\u0011IA*\u0011\u001d\ti\u0006\u0001C\u0001\u0003?Bq!!\u0018\u0001\t\u0003\tY\u0007C\u0004\u0002^\u0001!\t!!\u001e\t\u000f\u0005u\u0003\u0001\"\u0001\u0002\u0000!9\u0011\u0011\u0012\u0001\u0005B\u0005-\u0005bBAJ\u0001\u0011E\u0013q\u0007\u0005\b\u0003+\u0003A\u0011IAL\u0011\u001d\tI\n\u0001C)\u00037Cq!a(\u0001\t#\t\t\u000bC\u0004\u0002 \u0002!\t!a*\t\r\u0005U\u0006\u0001\"\u0015y\u0005)a\u0015N\\3TiJLgn\u001a\u0006\u0003W1\nAaZ3p[*\u0011QFL\u0001\u0004UR\u001c(BA\u00181\u00031awnY1uS>tG/Z2i\u0015\u0005\t\u0014aA8sO\u000e\u00011c\u0001\u00015qA\u0011QGN\u0007\u0002U%\u0011qG\u000b\u0002\t\u000f\u0016|W.\u001a;ssB\u0011Q'O\u0005\u0003u)\u0012a\u0001T5oK\u0006d\u0017a\u00014bGB\u0011Q'P\u0005\u0003})\u0012qbR3p[\u0016$(/\u001f$bGR|'/_\u0005\u0003\u0001Z\nqAZ1di>\u0014\u00180\u0001\u0004=S:LGO\u0010\u000b\u0003\u0007\u0012\u0003\"!\u000e\u0001\t\u000bm\u0012\u0001\u0019\u0001\u001f\u0002\rA|\u0017N\u001c;t+\u00059\u0005CA\u001bI\u0013\tI%F\u0001\nD_>\u0014H-\u001b8bi\u0016\u001cV-];f]\u000e,\u0017A\u00039pS:$8o\u0018\u0013fcR\u0011AJ\u0015\t\u0003\u001bBk\u0011A\u0014\u0006\u0002\u001f\u0006)1oY1mC&\u0011\u0011K\u0014\u0002\u0005+:LG\u000fC\u0004T\t\u0005\u0005\t\u0019A$\u0002\u0007a$\u0013'A\u0004q_&tGo\u001d\u0011\u0015\t\r3VL\u0019\u0005\u0006\u000b\u001a\u0001\ra\u0016\t\u0004\u001bbS\u0016BA-O\u0005\u0015\t%O]1z!\t)4,\u0003\u0002]U\tQ1i\\8sI&t\u0017\r^3\t\u000by3\u0001\u0019A0\u0002\u001dA\u0014XmY5tS>tWj\u001c3fYB\u0011Q\u0007Y\u0005\u0003C*\u0012a\u0002\u0015:fG&\u001c\u0018n\u001c8N_\u0012,G\u000eC\u0003d\r\u0001\u0007A-\u0001\u0003T%&#\u0005CA'f\u0013\t1gJA\u0002J]R$2a\u00115j\u0011\u0015)u\u00011\u0001H\u0011\u0015\u0001u\u00011\u0001=\u0003\u0011Ig.\u001b;\u0015\u00051c\u0007\"B7\t\u0001\u00049\u0015!\u00029pS:$\u0018AD4fi\u000e{wN\u001d3j]\u0006$Xm]\u000b\u0002/\u0006)r-\u001a;D_>\u0014H-\u001b8bi\u0016\u001cV-];f]\u000e,\u0017AD4fi\u000e{wN\u001d3j]\u0006$XM\u0014\u000b\u00035NDQ\u0001^\u0006A\u0002\u0011\f\u0011A\\\u0001\u000eO\u0016$8i\\8sI&t\u0017\r^3\u0016\u0003i\u000bAbZ3u\t&lWM\\:j_:,\u0012\u0001Z\u0001\u0015O\u0016$(i\\;oI\u0006\u0014\u0018\u0010R5nK:\u001c\u0018n\u001c8\u0002\u000f%\u001cX)\u001c9usV\tA\u0010\u0005\u0002N{&\u0011aP\u0014\u0002\b\u0005>|G.Z1o\u000319W\r\u001e(v[B{\u0017N\u001c;t\u0003%9W\r\u001e)pS:$h\n\u0006\u0003\u0002\u0006\u0005-\u0001cA\u001b\u0002\b%\u0019\u0011\u0011\u0002\u0016\u0003\u000bA{\u0017N\u001c;\t\u000bQ\f\u0002\u0019\u00013\u0002\u001b\u001d,Go\u0015;beR\u0004v.\u001b8u+\t\t)!A\u0006hKR,e\u000e\u001a)pS:$\u0018\u0001C5t\u00072|7/\u001a3\u0002\r%\u001c(+\u001b8h\u0003=9W\r^$f_6,GO]=UsB,WCAA\u000e!\u0011\ti\"a\n\u000e\u0005\u0005}!\u0002BA\u0011\u0003G\tA\u0001\\1oO*\u0011\u0011QE\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002*\u0005}!AB*ue&tw-A\u0005hKRdUM\\4uQV\u0011\u0011q\u0006\t\u0004\u001b\u0006E\u0012bAA\u001a\u001d\n1Ai\\;cY\u0016\f1bZ3u\u0005>,h\u000eZ1ssV\tA'A\u0004sKZ,'o]3\u0002\u001fI,g/\u001a:tK&sG/\u001a:oC2,\u0012aQ\u0001\rSN\u001cun\u001c:eS:\fG/\u001a\u000b\u0004y\u0006\r\u0003BBA#7\u0001\u0007!,\u0001\u0002qi\u000692m\\7qkR,WI\u001c<fY>\u0004X-\u00138uKJt\u0017\r\\\u000b\u0003\u0003\u0017\u00022!NA'\u0013\r\tyE\u000b\u0002\t\u000b:4X\r\\8qK\u0006YQ-];bYN,\u00050Y2u)\u0015a\u0018QKA-\u0011\u0019\t9&\ba\u0001i\u0005)q\u000e\u001e5fe\"9\u00111L\u000fA\u0002\u0005=\u0012!\u0003;pY\u0016\u0014\u0018M\\2f\u0003\u0019\t\u0007\u000f\u001d7z\rR\u0019A*!\u0019\t\u000f\u0005\rd\u00041\u0001\u0002f\u00051a-\u001b7uKJ\u00042!NA4\u0013\r\tIG\u000b\u0002\u0011\u0007>|'\u000fZ5oCR,g)\u001b7uKJ$2\u0001TA7\u0011\u001d\t\u0019g\ba\u0001\u0003_\u00022!NA9\u0013\r\t\u0019H\u000b\u0002\u0019\u0007>|'\u000fZ5oCR,7+Z9vK:\u001cWMR5mi\u0016\u0014Hc\u0001'\u0002x!9\u00111\r\u0011A\u0002\u0005e\u0004cA\u001b\u0002|%\u0019\u0011Q\u0010\u0016\u0003\u001d\u001d+w.\\3uef4\u0015\u000e\u001c;feR\u0019A*!!\t\u000f\u0005\r\u0014\u00051\u0001\u0002\u0004B\u0019Q'!\"\n\u0007\u0005\u001d%FA\fHK>lW\r\u001e:z\u0007>l\u0007o\u001c8f]R4\u0015\u000e\u001c;fe\u0006)1\r\\8oKR\u0011\u0011Q\u0012\t\u0004\u001b\u0006=\u0015bAAI\u001d\n1\u0011I\\=SK\u001a\fAbY8qs&sG/\u001a:oC2\f\u0011B\\8s[\u0006d\u0017N_3\u0015\u00031\u000b\u0011#[:FcVLg/\u00197f]R\u001cE.Y:t)\ra\u0018Q\u0014\u0005\u0007\u0003/*\u0003\u0019\u0001\u001b\u0002%\r|W\u000e]1sKR{7+Y7f\u00072\f7o\u001d\u000b\u0004I\u0006\r\u0006BBASM\u0001\u0007A'A\u0001p)\u0015!\u0017\u0011VAV\u0011\u0019\t)k\na\u0001i!9\u0011QV\u0014A\u0002\u0005=\u0016\u0001B2p[B\u00042!NAY\u0013\r\t\u0019L\u000b\u0002\u001d\u0007>|'\u000fZ5oCR,7+Z9vK:\u001cWmQ8na\u0006\u0014\u0018\r^8s\u000319W\r^*peRLe\u000eZ3yQ\u001d\u0001\u0011\u0011XA`\u0003\u0003\u00042!TA^\u0013\r\tiL\u0014\u0002\u0011'\u0016\u0014\u0018.\u00197WKJ\u001c\u0018n\u001c8V\u0013\u0012\u000bQA^1mk\u0016t\u0002bK\u0016Ru\u000fcf\u0012\u000f")
public class LineString
extends Geometry
implements Lineal {
    private static final long serialVersionUID = 3110669828065365560L;
    private CoordinateSequence points = null;
    private volatile boolean bitmap$init$0 = true;

    public CoordinateSequence points() {
        if (!this.bitmap$init$0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/geom/LineString.scala: 50");
        }
        return this.points;
    }

    public void points_$eq(CoordinateSequence x$1) {
        this.points = x$1;
        this.bitmap$init$0 = true;
    }

    private void init(CoordinateSequence point) {
        if (point == null) {
            this.points_$eq(this.getFactory().getCoordinateSequenceFactory().create((Coordinate[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Coordinate.class))));
        }
        if (point.size() == 1) {
            throw new IllegalArgumentException(new StringBuilder(67).append("Invalid number of points in LineString (found ").append(this.points().size()).append(" - must be 0 or >= 2)").toString());
        }
        this.points_$eq(point);
    }

    @Override
    public Coordinate[] getCoordinates() {
        return this.points().toCoordinateArray();
    }

    public CoordinateSequence getCoordinateSequence() {
        return this.points();
    }

    public Coordinate getCoordinateN(int n) {
        return this.points().getCoordinate(n);
    }

    @Override
    public Coordinate getCoordinate() {
        if (this.isEmpty()) {
            return null;
        }
        return this.points().getCoordinate(0);
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public int getBoundaryDimension() {
        if (this.isClosed()) {
            return Dimension$.MODULE$.FALSE();
        }
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return this.points().size() == 0;
    }

    @Override
    public int getNumPoints() {
        return this.points().size();
    }

    public Point getPointN(int n) {
        return this.getFactory().createPoint(this.points().getCoordinate(n));
    }

    public Point getStartPoint() {
        if (this.isEmpty()) {
            return null;
        }
        return this.getPointN(0);
    }

    public Point getEndPoint() {
        if (this.isEmpty()) {
            return null;
        }
        return this.getPointN(this.getNumPoints() - 1);
    }

    public boolean isClosed() {
        if (this.isEmpty()) {
            return false;
        }
        return this.getCoordinateN(0).equals2D(this.getCoordinateN(this.getNumPoints() - 1));
    }

    public boolean isRing() {
        return this.isClosed() && this.isSimple();
    }

    @Override
    public String getGeometryType() {
        return "LineString";
    }

    @Override
    public double getLength() {
        return Length$.MODULE$.ofLine(this.points());
    }

    @Override
    public Geometry getBoundary() {
        return new BoundaryOp(this).getBoundary();
    }

    @Override
    public Geometry reverse() {
        return super.reverse();
    }

    @Override
    public LineString reverseInternal() {
        CoordinateSequence seq = this.points().copy();
        CoordinateSequences$.MODULE$.reverse(seq);
        return this.getFactory().createLineString(seq);
    }

    public boolean isCoordinate(Coordinate pt) {
        for (int i = 0; i < this.points().size(); ++i) {
            Coordinate coordinate = this.points().getCoordinate(i);
            Coordinate coordinate2 = pt;
            if (coordinate != null ? !((Object)coordinate).equals(coordinate2) : coordinate2 != null) continue;
            return true;
        }
        return false;
    }

    @Override
    public Envelope computeEnvelopeInternal() {
        if (this.isEmpty()) {
            return new Envelope();
        }
        return this.points().expandEnvelope(new Envelope());
    }

    @Override
    public boolean equalsExact(Geometry other, double tolerance) {
        if (!this.isEquivalentClass(other)) {
            return false;
        }
        LineString otherLineString = (LineString)other;
        if (this.points().size() != otherLineString.points().size()) {
            return false;
        }
        for (int i = 0; i < this.points().size(); ++i) {
            if (this.equal(this.points().getCoordinate(i), otherLineString.points().getCoordinate(i), tolerance)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void applyF(CoordinateFilter filter) {
        for (int i = 0; i < this.points().size(); ++i) {
            filter.filter(this.points().getCoordinate(i));
        }
    }

    @Override
    public void applyF(CoordinateSequenceFilter filter) {
        block3: {
            if (this.points().size() == 0) {
                return;
            }
            int i = 0;
            while (i < this.points().size()) {
                filter.filter(this.points(), i);
                if (filter.isDone()) {
                    i = this.points().size();
                    continue;
                }
                ++i;
            }
            if (!filter.isGeometryChanged()) break block3;
            this.geometryChanged();
        }
    }

    @Override
    public void applyF(GeometryFilter filter) {
        filter.filter(this);
    }

    @Override
    public void applyF(GeometryComponentFilter filter) {
        filter.filter(this);
    }

    @Override
    public Object clone() {
        return this.copy();
    }

    @Override
    public Geometry copyInternal() {
        return new LineString(this.points().copy(), this.factory());
    }

    @Override
    public void normalize() {
        for (int i = 0; i < this.points().size() / 2; ++i) {
            int j = this.points().size() - 1 - i;
            Coordinate coordinate = this.points().getCoordinate(i);
            Coordinate coordinate2 = this.points().getCoordinate(j);
            if (!(coordinate == null ? coordinate2 != null : !((Object)coordinate).equals(coordinate2))) continue;
            if (this.points().getCoordinate(i).compareTo(this.points().getCoordinate(j)) > 0) {
                CoordinateSequence copy = this.points().copy();
                CoordinateSequences$.MODULE$.reverse(copy);
                this.points_$eq(copy);
            }
            return;
        }
    }

    @Override
    public boolean isEquivalentClass(Geometry other) {
        return other instanceof LineString;
    }

    @Override
    public int compareToSameClass(Geometry o) {
        int j;
        LineString line = (LineString)o;
        int i = 0;
        for (j = 0; i < this.points().size() && j < line.points().size(); ++i, ++j) {
            int comparison = this.points().getCoordinate(i).compareTo(line.points().getCoordinate(j));
            if (comparison == 0) continue;
            return comparison;
        }
        if (i < this.points().size()) {
            return 1;
        }
        if (j < line.points().size()) {
            return -1;
        }
        return 0;
    }

    @Override
    public int compareToSameClass(Geometry o, CoordinateSequenceComparator comp) {
        LineString line = (LineString)o;
        return comp.compare(this.points(), line.points());
    }

    @Override
    public int getSortIndex() {
        return Geometry$.MODULE$.SORTINDEX_LINESTRING();
    }

    public LineString(GeometryFactory fac) {
        super(fac);
    }

    public LineString(Coordinate[] points, PrecisionModel precisionModel, int SRID) {
        this(new GeometryFactory(precisionModel, SRID));
        this.init(this.getFactory().getCoordinateSequenceFactory().create(points));
    }

    public LineString(CoordinateSequence points, GeometryFactory factory) {
        this(factory);
        this.init(points);
    }
}

