/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import java.io.Serializable;
import java.util.Arrays;
import org.locationtech.jts.algorithm.Area$;
import org.locationtech.jts.algorithm.Orientation$;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceComparator;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.CoordinateSequences$;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Geometry$;
import org.locationtech.jts.geom.GeometryComponentFilter;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.GeometryFilter;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygonal;
import org.locationtech.jts.geom.PrecisionModel;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.UninitializedFieldError;
import scala.collection.ArrayOps$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005=g\u0001B\u0017/\u0001]B\u0001b\u0010\u0001\u0003\u0006\u0004%\t\u0001\u0011\u0005\t\t\u0002\u0011\t\u0011)A\u0005\u0003\"AQ\t\u0001BA\u0002\u0013\u0005a\t\u0003\u0005N\u0001\t\u0005\r\u0011\"\u0001O\u0011!!\u0006A!A!B\u00139\u0005\u0002C+\u0001\u0005\u000b\u0007I\u0011\t,\t\u0013i\u0003!\u0011!Q\u0001\n][\u0006\"\u0002/\u0001\t\u0003i\u0006b\u00022\u0001\u0001\u0004%\t\u0001\u0011\u0005\bG\u0002\u0001\r\u0011\"\u0001e\u0011\u00191\u0007\u0001)Q\u0005\u0003\")A\f\u0001C\u0001O\")A\f\u0001C\u0001g\")\u0001\u0010\u0001C!s\")Q\u0010\u0001C!}\"9\u0011\u0011\u0001\u0001\u0005B\u0005\r\u0001bBA\u0003\u0001\u0011\u0005\u00131\u0001\u0005\b\u0003\u000f\u0001A\u0011IA\u0002\u0011\u001d\tI\u0001\u0001C!\u0003\u0017Aq!a\u0005\u0001\t\u0003\nY\u0001\u0003\u0004\u0002\u0016\u0001!\t\u0001\u0011\u0005\b\u0003/\u0001A\u0011AA\u0002\u0011\u001d\tI\u0002\u0001C\u0001\u00037Aq!!\t\u0001\t\u0003\n\u0019\u0003C\u0004\u00026\u0001!\t%a\u000e\t\u000f\u0005}\u0002\u0001\"\u0011\u00028!9\u0011\u0011\t\u0001\u0005B\u0005\r\u0003bBA#\u0001\u0011E\u0013q\t\u0005\b\u0003\u001f\u0002A\u0011IA)\u0011\u001d\tY\u0006\u0001C\u0001\u0003;Bq!a\u0017\u0001\t\u0003\tI\u0007C\u0004\u0002\\\u0001!\t!a\u001d\t\u000f\u0005m\u0003\u0001\"\u0001\u0002~!9\u0011q\u0011\u0001\u0005B\u0005%\u0005bBAF\u0001\u0011E\u00131\t\u0005\b\u0003\u001b\u0003A\u0011IA\"\u0011\u001d\ty\t\u0001C!\u0003#Cq!a%\u0001\t#\t)\nC\u0004\u0002\u0014\u0002!\t!a'\t\u000f\u0005%\u0006\u0001\"\u0015\u0002\u0004!9\u00111\u0016\u0001\u0005\n\u00055\u0006bBAH\u0001\u0011%\u0011q\u0017\u0005\b\u0003{\u0003A\u0011IA\"\u0011\u001d\ty\f\u0001C)\u0003\u0003\u0014q\u0001U8ms\u001e|gN\u0003\u00020a\u0005!q-Z8n\u0015\t\t$'A\u0002kiNT!a\r\u001b\u0002\u00191|7-\u0019;j_:$Xm\u00195\u000b\u0003U\n1a\u001c:h\u0007\u0001\u00192\u0001\u0001\u001d=!\tI$(D\u0001/\u0013\tYdF\u0001\u0005HK>lW\r\u001e:z!\tIT(\u0003\u0002?]\tI\u0001k\u001c7zO>t\u0017\r\\\u0001\tg\",G\u000e\\!sOV\t\u0011\t\u0005\u0002:\u0005&\u00111I\f\u0002\u000b\u0019&tW-\u0019:SS:<\u0017!C:iK2d\u0017I]4!\u0003\u0015Aw\u000e\\3t+\u00059\u0005c\u0001%L\u00036\t\u0011JC\u0001K\u0003\u0015\u00198-\u00197b\u0013\ta\u0015JA\u0003BeJ\f\u00170A\u0005i_2,7o\u0018\u0013fcR\u0011qJ\u0015\t\u0003\u0011BK!!U%\u0003\tUs\u0017\u000e\u001e\u0005\b'\u0012\t\t\u00111\u0001H\u0003\rAH%M\u0001\u0007Q>dWm\u001d\u0011\u0002\u000f\u0019\f7\r^8ssV\tq\u000b\u0005\u0002:1&\u0011\u0011L\f\u0002\u0010\u000f\u0016|W.\u001a;ss\u001a\u000b7\r^8ss\u0006Aa-Y2u_JL\b%\u0003\u0002Vu\u00051A(\u001b8jiz\"BAX0aCB\u0011\u0011\b\u0001\u0005\u0006\u007f!\u0001\r!\u0011\u0005\u0006\u000b\"\u0001\ra\u0012\u0005\u0006+\"\u0001\raV\u0001\u0006g\",G\u000e\\\u0001\ng\",G\u000e\\0%KF$\"aT3\t\u000fMS\u0011\u0011!a\u0001\u0003\u000611\u000f[3mY\u0002\"BA\u00185j]\")!\r\u0004a\u0001\u0003\")!\u000e\u0004a\u0001W\u0006q\u0001O]3dSNLwN\\'pI\u0016d\u0007CA\u001dm\u0013\tigF\u0001\bQe\u0016\u001c\u0017n]5p]6{G-\u001a7\t\u000b=d\u0001\u0019\u00019\u0002\tM\u0013\u0016\n\u0012\t\u0003\u0011FL!A]%\u0003\u0007%sG\u000fF\u0003_iV4x\u000fC\u0003c\u001b\u0001\u0007\u0011\tC\u0003F\u001b\u0001\u0007q\tC\u0003k\u001b\u0001\u00071\u000eC\u0003p\u001b\u0001\u0007\u0001/A\u0007hKR\u001cun\u001c:eS:\fG/Z\u000b\u0002uB\u0011\u0011h_\u0005\u0003y:\u0012!bQ8pe\u0012Lg.\u0019;f\u000399W\r^\"p_J$\u0017N\\1uKN,\u0012a \t\u0004\u0011.S\u0018\u0001D4fi:+X\u000eU8j]R\u001cX#\u00019\u0002\u0019\u001d,G\u000fR5nK:\u001c\u0018n\u001c8\u0002)\u001d,GOQ8v]\u0012\f'/\u001f#j[\u0016t7/[8o\u0003\u001dI7/R7qif,\"!!\u0004\u0011\u0007!\u000by!C\u0002\u0002\u0012%\u0013qAQ8pY\u0016\fg.A\u0006jgJ+7\r^1oO2,\u0017aD4fi\u0016CH/\u001a:j_J\u0014\u0016N\\4\u0002%\u001d,GOT;n\u0013:$XM]5peJKgnZ\u0001\u0011O\u0016$\u0018J\u001c;fe&|'OU5oO:#2!QA\u000f\u0011\u0019\tyb\u0006a\u0001a\u0006\ta.A\bhKR<Um\\7fiJLH+\u001f9f+\t\t)\u0003\u0005\u0003\u0002(\u0005ERBAA\u0015\u0015\u0011\tY#!\f\u0002\t1\fgn\u001a\u0006\u0003\u0003_\tAA[1wC&!\u00111GA\u0015\u0005\u0019\u0019FO]5oO\u00069q-\u001a;Be\u0016\fWCAA\u001d!\rA\u00151H\u0005\u0004\u0003{I%A\u0002#pk\ndW-A\u0005hKRdUM\\4uQ\u0006Yq-\u001a;C_VtG-\u0019:z+\u0005A\u0014aF2p[B,H/Z#om\u0016dw\u000e]3J]R,'O\\1m+\t\tI\u0005E\u0002:\u0003\u0017J1!!\u0014/\u0005!)eN^3m_B,\u0017aC3rk\u0006d7/\u0012=bGR$b!!\u0004\u0002T\u0005]\u0003BBA+;\u0001\u0007\u0001(A\u0003pi\",'\u000fC\u0004\u0002Zu\u0001\r!!\u000f\u0002\u0013Q|G.\u001a:b]\u000e,\u0017AB1qa2Lh\tF\u0002P\u0003?Bq!!\u0019\u001f\u0001\u0004\t\u0019'\u0001\u0004gS2$XM\u001d\t\u0004s\u0005\u0015\u0014bAA4]\t\u00012i\\8sI&t\u0017\r^3GS2$XM\u001d\u000b\u0004\u001f\u0006-\u0004bBA1?\u0001\u0007\u0011Q\u000e\t\u0004s\u0005=\u0014bAA9]\tA2i\\8sI&t\u0017\r^3TKF,XM\\2f\r&dG/\u001a:\u0015\u0007=\u000b)\bC\u0004\u0002b\u0001\u0002\r!a\u001e\u0011\u0007e\nI(C\u0002\u0002|9\u0012abR3p[\u0016$(/\u001f$jYR,'\u000fF\u0002P\u0003\u007fBq!!\u0019\"\u0001\u0004\t\t\tE\u0002:\u0003\u0007K1!!\"/\u0005]9Um\\7fiJL8i\\7q_:,g\u000e\u001e$jYR,'/A\u0003dY>tW\rF\u00019\u00031\u0019w\u000e]=J]R,'O\\1m\u0003)\u0019wN\u001c<fq\"+H\u000e\\\u0001\n]>\u0014X.\u00197ju\u0016$\u0012aT\u0001\u0013G>l\u0007/\u0019:f)>\u001c\u0016-\\3DY\u0006\u001c8\u000fF\u0002q\u0003/Ca!!''\u0001\u0004A\u0014!A8\u0015\u000bA\fi*a(\t\r\u0005eu\u00051\u00019\u0011\u001d\t\tk\na\u0001\u0003G\u000bAaY8naB\u0019\u0011(!*\n\u0007\u0005\u001dfF\u0001\u000fD_>\u0014H-\u001b8bi\u0016\u001cV-];f]\u000e,7i\\7qCJ\fGo\u001c:\u0002\u0019\u001d,GoU8si&sG-\u001a=\u0002\u00159|'/\\1mSj,G\rF\u0003B\u0003_\u000b\u0019\f\u0003\u0004\u00022&\u0002\r!Q\u0001\u0005e&tw\rC\u0004\u00026&\u0002\r!!\u0004\u0002\u0013\rdwnY6xSN,G#B(\u0002:\u0006m\u0006BBAYU\u0001\u0007\u0011\tC\u0004\u00026*\u0002\r!!\u0004\u0002\u000fI,g/\u001a:tK\u0006y!/\u001a<feN,\u0017J\u001c;fe:\fG.F\u0001_Q\u001d\u0001\u0011QYAf\u0003\u001b\u00042\u0001SAd\u0013\r\tI-\u0013\u0002\u0011'\u0016\u0014\u0018.\u00197WKJ\u001c\u0018n\u001c8V\u0013\u0012\u000bQA^1mk\u0016t\u0002b4A\u0002\u0005I4dr\u0013")
public class Polygon
extends Geometry
implements Polygonal {
    private static final long serialVersionUID = -3494792200821764533L;
    private final LinearRing shellArg;
    private LinearRing[] holes;
    private LinearRing shell;
    private volatile boolean bitmap$init$0;

    public LinearRing shellArg() {
        return this.shellArg;
    }

    public LinearRing[] holes() {
        return this.holes;
    }

    public void holes_$eq(LinearRing[] x$1) {
        this.holes = x$1;
    }

    @Override
    public GeometryFactory factory() {
        return super.factory();
    }

    public LinearRing shell() {
        if (!this.bitmap$init$0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/geom/Polygon.scala: 66");
        }
        return this.shell;
    }

    public void shell_$eq(LinearRing x$1) {
        this.shell = x$1;
        this.bitmap$init$0 = true;
    }

    @Override
    public Coordinate getCoordinate() {
        return this.shell().getCoordinate();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Coordinate[] getCoordinates() {
        void var1_1;
        if (this.isEmpty()) {
            return (Coordinate[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Coordinate.class));
        }
        Coordinate[] coordinates = new Coordinate[this.getNumPoints()];
        int k = -1;
        Coordinate[] shellCoordinates = this.shell().getCoordinates();
        for (int x = 0; x < shellCoordinates.length; ++x) {
            coordinates[++k] = shellCoordinates[x];
        }
        for (int i = 0; i < this.holes().length; ++i) {
            Coordinate[] childCoordinates = this.holes()[i].getCoordinates();
            for (int j = 0; j < childCoordinates.length; ++j) {
                coordinates[++k] = childCoordinates[j];
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getNumPoints() {
        void var1_1;
        int numPoints = this.shell().getNumPoints();
        for (int i = 0; i < this.holes().length; ++i) {
            numPoints += this.holes()[i].getNumPoints();
        }
        return (int)var1_1;
    }

    @Override
    public int getDimension() {
        return 2;
    }

    @Override
    public int getBoundaryDimension() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return this.shell().isEmpty();
    }

    @Override
    public boolean isRectangle() {
        int i;
        if (this.getNumInteriorRing() != 0) {
            return false;
        }
        if (this.shell() == null) {
            return false;
        }
        if (this.shell().getNumPoints() != 5) {
            return false;
        }
        CoordinateSequence seq = this.shell().getCoordinateSequence();
        Envelope env = this.getEnvelopeInternal();
        for (i = 0; i < 5; ++i) {
            double x = seq.getX(i);
            if (x != env.getMinX() && x != env.getMaxX()) {
                return false;
            }
            double y = seq.getY(i);
            if (y == env.getMinY() || y == env.getMaxY()) continue;
            return false;
        }
        double prevX = seq.getX(0);
        double prevY = seq.getY(0);
        for (i = 1; i <= 4; ++i) {
            boolean yChanged;
            double x = seq.getX(i);
            double y = seq.getY(i);
            boolean xChanged = x != prevX;
            boolean bl = yChanged = y != prevY;
            if (xChanged == yChanged) {
                return false;
            }
            prevX = x;
            prevY = y;
        }
        return true;
    }

    public LinearRing getExteriorRing() {
        return this.shell();
    }

    public int getNumInteriorRing() {
        return this.holes().length;
    }

    public LinearRing getInteriorRingN(int n) {
        return this.holes()[n];
    }

    @Override
    public String getGeometryType() {
        return "Polygon";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double getArea() {
        void var1_1;
        double area = 0.0;
        area += Area$.MODULE$.ofRing(this.shell().getCoordinateSequence());
        for (int i = 0; i < this.holes().length; ++i) {
            area -= Area$.MODULE$.ofRing(this.holes()[i].getCoordinateSequence());
        }
        return (double)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double getLength() {
        void var1_1;
        double len = 0.0;
        len += this.shell().getLength();
        for (int i = 0; i < this.holes().length; ++i) {
            len += this.holes()[i].getLength();
        }
        return (double)var1_1;
    }

    @Override
    public Geometry getBoundary() {
        if (this.isEmpty()) {
            return this.getFactory().createMultiLineString();
        }
        LinearRing[] rings = new LinearRing[this.holes().length + 1];
        rings[0] = this.shell();
        for (int i = 0; i < this.holes().length; ++i) {
            rings[i + 1] = this.holes()[i];
        }
        if (rings.length <= 1) {
            return this.getFactory().createLinearRing(rings[0].getCoordinateSequence());
        }
        return this.getFactory().createMultiLineString((LineString[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])rings), (Function1 & Serializable)x -> x, ClassTag$.MODULE$.apply(LineString.class)));
    }

    @Override
    public Envelope computeEnvelopeInternal() {
        return this.shell().getEnvelopeInternal();
    }

    @Override
    public boolean equalsExact(Geometry other, double tolerance) {
        LinearRing otherPolygonShell;
        if (!this.isEquivalentClass(other)) {
            return false;
        }
        Polygon otherPolygon = (Polygon)other;
        LinearRing thisShell = this.shell();
        if (!thisShell.equalsExact(otherPolygonShell = otherPolygon.shell(), tolerance)) {
            return false;
        }
        if (this.holes().length != otherPolygon.holes().length) {
            return false;
        }
        for (int i = 0; i < this.holes().length; ++i) {
            if (((Geometry)this.holes()[i]).equalsExact(otherPolygon.holes()[i], tolerance)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void applyF(CoordinateFilter filter) {
        this.shell().applyF(filter);
        for (int i = 0; i < this.holes().length; ++i) {
            this.holes()[i].applyF(filter);
        }
    }

    @Override
    public void applyF(CoordinateSequenceFilter filter) {
        block3: {
            this.shell().applyF(filter);
            if (filter.isDone()) break block3;
            int i = 0;
            while (i < this.holes().length) {
                this.holes()[i].applyF(filter);
                if (filter.isDone()) {
                    i = this.holes().length;
                    continue;
                }
                ++i;
            }
            if (filter.isGeometryChanged()) {
                this.geometryChanged();
            }
        }
    }

    @Override
    public void applyF(GeometryFilter filter) {
        filter.filter(this);
    }

    @Override
    public void applyF(GeometryComponentFilter filter) {
        filter.filter(this);
        this.shell().applyF(filter);
        for (int i = 0; i < this.holes().length; ++i) {
            this.holes()[i].applyF(filter);
        }
    }

    @Override
    public Geometry clone() {
        return this.copy();
    }

    @Override
    public Geometry copyInternal() {
        LinearRing shellCopy = (LinearRing)this.shell().copy();
        LinearRing[] holeCopies = new LinearRing[this.holes().length];
        for (int i = 0; i < this.holes().length; ++i) {
            holeCopies[i] = (LinearRing)this.holes()[i].copy();
        }
        return new Polygon(shellCopy, holeCopies, this.factory());
    }

    @Override
    public Geometry convexHull() {
        return this.getExteriorRing().convexHull();
    }

    @Override
    public void normalize() {
        this.shell_$eq(this.normalized(this.shell(), true));
        for (int i = 0; i < this.holes().length; ++i) {
            this.holes()[i] = this.normalized(this.holes()[i], false);
        }
        Arrays.sort((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.holes()), (Function1 & Serializable)x -> x, ClassTag$.MODULE$.AnyRef()));
    }

    @Override
    public int compareToSameClass(Geometry o) {
        LinearRing thisShell = this.shell();
        LinearRing otherShell = ((Polygon)o).shell();
        return thisShell.compareToSameClass(otherShell, null);
    }

    @Override
    public int compareToSameClass(Geometry o, CoordinateSequenceComparator comp) {
        int i;
        LinearRing otherShell;
        Polygon poly = (Polygon)o;
        LinearRing thisShell = this.shell();
        int shellComp = thisShell.compareToSameClass(otherShell = poly.shell(), comp);
        if (shellComp != 0) {
            return shellComp;
        }
        int nHole1 = this.getNumInteriorRing();
        int nHole2 = poly.getNumInteriorRing();
        for (i = 0; i < nHole1 && i < nHole2; ++i) {
            LinearRing otherHole;
            LinearRing thisHole = this.getInteriorRingN(i);
            int holeComp = thisHole.compareToSameClass(otherHole = poly.getInteriorRingN(i), comp);
            if (holeComp == 0) continue;
            return holeComp;
        }
        if (i < nHole1) {
            return 1;
        }
        if (i < nHole2) {
            return -1;
        }
        return 0;
    }

    @Override
    public int getSortIndex() {
        return Geometry$.MODULE$.SORTINDEX_POLYGON();
    }

    /*
     * WARNING - void declaration
     */
    private LinearRing normalized(LinearRing ring, boolean clockwise) {
        void var3_3;
        LinearRing res = (LinearRing)ring.copy();
        this.normalize(res, clockwise);
        return var3_3;
    }

    private void normalize(LinearRing ring, boolean clockwise) {
        block1: {
            if (ring.isEmpty()) {
                return;
            }
            CoordinateSequence seq = ring.getCoordinateSequence();
            int minCoordinateIndex = CoordinateSequences$.MODULE$.minCoordinateIndex(seq, 0, seq.size() - 2);
            CoordinateSequences$.MODULE$.scroll(seq, minCoordinateIndex, true);
            if (Orientation$.MODULE$.isCCW(seq) != clockwise) break block1;
            CoordinateSequences$.MODULE$.reverse(seq);
        }
    }

    @Override
    public Geometry reverse() {
        return super.reverse();
    }

    @Override
    public Polygon reverseInternal() {
        LinearRing shell = (LinearRing)this.getExteriorRing().reverse();
        LinearRing[] holes = new LinearRing[this.getNumInteriorRing()];
        for (int i = 0; i < holes.length; ++i) {
            holes[i] = (LinearRing)this.getInteriorRingN(i).reverse();
        }
        return this.getFactory().createPolygon(shell, holes);
    }

    public Polygon(LinearRing shellArg, LinearRing[] holes, GeometryFactory factory) {
        this.shellArg = shellArg;
        this.holes = holes;
        super(factory);
        this.shell = shellArg == null ? this.getFactory().createLinearRing() : shellArg;
        this.bitmap$init$0 = true;
        if (this.holes() == null) {
            this.holes_$eq((LinearRing[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(LinearRing.class)));
        }
        if (Geometry$.MODULE$.hasNullElements((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.holes()), (Function1 & Serializable)x -> x, ClassTag$.MODULE$.AnyRef()))) {
            throw new IllegalArgumentException("holes must not contain null elements");
        }
        if (this.shell().isEmpty() && Geometry$.MODULE$.hasNonEmptyElements((Geometry[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.holes()), (Function1 & Serializable)x -> x, ClassTag$.MODULE$.apply(Geometry.class)))) {
            throw new IllegalArgumentException("shell is empty but holes are not");
        }
    }

    public Polygon(LinearRing shell, PrecisionModel precisionModel, int SRID) {
        this(shell, (LinearRing[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(LinearRing.class)), new GeometryFactory(precisionModel, SRID));
    }

    public Polygon(LinearRing shell, LinearRing[] holes, PrecisionModel precisionModel, int SRID) {
        this(shell, holes, new GeometryFactory(precisionModel, SRID));
    }
}

