/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import org.locationtech.jts.algorithm.Angle$;
import org.locationtech.jts.algorithm.HCoordinate;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.math.DD;
import org.locationtech.jts.math.DD$;

public final class Triangle$ {
    public static final Triangle$ MODULE$ = new Triangle$();

    public boolean isAcute(Coordinate a, Coordinate b, Coordinate c) {
        if (!Angle$.MODULE$.isAcute(a, b, c)) {
            return false;
        }
        if (!Angle$.MODULE$.isAcute(b, c, a)) {
            return false;
        }
        return Angle$.MODULE$.isAcute(c, a, b);
    }

    public HCoordinate perpendicularBisector(Coordinate a, Coordinate b) {
        double dx = b.x() - a.x();
        double dy = b.y() - a.y();
        HCoordinate l1 = new HCoordinate(a.x() + dx / 2.0, a.y() + dy / 2.0, 1.0);
        HCoordinate l2 = new HCoordinate(a.x() - dy + dx / 2.0, a.y() + dx + dy / 2.0, 1.0);
        return new HCoordinate(l1, l2);
    }

    public Coordinate circumcentre(Coordinate a, Coordinate b, Coordinate c) {
        double cx = c.x();
        double cy = c.y();
        double ax = a.x() - cx;
        double ay = a.y() - cy;
        double bx = b.x() - cx;
        double by = b.y() - cy;
        double denom = (double)2 * this.det(ax, ay, bx, by);
        double numx = this.det(ay, ax * ax + ay * ay, by, bx * bx + by * by);
        double numy = this.det(ax, ax * ax + ay * ay, bx, bx * bx + by * by);
        double ccx = cx - numx / denom;
        double ccy = cy + numy / denom;
        return new Coordinate(ccx, ccy);
    }

    public Coordinate circumcentreDD(Coordinate a, Coordinate b, Coordinate c) {
        DD ax = DD$.MODULE$.valueOf(a.x()).subtract(c.x());
        DD ay = DD$.MODULE$.valueOf(a.y()).subtract(c.y());
        DD bx = DD$.MODULE$.valueOf(b.x()).subtract(c.x());
        DD by = DD$.MODULE$.valueOf(b.y()).subtract(c.y());
        DD denom = DD$.MODULE$.determinant(ax, ay, bx, by).multiply(2.0);
        DD asqr = ax.sqr().add(ay.sqr());
        DD bsqr = bx.sqr().add(by.sqr());
        DD numx = DD$.MODULE$.determinant(ay, asqr, by, bsqr);
        DD numy = DD$.MODULE$.determinant(ax, asqr, bx, bsqr);
        double ccx = DD$.MODULE$.valueOf(c.x()).subtract(numx.divide(denom)).doubleValue();
        double ccy = DD$.MODULE$.valueOf(c.y()).add(numy.divide(denom)).doubleValue();
        return new Coordinate(ccx, ccy);
    }

    private double det(double m00, double m01, double m10, double m11) {
        return m00 * m11 - m01 * m10;
    }

    public Coordinate inCentre(Coordinate a, Coordinate b, Coordinate c) {
        double len0 = b.distance(c);
        double len1 = a.distance(c);
        double len2 = a.distance(b);
        double circum = len0 + len1 + len2;
        double inCentreX = (len0 * a.x() + len1 * b.x() + len2 * c.x()) / circum;
        double inCentreY = (len0 * a.y() + len1 * b.y() + len2 * c.y()) / circum;
        return new Coordinate(inCentreX, inCentreY);
    }

    public Coordinate centroid(Coordinate a, Coordinate b, Coordinate c) {
        double x = (a.x() + b.x() + c.x()) / (double)3;
        double y = (a.y() + b.y() + c.y()) / (double)3;
        return new Coordinate(x, y);
    }

    public double longestSideLength(Coordinate a, Coordinate b, Coordinate c) {
        double maxLen;
        block1: {
            double lenAB = a.distance(b);
            double lenBC = b.distance(c);
            double lenCA = c.distance(a);
            maxLen = lenAB;
            if (lenBC > maxLen) {
                maxLen = lenBC;
            }
            if (!(lenCA > maxLen)) break block1;
            maxLen = lenCA;
        }
        return maxLen;
    }

    public Coordinate angleBisector(Coordinate a, Coordinate b, Coordinate c) {
        double len0 = b.distance(a);
        double len2 = b.distance(c);
        double frac = len0 / (len0 + len2);
        double dx = c.x() - a.x();
        double dy = c.y() - a.y();
        Coordinate splitPt = new Coordinate(a.x() + frac * dx, a.y() + frac * dy);
        return splitPt;
    }

    public double area(Coordinate a, Coordinate b, Coordinate c) {
        return Math.abs(((c.x() - a.x()) * (b.y() - a.y()) - (b.x() - a.x()) * (c.y() - a.y())) / (double)2);
    }

    public double signedArea(Coordinate a, Coordinate b, Coordinate c) {
        return ((c.x() - a.x()) * (b.y() - a.y()) - (b.x() - a.x()) * (c.y() - a.y())) / (double)2;
    }

    public double area3D(Coordinate a, Coordinate b, Coordinate c) {
        double ux = b.x() - a.x();
        double uy = b.y() - a.y();
        double uz = b.getZ() - a.getZ();
        double vx = c.x() - a.x();
        double vy = c.y() - a.y();
        double vz = c.getZ() - a.getZ();
        double crossx = uy * vz - uz * vy;
        double crossy = uz * vx - ux * vz;
        double crossz = ux * vy - uy * vx;
        double absSq = crossx * crossx + crossy * crossy + crossz * crossz;
        double area3D = Math.sqrt(absSq) / (double)2;
        return area3D;
    }

    public double interpolateZ(Coordinate p, Coordinate v0, Coordinate v1, Coordinate v2) {
        double x0 = v0.x();
        double y0 = v0.y();
        double a = v1.x() - x0;
        double b = v2.x() - x0;
        double c = v1.y() - y0;
        double d = v2.y() - y0;
        double det = a * d - b * c;
        double dx = p.x() - x0;
        double dy = p.y() - y0;
        double t = (d * dx - b * dy) / det;
        double u = (-c * dx + a * dy) / det;
        double z = v0.getZ() + t * (v1.getZ() - v0.getZ()) + u * (v2.getZ() - v0.getZ());
        return z;
    }

    private Triangle$() {
    }
}

