/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom.util;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.util.AffineTransformation$;
import org.locationtech.jts.geom.util.NoninvertibleTransformationException;
import org.locationtech.jts.util.Assert$;
import scala.Array$;
import scala.UninitializedFieldError;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\r]s!\u0002&L\u0011\u00031f!\u0002-L\u0011\u0003I\u0006\"\u00021\u0002\t\u0003\t\u0007\"\u00022\u0002\t\u0003\u0019\u0007B\u00022\u0002\t\u0003\u0019\t\u0002C\u0004\u0004\u0018\u0005!\ta!\u0007\t\u000f\r]\u0011\u0001\"\u0001\u0004\u001e!91qC\u0001\u0005\u0002\r\r\u0002bBB\f\u0003\u0011\u000511\u0006\u0005\b\u0007k\tA\u0011AB\u001c\u0011\u001d\u0019)$\u0001C\u0001\u0007{Aqaa\u0012\u0002\t\u0003\u0019I\u0005C\u0004\u0004P\u0005!\ta!\u0015\u0007\ta[\u0005!\u001a\u0005\u0006A6!\tA\u001e\u0005\bo6\u0001\r\u0011\"\u0003y\u0011\u001daX\u00021A\u0005\nuDq!a\u0002\u000eA\u0003&\u0011\u0010\u0003\u0005\u0002\n5\u0001\r\u0011\"\u0003y\u0011%\tY!\u0004a\u0001\n\u0013\ti\u0001C\u0004\u0002\u00125\u0001\u000b\u0015B=\t\u0011\u0005MQ\u00021A\u0005\naD\u0011\"!\u0006\u000e\u0001\u0004%I!a\u0006\t\u000f\u0005mQ\u0002)Q\u0005s\"A\u0011QD\u0007A\u0002\u0013%\u0001\u0010C\u0005\u0002 5\u0001\r\u0011\"\u0003\u0002\"!9\u0011QE\u0007!B\u0013I\b\u0002CA\u0014\u001b\u0001\u0007I\u0011\u0002=\t\u0013\u0005%R\u00021A\u0005\n\u0005-\u0002bBA\u0018\u001b\u0001\u0006K!\u001f\u0005\t\u0003ci\u0001\u0019!C\u0005q\"I\u00111G\u0007A\u0002\u0013%\u0011Q\u0007\u0005\b\u0003si\u0001\u0015)\u0003z\u0011\u0019\u0001W\u0002\"\u0001\u0002<!1\u0001-\u0004C\u0001\u0003\u000fBa\u0001Y\u0007\u0005\u0002\u0005U\u0003B\u00021\u000e\t\u0003\tY\u0006C\u0004\u0002|5!\t!! \t\u000f\u0005}T\u0002\"\u0001\u0002\u0002\"9\u0011qP\u0007\u0005\u0002\u0005=\u0005bBAJ\u001b\u0011\u0005\u0011Q\u0013\u0005\u0007\u0003/kA\u0011\u0001=\t\u000f\u0005eU\u0002\"\u0001\u0002~!9\u0011\u0011^\u0007\u0005\u0002\u0005-\bbBA\u007f\u001b\u0011\u0005\u0011q \u0005\b\u0003{lA\u0011\u0001B\u0005\u0011\u001d\u0011\u0019\"\u0004C\u0001\u0005+AqAa\u0005\u000e\t\u0003\u0011Y\u0002C\u0004\u0003\u00145!\tA!\n\t\u000f\tMQ\u0002\"\u0001\u0003.!9!qG\u0007\u0005\u0002\te\u0002b\u0002B\"\u001b\u0011\u0005!Q\t\u0005\b\u0005\u001fjA\u0011\u0001B)\u0011\u001d\u0011Y&\u0004C\u0001\u0005;BqAa\u0017\u000e\t\u0003\u00119\u0007C\u0004\u0003n5!\tAa\u001c\t\u000f\t5T\u0002\"\u0001\u0003t!9!QN\u0007\u0005\u0002\te\u0004b\u0002B7\u001b\u0011\u0005!\u0011\u0011\u0005\b\u0005\u0017kA\u0011\u0001BG\u0011\u001d\u0011\u0019*\u0004C\u0001\u0005+CqAa'\u000e\t\u0003\u0011i\nC\u0004\u0003$6!\tA!*\t\u000f\t%V\u0002\"\u0001\u0003,\"9!qV\u0007\u0005\u0002\tE\u0006b\u0002BX\u001b\u0011\u0005!1\u0018\u0005\b\u0005_kA\u0011\u0001Bd\u0011\u001d\u0011i.\u0004C!\u0005?DqA!:\u000e\t\u0003\u00129\u000fC\u0004\u0003p6!\tEa:\t\u000f\tEX\u0002\"\u0001\u0003h\"9!1_\u0007\u0005B\tU\bbBB\u0001\u001b\u0011\u000531\u0001\u0005\b\u0007\u000biA\u0011IB\u0004\u0003Q\teMZ5oKR\u0013\u0018M\\:g_Jl\u0017\r^5p]*\u0011A*T\u0001\u0005kRLGN\u0003\u0002O\u001f\u0006!q-Z8n\u0015\t\u0001\u0016+A\u0002kiNT!AU*\u0002\u00191|7-\u0019;j_:$Xm\u00195\u000b\u0003Q\u000b1a\u001c:h\u0007\u0001\u0001\"aV\u0001\u000e\u0003-\u0013A#\u00114gS:,GK]1og\u001a|'/\\1uS>t7CA\u0001[!\tYf,D\u0001]\u0015\u0005i\u0016!B:dC2\f\u0017BA0]\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012AV\u0001\u0013e\u00164G.Z2uS>t\u0017J\\:uC:\u001cW\rF\u0005e\u0007\u0013\u0019Ya!\u0004\u0004\u0010A\u0011q+D\n\u0005\u001bi3'\u000f\u0005\u0002h_:\u0011\u0001.\u001c\b\u0003S2l\u0011A\u001b\u0006\u0003WV\u000ba\u0001\u0010:p_Rt\u0014\"A/\n\u00059d\u0016a\u00029bG.\fw-Z\u0005\u0003aF\u0014\u0011b\u00117p]\u0016\f'\r\\3\u000b\u00059d\u0006CA:u\u001b\u0005i\u0015BA;N\u0005a\u0019un\u001c:eS:\fG/Z*fcV,gnY3GS2$XM\u001d\u000b\u0002I\u0006\u0019Q\u000e\r\u0019\u0016\u0003e\u0004\"a\u0017>\n\u0005md&A\u0002#pk\ndW-A\u0004naAzF%Z9\u0015\u0007y\f\u0019\u0001\u0005\u0002\\\u007f&\u0019\u0011\u0011\u0001/\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003\u000b\u0001\u0012\u0011!a\u0001s\u0006\u0019\u0001\u0010J\u0019\u0002\t5\u0004\u0004\u0007I\u0001\u0004[B\n\u0014aB71c}#S-\u001d\u000b\u0004}\u0006=\u0001\u0002CA\u0003'\u0005\u0005\t\u0019A=\u0002\t5\u0004\u0014\u0007I\u0001\u0004[B\u0012\u0014aB71e}#S-\u001d\u000b\u0004}\u0006e\u0001\u0002CA\u0003-\u0005\u0005\t\u0019A=\u0002\t5\u0004$\u0007I\u0001\u0004[F\u0002\u0014aB72a}#S-\u001d\u000b\u0004}\u0006\r\u0002\u0002CA\u00033\u0005\u0005\t\u0019A=\u0002\t5\f\u0004\u0007I\u0001\u0004[F\n\u0014aB72c}#S-\u001d\u000b\u0004}\u00065\u0002\u0002CA\u00039\u0005\u0005\t\u0019A=\u0002\t5\f\u0014\u0007I\u0001\u0004[F\u0012\u0014aB72e}#S-\u001d\u000b\u0004}\u0006]\u0002\u0002CA\u0003?\u0005\u0005\t\u0019A=\u0002\t5\f$\u0007\t\u000b\u0004I\u0006u\u0002bBA C\u0001\u0007\u0011\u0011I\u0001\u0007[\u0006$(/\u001b=\u0011\tm\u000b\u0019%_\u0005\u0004\u0003\u000bb&!B!se\u0006LH#\u00043\u0002J\u0005-\u0013QJA(\u0003#\n\u0019\u0006C\u0003xE\u0001\u0007\u0011\u0010\u0003\u0004\u0002\n\t\u0002\r!\u001f\u0005\u0007\u0003'\u0011\u0003\u0019A=\t\r\u0005u!\u00051\u0001z\u0011\u0019\t9C\ta\u0001s\"1\u0011\u0011\u0007\u0012A\u0002e$2\u0001ZA,\u0011\u0019\tIf\ta\u0001I\u0006)AO]1ogRiA-!\u0018\u0002h\u0005-\u0014qNA:\u0003oBq!a\u0018%\u0001\u0004\t\t'\u0001\u0003te\u000e\u0004\u0004cA:\u0002d%\u0019\u0011QM'\u0003\u0015\r{wN\u001d3j]\u0006$X\rC\u0004\u0002j\u0011\u0002\r!!\u0019\u0002\tM\u00148-\r\u0005\b\u0003[\"\u0003\u0019AA1\u0003\u0011\u0019(o\u0019\u001a\t\u000f\u0005ED\u00051\u0001\u0002b\u0005)A-Z:ua!9\u0011Q\u000f\u0013A\u0002\u0005\u0005\u0014!\u00023fgR\f\u0004bBA=I\u0001\u0007\u0011\u0011M\u0001\u0006I\u0016\u001cHOM\u0001\u000eg\u0016$Hk\\%eK:$\u0018\u000e^=\u0016\u0003\u0011\f\u0011c]3u)J\fgn\u001d4pe6\fG/[8o)5!\u00171QAC\u0003\u000f\u000bI)a#\u0002\u000e\")qO\na\u0001s\"1\u0011\u0011\u0002\u0014A\u0002eDa!a\u0005'\u0001\u0004I\bBBA\u000fM\u0001\u0007\u0011\u0010\u0003\u0004\u0002(\u0019\u0002\r!\u001f\u0005\u0007\u0003c1\u0003\u0019A=\u0015\u0007\u0011\f\t\n\u0003\u0004\u0002Z\u001d\u0002\r\u0001Z\u0001\u0011O\u0016$X*\u0019;sSb,e\u000e\u001e:jKN,\"!!\u0011\u0002\u001d\u001d,G\u000fR3uKJl\u0017N\\1oi\u0006Qq-\u001a;J]Z,'o]3)\u000b)\ni*!+\u0011\u000bm\u000by*a)\n\u0007\u0005\u0005FL\u0001\u0004uQJ|wo\u001d\t\u0004/\u0006\u0015\u0016bAAT\u0017\n!cj\u001c8j]Z,'\u000f^5cY\u0016$&/\u00198tM>\u0014X.\u0019;j_:,\u0005pY3qi&|g.M\u0004\u001f\u0003W\u000bY,a:\u0011\t\u00055\u0016Q\u0017\b\u0005\u0003_\u000b\t\f\u0005\u0002j9&\u0019\u00111\u0017/\u0002\rA\u0013X\rZ3g\u0013\u0011\t9,!/\u0003\rM#(/\u001b8h\u0015\r\t\u0019\fX\u0019\nG\u0005u\u0016QYAo\u0003\u000f,B!a0\u0002BV\u0011\u00111\u0016\u0003\b\u0003\u0007\u0004!\u0019AAg\u0005\u0005!\u0016\u0002BAd\u0003\u0013\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\n$bAAf9\u00061A\u000f\u001b:poN\fB!a4\u0002VB\u00191,!5\n\u0007\u0005MGLA\u0004O_RD\u0017N\\4\u0011\t\u0005]\u0017\u0011\u001c\b\u000376L1!a7r\u0005%!\u0006N]8xC\ndW-M\u0005$\u0003?\f\t/a9\u0002L:\u00191,!9\n\u0007\u0005-G,M\u0003#7r\u000b)OA\u0003tG\u0006d\u0017-M\u0002'\u0003G\u000bAc]3u)>\u0014VM\u001a7fGRLwN\u001c\"bg&\u001cG#\u00033\u0002n\u0006E\u0018Q_A}\u0011\u0019\tyo\u000ba\u0001s\u0006\u0011\u0001\u0010\r\u0005\u0007\u0003g\\\u0003\u0019A=\u0002\u0005e\u0004\u0004BBA|W\u0001\u0007\u00110\u0001\u0002yc!1\u00111`\u0016A\u0002e\f!!_\u0019\u0002\u001fM,G\u000fV8SK\u001adWm\u0019;j_:$\u0012\u0002\u001aB\u0001\u0005\u0007\u0011)Aa\u0002\t\r\u0005=H\u00061\u0001z\u0011\u0019\t\u0019\u0010\fa\u0001s\"1\u0011q\u001f\u0017A\u0002eDa!a?-\u0001\u0004IH#\u00023\u0003\f\t=\u0001B\u0002B\u0007[\u0001\u0007\u00110A\u0001y\u0011\u0019\u0011\t\"\fa\u0001s\u0006\t\u00110A\u0007tKR$vNU8uCRLwN\u001c\u000b\u0004I\n]\u0001B\u0002B\r]\u0001\u0007\u00110A\u0003uQ\u0016$\u0018\rF\u0003e\u0005;\u0011\t\u0003\u0003\u0004\u0003 =\u0002\r!_\u0001\tg&tG\u000b[3uC\"1!1E\u0018A\u0002e\f\u0001bY8t)\",G/\u0019\u000b\bI\n\u001d\"\u0011\u0006B\u0016\u0011\u0019\u0011I\u0002\ra\u0001s\"1!Q\u0002\u0019A\u0002eDaA!\u00051\u0001\u0004IH#\u00033\u00030\tE\"1\u0007B\u001b\u0011\u0019\u0011y\"\ra\u0001s\"1!1E\u0019A\u0002eDaA!\u00042\u0001\u0004I\bB\u0002B\tc\u0001\u0007\u00110\u0001\u0006tKR$vnU2bY\u0016$R\u0001\u001aB\u001e\u0005\u007fAaA!\u00103\u0001\u0004I\u0018A\u0002=TG\u0006dW\r\u0003\u0004\u0003BI\u0002\r!_\u0001\u0007sN\u001b\u0017\r\\3\u0002\u0015M,G\u000fV8TQ\u0016\f'\u000fF\u0003e\u0005\u000f\u0012Y\u0005\u0003\u0004\u0003JM\u0002\r!_\u0001\u0007qNCW-\u0019:\t\r\t53\u00071\u0001z\u0003\u0019I8\u000b[3be\u0006\u00012/\u001a;U_R\u0013\u0018M\\:mCRLwN\u001c\u000b\u0006I\nM#q\u000b\u0005\u0007\u0005+\"\u0004\u0019A=\u0002\u0005\u0011D\bB\u0002B-i\u0001\u0007\u00110\u0001\u0002es\u00069!/\u001a4mK\u000e$H#\u00033\u0003`\t\u0005$1\rB3\u0011\u0019\ty/\u000ea\u0001s\"1\u00111_\u001bA\u0002eDa!a>6\u0001\u0004I\bBBA~k\u0001\u0007\u0011\u0010F\u0003e\u0005S\u0012Y\u0007\u0003\u0004\u0003\u000eY\u0002\r!\u001f\u0005\u0007\u0005#1\u0004\u0019A=\u0002\rI|G/\u0019;f)\r!'\u0011\u000f\u0005\u0007\u000539\u0004\u0019A=\u0015\u000b\u0011\u0014)Ha\u001e\t\r\t}\u0001\b1\u0001z\u0011\u0019\u0011\u0019\u0003\u000fa\u0001sR9AMa\u001f\u0003~\t}\u0004B\u0002B\rs\u0001\u0007\u0011\u0010\u0003\u0004\u0003\u000ee\u0002\r!\u001f\u0005\u0007\u0005#I\u0004\u0019A=\u0015\u0013\u0011\u0014\u0019I!\"\u0003\b\n%\u0005B\u0002B\u0010u\u0001\u0007\u0011\u0010\u0003\u0004\u0003$i\u0002\r!\u001f\u0005\u0007\u0005\u001bQ\u0004\u0019A=\t\r\tE!\b1\u0001z\u0003\u0015\u00198-\u00197f)\u0015!'q\u0012BI\u0011\u0019\u0011id\u000fa\u0001s\"1!\u0011I\u001eA\u0002e\fQa\u001d5fCJ$R\u0001\u001aBL\u00053CaA!\u0013=\u0001\u0004I\bB\u0002B'y\u0001\u0007\u00110A\u0005ue\u0006t7\u000f\\1uKR)AMa(\u0003\"\"1!QB\u001fA\u0002eDaA!\u0005>\u0001\u0004I\u0018aB2p[B|7/\u001a\u000b\u0004I\n\u001d\u0006BBA-}\u0001\u0007A-A\u0007d_6\u0004xn]3CK\u001a|'/\u001a\u000b\u0004I\n5\u0006BBA-\u007f\u0001\u0007A-A\u0005ue\u0006t7OZ8s[R1\u0011\u0011\rBZ\u0005oCqA!.A\u0001\u0004\t\t'A\u0002te\u000eDqA!/A\u0001\u0004\t\t'\u0001\u0003eKN$H\u0003\u0002B_\u0005\u0007\u00042a\u001dB`\u0013\r\u0011\t-\u0014\u0002\t\u000f\u0016|W.\u001a;ss\"9!QY!A\u0002\tu\u0016!A4\u0015\u000by\u0014IMa5\t\u000f\t-'\t1\u0001\u0003N\u0006\u00191/Z9\u0011\u0007M\u0014y-C\u0002\u0003R6\u0013!cQ8pe\u0012Lg.\u0019;f'\u0016\fX/\u001a8dK\"9!Q\u001b\"A\u0002\t]\u0017!A5\u0011\u0007m\u0013I.C\u0002\u0003\\r\u00131!\u00138u\u0003\u00191\u0017\u000e\u001c;feR)aP!9\u0003d\"9!1Z\"A\u0002\t5\u0007b\u0002Bk\u0007\u0002\u0007!q[\u0001\u0012SN<Um\\7fiJL8\t[1oO\u0016$WC\u0001Bu!\rY&1^\u0005\u0004\u0005[d&a\u0002\"p_2,\u0017M\\\u0001\u0007SN$uN\\3\u0002\u0015%\u001c\u0018\nZ3oi&$\u00180\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0005S\u00149\u0010C\u0004\u0003z\u001e\u0003\rAa?\u0002\u0007=\u0014'\u000eE\u0002\\\u0005{L1Aa@]\u0005\r\te._\u0001\ti>\u001cFO]5oOR\u0011\u00111V\u0001\u0006G2|g.\u001a\u000b\u0003\u0005wDa!a<\u0004\u0001\u0004I\bBBAz\u0007\u0001\u0007\u0011\u0010\u0003\u0004\u0002x\u000e\u0001\r!\u001f\u0005\u0007\u0003w\u001c\u0001\u0019A=\u0015\u000b\u0011\u001c\u0019b!\u0006\t\r\t5A\u00011\u0001z\u0011\u0019\u0011\t\u0002\u0002a\u0001s\u0006\u0001\"o\u001c;bi&|g.\u00138ti\u0006t7-\u001a\u000b\u0004I\u000em\u0001B\u0002B\r\u000b\u0001\u0007\u0011\u0010F\u0003e\u0007?\u0019\t\u0003\u0003\u0004\u0003 \u0019\u0001\r!\u001f\u0005\u0007\u0005G1\u0001\u0019A=\u0015\u000f\u0011\u001c)ca\n\u0004*!1!\u0011D\u0004A\u0002eDaA!\u0004\b\u0001\u0004I\bB\u0002B\t\u000f\u0001\u0007\u0011\u0010F\u0005e\u0007[\u0019yc!\r\u00044!1!q\u0004\u0005A\u0002eDaAa\t\t\u0001\u0004I\bB\u0002B\u0007\u0011\u0001\u0007\u0011\u0010\u0003\u0004\u0003\u0012!\u0001\r!_\u0001\u000eg\u000e\fG.Z%ogR\fgnY3\u0015\u000b\u0011\u001cIda\u000f\t\r\tu\u0012\u00021\u0001z\u0011\u0019\u0011\t%\u0003a\u0001sRIAma\u0010\u0004B\r\r3Q\t\u0005\u0007\u0005{Q\u0001\u0019A=\t\r\t\u0005#\u00021\u0001z\u0011\u0019\u0011iA\u0003a\u0001s\"1!\u0011\u0003\u0006A\u0002e\fQb\u001d5fCJLen\u001d;b]\u000e,G#\u00023\u0004L\r5\u0003B\u0002B%\u0017\u0001\u0007\u0011\u0010\u0003\u0004\u0003N-\u0001\r!_\u0001\u0014iJ\fgn\u001d7bi&|g.\u00138ti\u0006t7-\u001a\u000b\u0006I\u000eM3Q\u000b\u0005\u0007\u0005\u001ba\u0001\u0019A=\t\r\tEA\u00021\u0001z\u0001")
public class AffineTransformation
implements Cloneable,
CoordinateSequenceFilter {
    private double m00;
    private double m01;
    private double m02;
    private double m10;
    private double m11;
    private double m12;
    private volatile byte bitmap$init$0;

    public static AffineTransformation translationInstance(double d, double d2) {
        return AffineTransformation$.MODULE$.translationInstance(d, d2);
    }

    public static AffineTransformation shearInstance(double d, double d2) {
        return AffineTransformation$.MODULE$.shearInstance(d, d2);
    }

    public static AffineTransformation scaleInstance(double d, double d2, double d3, double d4) {
        return AffineTransformation$.MODULE$.scaleInstance(d, d2, d3, d4);
    }

    public static AffineTransformation scaleInstance(double d, double d2) {
        return AffineTransformation$.MODULE$.scaleInstance(d, d2);
    }

    public static AffineTransformation rotationInstance(double d, double d2, double d3, double d4) {
        return AffineTransformation$.MODULE$.rotationInstance(d, d2, d3, d4);
    }

    public static AffineTransformation rotationInstance(double d, double d2, double d3) {
        return AffineTransformation$.MODULE$.rotationInstance(d, d2, d3);
    }

    public static AffineTransformation rotationInstance(double d, double d2) {
        return AffineTransformation$.MODULE$.rotationInstance(d, d2);
    }

    public static AffineTransformation rotationInstance(double d) {
        return AffineTransformation$.MODULE$.rotationInstance(d);
    }

    public static AffineTransformation reflectionInstance(double d, double d2) {
        return AffineTransformation$.MODULE$.reflectionInstance(d, d2);
    }

    public static AffineTransformation reflectionInstance(double d, double d2, double d3, double d4) {
        return AffineTransformation$.MODULE$.reflectionInstance(d, d2, d3, d4);
    }

    private double m00() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/geom/util/AffineTransformation.scala: 243");
        }
        return this.m00;
    }

    private void m00_$eq(double x$1) {
        this.m00 = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
    }

    private double m01() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/geom/util/AffineTransformation.scala: 244");
        }
        return this.m01;
    }

    private void m01_$eq(double x$1) {
        this.m01 = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
    }

    private double m02() {
        if ((byte)(this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/geom/util/AffineTransformation.scala: 245");
        }
        return this.m02;
    }

    private void m02_$eq(double x$1) {
        this.m02 = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
    }

    private double m10() {
        if ((byte)(this.bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/geom/util/AffineTransformation.scala: 246");
        }
        return this.m10;
    }

    private void m10_$eq(double x$1) {
        this.m10 = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
    }

    private double m11() {
        if ((byte)(this.bitmap$init$0 & 0x10) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/geom/util/AffineTransformation.scala: 247");
        }
        return this.m11;
    }

    private void m11_$eq(double x$1) {
        this.m11 = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x10);
    }

    private double m12() {
        if ((byte)(this.bitmap$init$0 & 0x20) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/geom/util/AffineTransformation.scala: 248");
        }
        return this.m12;
    }

    private void m12_$eq(double x$1) {
        this.m12 = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x20);
    }

    public AffineTransformation setToIdentity() {
        this.m00_$eq(1.0);
        this.m01_$eq(0.0);
        this.m02_$eq(0.0);
        this.m10_$eq(0.0);
        this.m11_$eq(1.0);
        this.m12_$eq(0.0);
        return this;
    }

    public AffineTransformation setTransformation(double m00, double m01, double m02, double m10, double m11, double m12) {
        this.m00_$eq(m00);
        this.m01_$eq(m01);
        this.m02_$eq(m02);
        this.m10_$eq(m10);
        this.m11_$eq(m11);
        this.m12_$eq(m12);
        return this;
    }

    public AffineTransformation setTransformation(AffineTransformation trans) {
        this.m00_$eq(trans.m00());
        this.m01_$eq(trans.m01());
        this.m02_$eq(trans.m02());
        this.m10_$eq(trans.m10());
        this.m11_$eq(trans.m11());
        this.m12_$eq(trans.m12());
        return this;
    }

    public double[] getMatrixEntries() {
        return (double[])Array$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{this.m00(), this.m01(), this.m02(), this.m10(), this.m11(), this.m12()}), (ClassTag)ClassTag$.MODULE$.Double());
    }

    public double getDeterminant() {
        return this.m00() * this.m11() - this.m01() * this.m10();
    }

    public AffineTransformation getInverse() throws NoninvertibleTransformationException {
        double det = this.getDeterminant();
        if (det == 0.0) {
            throw new NoninvertibleTransformationException("Transformation is non-invertible");
        }
        double im00 = this.m11() / det;
        double im10 = -this.m10() / det;
        double im01 = -this.m01() / det;
        double im11 = this.m00() / det;
        double im02 = (this.m01() * this.m12() - this.m02() * this.m11()) / det;
        double im12 = (-this.m00() * this.m12() + this.m10() * this.m02()) / det;
        return new AffineTransformation(im00, im01, im02, im10, im11, im12);
    }

    public AffineTransformation setToReflectionBasic(double x0, double y0, double x1, double y1) {
        if (x0 == x1 && y0 == y1) {
            throw new IllegalArgumentException("Reflection line points must be distinct");
        }
        double dx = x1 - x0;
        double dy = y1 - y0;
        double d = Math.sqrt(dx * dx + dy * dy);
        double sin = dy / d;
        double cos = dx / d;
        double cs2 = (double)2 * sin * cos;
        double c2s2 = cos * cos - sin * sin;
        this.m00_$eq(c2s2);
        this.m01_$eq(cs2);
        this.m02_$eq(0.0);
        this.m10_$eq(cs2);
        this.m11_$eq(-c2s2);
        this.m12_$eq(0.0);
        return this;
    }

    public AffineTransformation setToReflection(double x0, double y0, double x1, double y1) {
        if (x0 == x1 && y0 == y1) {
            throw new IllegalArgumentException("Reflection line points must be distinct");
        }
        this.setToTranslation(-x0, -y0);
        double dx = x1 - x0;
        double dy = y1 - y0;
        double d = Math.sqrt(dx * dx + dy * dy);
        double sin = dy / d;
        double cos = dx / d;
        this.rotate(-sin, cos);
        this.scale(1.0, -1.0);
        this.rotate(sin, cos);
        this.translate(x0, y0);
        return this;
    }

    public AffineTransformation setToReflection(double x, double y) {
        if (x == 0.0 && y == 0.0) {
            throw new IllegalArgumentException("Reflection vector must be non-zero");
        }
        if (x == y) {
            this.m00_$eq(0.0);
            this.m01_$eq(1.0);
            this.m02_$eq(0.0);
            this.m10_$eq(1.0);
            this.m11_$eq(0.0);
            this.m12_$eq(0.0);
            return this;
        }
        double d = Math.sqrt(x * x + y * y);
        double sin = y / d;
        double cos = x / d;
        this.rotate(-sin, cos);
        this.scale(1.0, -1.0);
        this.rotate(sin, cos);
        return this;
    }

    public AffineTransformation setToRotation(double theta) {
        this.setToRotation(Math.sin(theta), Math.cos(theta));
        return this;
    }

    public AffineTransformation setToRotation(double sinTheta, double cosTheta) {
        this.m00_$eq(cosTheta);
        this.m01_$eq(-sinTheta);
        this.m02_$eq(0.0);
        this.m10_$eq(sinTheta);
        this.m11_$eq(cosTheta);
        this.m12_$eq(0.0);
        return this;
    }

    public AffineTransformation setToRotation(double theta, double x, double y) {
        this.setToRotation(Math.sin(theta), Math.cos(theta), x, y);
        return this;
    }

    public AffineTransformation setToRotation(double sinTheta, double cosTheta, double x, double y) {
        this.m00_$eq(cosTheta);
        this.m01_$eq(-sinTheta);
        this.m02_$eq(x - x * cosTheta + y * sinTheta);
        this.m10_$eq(sinTheta);
        this.m11_$eq(cosTheta);
        this.m12_$eq(y - x * sinTheta - y * cosTheta);
        return this;
    }

    public AffineTransformation setToScale(double xScale, double yScale) {
        this.m00_$eq(xScale);
        this.m01_$eq(0.0);
        this.m02_$eq(0.0);
        this.m10_$eq(0.0);
        this.m11_$eq(yScale);
        this.m12_$eq(0.0);
        return this;
    }

    public AffineTransformation setToShear(double xShear, double yShear) {
        this.m00_$eq(1.0);
        this.m01_$eq(xShear);
        this.m02_$eq(0.0);
        this.m10_$eq(yShear);
        this.m11_$eq(1.0);
        this.m12_$eq(0.0);
        return this;
    }

    public AffineTransformation setToTranslation(double dx, double dy) {
        this.m00_$eq(1.0);
        this.m01_$eq(0.0);
        this.m02_$eq(dx);
        this.m10_$eq(0.0);
        this.m11_$eq(1.0);
        this.m12_$eq(dy);
        return this;
    }

    public AffineTransformation reflect(double x0, double y0, double x1, double y1) {
        this.compose(AffineTransformation$.MODULE$.reflectionInstance(x0, y0, x1, y1));
        return this;
    }

    public AffineTransformation reflect(double x, double y) {
        this.compose(AffineTransformation$.MODULE$.reflectionInstance(x, y));
        return this;
    }

    public AffineTransformation rotate(double theta) {
        this.compose(AffineTransformation$.MODULE$.rotationInstance(theta));
        return this;
    }

    public AffineTransformation rotate(double sinTheta, double cosTheta) {
        this.compose(AffineTransformation$.MODULE$.rotationInstance(sinTheta, cosTheta));
        return this;
    }

    public AffineTransformation rotate(double theta, double x, double y) {
        this.compose(AffineTransformation$.MODULE$.rotationInstance(theta, x, y));
        return this;
    }

    public AffineTransformation rotate(double sinTheta, double cosTheta, double x, double y) {
        this.compose(AffineTransformation$.MODULE$.rotationInstance(sinTheta, cosTheta, x, y));
        return this;
    }

    public AffineTransformation scale(double xScale, double yScale) {
        this.compose(AffineTransformation$.MODULE$.scaleInstance(xScale, yScale));
        return this;
    }

    public AffineTransformation shear(double xShear, double yShear) {
        this.compose(AffineTransformation$.MODULE$.shearInstance(xShear, yShear));
        return this;
    }

    public AffineTransformation translate(double x, double y) {
        this.compose(AffineTransformation$.MODULE$.translationInstance(x, y));
        return this;
    }

    public AffineTransformation compose(AffineTransformation trans) {
        double mp00 = trans.m00() * this.m00() + trans.m01() * this.m10();
        double mp01 = trans.m00() * this.m01() + trans.m01() * this.m11();
        double mp02 = trans.m00() * this.m02() + trans.m01() * this.m12() + trans.m02();
        double mp10 = trans.m10() * this.m00() + trans.m11() * this.m10();
        double mp11 = trans.m10() * this.m01() + trans.m11() * this.m11();
        double mp12 = trans.m10() * this.m02() + trans.m11() * this.m12() + trans.m12();
        this.m00_$eq(mp00);
        this.m01_$eq(mp01);
        this.m02_$eq(mp02);
        this.m10_$eq(mp10);
        this.m11_$eq(mp11);
        this.m12_$eq(mp12);
        return this;
    }

    public AffineTransformation composeBefore(AffineTransformation trans) {
        double mp00 = this.m00() * trans.m00() + this.m01() * trans.m10();
        double mp01 = this.m00() * trans.m01() + this.m01() * trans.m11();
        double mp02 = this.m00() * trans.m02() + this.m01() * trans.m12() + this.m02();
        double mp10 = this.m10() * trans.m00() + this.m11() * trans.m10();
        double mp11 = this.m10() * trans.m01() + this.m11() * trans.m11();
        double mp12 = this.m10() * trans.m02() + this.m11() * trans.m12() + this.m12();
        this.m00_$eq(mp00);
        this.m01_$eq(mp01);
        this.m02_$eq(mp02);
        this.m10_$eq(mp10);
        this.m11_$eq(mp11);
        this.m12_$eq(mp12);
        return this;
    }

    public Coordinate transform(Coordinate src, Coordinate dest) {
        double xp = this.m00() * src.x() + this.m01() * src.y() + this.m02();
        double yp = this.m10() * src.x() + this.m11() * src.y() + this.m12();
        dest.x_$eq(xp);
        dest.y_$eq(yp);
        return dest;
    }

    /*
     * WARNING - void declaration
     */
    public Geometry transform(Geometry g) {
        void var2_2;
        Geometry g2 = g.copy();
        g2.applyF(this);
        return var2_2;
    }

    public void transform(CoordinateSequence seq, int i) {
        double xp = this.m00() * seq.getOrdinate(i, 0) + this.m01() * seq.getOrdinate(i, 1) + this.m02();
        double yp = this.m10() * seq.getOrdinate(i, 0) + this.m11() * seq.getOrdinate(i, 1) + this.m12();
        seq.setOrdinate(i, 0, xp);
        seq.setOrdinate(i, 1, yp);
    }

    @Override
    public void filter(CoordinateSequence seq, int i) {
        this.transform(seq, i);
    }

    @Override
    public boolean isGeometryChanged() {
        return true;
    }

    @Override
    public boolean isDone() {
        return false;
    }

    public boolean isIdentity() {
        return this.m00() == 1.0 && this.m01() == 0.0 && this.m02() == 0.0 && this.m10() == 0.0 && this.m11() == 1.0 && this.m12() == 0.0;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AffineTransformation)) {
            return false;
        }
        AffineTransformation trans = (AffineTransformation)obj;
        return this.m00() == trans.m00() && this.m01() == trans.m01() && this.m02() == trans.m02() && this.m10() == trans.m10() && this.m11() == trans.m11() && this.m12() == trans.m12();
    }

    public String toString() {
        return new StringBuilder(36).append("AffineTransformation[[").append(this.m00()).append(", ").append(this.m01()).append(", ").append(this.m02()).append("], [").append(this.m10()).append(", ").append(this.m11()).append(", ").append(this.m12()).append("]]").toString();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception exception) {
            Assert$.MODULE$.shouldNeverReachHere();
            return null;
        }
    }

    public AffineTransformation() {
        this.setToIdentity();
        this.m00 = 0.0;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.m01 = 0.0;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.m02 = 0.0;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
        this.m10 = 0.0;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
        this.m11 = 0.0;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x10);
        this.m12 = 0.0;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x20);
    }

    public AffineTransformation(double[] matrix) {
        this();
        this.m00_$eq(matrix[0]);
        this.m01_$eq(matrix[1]);
        this.m02_$eq(matrix[2]);
        this.m10_$eq(matrix[3]);
        this.m11_$eq(matrix[4]);
        this.m12_$eq(matrix[5]);
    }

    public AffineTransformation(double m00, double m01, double m02, double m10, double m11, double m12) {
        this();
        this.setTransformation(m00, m01, m02, m10, m11, m12);
    }

    public AffineTransformation(AffineTransformation trans) {
        this();
        this.setTransformation(trans);
    }

    public AffineTransformation(Coordinate src0, Coordinate src1, Coordinate src2, Coordinate dest0, Coordinate dest1, Coordinate dest2) {
        this();
    }
}

