/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom.util;

import java.util.ArrayList;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.util.Assert$;
import scala.Array$;
import scala.UninitializedFieldError;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005ur!B\u000f\u001f\u0011\u0003Ic!B\u0016\u001f\u0011\u0003a\u0003\"B\u001a\u0002\t\u0003!daB\u001b\u0002!\u0003\r\nA\u000e\u0005\u0006o\r1\t\u0001\u000f\u0004\u0005\t\u0006\u0001Q\tC\u00034\u000b\u0011\u0005\u0001\nC\u00038\u000b\u0011\u00053JB\u0003O\u0003\u0005\u0005q\nC\u00034\u0011\u0011\u0005\u0001\u000bC\u00038\u0011\u0011\u0015#\u000bC\u00038\u0011\u0019\u0005QKB\u0003`\u0003\u0005\u0005\u0001\rC\u00034\u0019\u0011\u0005\u0011\rC\u00038\u0019\u0011\u00153\rC\u00038\u0019\u0019\u0005aM\u0002\u0003,=\u0001i\u0007\u0002\u0003!\u0011\u0005\u0003\u0007I\u0011\u00018\t\u0011=\u0004\"\u00111A\u0005\u0002AD\u0001B\u001e\t\u0003\u0002\u0003\u0006K!\u0011\u0005\u0006gA!\ta\u001e\u0005\buB\u0001\r\u0011\"\u0003|\u0011!y\b\u00031A\u0005\n\u0005\u0005\u0001bBA\u0003!\u0001\u0006K\u0001 \u0005\b\u0003\u000f\u0001B\u0011AA\u0005\u0011\u00199\u0004\u0003\"\u0001\u0002\u000e!9\u0011Q\u0003\t\u0005\n\u0005]\u0001bBA\u000f!\u0011%\u0011q\u0004\u0005\b\u0003[\u0001B\u0011BA\u0018\u000399Um\\7fiJLX\tZ5u_JT!a\b\u0011\u0002\tU$\u0018\u000e\u001c\u0006\u0003C\t\nAaZ3p[*\u00111\u0005J\u0001\u0004UR\u001c(BA\u0013'\u00031awnY1uS>tG/Z2i\u0015\u00059\u0013aA8sO\u000e\u0001\u0001C\u0001\u0016\u0002\u001b\u0005q\"AD$f_6,GO]=FI&$xN]\n\u0003\u00035\u0002\"AL\u0019\u000e\u0003=R\u0011\u0001M\u0001\u0006g\u000e\fG.Y\u0005\u0003e=\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001*\u0005]9Um\\7fiJLX\tZ5u_J|\u0005/\u001a:bi&|gn\u0005\u0002\u0004[\u0005!Q\rZ5u)\rITh\u0010\t\u0003umj\u0011\u0001I\u0005\u0003y\u0001\u0012\u0001bR3p[\u0016$(/\u001f\u0005\u0006}\u0011\u0001\r!O\u0001\tO\u0016|W.\u001a;ss\")\u0001\t\u0002a\u0001\u0003\u00069a-Y2u_JL\bC\u0001\u001eC\u0013\t\u0019\u0005EA\bHK>lW\r\u001e:z\r\u0006\u001cGo\u001c:z\u0005Uqun\u00149HK>lW\r\u001e:z\u001fB,'/\u0019;j_:\u001c2!B\u0017G!\t95A\u0004\u0002+\u0001Q\t\u0011\n\u0005\u0002K\u000b5\t\u0011\u0001F\u0002:\u00196CQAP\u0004A\u0002eBQ\u0001Q\u0004A\u0002\u0005\u00131cQ8pe\u0012Lg.\u0019;f\u001fB,'/\u0019;j_:\u001c2\u0001C\u0017G)\u0005\t\u0006C\u0001&\t)\rI4\u000b\u0016\u0005\u0006})\u0001\r!\u000f\u0005\u0006\u0001*\u0001\r!\u0011\u000b\u0004-rs\u0006c\u0001\u0018X3&\u0011\u0001l\f\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003uiK!a\u0017\u0011\u0003\u0015\r{wN\u001d3j]\u0006$X\rC\u0003^\u0017\u0001\u0007a+A\u0006d_>\u0014H-\u001b8bi\u0016\u001c\b\"\u0002 \f\u0001\u0004I$aG\"p_J$\u0017N\\1uKN+\u0017/^3oG\u0016|\u0005/\u001a:bi&|gnE\u0002\r[\u0019#\u0012A\u0019\t\u0003\u00152!2!\u000f3f\u0011\u0015qd\u00021\u0001:\u0011\u0015\u0001e\u00021\u0001B)\r9'\u000e\u001c\t\u0003u!L!!\u001b\u0011\u0003%\r{wN\u001d3j]\u0006$XmU3rk\u0016t7-\u001a\u0005\u0006W>\u0001\raZ\u0001\tG>|'\u000fZ*fc\")ah\u0004a\u0001sM\u0011\u0001#L\u000b\u0002\u0003\u0006Ya-Y2u_JLx\fJ3r)\t\tH\u000f\u0005\u0002/e&\u00111o\f\u0002\u0005+:LG\u000fC\u0004v%\u0005\u0005\t\u0019A!\u0002\u0007a$\u0013'\u0001\u0005gC\u000e$xN]=!)\tA\u0018\u0010\u0005\u0002+!!)\u0001\t\u0006a\u0001\u0003\u0006\u0001\u0012n]+tKJ$\u0015\r^1D_BLW\rZ\u000b\u0002yB\u0011a&`\u0005\u0003}>\u0012qAQ8pY\u0016\fg.\u0001\u000bjgV\u001bXM\u001d#bi\u0006\u001cu\u000e]5fI~#S-\u001d\u000b\u0004c\u0006\r\u0001bB;\u0017\u0003\u0003\u0005\r\u0001`\u0001\u0012SN,6/\u001a:ECR\f7i\u001c9jK\u0012\u0004\u0013aD:fi\u000e{\u0007/_+tKJ$\u0015\r^1\u0015\u0007E\fY\u0001C\u0003{1\u0001\u0007A\u0010F\u0003:\u0003\u001f\t\t\u0002C\u0003?3\u0001\u0007\u0011\b\u0003\u0004\u0002\u0014e\u0001\rAR\u0001\n_B,'/\u0019;j_:\fA\"\u001a3ji&sG/\u001a:oC2$R!OA\r\u00037AQA\u0010\u000eA\u0002eBa!a\u0005\u001b\u0001\u00041\u0015aC3eSR\u0004v\u000e\\=h_:$b!!\t\u0002(\u0005-\u0002c\u0001\u001e\u0002$%\u0019\u0011Q\u0005\u0011\u0003\u000fA{G._4p]\"9\u0011\u0011F\u000eA\u0002\u0005\u0005\u0012a\u00029pYf<wN\u001c\u0005\u0007\u0003'Y\u0002\u0019\u0001$\u0002-\u0015$\u0017\u000e^$f_6,GO]=D_2dWm\u0019;j_:$b!!\r\u00028\u0005m\u0002c\u0001\u001e\u00024%\u0019\u0011Q\u0007\u0011\u0003%\u001d+w.\\3uef\u001cu\u000e\u001c7fGRLwN\u001c\u0005\b\u0003sa\u0002\u0019AA\u0019\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\u0005\u0007\u0003'a\u0002\u0019\u0001$")
public class GeometryEditor {
    private GeometryFactory factory;
    private boolean isUserDataCopied;
    private volatile boolean bitmap$init$0;

    public GeometryFactory factory() {
        return this.factory;
    }

    public void factory_$eq(GeometryFactory x$1) {
        this.factory = x$1;
    }

    private boolean isUserDataCopied() {
        if (!this.bitmap$init$0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/geom/util/GeometryEditor.scala: 179");
        }
        return this.isUserDataCopied;
    }

    private void isUserDataCopied_$eq(boolean x$1) {
        this.isUserDataCopied = x$1;
        this.bitmap$init$0 = true;
    }

    public void setCopyUserData(boolean isUserDataCopied) {
        this.isUserDataCopied_$eq(isUserDataCopied);
    }

    /*
     * WARNING - void declaration
     */
    public Geometry edit(Geometry geometry, GeometryEditorOperation operation) {
        void var3_3;
        block1: {
            if (geometry == null) {
                return null;
            }
            Geometry result = this.editInternal(geometry, operation);
            if (!this.isUserDataCopied()) break block1;
            result.setUserData(geometry.getUserData());
        }
        return var3_3;
    }

    private Geometry editInternal(Geometry geometry, GeometryEditorOperation operation) {
        if (this.factory() == null) {
            this.factory_$eq(geometry.getFactory());
        }
        if (geometry instanceof GeometryCollection) {
            return this.editGeometryCollection((GeometryCollection)geometry, operation);
        }
        if (geometry instanceof Polygon) {
            return this.editPolygon((Polygon)geometry, operation);
        }
        if (geometry instanceof Point) {
            return operation.edit(geometry, this.factory());
        }
        if (geometry instanceof LineString) {
            return operation.edit(geometry, this.factory());
        }
        Assert$.MODULE$.shouldNeverReachHere(new StringBuilder(28).append("Unsupported Geometry class: ").append(geometry.getClass().getName()).toString());
        return null;
    }

    private Polygon editPolygon(Polygon polygon, GeometryEditorOperation operation) {
        Polygon newPolygon = (Polygon)operation.edit(polygon, this.factory());
        if (newPolygon == null) {
            newPolygon = this.factory().createPolygon();
        }
        if (newPolygon.isEmpty()) {
            return newPolygon;
        }
        LinearRing shell = (LinearRing)this.edit(newPolygon.getExteriorRing(), operation);
        if (shell == null || shell.isEmpty()) {
            return this.factory().createPolygon();
        }
        ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
        for (int i = 0; i < newPolygon.getNumInteriorRing(); ++i) {
            LinearRing hole = (LinearRing)this.edit(newPolygon.getInteriorRingN(i), operation);
            Object object = hole != null && !hole.isEmpty() ? BoxesRunTime.boxToBoolean((boolean)holes.add(hole)) : BoxedUnit.UNIT;
        }
        return this.factory().createPolygon(shell, (LinearRing[])holes.toArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(LinearRing.class))));
    }

    private GeometryCollection editGeometryCollection(GeometryCollection collection, GeometryEditorOperation operation) {
        GeometryCollection collectionForType = (GeometryCollection)operation.edit(collection, this.factory());
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        for (int i = 0; i < collectionForType.getNumGeometries(); ++i) {
            Geometry geometry = this.edit(collectionForType.getGeometryN(i), operation);
            Object object = geometry != null && !geometry.isEmpty() ? BoxesRunTime.boxToBoolean((boolean)geometries.add(geometry)) : BoxedUnit.UNIT;
        }
        if (collectionForType.getClass() == MultiPoint.class) {
            return this.factory().createMultiPoint((Point[])geometries.toArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Point.class))));
        }
        if (collectionForType.getClass() == MultiLineString.class) {
            return this.factory().createMultiLineString((LineString[])geometries.toArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(LineString.class))));
        }
        if (collectionForType.getClass() == MultiPolygon.class) {
            return this.factory().createMultiPolygon((Polygon[])geometries.toArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Polygon.class))));
        }
        return this.factory().createGeometryCollection((Geometry[])geometries.toArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Geometry.class))));
    }

    public GeometryEditor(GeometryFactory factory) {
        this.factory = factory;
        this.isUserDataCopied = false;
        this.bitmap$init$0 = true;
    }

    public static abstract class CoordinateOperation
    implements GeometryEditorOperation {
        @Override
        public final Geometry edit(Geometry geometry, GeometryFactory factory) {
            if (geometry instanceof LinearRing) {
                return factory.createLinearRing(this.edit(geometry.getCoordinates(), geometry));
            }
            if (geometry instanceof LineString) {
                return factory.createLineString(this.edit(geometry.getCoordinates(), geometry));
            }
            if (geometry instanceof Point) {
                Coordinate[] newCoordinates = this.edit(geometry.getCoordinates(), geometry);
                return factory.createPoint(newCoordinates.length > 0 ? newCoordinates[0] : null);
            }
            return geometry;
        }

        public abstract Coordinate[] edit(Coordinate[] var1, Geometry var2);
    }

    public static abstract class CoordinateSequenceOperation
    implements GeometryEditorOperation {
        @Override
        public final Geometry edit(Geometry geometry, GeometryFactory factory) {
            if (geometry instanceof LinearRing) {
                return factory.createLinearRing(this.edit(((LinearRing)geometry).getCoordinateSequence(), geometry));
            }
            if (geometry instanceof LineString) {
                return factory.createLineString(this.edit(((LineString)geometry).getCoordinateSequence(), geometry));
            }
            if (geometry instanceof Point) {
                return factory.createPoint(this.edit(((Point)geometry).getCoordinateSequence(), geometry));
            }
            return geometry;
        }

        public abstract CoordinateSequence edit(CoordinateSequence var1, Geometry var2);
    }

    public static interface GeometryEditorOperation {
        public Geometry edit(Geometry var1, GeometryFactory var2);
    }

    public static class NoOpGeometryOperation
    implements GeometryEditorOperation {
        @Override
        public Geometry edit(Geometry geometry, GeometryFactory factory) {
            return geometry;
        }
    }
}

