/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom.util;

import java.util.ArrayList;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.GeometryFactory$;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import scala.Array$;
import scala.UninitializedFieldError;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005-c\u0001B\u000e\u001d\u0001\u001dBQA\f\u0001\u0005\u0002=BqA\r\u0001A\u0002\u0013%1\u0007C\u00049\u0001\u0001\u0007I\u0011B\u001d\t\r}\u0002\u0001\u0015)\u00035\u0011\u001d\u0001\u0005\u00011A\u0005\u0012\u0005Cq!\u0012\u0001A\u0002\u0013Ea\t\u0003\u0004I\u0001\u0001\u0006KA\u0011\u0005\b\u0013\u0002\u0011\r\u0011\"\u0003K\u0011\u0019q\u0005\u0001)A\u0005\u0017\"9q\n\u0001b\u0001\n\u0013Q\u0005B\u0002)\u0001A\u0003%1\nC\u0004R\u0001\t\u0007I\u0011\u0002&\t\rI\u0003\u0001\u0015!\u0003L\u0011\u0015\u0019\u0006\u0001\"\u00014\u0011\u0015!\u0006\u0001\"\u0002V\u0011\u00159\u0006\u0001\"\u0006Y\u0011\u0015!\u0007\u0001\"\u0006f\u0011\u0015A\u0007\u0001\"\u0005j\u0011\u0015i\u0007\u0001\"\u0005o\u0011\u0015!\b\u0001\"\u0005v\u0011\u0015Y\b\u0001\"\u0005}\u0011\u001d\t)\u0001\u0001C\t\u0003\u000fAq!a\u0005\u0001\t#\t)\u0002C\u0004\u0002\"\u0001!\t\"a\t\t\u000f\u0005=\u0002\u0001\"\u0005\u00022!9\u0011Q\b\u0001\u0005\u0012\u0005}\"aE$f_6,GO]=Ue\u0006t7OZ8s[\u0016\u0014(BA\u000f\u001f\u0003\u0011)H/\u001b7\u000b\u0005}\u0001\u0013\u0001B4f_6T!!\t\u0012\u0002\u0007)$8O\u0003\u0002$I\u0005aAn\\2bi&|g\u000e^3dQ*\tQ%A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001QA\u0011\u0011\u0006L\u0007\u0002U)\t1&A\u0003tG\u0006d\u0017-\u0003\u0002.U\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u0019\u0011\u0005E\u0002Q\"\u0001\u000f\u0002\u0013%t\u0007/\u001e;HK>lW#\u0001\u001b\u0011\u0005U2T\"\u0001\u0010\n\u0005]r\"\u0001C$f_6,GO]=\u0002\u001b%t\u0007/\u001e;HK>lw\fJ3r)\tQT\b\u0005\u0002*w%\u0011AH\u000b\u0002\u0005+:LG\u000fC\u0004?\u0007\u0005\u0005\t\u0019\u0001\u001b\u0002\u0007a$\u0013'\u0001\u0006j]B,HoR3p[\u0002\nqAZ1di>\u0014\u00180F\u0001C!\t)4)\u0003\u0002E=\tyq)Z8nKR\u0014\u0018PR1di>\u0014\u00180A\u0006gC\u000e$xN]=`I\u0015\fHC\u0001\u001eH\u0011\u001dqd!!AA\u0002\t\u000b\u0001BZ1di>\u0014\u0018\u0010I\u0001\u0013aJ,h.Z#naRLx)Z8nKR\u0014\u00180F\u0001L!\tIC*\u0003\u0002NU\t9!i\\8mK\u0006t\u0017a\u00059sk:,W)\u001c9us\u001e+w.\\3uef\u0004\u0013A\b9sKN,'O^3HK>lW\r\u001e:z\u0007>dG.Z2uS>tG+\u001f9f\u0003}\u0001(/Z:feZ,w)Z8nKR\u0014\u0018pQ8mY\u0016\u001cG/[8o)f\u0004X\rI\u0001\raJ,7/\u001a:wKRK\b/Z\u0001\u000eaJ,7/\u001a:wKRK\b/\u001a\u0011\u0002!\u001d,G/\u00138qkR<Um\\7fiJL\u0018!\u0003;sC:\u001chm\u001c:n)\t!d\u000bC\u00033\u001f\u0001\u0007A'\u0001\rde\u0016\fG/Z\"p_J$\u0017N\\1uKN+\u0017/^3oG\u0016$\"!\u0017/\u0011\u0005UR\u0016BA.\u001f\u0005I\u0019un\u001c:eS:\fG/Z*fcV,gnY3\t\u000bu\u0003\u0002\u0019\u00010\u0002\r\r|wN\u001d3t!\rIs,Y\u0005\u0003A*\u0012Q!\u0011:sCf\u0004\"!\u000e2\n\u0005\rt\"AC\"p_J$\u0017N\\1uK\u0006!1m\u001c9z)\tIf\rC\u0003h#\u0001\u0007\u0011,A\u0002tKF\fA\u0003\u001e:b]N4wN]7D_>\u0014H-\u001b8bi\u0016\u001cHcA-kW\")QL\u0005a\u00013\")AN\u0005a\u0001i\u00051\u0001/\u0019:f]R\fa\u0002\u001e:b]N4wN]7Q_&tG\u000fF\u0002peN\u0004\"!\u000e9\n\u0005Et\"!\u0002)pS:$\b\"B\u0010\u0014\u0001\u0004y\u0007\"\u00027\u0014\u0001\u0004!\u0014a\u0005;sC:\u001chm\u001c:n\u001bVdG/\u001b)pS:$Hc\u0001\u001bwu\")q\u0004\u0006a\u0001oB\u0011Q\u0007_\u0005\u0003sz\u0011!\"T;mi&\u0004v.\u001b8u\u0011\u0015aG\u00031\u00015\u0003M!(/\u00198tM>\u0014X\u000eT5oK\u0006\u0014(+\u001b8h)\u0011!T0a\u0001\t\u000b})\u0002\u0019\u0001@\u0011\u0005Uz\u0018bAA\u0001=\tQA*\u001b8fCJ\u0014\u0016N\\4\t\u000b1,\u0002\u0019\u0001\u001b\u0002'Q\u0014\u0018M\\:g_JlG*\u001b8f'R\u0014\u0018N\\4\u0015\r\u0005%\u0011qBA\t!\r)\u00141B\u0005\u0004\u0003\u001bq\"A\u0003'j]\u0016\u001cFO]5oO\"1qD\u0006a\u0001\u0003\u0013AQ\u0001\u001c\fA\u0002Q\n\u0001\u0004\u001e:b]N4wN]7Nk2$\u0018\u000eT5oKN#(/\u001b8h)\u0015!\u0014qCA\u0010\u0011\u0019yr\u00031\u0001\u0002\u001aA\u0019Q'a\u0007\n\u0007\u0005uaDA\bNk2$\u0018\u000eT5oKN#(/\u001b8h\u0011\u0015aw\u00031\u00015\u0003A!(/\u00198tM>\u0014X\u000eU8ms\u001e|g\u000eF\u00035\u0003K\ti\u0003\u0003\u0004 1\u0001\u0007\u0011q\u0005\t\u0004k\u0005%\u0012bAA\u0016=\t9\u0001k\u001c7zO>t\u0007\"\u00027\u0019\u0001\u0004!\u0014!\u0006;sC:\u001chm\u001c:n\u001bVdG/\u001b)pYf<wN\u001c\u000b\u0006i\u0005M\u00121\b\u0005\u0007?e\u0001\r!!\u000e\u0011\u0007U\n9$C\u0002\u0002:y\u0011A\"T;mi&\u0004v\u000e\\=h_:DQ\u0001\\\rA\u0002Q\n1\u0004\u001e:b]N4wN]7HK>lW\r\u001e:z\u0007>dG.Z2uS>tG#\u0002\u001b\u0002B\u0005%\u0003BB\u0010\u001b\u0001\u0004\t\u0019\u0005E\u00026\u0003\u000bJ1!a\u0012\u001f\u0005I9Um\\7fiJL8i\u001c7mK\u000e$\u0018n\u001c8\t\u000b1T\u0002\u0019\u0001\u001b")
public class GeometryTransformer {
    private Geometry inputGeom = null;
    private GeometryFactory factory = null;
    private final boolean pruneEmptyGeometry;
    private final boolean preserveGeometryCollectionType;
    private final boolean preserveType;
    private volatile byte bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x10);

    private Geometry inputGeom() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/geom/util/GeometryTransformer.scala: 79");
        }
        return this.inputGeom;
    }

    private void inputGeom_$eq(Geometry x$1) {
        this.inputGeom = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
    }

    public GeometryFactory factory() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/geom/util/GeometryTransformer.scala: 80");
        }
        return this.factory;
    }

    public void factory_$eq(GeometryFactory x$1) {
        this.factory = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
    }

    private boolean pruneEmptyGeometry() {
        if ((byte)(this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/geom/util/GeometryTransformer.scala: 84");
        }
        return this.pruneEmptyGeometry;
    }

    private boolean preserveGeometryCollectionType() {
        if ((byte)(this.bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/geom/util/GeometryTransformer.scala: 90");
        }
        return this.preserveGeometryCollectionType;
    }

    private boolean preserveType() {
        if ((byte)(this.bitmap$init$0 & 0x10) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/geom/util/GeometryTransformer.scala: 98");
        }
        return this.preserveType;
    }

    public Geometry getInputGeometry() {
        return this.inputGeom();
    }

    public final Geometry transform(Geometry inputGeom) {
        this.inputGeom_$eq(inputGeom);
        this.factory_$eq(inputGeom.getFactory());
        if (inputGeom instanceof Point) {
            return this.transformPoint((Point)inputGeom, null);
        }
        if (inputGeom instanceof MultiPoint) {
            return this.transformMultiPoint((MultiPoint)inputGeom, null);
        }
        if (inputGeom instanceof LinearRing) {
            return this.transformLinearRing((LinearRing)inputGeom, null);
        }
        if (inputGeom instanceof LineString) {
            return this.transformLineString((LineString)inputGeom, null);
        }
        if (inputGeom instanceof MultiLineString) {
            return this.transformMultiLineString((MultiLineString)inputGeom, null);
        }
        if (inputGeom instanceof Polygon) {
            return this.transformPolygon((Polygon)inputGeom, null);
        }
        if (inputGeom instanceof MultiPolygon) {
            return this.transformMultiPolygon((MultiPolygon)inputGeom, null);
        }
        if (inputGeom instanceof GeometryCollection) {
            return this.transformGeometryCollection((GeometryCollection)inputGeom, null);
        }
        throw new IllegalArgumentException(new StringBuilder(26).append("Unknown Geometry subtype: ").append(inputGeom.getClass().getName()).toString());
    }

    public final CoordinateSequence createCoordinateSequence(Coordinate[] coords) {
        return this.factory().getCoordinateSequenceFactory().create(coords);
    }

    public final CoordinateSequence copy(CoordinateSequence seq) {
        return seq.copy();
    }

    public CoordinateSequence transformCoordinates(CoordinateSequence coords, Geometry parent) {
        return this.copy(coords);
    }

    public Point transformPoint(Point geom, Geometry parent) {
        return this.factory().createPoint(this.transformCoordinates(geom.getCoordinateSequence(), geom));
    }

    public Geometry transformMultiPoint(MultiPoint geom, Geometry parent) {
        ArrayList<Geometry> transGeomList = new ArrayList<Geometry>();
        for (int i = 0; i < geom.getNumGeometries(); ++i) {
            Object object;
            Point transformGeom = this.transformPoint((Point)geom.getGeometryN(i), geom);
            if (transformGeom != null) {
                if (!transformGeom.isEmpty()) {
                    object = BoxesRunTime.boxToBoolean((boolean)transGeomList.add(transformGeom));
                    continue;
                }
                object = BoxedUnit.UNIT;
                continue;
            }
            object = BoxedUnit.UNIT;
        }
        return this.factory().buildGeometry(transGeomList);
    }

    public Geometry transformLinearRing(LinearRing geom, Geometry parent) {
        CoordinateSequence seq = this.transformCoordinates(geom.getCoordinateSequence(), geom);
        if (seq == null) {
            return this.factory().createLinearRing((CoordinateSequence)null);
        }
        int seqSize = seq.size();
        if (seqSize > 0 && seqSize < 4 && !this.preserveType()) {
            return this.factory().createLineString(seq);
        }
        return this.factory().createLinearRing(seq);
    }

    public LineString transformLineString(LineString geom, Geometry parent) {
        return this.factory().createLineString(this.transformCoordinates(geom.getCoordinateSequence(), geom));
    }

    public Geometry transformMultiLineString(MultiLineString geom, Geometry parent) {
        ArrayList<Geometry> transGeomList = new ArrayList<Geometry>();
        for (int i = 0; i < geom.getNumGeometries(); ++i) {
            Object object;
            LineString transformGeom = this.transformLineString((LineString)geom.getGeometryN(i), geom);
            if (transformGeom != null) {
                if (!transformGeom.isEmpty()) {
                    object = BoxesRunTime.boxToBoolean((boolean)transGeomList.add(transformGeom));
                    continue;
                }
                object = BoxedUnit.UNIT;
                continue;
            }
            object = BoxedUnit.UNIT;
        }
        return this.factory().buildGeometry(transGeomList);
    }

    public Geometry transformPolygon(Polygon geom, Geometry parent) {
        boolean isAllValidLinearRings = true;
        Geometry shell = this.transformLinearRing(geom.getExteriorRing(), geom);
        if (shell == null || !(shell instanceof LinearRing) || shell.isEmpty()) {
            isAllValidLinearRings = false;
        }
        ArrayList<Geometry> holes = new ArrayList<Geometry>();
        for (int i = 0; i < geom.getNumInteriorRing(); ++i) {
            Object object;
            Geometry hole = this.transformLinearRing(geom.getInteriorRingN(i), geom);
            if (hole != null && !hole.isEmpty()) {
                if (!(hole instanceof LinearRing)) {
                    isAllValidLinearRings = false;
                }
                object = BoxesRunTime.boxToBoolean((boolean)holes.add(hole));
                continue;
            }
            object = BoxedUnit.UNIT;
        }
        if (isAllValidLinearRings) {
            return this.factory().createPolygon((LinearRing)shell, (LinearRing[])holes.toArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(LinearRing.class))));
        }
        ArrayList<Geometry> components = new ArrayList<Geometry>();
        Object object = shell != null ? BoxesRunTime.boxToBoolean((boolean)components.add(shell)) : BoxedUnit.UNIT;
        components.addAll(holes);
        return this.factory().buildGeometry(components);
    }

    public Geometry transformMultiPolygon(MultiPolygon geom, Geometry parent) {
        ArrayList<Geometry> transGeomList = new ArrayList<Geometry>();
        for (int i = 0; i < geom.getNumGeometries(); ++i) {
            Object object;
            Geometry transformGeom = this.transformPolygon((Polygon)geom.getGeometryN(i), geom);
            if (transformGeom != null) {
                if (!transformGeom.isEmpty()) {
                    object = BoxesRunTime.boxToBoolean((boolean)transGeomList.add(transformGeom));
                    continue;
                }
                object = BoxedUnit.UNIT;
                continue;
            }
            object = BoxedUnit.UNIT;
        }
        return this.factory().buildGeometry(transGeomList);
    }

    public Geometry transformGeometryCollection(GeometryCollection geom, Geometry parent) {
        ArrayList<Geometry> transGeomList = new ArrayList<Geometry>();
        for (int i = 0; i < geom.getNumGeometries(); ++i) {
            Object object;
            Geometry transformGeom = this.transform(geom.getGeometryN(i));
            if (transformGeom != null) {
                if (!this.pruneEmptyGeometry() || !transformGeom.isEmpty()) {
                    object = BoxesRunTime.boxToBoolean((boolean)transGeomList.add(transformGeom));
                    continue;
                }
                object = BoxedUnit.UNIT;
                continue;
            }
            object = BoxedUnit.UNIT;
        }
        if (this.preserveGeometryCollectionType()) {
            return this.factory().createGeometryCollection(GeometryFactory$.MODULE$.toGeometryArray(transGeomList));
        }
        return this.factory().buildGeometry(transGeomList);
    }

    public GeometryTransformer() {
        this.pruneEmptyGeometry = true;
        this.preserveGeometryCollectionType = true;
        this.preserveType = false;
    }
}

