/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom.util;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.util.SineStarFactory$;
import org.locationtech.jts.util.GeometricShapeFactory;
import scala.UninitializedFieldError;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u001d<Q!\u0005\n\t\u0002u1Qa\b\n\t\u0002\u0001BQaJ\u0001\u0005\u0002!BQ!K\u0001\u0005\u0002)2Aa\b\n\u0001\u0005\"A\u0001\n\u0002B\u0001B\u0003%\u0011\nC\u0003(\t\u0011\u0005A\nC\u0004P\t\u0001\u0007I\u0011\u0003)\t\u000fE#\u0001\u0019!C\t%\"1\u0001\f\u0002Q!\nmBq!\u0011\u0003A\u0002\u0013E\u0011\fC\u0004[\t\u0001\u0007I\u0011C.\t\ru#\u0001\u0015)\u00037\u0011\u00159C\u0001\"\u0001_\u0011\u0015yF\u0001\"\u0001a\u0011\u0015\u0011G\u0001\"\u0001d\u0011\u0015)G\u0001\"\u0001g\u0003=\u0019\u0016N\\3Ti\u0006\u0014h)Y2u_JL(BA\n\u0015\u0003\u0011)H/\u001b7\u000b\u0005U1\u0012\u0001B4f_6T!a\u0006\r\u0002\u0007)$8O\u0003\u0002\u001a5\u0005aAn\\2bi&|g\u000e^3dQ*\t1$A\u0002pe\u001e\u001c\u0001\u0001\u0005\u0002\u001f\u00035\t!CA\bTS:,7\u000b^1s\r\u0006\u001cGo\u001c:z'\t\t\u0011\u0005\u0005\u0002#K5\t1EC\u0001%\u0003\u0015\u00198-\u00197b\u0013\t13E\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003u\taa\u0019:fCR,GCB\u00160ier\u0004\t\u0005\u0002-[5\tA#\u0003\u0002/)\t9\u0001k\u001c7zO>t\u0007\"\u0002\u0019\u0004\u0001\u0004\t\u0014AB8sS\u001eLg\u000e\u0005\u0002-e%\u00111\u0007\u0006\u0002\u000b\u0007>|'\u000fZ5oCR,\u0007\"B\u001b\u0004\u0001\u00041\u0014\u0001B:ju\u0016\u0004\"AI\u001c\n\u0005a\u001a#A\u0002#pk\ndW\rC\u0003;\u0007\u0001\u00071(\u0001\u0003o!R\u001c\bC\u0001\u0012=\u0013\ti4EA\u0002J]RDQaP\u0002A\u0002m\nQA\\!s[NDQ!Q\u0002A\u0002Y\na\"\u0019:n\u0019\u0016tw\r\u001e5SCRLwn\u0005\u0002\u0005\u0007B\u0011AIR\u0007\u0002\u000b*\u00111CF\u0005\u0003\u000f\u0016\u0013QcR3p[\u0016$(/[2TQ\u0006\u0004XMR1di>\u0014\u00180A\u0004hK>lg)Y2\u0011\u00051R\u0015BA&\u0015\u0005=9Um\\7fiJLh)Y2u_JLHCA'O!\tqB\u0001C\u0003I\r\u0001\u0007\u0011*A\u0004ok6\f%/\\:\u0016\u0003m\n1B\\;n\u0003Jl7o\u0018\u0013fcR\u00111K\u0016\t\u0003EQK!!V\u0012\u0003\tUs\u0017\u000e\u001e\u0005\b/\"\t\t\u00111\u0001<\u0003\rAH%M\u0001\t]Vl\u0017I]7tAU\ta'\u0001\nbe6dUM\\4uQJ\u000bG/[8`I\u0015\fHCA*]\u0011\u001d96\"!AA\u0002Y\nq\"\u0019:n\u0019\u0016tw\r\u001e5SCRLw\u000e\t\u000b\u0002\u001b\u0006Q1/\u001a;Ok6\f%/\\:\u0015\u0005M\u000b\u0007\"B(\u000f\u0001\u0004Y\u0014!E:fi\u0006\u0013X\u000eT3oORD'+\u0019;j_R\u00111\u000b\u001a\u0005\u0006\u0003>\u0001\rAN\u0001\u000fGJ,\u0017\r^3TS:,7\u000b^1s+\u0005Y\u0003")
public class SineStarFactory
extends GeometricShapeFactory {
    private int numArms = 8;
    private double armLengthRatio = 0.5;
    private volatile byte bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);

    public static Polygon create(Coordinate coordinate, double d, int n, int n2, double d2) {
        return SineStarFactory$.MODULE$.create(coordinate, d, n, n2, d2);
    }

    public int numArms() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/geom/util/SineStarFactory.scala: 68");
        }
        return this.numArms;
    }

    public void numArms_$eq(int x$1) {
        this.numArms = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
    }

    public double armLengthRatio() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/geom/util/SineStarFactory.scala: 69");
        }
        return this.armLengthRatio;
    }

    public void armLengthRatio_$eq(double x$1) {
        this.armLengthRatio = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
    }

    public void setNumArms(int numArms) {
        this.numArms_$eq(numArms);
    }

    public void setArmLengthRatio(double armLengthRatio) {
        this.armLengthRatio_$eq(armLengthRatio);
    }

    public Polygon createSineStar() {
        Envelope env = this.dim().getEnvelope();
        double radius = env.getWidth() / 2.0;
        double armRatio = this.armLengthRatio();
        if (armRatio < 0.0) {
            armRatio = 0.0;
        }
        if (armRatio > 1.0) {
            armRatio = 1.0;
        }
        double armMaxLen = armRatio * radius;
        double insideRadius = (1.0 - armRatio) * radius;
        double centreX = env.getMinX() + radius;
        double centreY = env.getMinY() + radius;
        Coordinate[] pts = new Coordinate[this.nPts() + 1];
        int iPt = 0;
        for (int i = 0; i < this.nPts(); ++i) {
            double ptArcFrac = (double)i / (double)this.nPts() * (double)this.numArms();
            double armAngFrac = ptArcFrac - Math.floor(ptArcFrac);
            double armAng = Math.PI * 2 * armAngFrac;
            double armLenFrac = (Math.cos(armAng) + 1.0) / 2.0;
            double curveRadius = insideRadius + armMaxLen * armLenFrac;
            double ang = (double)i * (Math.PI * 2 / (double)this.nPts());
            double x = curveRadius * Math.cos(ang) + centreX;
            double y = curveRadius * Math.sin(ang) + centreY;
            pts[++iPt - 1] = this.coord(x, y);
        }
        pts[iPt] = new Coordinate(pts[0]);
        LinearRing ring = this.geomFact().createLinearRing(pts);
        Polygon poly = this.geomFact().createPolygon(ring);
        return poly;
    }

    public SineStarFactory(GeometryFactory geomFac) {
        super(geomFac);
    }

    public SineStarFactory() {
        this(new GeometryFactory());
    }
}

