/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geomgraph;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.locationtech.jts.geom.Location$;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.geomgraph.DirectedEdge;
import org.locationtech.jts.geomgraph.Edge;
import org.locationtech.jts.geomgraph.EdgeEnd;
import org.locationtech.jts.geomgraph.EdgeEndStar;
import org.locationtech.jts.geomgraph.EdgeRing;
import org.locationtech.jts.geomgraph.GeometryGraph;
import org.locationtech.jts.geomgraph.Label;
import org.locationtech.jts.geomgraph.Position$;
import org.locationtech.jts.geomgraph.Quadrant$;
import org.locationtech.jts.util.Assert$;
import scala.Function0;
import scala.MatchError;
import scala.UninitializedFieldError;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.control.Breaks$;

@ScalaSignature(bytes="\u0006\u0005\u0005Ub\u0001\u0002\u000f\u001e\u0001\u0019BQa\u000b\u0001\u0005\u00021BqA\f\u0001A\u0002\u0013%q\u0006C\u0004<\u0001\u0001\u0007I\u0011\u0002\u001f\t\r\u0015\u0003\u0001\u0015)\u00031\u0011\u001d1\u0005\u00011A\u0005\n\u001dCqa\u0013\u0001A\u0002\u0013%A\n\u0003\u0004O\u0001\u0001\u0006K\u0001\u0013\u0005\u0006\u001f\u0002!\t\u0005\u0015\u0005\u0006-\u0002!\ta\u0012\u0005\u0006/\u0002!\t\u0001\u0017\u0005\u0006/\u0002!\t\u0001\u0018\u0005\u0006E\u0002!\ta\u0019\u0005\u0006I\u0002!\t%\u001a\u0005\u0006]\u0002!\ta\u001c\u0005\u0006a\u0002!\t!\u001d\u0005\u0006i\u0002!Ia\f\u0005\bk\u0002\u0011\r\u0011\"\u0004w\u0011\u0019I\b\u0001)A\u0007o\"9!\u0010\u0001b\u0001\n\u001bY\bB\u0002@\u0001A\u00035A\u0010C\u0003\u0000\u0001\u0011\u0005q\u000eC\u0004\u0002\u0002\u0001!\t!a\u0001\t\r\u0005\u001d\u0001\u0001\"\u0001p\u0011\u0019\tI\u0001\u0001C\u0001_\"9\u00111\u0002\u0001\u0005\u0002\u00055\u0001bBA\u0006\u0001\u0011%\u00111\u0003\u0005\b\u0003C\u0001A\u0011IA\u0012\u0005A!\u0015N]3di\u0016$W\tZ4f'R\f'O\u0003\u0002\u001f?\u0005Iq-Z8nOJ\f\u0007\u000f\u001b\u0006\u0003A\u0005\n1A\u001b;t\u0015\t\u00113%\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001%\u0003\ry'oZ\u0002\u0001'\t\u0001q\u0005\u0005\u0002)S5\tQ$\u0003\u0002+;\tYQ\tZ4f\u000b:$7\u000b^1s\u0003\u0019a\u0014N\\5u}Q\tQ\u0006\u0005\u0002)\u0001\u0005\u0011\"/Z:vYR\f%/Z1FI\u001e,G*[:u+\u0005\u0001\u0004cA\u00197q5\t!G\u0003\u00024i\u0005!Q\u000f^5m\u0015\u0005)\u0014\u0001\u00026bm\u0006L!a\u000e\u001a\u0003\t1K7\u000f\u001e\t\u0003QeJ!AO\u000f\u0003\u0019\u0011K'/Z2uK\u0012,EmZ3\u0002-I,7/\u001e7u\u0003J,\u0017-\u00123hK2K7\u000f^0%KF$\"!P\"\u0011\u0005y\nU\"A \u000b\u0003\u0001\u000bQa]2bY\u0006L!AQ \u0003\tUs\u0017\u000e\u001e\u0005\b\t\u000e\t\t\u00111\u00011\u0003\rAH%M\u0001\u0014e\u0016\u001cX\u000f\u001c;Be\u0016\fW\tZ4f\u0019&\u001cH\u000fI\u0001\u0006Y\u0006\u0014W\r\\\u000b\u0002\u0011B\u0011\u0001&S\u0005\u0003\u0015v\u0011Q\u0001T1cK2\f\u0011\u0002\\1cK2|F%Z9\u0015\u0005uj\u0005b\u0002#\u0007\u0003\u0003\u0005\r\u0001S\u0001\u0007Y\u0006\u0014W\r\u001c\u0011\u0002\r%t7/\u001a:u)\ti\u0014\u000bC\u0003S\u0011\u0001\u00071+\u0001\u0002fKB\u0011\u0001\u0006V\u0005\u0003+v\u0011q!\u00123hK\u0016sG-\u0001\u0005hKRd\u0015MY3m\u0003E9W\r^(vi\u001e|\u0017N\\4EK\u001e\u0014X-Z\u000b\u00023B\u0011aHW\u0005\u00037~\u00121!\u00138u)\tIV\fC\u0003_\u0017\u0001\u0007q,\u0001\u0002feB\u0011\u0001\u0006Y\u0005\u0003Cv\u0011\u0001\"\u00123hKJKgnZ\u0001\u0011O\u0016$(+[4ii6|7\u000f^#eO\u0016,\u0012\u0001O\u0001\u0011G>l\u0007/\u001e;f\u0019\u0006\u0014W\r\u001c7j]\u001e$\"!\u00104\t\u000b\u001dl\u0001\u0019\u00015\u0002\t\u001d,w.\u001c\t\u0004}%\\\u0017B\u00016@\u0005\u0015\t%O]1z!\tAC.\u0003\u0002n;\tiq)Z8nKR\u0014\u0018p\u0012:ba\"\fa\"\\3sO\u0016\u001c\u00160\u001c'bE\u0016d7\u000fF\u0001>\u0003=)\b\u000fZ1uK2\u000b'-\u001a7mS:<GCA\u001fs\u0011\u0015\u0019x\u00021\u0001I\u0003%qw\u000eZ3MC\n,G.\u0001\nhKR\u0014Vm];mi\u0006\u0013X-Y#eO\u0016\u001c\u0018!F*D\u0003:s\u0015JT$`\r>\u0013v,\u0013(D\u001f6KejR\u000b\u0002o>\t\u00010H\u0001\u0002\u0003Y\u00196)\u0011(O\u0013:;uLR(S?&s5iT'J\u001d\u001e\u0003\u0013a\u0005'J\u001d.KejR0U\u001f~{U\u000bV$P\u0013:;U#\u0001?\u0010\u0003ul\u0012AA\u0001\u0015\u0019&s5*\u0013(H?R{ulT+U\u000f>Kej\u0012\u0011\u0002/1Lgn\u001b*fgVdG\u000fR5sK\u000e$X\rZ#eO\u0016\u001c\u0018\u0001\u00077j].l\u0015N\\5nC2$\u0015N]3di\u0016$W\tZ4fgR\u0019Q(!\u0002\t\u000by3\u0002\u0019A0\u0002)1Lgn[!mY\u0012K'/Z2uK\u0012,EmZ3t\u0003Q1\u0017N\u001c3D_Z,'/\u001a3MS:,W\tZ4fg\u0006i1m\\7qkR,G)\u001a9uQN$2!PA\b\u0011\u0019\t\t\"\u0007a\u0001q\u0005\u0011A-\u001a\u000b\b3\u0006U\u0011\u0011DA\u000f\u0011\u0019\t9B\u0007a\u00013\u0006Q1\u000f^1si&sG-\u001a=\t\r\u0005m!\u00041\u0001Z\u0003!)g\u000eZ%oI\u0016D\bBBA\u00105\u0001\u0007\u0011,\u0001\u0006ti\u0006\u0014H\u000fR3qi\"\fQ\u0001\u001d:j]R$2!PA\u0013\u0011\u001d\t9c\u0007a\u0001\u0003S\t1a\\;u!\u0011\tY#!\r\u000e\u0005\u00055\"bAA\u0018i\u0005\u0011\u0011n\\\u0005\u0005\u0003g\tiCA\u0006Qe&tGo\u0015;sK\u0006l\u0007")
public class DirectedEdgeStar
extends EdgeEndStar {
    private List<DirectedEdge> resultAreaEdgeList = null;
    private Label label = null;
    private volatile byte bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);

    private List<DirectedEdge> resultAreaEdgeList() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/geomgraph/DirectedEdgeStar.scala: 31");
        }
        return this.resultAreaEdgeList;
    }

    private void resultAreaEdgeList_$eq(List<DirectedEdge> x$1) {
        this.resultAreaEdgeList = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
    }

    private Label label() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/geomgraph/DirectedEdgeStar.scala: 32");
        }
        return this.label;
    }

    private void label_$eq(Label x$1) {
        this.label = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
    }

    @Override
    public void insert(EdgeEnd ee) {
        DirectedEdge de = (DirectedEdge)ee;
        this.insertEdgeEnd(de, de);
    }

    public Label getLabel() {
        return this.label();
    }

    /*
     * WARNING - void declaration
     */
    public int getOutgoingDegree() {
        void var1_1;
        int degree = 0;
        Iterator<EdgeEnd> it = this.iterator();
        while (it.hasNext()) {
            DirectedEdge de = (DirectedEdge)it.next();
            Object object = de.isInResult() ? BoxesRunTime.boxToInteger((int)(++degree - 1)) : BoxedUnit.UNIT;
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public int getOutgoingDegree(EdgeRing er) {
        void var2_2;
        int degree = 0;
        Iterator<EdgeEnd> it = this.iterator();
        while (it.hasNext()) {
            DirectedEdge de = (DirectedEdge)it.next();
            Object object = de.getEdgeRing() == er ? BoxesRunTime.boxToInteger((int)(++degree - 1)) : BoxedUnit.UNIT;
        }
        return (int)var2_2;
    }

    public DirectedEdge getRightmostEdge() {
        List<EdgeEnd> edges = this.getEdges();
        int size = edges.size();
        if (size < 1) {
            return null;
        }
        DirectedEdge de0 = (DirectedEdge)edges.get(0);
        if (size == 1) {
            return de0;
        }
        DirectedEdge deLast = (DirectedEdge)edges.get(size - 1);
        int quad0 = de0.getQuadrant();
        int quad1 = deLast.getQuadrant();
        if (Quadrant$.MODULE$.isNorthern(quad0) && Quadrant$.MODULE$.isNorthern(quad1)) {
            return de0;
        }
        if (!Quadrant$.MODULE$.isNorthern(quad0) && !Quadrant$.MODULE$.isNorthern(quad1)) {
            return deLast;
        }
        if (de0.getDy() != 0.0) {
            return de0;
        }
        if (deLast.getDy() != 0.0) {
            return deLast;
        }
        Assert$.MODULE$.shouldNeverReachHere("found two horizontal edges incident on node");
        return null;
    }

    @Override
    public void computeLabelling(GeometryGraph[] geom) {
        super.computeLabelling(geom);
        this.label_$eq(new Label(Location$.MODULE$.NONE()));
        Iterator<EdgeEnd> it = this.iterator();
        while (it.hasNext()) {
            EdgeEnd ee = it.next();
            Edge e = ee.getEdge();
            Label eLabel = e.getLabel();
            for (int i = 0; i < 2; ++i) {
                int eLoc = eLabel.getLocation(i);
                if (eLoc != Location$.MODULE$.INTERIOR() && eLoc != Location$.MODULE$.BOUNDARY()) continue;
                this.label().setLocation(i, Location$.MODULE$.INTERIOR());
            }
        }
    }

    public void mergeSymLabels() {
        Iterator<EdgeEnd> it = this.iterator();
        while (it.hasNext()) {
            DirectedEdge de = (DirectedEdge)it.next();
            Label label = de.getLabel();
            label.merge(de.getSym().getLabel());
        }
    }

    public void updateLabelling(Label nodeLabel) {
        Iterator<EdgeEnd> it = this.iterator();
        while (it.hasNext()) {
            DirectedEdge de = (DirectedEdge)it.next();
            Label label = de.getLabel();
            label.setAllLocationsIfNull(0, nodeLabel.getLocation(0));
            label.setAllLocationsIfNull(1, nodeLabel.getLocation(1));
        }
    }

    private List<DirectedEdge> getResultAreaEdges() {
        if (this.resultAreaEdgeList() != null) {
            return this.resultAreaEdgeList();
        }
        this.resultAreaEdgeList_$eq(new ArrayList<DirectedEdge>());
        Iterator<EdgeEnd> it = this.iterator();
        while (it.hasNext()) {
            DirectedEdge de = (DirectedEdge)it.next();
            Object object = de.isInResult() || de.getSym().isInResult() ? BoxesRunTime.boxToBoolean((boolean)this.resultAreaEdgeList().add(de)) : BoxedUnit.UNIT;
        }
        return this.resultAreaEdgeList();
    }

    private final int SCANNING_FOR_INCOMING() {
        return 1;
    }

    private final int LINKING_TO_OUTGOING() {
        return 2;
    }

    public void linkResultDirectedEdges() {
        block7: {
            this.getResultAreaEdges();
            DirectedEdge firstOut = null;
            DirectedEdge incoming = null;
            int state = 1;
            block4: for (int i = 0; i < this.resultAreaEdgeList().size(); ++i) {
                DirectedEdge nextOut = this.resultAreaEdgeList().get(i);
                DirectedEdge nextIn = nextOut.getSym();
                if (!nextOut.getLabel().isArea()) continue;
                if (firstOut == null && nextOut.isInResult()) {
                    firstOut = nextOut;
                }
                int n = state;
                switch (n) {
                    case 1: {
                        if (!nextIn.isInResult()) continue block4;
                        incoming = nextIn;
                        state = 2;
                        continue block4;
                    }
                    case 2: {
                        if (!nextOut.isInResult()) continue block4;
                        incoming.setNext(nextOut);
                        state = 1;
                        continue block4;
                    }
                    default: {
                        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                    }
                }
            }
            if (state != 2) break block7;
            if (firstOut == null) {
                throw new TopologyException("no outgoing dirEdge found", this.getCoordinate());
            }
            Assert$.MODULE$.isTrue(firstOut.isInResult(), "unable to link last incoming dirEdge");
            incoming.setNext(firstOut);
        }
    }

    public void linkMinimalDirectedEdges(EdgeRing er) {
        block7: {
            DirectedEdge firstOut = null;
            DirectedEdge incoming = null;
            int state = 1;
            block4: for (int i = this.resultAreaEdgeList().size() - 1; i >= 0; --i) {
                DirectedEdge nextOut = this.resultAreaEdgeList().get(i);
                DirectedEdge nextIn = nextOut.getSym();
                if (firstOut == null) {
                    EdgeRing edgeRing = nextOut.getEdgeRing();
                    EdgeRing edgeRing2 = er;
                    if (!(edgeRing != null ? !edgeRing.equals(edgeRing2) : edgeRing2 != null)) {
                        firstOut = nextOut;
                    }
                }
                int n = state;
                switch (n) {
                    case 1: {
                        EdgeRing edgeRing = nextIn.getEdgeRing();
                        EdgeRing edgeRing3 = er;
                        if (edgeRing != null ? !edgeRing.equals(edgeRing3) : edgeRing3 != null) continue block4;
                        incoming = nextIn;
                        state = 2;
                        continue block4;
                    }
                    case 2: {
                        EdgeRing edgeRing = nextOut.getEdgeRing();
                        EdgeRing edgeRing4 = er;
                        if (edgeRing != null ? !edgeRing.equals(edgeRing4) : edgeRing4 != null) continue block4;
                        incoming.setNextMin(nextOut);
                        state = 1;
                        continue block4;
                    }
                    default: {
                        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                    }
                }
            }
            if (state != 2) break block7;
            Assert$.MODULE$.isTrue(firstOut != null, "found null for first outgoing dirEdge");
            Assert$.MODULE$.isTrue(firstOut.getEdgeRing() == er, "unable to link last incoming dirEdge");
            incoming.setNextMin(firstOut);
        }
    }

    public void linkAllDirectedEdges() {
        this.getEdges();
        DirectedEdge prevOut = null;
        DirectedEdge firstIn = null;
        int i = this.edgeList().size() - 1;
        while (i >= 0) {
            DirectedEdge nextOut = (DirectedEdge)this.edgeList().get(i);
            DirectedEdge nextIn = nextOut.getSym();
            if (firstIn == null) {
                firstIn = nextIn;
            }
            if (prevOut != null) {
                nextIn.setNext(prevOut);
            }
            prevOut = nextOut;
            int cfr_ignored_0 = --i + 1;
        }
        firstIn.setNext(prevOut);
    }

    public void findCoveredLineEdges() {
        IntRef startLoc = IntRef.create((int)Location$.MODULE$.NONE());
        ObjectRef it = ObjectRef.create(this.iterator());
        Breaks$.MODULE$.breakable((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            while (((Iterator)it$1.elem).hasNext()) {
                DirectedEdge nextOut = (DirectedEdge)((Iterator)it$1.elem).next();
                DirectedEdge nextIn = nextOut.getSym();
                if (nextOut.isLineEdge()) continue;
                if (nextOut.isInResult()) {
                    startLoc$1.elem = Location$.MODULE$.INTERIOR();
                    throw Breaks$.MODULE$.break();
                }
                if (!nextIn.isInResult()) continue;
                startLoc$1.elem = Location$.MODULE$.EXTERIOR();
                throw Breaks$.MODULE$.break();
            }
        });
        if (startLoc.elem == Location$.MODULE$.NONE()) {
            return;
        }
        int currLoc = startLoc.elem;
        it.elem = this.iterator();
        while (((Iterator)it.elem).hasNext()) {
            DirectedEdge nextOut = (DirectedEdge)((Iterator)it.elem).next();
            DirectedEdge nextIn = nextOut.getSym();
            if (nextOut.isLineEdge()) {
                nextOut.getEdge().setCovered(currLoc == Location$.MODULE$.INTERIOR());
                continue;
            }
            if (nextOut.isInResult()) {
                currLoc = Location$.MODULE$.EXTERIOR();
            }
            if (!nextIn.isInResult()) continue;
            currLoc = Location$.MODULE$.INTERIOR();
        }
    }

    public void computeDepths(DirectedEdge de) {
        int edgeIndex = this.findIndex(de);
        int startDepth = de.getDepth(Position$.MODULE$.LEFT());
        int targetLastDepth = de.getDepth(Position$.MODULE$.RIGHT());
        int nextDepth = this.computeDepths(edgeIndex + 1, this.edgeList().size(), startDepth);
        int lastDepth = this.computeDepths(0, edgeIndex, nextDepth);
        if (lastDepth != targetLastDepth) {
            throw new TopologyException(new StringBuilder(18).append("depth mismatch at ").append(de.getCoordinate()).toString());
        }
    }

    private int computeDepths(int startIndex, int endIndex, int startDepth) {
        int currDepth = startDepth;
        int i = startIndex;
        while (i < endIndex) {
            DirectedEdge nextDe = (DirectedEdge)this.edgeList().get(i);
            nextDe.setEdgeDepths(Position$.MODULE$.RIGHT(), currDepth);
            currDepth = nextDe.getDepth(Position$.MODULE$.LEFT());
            int cfr_ignored_0 = ++i - 1;
        }
        return currDepth;
    }

    @Override
    public void print(PrintStream out) {
        System.out.println(new StringBuilder(18).append("DirectedEdgeStar: ").append(this.getCoordinate()).toString());
        Iterator<EdgeEnd> it = this.iterator();
        while (it.hasNext()) {
            DirectedEdge de = (DirectedEdge)it.next();
            out.print("out ");
            de.print(out);
            out.println();
            out.print("in ");
            de.getSym().print(out);
            out.println();
        }
    }
}

