/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geomgraph;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.locationtech.jts.algorithm.BoundaryNodeRule;
import org.locationtech.jts.algorithm.locate.SimplePointInAreaLocator$;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Location$;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.geomgraph.EdgeEnd;
import org.locationtech.jts.geomgraph.GeometryGraph;
import org.locationtech.jts.geomgraph.Label;
import org.locationtech.jts.geomgraph.Position$;
import org.locationtech.jts.util.Assert$;
import scala.Predef$;
import scala.UninitializedFieldError;
import scala.collection.Seq;
import scala.collection.mutable.TreeMap;
import scala.collection.mutable.TreeMap$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005Ed!\u0002\u000e\u001c\u0003\u0003!\u0003\"B\u0016\u0001\t\u0003a\u0003bB\u0018\u0001\u0001\u0004%\t\u0002\r\u0005\by\u0001\u0001\r\u0011\"\u0005>\u0011\u0019\u0019\u0005\u0001)Q\u0005c!9A\t\u0001a\u0001\n#)\u0005b\u0002(\u0001\u0001\u0004%\tb\u0014\u0005\u0007#\u0002\u0001\u000b\u0015\u0002$\t\u000fI\u0003!\u0019!C\u0005'\"1!\f\u0001Q\u0001\nQCQa\u0017\u0001\u0007\u0002qCQa\u0018\u0001\u0005\u0012\u0001DQ\u0001\u001a\u0001\u0005\u0002\u0015DQ\u0001\u001c\u0001\u0005\u00025DQA\u001c\u0001\u0005\u0002=DQa\u001d\u0001\u0005\u0002\u0015CQ\u0001\u001e\u0001\u0005\u0002UDQ\u0001\u001f\u0001\u0005\u0002eDq!!\u0001\u0001\t\u0013\t\u0019\u0001C\u0004\u0002\u0016\u0001!I!a\u0006\t\u000f\u0005\r\u0002\u0001\"\u0001\u0002&!9\u0011q\u0006\u0001\u0005\n\u0005E\u0002\u0002CA\u001b\u0001\u0011\u00051$a\u000e\t\u000f\u0005m\u0002\u0001\"\u0001\u0002>!9\u00111\t\u0001\u0005\u0002\u0005\u0015\u0003bBA,\u0001\u0011\u0005\u0013\u0011\f\u0002\f\u000b\u0012<W-\u00128e'R\f'O\u0003\u0002\u001d;\u0005Iq-Z8nOJ\f\u0007\u000f\u001b\u0006\u0003=}\t1A\u001b;t\u0015\t\u0001\u0013%\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001#\u0003\ry'oZ\u0002\u0001'\t\u0001Q\u0005\u0005\u0002'S5\tqEC\u0001)\u0003\u0015\u00198-\u00197b\u0013\tQsE\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00035\u0002\"A\f\u0001\u000e\u0003m\tq!\u001a3hK6\u000b\u0007/F\u00012!\u0011\u0011t'O\u001d\u000e\u0003MR!\u0001N\u001b\u0002\u000f5,H/\u00192mK*\u0011agJ\u0001\u000bG>dG.Z2uS>t\u0017B\u0001\u001d4\u0005\u001d!&/Z3NCB\u0004\"A\f\u001e\n\u0005mZ\"aB#eO\u0016,e\u000eZ\u0001\fK\u0012<W-T1q?\u0012*\u0017\u000f\u0006\u0002?\u0003B\u0011aeP\u0005\u0003\u0001\u001e\u0012A!\u00168ji\"9!iAA\u0001\u0002\u0004\t\u0014a\u0001=%c\u0005AQ\rZ4f\u001b\u0006\u0004\b%\u0001\u0005fI\u001e,G*[:u+\u00051\u0005cA$Ms5\t\u0001J\u0003\u0002J\u0015\u0006!Q\u000f^5m\u0015\u0005Y\u0015\u0001\u00026bm\u0006L!!\u0014%\u0003\t1K7\u000f^\u0001\rK\u0012<W\rT5ti~#S-\u001d\u000b\u0003}ACqA\u0011\u0004\u0002\u0002\u0003\u0007a)A\u0005fI\u001e,G*[:uA\u0005\u0001\u0002\u000f^%o\u0003J,\u0017\rT8dCRLwN\\\u000b\u0002)B\u0019a%V,\n\u0005Y;#!B!se\u0006L\bC\u0001\u0014Y\u0013\tIvEA\u0002J]R\f\u0011\u0003\u001d;J]\u0006\u0013X-\u0019'pG\u0006$\u0018n\u001c8!\u0003\u0019Ign]3siR\u0011a(\u0018\u0005\u0006=*\u0001\r!O\u0001\u0002K\u0006i\u0011N\\:feR,EmZ3F]\u0012$2AP1c\u0011\u0015q6\u00021\u0001:\u0011\u0015\u00197\u00021\u0001:\u0003\ry'M[\u0001\u000eO\u0016$8i\\8sI&t\u0017\r^3\u0016\u0003\u0019\u0004\"a\u001a6\u000e\u0003!T!![\u000f\u0002\t\u001d,w.\\\u0005\u0003W\"\u0014!bQ8pe\u0012Lg.\u0019;f\u0003%9W\r\u001e#fOJ,W-F\u0001X\u0003!IG/\u001a:bi>\u0014X#\u00019\u0011\u0007\u001d\u000b\u0018(\u0003\u0002s\u0011\nA\u0011\n^3sCR|'/\u0001\u0005hKR,EmZ3t\u0003%9W\r\u001e(fqR\u001cu\u000b\u0006\u0002:m\")q\u000f\u0005a\u0001s\u0005\u0011Q-Z\u0001\u0011G>l\u0007/\u001e;f\u0019\u0006\u0014W\r\u001c7j]\u001e$\"A\u0010>\t\u000bm\f\u0002\u0019\u0001?\u0002\u0013\u001d,w.\\$sCBD\u0007c\u0001\u0014V{B\u0011aF`\u0005\u0003\u007fn\u0011QbR3p[\u0016$(/_$sCBD\u0017\u0001F2p[B,H/Z#eO\u0016,e\u000e\u001a'bE\u0016d7\u000fF\u0002?\u0003\u000bAq!a\u0002\u0013\u0001\u0004\tI!\u0001\tc_VtG-\u0019:z\u001d>$WMU;mKB!\u00111BA\t\u001b\t\tiAC\u0002\u0002\u0010u\t\u0011\"\u00197h_JLG\u000f[7\n\t\u0005M\u0011Q\u0002\u0002\u0011\u0005>,h\u000eZ1ss:{G-\u001a*vY\u0016\f1bZ3u\u0019>\u001c\u0017\r^5p]R9q+!\u0007\u0002\u001e\u0005\u0005\u0002BBA\u000e'\u0001\u0007q+A\u0005hK>l\u0017J\u001c3fq\"1\u0011qD\nA\u0002\u0019\f\u0011\u0001\u001d\u0005\u0006SN\u0001\r\u0001`\u0001\u0017SN\f%/Z1MC\n,Gn]\"p]NL7\u000f^3oiR!\u0011qEA\u0017!\r1\u0013\u0011F\u0005\u0004\u0003W9#a\u0002\"p_2,\u0017M\u001c\u0005\u0006wR\u0001\r!`\u0001\u001aG\",7m[!sK\u0006d\u0015MY3mg\u000e{gn]5ti\u0016tG\u000f\u0006\u0003\u0002(\u0005M\u0002BBA\u000e+\u0001\u0007q+A\nqe>\u0004\u0018mZ1uKNKG-\u001a'bE\u0016d7\u000fF\u0002?\u0003sAa!a\u0007\u0017\u0001\u00049\u0016!\u00034j]\u0012Le\u000eZ3y)\r9\u0016q\b\u0005\u0007\u0003\u0003:\u0002\u0019A\u001d\u0002\u000f\u0015\u001cV-\u0019:dQ\u0006)\u0001O]5oiR\u0019a(a\u0012\t\u000f\u0005%\u0003\u00041\u0001\u0002L\u0005\u0019q.\u001e;\u0011\t\u00055\u00131K\u0007\u0003\u0003\u001fR1!!\u0015K\u0003\tIw.\u0003\u0003\u0002V\u0005=#a\u0003)sS:$8\u000b\u001e:fC6\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u00037\u0002B!!\u0018\u0002l9!\u0011qLA4!\r\t\tgJ\u0007\u0003\u0003GR1!!\u001a$\u0003\u0019a$o\\8u}%\u0019\u0011\u0011N\u0014\u0002\rA\u0013X\rZ3g\u0013\u0011\ti'a\u001c\u0003\rM#(/\u001b8h\u0015\r\tIg\n")
public abstract class EdgeEndStar {
    private TreeMap<EdgeEnd, EdgeEnd> edgeMap = TreeMap$.MODULE$.empty(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
    private List<EdgeEnd> edgeList = null;
    private final int[] ptInAreaLocation;
    private volatile byte bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);

    public TreeMap<EdgeEnd, EdgeEnd> edgeMap() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/geomgraph/EdgeEndStar.scala: 38");
        }
        return this.edgeMap;
    }

    public void edgeMap_$eq(TreeMap<EdgeEnd, EdgeEnd> x$1) {
        this.edgeMap = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
    }

    public List<EdgeEnd> edgeList() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/geomgraph/EdgeEndStar.scala: 42");
        }
        return this.edgeList;
    }

    public void edgeList_$eq(List<EdgeEnd> x$1) {
        this.edgeList = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
    }

    private int[] ptInAreaLocation() {
        if ((byte)(this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/geomgraph/EdgeEndStar.scala: 46");
        }
        return this.ptInAreaLocation;
    }

    public abstract void insert(EdgeEnd var1);

    public void insertEdgeEnd(EdgeEnd e, EdgeEnd obj) {
        this.edgeMap().put((Object)e, (Object)obj);
        this.edgeList_$eq(null);
    }

    public Coordinate getCoordinate() {
        Iterator<EdgeEnd> it = this.iterator();
        if (!it.hasNext()) {
            return null;
        }
        EdgeEnd e = it.next();
        return e.getCoordinate();
    }

    public int getDegree() {
        return this.edgeMap().size();
    }

    public Iterator<EdgeEnd> iterator() {
        return this.getEdges().iterator();
    }

    public List<EdgeEnd> getEdges() {
        block0: {
            if (this.edgeList() != null) break block0;
            this.edgeList_$eq(new ArrayList<EdgeEnd>(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)this.edgeMap().values().toList()).asJava()));
        }
        return this.edgeList();
    }

    public EdgeEnd getNextCW(EdgeEnd ee) {
        int iNextCW;
        block0: {
            this.getEdges();
            int i = this.edgeList().indexOf(ee);
            iNextCW = i - 1;
            if (i != 0) break block0;
            iNextCW = this.edgeList().size() - 1;
        }
        return this.edgeList().get(iNextCW);
    }

    public void computeLabelling(GeometryGraph[] geomGraph) {
        this.computeEdgeEndLabels(geomGraph[0].getBoundaryNodeRule());
        this.propagateSideLabels(0);
        this.propagateSideLabels(1);
        boolean[] hasDimensionalCollapseEdge = new boolean[]{false, false};
        Iterator<EdgeEnd> it = this.iterator();
        while (it.hasNext()) {
            EdgeEnd e = it.next();
            Label label = e.getLabel();
            for (int geomi = 0; geomi < 2; ++geomi) {
                if (!label.isLine(geomi) || label.getLocation(geomi) != Location$.MODULE$.BOUNDARY()) continue;
                hasDimensionalCollapseEdge[geomi] = true;
            }
        }
        it = this.iterator();
        while (it.hasNext()) {
            EdgeEnd e = it.next();
            Label label = e.getLabel();
            int geomi = 0;
            while (geomi < 2) {
                if (label.isAnyNull(geomi)) {
                    int loc = Location$.MODULE$.NONE();
                    if (hasDimensionalCollapseEdge[geomi]) {
                        loc = Location$.MODULE$.EXTERIOR();
                    } else {
                        Coordinate p = e.getCoordinate();
                        loc = this.getLocation(geomi, p, geomGraph);
                    }
                    label.setAllLocationsIfNull(geomi, loc);
                }
                int cfr_ignored_0 = ++geomi - 1;
            }
        }
    }

    private void computeEdgeEndLabels(BoundaryNodeRule boundaryNodeRule) {
        Iterator<EdgeEnd> it = this.iterator();
        while (it.hasNext()) {
            EdgeEnd ee = it.next();
            ee.computeLabel(boundaryNodeRule);
        }
    }

    private int getLocation(int geomIndex, Coordinate p, GeometryGraph[] geom) {
        block0: {
            if (this.ptInAreaLocation()[geomIndex] != Location$.MODULE$.NONE()) break block0;
            this.ptInAreaLocation()[geomIndex] = SimplePointInAreaLocator$.MODULE$.locate(p, geom[geomIndex].getGeometry());
        }
        return this.ptInAreaLocation()[geomIndex];
    }

    public boolean isAreaLabelsConsistent(GeometryGraph geomGraph) {
        this.computeEdgeEndLabels(geomGraph.getBoundaryNodeRule());
        return this.checkAreaLabelsConsistent(0);
    }

    private boolean checkAreaLabelsConsistent(int geomIndex) {
        List<EdgeEnd> edges = this.getEdges();
        if (edges.size() <= 0) {
            return true;
        }
        int lastEdgeIndex = edges.size() - 1;
        Label startLabel = edges.get(lastEdgeIndex).getLabel();
        int startLoc = startLabel.getLocation(geomIndex, Position$.MODULE$.LEFT());
        Assert$.MODULE$.isTrue(startLoc != Location$.MODULE$.NONE(), "Found unlabelled area edge");
        int currLoc = startLoc;
        Iterator<EdgeEnd> it = this.iterator();
        while (it.hasNext()) {
            EdgeEnd e = it.next();
            Label label = e.getLabel();
            Assert$.MODULE$.isTrue(label.isArea(geomIndex), "Found non-area edge");
            int leftLoc = label.getLocation(geomIndex, Position$.MODULE$.LEFT());
            int rightLoc = label.getLocation(geomIndex, Position$.MODULE$.RIGHT());
            if (leftLoc == rightLoc) {
                return false;
            }
            if (rightLoc != currLoc) {
                return false;
            }
            currLoc = leftLoc;
        }
        return true;
    }

    public void propagateSideLabels(int geomIndex) {
        int startLoc = Location$.MODULE$.NONE();
        Iterator<EdgeEnd> it = this.iterator();
        while (it.hasNext()) {
            EdgeEnd e = it.next();
            Label label = e.getLabel();
            if (!label.isArea(geomIndex) || label.getLocation(geomIndex, Position$.MODULE$.LEFT()) == Location$.MODULE$.NONE()) continue;
            startLoc = label.getLocation(geomIndex, Position$.MODULE$.LEFT());
        }
        if (startLoc == Location$.MODULE$.NONE()) {
            return;
        }
        int currLoc = startLoc;
        it = this.iterator();
        while (it.hasNext()) {
            EdgeEnd e = it.next();
            Label label = e.getLabel();
            if (label.getLocation(geomIndex, Position$.MODULE$.ON()) == Location$.MODULE$.NONE()) {
                label.setLocation(geomIndex, Position$.MODULE$.ON(), currLoc);
            }
            if (!label.isArea(geomIndex)) continue;
            int leftLoc = label.getLocation(geomIndex, Position$.MODULE$.LEFT());
            int rightLoc = label.getLocation(geomIndex, Position$.MODULE$.RIGHT());
            if (rightLoc != Location$.MODULE$.NONE()) {
                if (rightLoc != currLoc) {
                    throw new TopologyException("side location conflict", e.getCoordinate());
                }
                if (leftLoc == Location$.MODULE$.NONE()) {
                    Assert$.MODULE$.shouldNeverReachHere(new StringBuilder(28).append("found single null side (at ").append(e.getCoordinate()).append(")").toString());
                }
                currLoc = leftLoc;
                continue;
            }
            Assert$.MODULE$.isTrue(label.getLocation(geomIndex, Position$.MODULE$.LEFT()) == Location$.MODULE$.NONE(), "found single null side");
            label.setLocation(geomIndex, Position$.MODULE$.RIGHT(), currLoc);
            label.setLocation(geomIndex, Position$.MODULE$.LEFT(), currLoc);
        }
    }

    public int findIndex(EdgeEnd eSearch) {
        this.iterator();
        for (int i = 0; i < this.edgeList().size(); ++i) {
            EdgeEnd e = this.edgeList().get(i);
            if (e != eSearch) continue;
            return i;
        }
        return -1;
    }

    public void print(PrintStream out) {
        System.out.println(new StringBuilder(15).append("EdgeEndStar:   ").append(this.getCoordinate()).toString());
        Iterator<EdgeEnd> it = this.iterator();
        while (it.hasNext()) {
            EdgeEnd e = it.next();
            e.print(out);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(new StringBuilder(15).append("EdgeEndStar:   ").append(this.getCoordinate()).toString());
        buf.append("\n");
        Iterator<EdgeEnd> it = this.iterator();
        while (it.hasNext()) {
            EdgeEnd e = it.next();
            buf.append(e);
            buf.append("\n");
        }
        return buf.toString();
    }

    public EdgeEndStar() {
        this.ptInAreaLocation = new int[]{Location$.MODULE$.NONE(), Location$.MODULE$.NONE()};
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
    }
}

