/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geomgraph;

import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geomgraph.Edge;
import org.locationtech.jts.geomgraph.EdgeIntersection;
import org.locationtech.jts.geomgraph.Label;
import scala.;
import scala.$less$colon$less$;
import scala.Predef$;
import scala.UninitializedFieldError;
import scala.collection.mutable.TreeMap;
import scala.collection.mutable.TreeMap$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005u4AAD\b\u00011!Aq\u0004\u0001BA\u0002\u0013\u0005\u0001\u0005\u0003\u0005&\u0001\t\u0005\r\u0011\"\u0001'\u0011!a\u0003A!A!B\u0013\t\u0003\"B\u0017\u0001\t\u0003q\u0003bB\u0019\u0001\u0005\u0004%IA\r\u0005\u0007}\u0001\u0001\u000b\u0011B\u001a\t\u000b}\u0002A\u0011\u0001!\t\u000bM\u0003A\u0011\u0001+\t\u000bu\u0003A\u0011\u00010\t\u000b\u0011\u0004A\u0011A3\t\u000b\u0019\u0004A\u0011A4\t\r5\u0004A\u0011A\bo\u0011\u0015\u0019\b\u0001\"\u0001u\u0005Q)EmZ3J]R,'o]3di&|g\u000eT5ti*\u0011\u0001#E\u0001\nO\u0016|Wn\u001a:ba\"T!AE\n\u0002\u0007)$8O\u0003\u0002\u0015+\u0005aAn\\2bi&|g\u000e^3dQ*\ta#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u00013A\u0011!$H\u0007\u00027)\tA$A\u0003tG\u0006d\u0017-\u0003\u0002\u001f7\t1\u0011I\\=SK\u001a\fA!\u001a3hKV\t\u0011\u0005\u0005\u0002#G5\tq\"\u0003\u0002%\u001f\t!Q\tZ4f\u0003!)GmZ3`I\u0015\fHCA\u0014+!\tQ\u0002&\u0003\u0002*7\t!QK\\5u\u0011\u001dY#!!AA\u0002\u0005\n1\u0001\u001f\u00132\u0003\u0015)GmZ3!\u0003\u0019a\u0014N\\5u}Q\u0011q\u0006\r\t\u0003E\u0001AQa\b\u0003A\u0002\u0005\nqA\\8eK6\u000b\u0007/F\u00014!\u0011!\u0014hO\u001e\u000e\u0003UR!AN\u001c\u0002\u000f5,H/\u00192mK*\u0011\u0001hG\u0001\u000bG>dG.Z2uS>t\u0017B\u0001\u001e6\u0005\u001d!&/Z3NCB\u0004\"A\t\u001f\n\u0005uz!\u0001E#eO\u0016Le\u000e^3sg\u0016\u001cG/[8o\u0003!qw\u000eZ3NCB\u0004\u0013aA1eIR!1(Q%O\u0011\u0015\u0011u\u00011\u0001D\u0003\u0015Ig\u000e\u001e)u!\t!u)D\u0001F\u0015\t1\u0015#\u0001\u0003hK>l\u0017B\u0001%F\u0005)\u0019un\u001c:eS:\fG/\u001a\u0005\u0006\u0015\u001e\u0001\raS\u0001\rg\u0016<W.\u001a8u\u0013:$W\r\u001f\t\u000351K!!T\u000e\u0003\u0007%sG\u000fC\u0003P\u000f\u0001\u0007\u0001+\u0001\u0003eSN$\bC\u0001\u000eR\u0013\t\u00116D\u0001\u0004E_V\u0014G.Z\u0001\tSR,'/\u0019;peV\tQ\u000bE\u0002W7nj\u0011a\u0016\u0006\u00031f\u000bA!\u001e;jY*\t!,\u0001\u0003kCZ\f\u0017B\u0001/X\u0005!IE/\u001a:bi>\u0014\u0018AD5t\u0013:$XM]:fGRLwN\u001c\u000b\u0003?\n\u0004\"A\u00071\n\u0005\u0005\\\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006G&\u0001\raQ\u0001\u0003aR\fA\"\u00193e\u000b:$\u0007o\\5oiN$\u0012aO\u0001\u000eC\u0012$7\u000b\u001d7ji\u0016#w-Z:\u0015\u0005\u001dB\u0007\"B5\f\u0001\u0004Q\u0017\u0001C3eO\u0016d\u0015n\u001d;\u0011\u0007Y[\u0017%\u0003\u0002m/\n!A*[:u\u0003=\u0019'/Z1uKN\u0003H.\u001b;FI\u001e,GcA\u0011pc\")\u0001\u000f\u0004a\u0001w\u0005\u0019Q-\u001b\u0019\t\u000bId\u0001\u0019A\u001e\u0002\u0007\u0015L\u0017'A\u0003qe&tG\u000f\u0006\u0002(k\")a/\u0004a\u0001o\u0006\u0019q.\u001e;\u0011\u0005a\\X\"A=\u000b\u0005iL\u0016AA5p\u0013\ta\u0018PA\u0006Qe&tGo\u0015;sK\u0006l\u0007")
public class EdgeIntersectionList {
    private Edge edge;
    private final TreeMap<EdgeIntersection, EdgeIntersection> nodeMap;
    private volatile boolean bitmap$init$0;

    public Edge edge() {
        return this.edge;
    }

    public void edge_$eq(Edge x$1) {
        this.edge = x$1;
    }

    private TreeMap<EdgeIntersection, EdgeIntersection> nodeMap() {
        if (!this.bitmap$init$0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/geomgraph/EdgeIntersectionList.scala: 42");
        }
        return this.nodeMap;
    }

    public EdgeIntersection add(Coordinate intPt, int segmentIndex, double dist) {
        EdgeIntersection eiNew = new EdgeIntersection(intPt, segmentIndex, dist);
        EdgeIntersection ei = (EdgeIntersection)this.nodeMap().get((Object)eiNew).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (ei != null) {
            return ei;
        }
        this.nodeMap().put((Object)eiNew, (Object)eiNew);
        return eiNew;
    }

    public Iterator<EdgeIntersection> iterator() {
        return CollectionConverters$.MODULE$.IteratorHasAsJava(this.nodeMap().values().iterator()).asJava();
    }

    public boolean isIntersection(Coordinate pt) {
        Iterator<EdgeIntersection> it = this.iterator();
        while (it.hasNext()) {
            EdgeIntersection ei = it.next();
            if (!ei.coord().equals(pt)) continue;
            return true;
        }
        return false;
    }

    public EdgeIntersection addEndpoints() {
        int maxSegIndex = this.edge().pts().length - 1;
        this.add(this.edge().pts()[0], 0, 0.0);
        return this.add(this.edge().pts()[maxSegIndex], maxSegIndex, 0.0);
    }

    public void addSplitEdges(List<Edge> edgeList) {
        this.addEndpoints();
        Iterator<EdgeIntersection> it = this.iterator();
        EdgeIntersection eiPrev = it.next();
        while (it.hasNext()) {
            EdgeIntersection ei = it.next();
            Edge newEdge = this.createSplitEdge(eiPrev, ei);
            edgeList.add(newEdge);
            eiPrev = ei;
        }
    }

    public Edge createSplitEdge(EdgeIntersection ei0, EdgeIntersection ei1) {
        boolean useIntPt1;
        int npts = ei1.segmentIndex() - ei0.segmentIndex() + 2;
        Coordinate lastSegStartPt = this.edge().pts()[ei1.segmentIndex()];
        boolean bl = useIntPt1 = ei1.dist() > 0.0 || !ei1.coord().equals2D(lastSegStartPt);
        if (!useIntPt1) {
            --npts;
        }
        Coordinate[] pts = new Coordinate[npts];
        int ipt = 0;
        pts[++ipt - 1] = new Coordinate(ei0.coord());
        for (int i = ei0.segmentIndex() + 1; i <= ei1.segmentIndex(); ++i) {
            pts[++ipt - 1] = this.edge().pts()[i];
        }
        if (useIntPt1) {
            pts[ipt] = ei1.coord();
        }
        return new Edge(pts, new Label(this.edge().label()));
    }

    public void print(PrintStream out) {
        out.println("Intersections:");
        Iterator<EdgeIntersection> it = this.iterator();
        while (it.hasNext()) {
            EdgeIntersection ei = it.next();
            ei.print(out);
        }
    }

    public EdgeIntersectionList(Edge edge) {
        this.edge = edge;
        this.nodeMap = TreeMap$.MODULE$.empty(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
        this.bitmap$init$0 = true;
    }
}

