/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geomgraph;

import java.util.ArrayList;
import org.locationtech.jts.algorithm.Orientation$;
import org.locationtech.jts.algorithm.PointLocation$;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Location$;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.geomgraph.DirectedEdge;
import org.locationtech.jts.geomgraph.DirectedEdgeStar;
import org.locationtech.jts.geomgraph.Edge;
import org.locationtech.jts.geomgraph.Label;
import org.locationtech.jts.geomgraph.Node;
import org.locationtech.jts.geomgraph.Position$;
import org.locationtech.jts.util.Assert$;
import scala.UninitializedFieldError;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005h!\u0002\u001b6\u0003\u0003q\u0004\u0002C#\u0001\u0005\u000b\u0007I\u0011\u0001$\t\u0011-\u0003!\u0011!Q\u0001\n\u001dC\u0001\u0002\u0014\u0001\u0003\u0002\u0004%\t!\u0014\u0005\t)\u0002\u0011\t\u0019!C\u0001+\"A1\f\u0001B\u0001B\u0003&a\nC\u0003]\u0001\u0011\u0005Q\fC\u0004b\u0001\u0001\u0007I\u0011\u0003$\t\u000f\t\u0004\u0001\u0019!C\tG\"1Q\r\u0001Q!\n\u001dCqA\u001a\u0001A\u0002\u0013%q\rC\u0004l\u0001\u0001\u0007I\u0011\u00027\t\r9\u0004\u0001\u0015)\u0003i\u0011\u001dy\u0007A1A\u0005\nADa!\u001f\u0001!\u0002\u0013\t\bb\u0002>\u0001\u0005\u0004%Ia\u001f\u0005\b\u0003\u0003\u0001\u0001\u0015!\u0003}\u0011%\t\u0019\u0001\u0001b\u0001\n\u0013\t)\u0001\u0003\u0005\u0002\u000e\u0001\u0001\u000b\u0011BA\u0004\u0011%\ty\u0001\u0001a\u0001\n\u0013\t\t\u0002C\u0005\u0002\u001a\u0001\u0001\r\u0011\"\u0003\u0002\u001c!A\u0011q\u0004\u0001!B\u0013\t\u0019\u0002C\u0005\u0002\"\u0001\u0001\r\u0011\"\u0003\u0002$!I\u00111\u0006\u0001A\u0002\u0013%\u0011Q\u0006\u0005\t\u0003c\u0001\u0001\u0015)\u0003\u0002&!I\u00111\u0007\u0001A\u0002\u0013%\u0011Q\u0007\u0005\n\u0003o\u0001\u0001\u0019!C\u0005\u0003sAq!!\u0010\u0001A\u0003&a\fC\u0005\u0002@\u0001\u0011\r\u0011\"\u0003\u0002B!A\u0011Q\t\u0001!\u0002\u0013\t\u0019\u0005C\u0004\u0002H\u0001!\t!a\t\t\u000f\u0005%\u0003\u0001\"\u0001\u0002$!9\u00111\n\u0001\u0005\u0002\u00055\u0003bBA*\u0001\u0011\u0005\u0011\u0011\u0003\u0005\b\u0003+\u0002A\u0011AA\u0003\u0011\u001d\t9\u0006\u0001C\u0001\u0003GAq!!\u0017\u0001\t\u0003\t)\u0004C\u0004\u0002\\\u0001!\t!!\u0018\t\u000f\u0005\u0005\u0004\u0001\"\u0001\u0002d!9\u0011q\r\u0001\u0005\u0002\u0005%\u0004bBA:\u0001\u0011\u0005\u0011Q\u000f\u0005\b\u0003o\u0002a\u0011AA=\u0011\u001d\ty\b\u0001D\u0001\u0003\u0003Cq!!#\u0001\t\u0003\tY\tC\u0004\u0002(\u0002!\t\"!+\t\r\u00055\u0006\u0001\"\u0001h\u0011\u001d\ty\u000b\u0001C\u0005\u0003kBq!!-\u0001\t\u0003\t)\bC\u0004\u00024\u0002!\t\"!.\t\u000f\u0005M\u0006\u0001\"\u0005\u0002<\"9\u00111\u0019\u0001\u0005\u0012\u0005\u0015\u0007bBAm\u0001\u0011\u0005\u00111\u001c\u0002\t\u000b\u0012<WMU5oO*\u0011agN\u0001\nO\u0016|Wn\u001a:ba\"T!\u0001O\u001d\u0002\u0007)$8O\u0003\u0002;w\u0005aAn\\2bi&|g\u000e^3dQ*\tA(A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u007fA\u0011\u0001iQ\u0007\u0002\u0003*\t!)A\u0003tG\u0006d\u0017-\u0003\u0002E\u0003\n1\u0011I\\=SK\u001a\fQa\u001d;beR,\u0012a\u0012\t\u0003\u0011&k\u0011!N\u0005\u0003\u0015V\u0012A\u0002R5sK\u000e$X\rZ#eO\u0016\faa\u001d;beR\u0004\u0013aD4f_6,GO]=GC\u000e$xN]=\u0016\u00039\u0003\"a\u0014*\u000e\u0003AS!!U\u001c\u0002\t\u001d,w.\\\u0005\u0003'B\u0013qbR3p[\u0016$(/\u001f$bGR|'/_\u0001\u0014O\u0016|W.\u001a;ss\u001a\u000b7\r^8ss~#S-\u001d\u000b\u0003-f\u0003\"\u0001Q,\n\u0005a\u000b%\u0001B+oSRDqA\u0017\u0003\u0002\u0002\u0003\u0007a*A\u0002yIE\n\u0001cZ3p[\u0016$(/\u001f$bGR|'/\u001f\u0011\u0002\rqJg.\u001b;?)\rqv\f\u0019\t\u0003\u0011\u0002AQ!\u0012\u0004A\u0002\u001dCQ\u0001\u0014\u0004A\u00029\u000bqa\u001d;beR$U-A\u0006ti\u0006\u0014H\u000fR3`I\u0015\fHC\u0001,e\u0011\u001dQ\u0006\"!AA\u0002\u001d\u000b\u0001b\u001d;beR$U\rI\u0001\u000e[\u0006Dhj\u001c3f\t\u0016<'/Z3\u0016\u0003!\u0004\"\u0001Q5\n\u0005)\f%aA%oi\u0006\tR.\u0019=O_\u0012,G)Z4sK\u0016|F%Z9\u0015\u0005Yk\u0007b\u0002.\f\u0003\u0003\u0005\r\u0001[\u0001\u000f[\u0006Dhj\u001c3f\t\u0016<'/Z3!\u0003\u0015)GmZ3t+\u0005\t\bc\u0001:x\u000f6\t1O\u0003\u0002uk\u0006!Q\u000f^5m\u0015\u00051\u0018\u0001\u00026bm\u0006L!\u0001_:\u0003\u0013\u0005\u0013(/Y=MSN$\u0018AB3eO\u0016\u001c\b%A\u0002qiN,\u0012\u0001 \t\u0004e^l\bCA(\u007f\u0013\ty\bK\u0001\u0006D_>\u0014H-\u001b8bi\u0016\fA\u0001\u001d;tA\u0005)A.\u00192fYV\u0011\u0011q\u0001\t\u0004\u0011\u0006%\u0011bAA\u0006k\t)A*\u00192fY\u00061A.\u00192fY\u0002\nAA]5oOV\u0011\u00111\u0003\t\u0004\u001f\u0006U\u0011bAA\f!\nQA*\u001b8fCJ\u0014\u0016N\\4\u0002\u0011ILgnZ0%KF$2AVA\u000f\u0011!QF#!AA\u0002\u0005M\u0011!\u0002:j]\u001e\u0004\u0013a\u0002<jg\"{G.Z\u000b\u0003\u0003K\u00012\u0001QA\u0014\u0013\r\tI#\u0011\u0002\b\u0005>|G.Z1o\u0003-1\u0018n\u001d%pY\u0016|F%Z9\u0015\u0007Y\u000by\u0003\u0003\u0005[/\u0005\u0005\t\u0019AA\u0013\u0003!1\u0018n\u001d%pY\u0016\u0004\u0013!B:iK2dW#\u00010\u0002\u0013MDW\r\u001c7`I\u0015\fHc\u0001,\u0002<!9!LGA\u0001\u0002\u0004q\u0016AB:iK2d\u0007%A\u0003i_2,7/\u0006\u0002\u0002DA\u0019!o\u001e0\u0002\r!|G.Z:!\u0003)I7/S:pY\u0006$X\rZ\u0001\u0007SNDu\u000e\\3\u0002\u001b\u001d,GoQ8pe\u0012Lg.\u0019;f)\ri\u0018q\n\u0005\u0007\u0003#\u0002\u0003\u0019\u00015\u0002\u0003%\fQbZ3u\u0019&tW-\u0019:SS:<\u0017\u0001C4fi2\u000b'-\u001a7\u0002\u000f%\u001c8\u000b[3mY\u0006Aq-\u001a;TQ\u0016dG.\u0001\u0005tKR\u001c\u0006.\u001a7m)\r1\u0016q\f\u0005\u0007\u0003g)\u0003\u0019\u00010\u0002\u000f\u0005$G\rS8mKR!\u0011QEA3\u0011\u0019\tyA\na\u0001=\u0006IAo\u001c)pYf<wN\u001c\u000b\u0005\u0003W\n\t\bE\u0002P\u0003[J1!a\u001cQ\u0005\u001d\u0001v\u000e\\=h_:DQ\u0001T\u0014A\u00029\u000b1bY8naV$XMU5oOR\ta+A\u0004hKRtU\r\u001f;\u0015\u0007\u001d\u000bY\b\u0003\u0004\u0002~%\u0002\raR\u0001\u0003I\u0016\f1b]3u\u000b\u0012<WMU5oOR)a+a!\u0002\u0006\"1\u0011Q\u0010\u0016A\u0002\u001dCa!a\"+\u0001\u0004q\u0016AA3s\u0003!9W\r^#eO\u0016\u001cXCAAGa\u0011\ty)!&\u0011\tI<\u0018\u0011\u0013\t\u0005\u0003'\u000b)\n\u0004\u0001\u0005\u0017\u0005]5&!A\u0001\u0002\u000b\u0005\u0011\u0011\u0014\u0002\u0004?\u0012\n\u0014\u0003BAN\u0003C\u00032\u0001QAO\u0013\r\ty*\u0011\u0002\b\u001d>$\b.\u001b8h!\r\u0001\u00151U\u0005\u0004\u0003K\u000b%aA!os\u0006i1m\\7qkR,\u0007k\\5oiN$2AVAV\u0011\u0015)E\u00061\u0001H\u0003A9W\r^'bq:{G-\u001a#fOJ,W-\u0001\u000bd_6\u0004X\u000f^3NCbtu\u000eZ3EK\u001e\u0014X-Z\u0001\fg\u0016$\u0018J\u001c*fgVdG/\u0001\u0006nKJ<W\rT1cK2$2AVA\\\u0011\u001d\tI\f\ra\u0001\u0003\u000f\tq\u0001Z3MC\n,G\u000eF\u0003W\u0003{\u000by\fC\u0004\u0002:F\u0002\r!a\u0002\t\r\u0005\u0005\u0017\u00071\u0001i\u0003%9Wm\\7J]\u0012,\u00070A\u0005bI\u0012\u0004v.\u001b8ugR9a+a2\u0002R\u0006U\u0007bBAee\u0001\u0007\u00111Z\u0001\u0005K\u0012<W\rE\u0002I\u0003\u001bL1!a46\u0005\u0011)EmZ3\t\u000f\u0005M'\u00071\u0001\u0002&\u0005I\u0011n\u001d$pe^\f'\u000f\u001a\u0005\b\u0003/\u0014\u0004\u0019AA\u0013\u0003-I7OR5sgR,EmZ3\u0002\u001b\r|g\u000e^1j]N\u0004v.\u001b8u)\u0011\t)#!8\t\r\u0005}7\u00071\u0001~\u0003\u0005\u0001\b")
public abstract class EdgeRing {
    private final DirectedEdge start;
    private GeometryFactory geometryFactory;
    private DirectedEdge startDe;
    private int maxNodeDegree;
    private final ArrayList<DirectedEdge> edges;
    private final ArrayList<Coordinate> pts;
    private final Label label;
    private LinearRing ring;
    private boolean visHole;
    private EdgeRing shell;
    private final ArrayList<EdgeRing> holes;
    private volatile int bitmap$init$0;

    public DirectedEdge start() {
        return this.start;
    }

    public GeometryFactory geometryFactory() {
        return this.geometryFactory;
    }

    public void geometryFactory_$eq(GeometryFactory x$1) {
        this.geometryFactory = x$1;
    }

    public DirectedEdge startDe() {
        if ((this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/geomgraph/EdgeRing.scala: 29");
        }
        return this.startDe;
    }

    public void startDe_$eq(DirectedEdge x$1) {
        this.startDe = x$1;
        this.bitmap$init$0 |= 1;
    }

    private int maxNodeDegree() {
        if ((this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/geomgraph/EdgeRing.scala: 30");
        }
        return this.maxNodeDegree;
    }

    private void maxNodeDegree_$eq(int x$1) {
        this.maxNodeDegree = x$1;
        this.bitmap$init$0 |= 2;
    }

    private ArrayList<DirectedEdge> edges() {
        if ((this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/geomgraph/EdgeRing.scala: 31");
        }
        return this.edges;
    }

    private ArrayList<Coordinate> pts() {
        if ((this.bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/geomgraph/EdgeRing.scala: 32");
        }
        return this.pts;
    }

    private Label label() {
        if ((this.bitmap$init$0 & 0x10) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/geomgraph/EdgeRing.scala: 33");
        }
        return this.label;
    }

    private LinearRing ring() {
        if ((this.bitmap$init$0 & 0x20) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/geomgraph/EdgeRing.scala: 34");
        }
        return this.ring;
    }

    private void ring_$eq(LinearRing x$1) {
        this.ring = x$1;
        this.bitmap$init$0 |= 0x20;
    }

    private boolean visHole() {
        if ((this.bitmap$init$0 & 0x40) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/geomgraph/EdgeRing.scala: 35");
        }
        return this.visHole;
    }

    private void visHole_$eq(boolean x$1) {
        this.visHole = x$1;
        this.bitmap$init$0 |= 0x40;
    }

    private EdgeRing shell() {
        if ((this.bitmap$init$0 & 0x80) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/geomgraph/EdgeRing.scala: 36");
        }
        return this.shell;
    }

    private void shell_$eq(EdgeRing x$1) {
        this.shell = x$1;
        this.bitmap$init$0 |= 0x80;
    }

    private ArrayList<EdgeRing> holes() {
        if ((this.bitmap$init$0 & 0x100) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/geomgraph/EdgeRing.scala: 37");
        }
        return this.holes;
    }

    public boolean isIsolated() {
        return this.label().getGeometryCount() == 1;
    }

    public boolean isHole() {
        return this.visHole();
    }

    public Coordinate getCoordinate(int i) {
        return this.pts().get(i);
    }

    public LinearRing getLinearRing() {
        return this.ring();
    }

    public Label getLabel() {
        return this.label();
    }

    public boolean isShell() {
        return this.shell() == null;
    }

    public EdgeRing getShell() {
        return this.shell();
    }

    public void setShell(EdgeRing shell) {
        this.shell_$eq(shell);
        Object object = shell != null ? BoxesRunTime.boxToBoolean((boolean)shell.addHole(this)) : BoxedUnit.UNIT;
    }

    public boolean addHole(EdgeRing ring) {
        return this.holes().add(ring);
    }

    public Polygon toPolygon(GeometryFactory geometryFactory) {
        LinearRing[] holeLR = new LinearRing[this.holes().size()];
        for (int i = 0; i < this.holes().size(); ++i) {
            holeLR[i] = this.holes().get(i).getLinearRing();
        }
        Polygon poly = geometryFactory.createPolygon(this.getLinearRing(), holeLR);
        return poly;
    }

    public void computeRing() {
        if (this.ring() != null) {
            return;
        }
        Coordinate[] coord = new Coordinate[this.pts().size()];
        for (int i = 0; i < this.pts().size(); ++i) {
            coord[i] = this.pts().get(i);
        }
        this.ring_$eq(this.geometryFactory().createLinearRing(coord));
        this.visHole_$eq(Orientation$.MODULE$.isCCW(this.ring().getCoordinates()));
    }

    public abstract DirectedEdge getNext(DirectedEdge var1);

    public abstract void setEdgeRing(DirectedEdge var1, EdgeRing var2);

    public ArrayList<?> getEdges() {
        return this.edges();
    }

    public void computePoints(DirectedEdge start) {
        DirectedEdge directedEdge;
        DirectedEdge directedEdge2;
        this.startDe_$eq(start);
        DirectedEdge de = start;
        boolean isFirstEdge = true;
        do {
            if (de == null) {
                throw new TopologyException("Found null DirectedEdge");
            }
            if (de.getEdgeRing() == this) {
                throw new TopologyException(new StringBuilder(52).append("Directed Edge visited twice during ring-building at ").append(de.getCoordinate()).toString());
            }
            this.edges().add(de);
            Label label = de.getLabel();
            Assert$.MODULE$.isTrue(label.isArea());
            this.mergeLabel(label);
            this.addPoints(de.getEdge(), de.isForward(), isFirstEdge);
            isFirstEdge = false;
            this.setEdgeRing(de, this);
            directedEdge2 = de = this.getNext(de);
            directedEdge = this.startDe();
        } while (directedEdge2 == null ? directedEdge != null : !directedEdge2.equals(directedEdge));
    }

    public int getMaxNodeDegree() {
        block0: {
            if (this.maxNodeDegree() >= 0) break block0;
            this.computeMaxNodeDegree();
        }
        return this.maxNodeDegree();
    }

    private void computeMaxNodeDegree() {
        DirectedEdge directedEdge;
        DirectedEdge directedEdge2;
        this.maxNodeDegree_$eq(0);
        DirectedEdge de = this.startDe();
        do {
            Node node;
            int degree;
            if ((degree = ((DirectedEdgeStar)(node = de.getNode()).getEdges()).getOutgoingDegree(this)) > this.maxNodeDegree()) {
                this.maxNodeDegree_$eq(degree);
            }
            directedEdge2 = de = this.getNext(de);
            directedEdge = this.startDe();
        } while (directedEdge2 == null ? directedEdge != null : !directedEdge2.equals(directedEdge));
        this.maxNodeDegree_$eq(this.maxNodeDegree() * 2);
    }

    public void setInResult() {
        DirectedEdge de = this.startDe();
        do {
            de.getEdge().setInResult(true);
            de = de.getNext();
        } while (de != this.startDe());
    }

    public void mergeLabel(Label deLabel) {
        this.mergeLabel(deLabel, 0);
        this.mergeLabel(deLabel, 1);
    }

    public void mergeLabel(Label deLabel, int geomIndex) {
        int loc = deLabel.getLocation(geomIndex, Position$.MODULE$.RIGHT());
        if (loc == Location$.MODULE$.NONE()) {
            return;
        }
        if (this.label().getLocation(geomIndex) == Location$.MODULE$.NONE()) {
            this.label().setLocation(geomIndex, loc);
            return;
        }
    }

    public void addPoints(Edge edge, boolean isForward, boolean isFirstEdge) {
        Coordinate[] edgePts = edge.getCoordinates();
        if (isForward) {
            int startIndex = 1;
            if (isFirstEdge) {
                startIndex = 0;
            }
            for (int i = startIndex; i < edgePts.length; ++i) {
                this.pts().add(edgePts[i]);
            }
        } else {
            int startIndex = edgePts.length - 2;
            if (isFirstEdge) {
                startIndex = edgePts.length - 1;
            }
            for (int i = startIndex; i >= 0; --i) {
                this.pts().add(edgePts[i]);
            }
        }
    }

    public boolean containsPoint(Coordinate p) {
        LinearRing shell = this.getLinearRing();
        Envelope env = shell.getEnvelopeInternal();
        if (!env.contains(p)) {
            return false;
        }
        if (!PointLocation$.MODULE$.isInRing(p, shell.getCoordinates())) {
            return false;
        }
        for (EdgeRing hole : this.holes()) {
            if (!hole.containsPoint(p)) continue;
            return false;
        }
        return true;
    }

    public EdgeRing(DirectedEdge start, GeometryFactory geometryFactory) {
        this.start = start;
        this.geometryFactory = geometryFactory;
        this.startDe = null;
        this.bitmap$init$0 |= 1;
        this.maxNodeDegree = -1;
        this.bitmap$init$0 |= 2;
        this.edges = new ArrayList();
        this.bitmap$init$0 |= 4;
        this.pts = new ArrayList();
        this.bitmap$init$0 |= 8;
        this.label = new Label(Location$.MODULE$.NONE());
        this.bitmap$init$0 |= 0x10;
        this.ring = null;
        this.bitmap$init$0 |= 0x20;
        this.visHole = false;
        this.bitmap$init$0 |= 0x40;
        this.shell = null;
        this.bitmap$init$0 |= 0x80;
        this.holes = new ArrayList();
        this.bitmap$init$0 |= 0x100;
        this.computePoints(start);
        this.computeRing();
    }
}

