/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geomgraph;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.locationtech.jts.algorithm.BoundaryNodeRule;
import org.locationtech.jts.algorithm.BoundaryNodeRule$;
import org.locationtech.jts.algorithm.LineIntersector;
import org.locationtech.jts.algorithm.Orientation$;
import org.locationtech.jts.algorithm.PointLocator;
import org.locationtech.jts.algorithm.PointLocator$;
import org.locationtech.jts.algorithm.locate.IndexedPointInAreaLocator;
import org.locationtech.jts.algorithm.locate.PointOnGeometryLocator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays$;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Location$;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.Polygonal;
import org.locationtech.jts.geomgraph.Edge;
import org.locationtech.jts.geomgraph.EdgeIntersection;
import org.locationtech.jts.geomgraph.GeometryGraph$;
import org.locationtech.jts.geomgraph.Label;
import org.locationtech.jts.geomgraph.Node;
import org.locationtech.jts.geomgraph.PlanarGraph;
import org.locationtech.jts.geomgraph.Position$;
import org.locationtech.jts.geomgraph.index.SegmentIntersector;
import org.locationtech.jts.geomgraph.index.SimpleMCSweepLineIntersector;
import org.locationtech.jts.util.Assert$;
import scala.UninitializedFieldError;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\t}t!\u0002\u001e<\u0011\u0003!e!\u0002$<\u0011\u00039\u0005\"\u0002(\u0002\t\u0003y\u0005\"\u0002)\u0002\t\u0003\tf\u0001\u0002$<\u0001}C\u0001b\u0019\u0003\u0003\u0002\u0004%\t\u0001\u001a\u0005\tK\u0012\u0011\t\u0019!C\u0001M\"AA\u000e\u0002B\u0001B\u0003&!\u000b\u0003\u0005n\t\t\u0005\r\u0011\"\u0001o\u0011!)HA!a\u0001\n\u00031\b\u0002\u0003=\u0005\u0005\u0003\u0005\u000b\u0015B8\t\u0011Y#!Q1A\u0005\u0002eD\u0001B\u001f\u0003\u0003\u0002\u0003\u0006Ia\u0016\u0005\u0006\u001d\u0012!\ta\u001f\u0005\n\u0003\u0003!!\u0019!C\u0005\u0003\u0007A\u0001\"!\t\u0005A\u0003%\u0011Q\u0001\u0005\n\u0003G!\u0001\u0019!C\u0005\u0003KA\u0011\"!\f\u0005\u0001\u0004%I!a\f\t\u0011\u0005MB\u0001)Q\u0005\u0003OA\u0011\"!\u000e\u0005\u0001\u0004%I!a\u000e\t\u0013\u0005\u0015C\u00011A\u0005\n\u0005\u001d\u0003\u0002CA&\t\u0001\u0006K!!\u000f\t\u0013\u00055C\u00011A\u0005\u0002\u0005\u0015\u0002\"CA(\t\u0001\u0007I\u0011AA)\u0011!\t)\u0006\u0002Q!\n\u0005\u001d\u0002\"CA,\t\u0001\u0007I\u0011BA-\u0011%\t\t\u0007\u0002a\u0001\n\u0013\t\u0019\u0007\u0003\u0005\u0002h\u0011\u0001\u000b\u0015BA.\u0011%\tI\u0007\u0002a\u0001\n\u0013\tY\u0007C\u0005\u0002z\u0011\u0001\r\u0011\"\u0003\u0002|!A\u0011q\u0010\u0003!B\u0013\ti\u0007C\u0005\u0002\u0002\u0012\u0011\r\u0011\"\u0004\u0002\u0004\"A\u00111\u0012\u0003!\u0002\u001b\t)\tC\u0004\u0002\u000e\u0012!I!a$\t\r9#A\u0011AAO\u0011\u001d\t\u0019\u000b\u0002C\u0001\u00033Ba!!*\u0005\t\u0003q\u0007BBAT\t\u0011\u0005\u0011\u0010C\u0004\u0002*\u0012!\t!a\u000e\t\u000f\u0005-F\u0001\"\u0001\u0002.\"9\u0011Q\u0017\u0003\u0005\u0002\u0005]\u0006bBA_\t\u0011\u0005\u0011q\u0018\u0005\b\u0003\u0017$A\u0011BAg\u0011\u001d\t\u0019\u000e\u0002C\u0005\u0003+Dq!!9\u0005\t\u0013\t\u0019\u000fC\u0004\u0002p\u0012!I!!=\t\u000f\t\u0015A\u0001\"\u0003\u0003\b!9!\u0011\u0003\u0003\u0005\n\tM\u0001b\u0002B\f\t\u0011\u0005!\u0011\u0004\u0005\b\u0003C$A\u0011\u0001B\u0010\u0011\u001d\u0011)\u0003\u0002C\u0001\u0005OAqA!\n\u0005\t\u0003\u0011i\u0004C\u0004\u0003H\u0011!\tA!\u0013\t\u000f\tMC\u0001\"\u0003\u0003V!9!\u0011\r\u0003\u0005\n\t\r\u0004b\u0002B5\t\u0011%!1\u000e\u0005\b\u0005_\"A\u0011\u0002B9\u0011\u001d\t\u0019\b\u0002C\u0001\u0005w\nQbR3p[\u0016$(/_$sCBD'B\u0001\u001f>\u0003%9Wm\\7he\u0006\u0004\bN\u0003\u0002?\u007f\u0005\u0019!\u000e^:\u000b\u0005\u0001\u000b\u0015\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"\u0001\"\u0002\u0007=\u0014xm\u0001\u0001\u0011\u0005\u0015\u000bQ\"A\u001e\u0003\u001b\u001d+w.\\3uef<%/\u00199i'\t\t\u0001\n\u0005\u0002J\u00196\t!JC\u0001L\u0003\u0015\u00198-\u00197b\u0013\ti%J\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0011\u000b\u0011\u0003Z3uKJl\u0017N\\3C_VtG-\u0019:z)\r\u0011V+\u0018\t\u0003\u0013NK!\u0001\u0016&\u0003\u0007%sG\u000fC\u0003W\u0007\u0001\u0007q+\u0001\tc_VtG-\u0019:z\u001d>$WMU;mKB\u0011\u0001lW\u0007\u00023*\u0011!,P\u0001\nC2<wN]5uQ6L!\u0001X-\u0003!\t{WO\u001c3beftu\u000eZ3Sk2,\u0007\"\u00020\u0004\u0001\u0004\u0011\u0016!\u00042pk:$\u0017M]=D_VtGo\u0005\u0002\u0005AB\u0011Q)Y\u0005\u0003En\u00121\u0002\u00157b]\u0006\u0014xI]1qQ\u0006A\u0011M]4J]\u0012,\u00070F\u0001S\u00031\t'oZ%oI\u0016Dx\fJ3r)\t9'\u000e\u0005\u0002JQ&\u0011\u0011N\u0013\u0002\u0005+:LG\u000fC\u0004l\r\u0005\u0005\t\u0019\u0001*\u0002\u0007a$\u0013'A\u0005be\u001eLe\u000eZ3yA\u0005Q\u0001/\u0019:f]R<Um\\7\u0016\u0003=\u0004\"\u0001]:\u000e\u0003ET!A]\u001f\u0002\t\u001d,w.\\\u0005\u0003iF\u0014\u0001bR3p[\u0016$(/_\u0001\u000fa\u0006\u0014XM\u001c;HK>lw\fJ3r)\t9w\u000fC\u0004l\u0013\u0005\u0005\t\u0019A8\u0002\u0017A\f'/\u001a8u\u000f\u0016|W\u000eI\u000b\u0002/\u0006\t\"m\\;oI\u0006\u0014\u0018PT8eKJ+H.\u001a\u0011\u0015\tqlhp \t\u0003\u000b\u0012AQaY\u0007A\u0002ICQ!\\\u0007A\u0002=DQAV\u0007A\u0002]\u000b1\u0002\\5oK\u0016#w-Z'baV\u0011\u0011Q\u0001\t\t\u0003\u000f\t\t\"!\u0006\u0002\u001c5\u0011\u0011\u0011\u0002\u0006\u0005\u0003\u0017\ti!\u0001\u0003vi&d'BAA\b\u0003\u0011Q\u0017M^1\n\t\u0005M\u0011\u0011\u0002\u0002\b\u0011\u0006\u001c\b.T1q!\r\u0001\u0018qC\u0005\u0004\u00033\t(A\u0003'j]\u0016\u001cFO]5oOB\u0019Q)!\b\n\u0007\u0005}1H\u0001\u0003FI\u001e,\u0017\u0001\u00047j]\u0016,EmZ3NCB\u0004\u0013\u0001H;tK\n{WO\u001c3bef$U\r^3s[&t\u0017\r^5p]J+H.Z\u000b\u0003\u0003O\u00012!SA\u0015\u0013\r\tYC\u0013\u0002\b\u0005>|G.Z1o\u0003\u0001*8/\u001a\"pk:$\u0017M]=EKR,'/\\5oCRLwN\u001c*vY\u0016|F%Z9\u0015\u0007\u001d\f\t\u0004\u0003\u0005l#\u0005\u0005\t\u0019AA\u0014\u0003u)8/\u001a\"pk:$\u0017M]=EKR,'/\\5oCRLwN\u001c*vY\u0016\u0004\u0013!\u00042pk:$\u0017M]=O_\u0012,7/\u0006\u0002\u0002:A1\u0011qAA\u001e\u0003\u007fIA!!\u0010\u0002\n\tQ1i\u001c7mK\u000e$\u0018n\u001c8\u0011\u0007\u0015\u000b\t%C\u0002\u0002Dm\u0012AAT8eK\u0006\t\"m\\;oI\u0006\u0014\u0018PT8eKN|F%Z9\u0015\u0007\u001d\fI\u0005\u0003\u0005l)\u0005\u0005\t\u0019AA\u001d\u00039\u0011w.\u001e8eCJLhj\u001c3fg\u0002\nq\u0002[1t)>|g)Z<Q_&tGo]\u0001\u0014Q\u0006\u001cHk\\8GK^\u0004v.\u001b8ug~#S-\u001d\u000b\u0004O\u0006M\u0003\u0002C6\u0018\u0003\u0003\u0005\r!a\n\u0002!!\f7\u000fV8p\r\u0016<\bk\\5oiN\u0004\u0013\u0001D5om\u0006d\u0017\u000e\u001a)pS:$XCAA.!\r\u0001\u0018QL\u0005\u0004\u0003?\n(AC\"p_J$\u0017N\\1uK\u0006\u0001\u0012N\u001c<bY&$\u0007k\\5oi~#S-\u001d\u000b\u0004O\u0006\u0015\u0004\u0002C6\u001b\u0003\u0003\u0005\r!a\u0017\u0002\u001b%tg/\u00197jIB{\u0017N\u001c;!\u00035\t'/Z1Qi2{7-\u0019;peV\u0011\u0011Q\u000e\t\u0005\u0003_\n)(\u0004\u0002\u0002r)\u0019\u00111O-\u0002\r1|7-\u0019;f\u0013\u0011\t9(!\u001d\u0003-A{\u0017N\u001c;P]\u001e+w.\\3uefdunY1u_J\f\u0011#\u0019:fCB#Hj\\2bi>\u0014x\fJ3r)\r9\u0017Q\u0010\u0005\tWv\t\t\u00111\u0001\u0002n\u0005q\u0011M]3b!RdunY1u_J\u0004\u0013!\u00039u\u0019>\u001c\u0017\r^8s+\t\t)\tE\u0002Y\u0003\u000fK1!!#Z\u00051\u0001v.\u001b8u\u0019>\u001c\u0017\r^8s\u0003)\u0001H\u000fT8dCR|'\u000fI\u0001\u0019GJ,\u0017\r^3FI\u001e,7+\u001a;J]R,'o]3di>\u0014XCAAI!\u0011\t\u0019*!'\u000e\u0005\u0005U%bAALw\u0005)\u0011N\u001c3fq&!\u00111TAK\u0005q\u0019\u0016.\u001c9mK6\u001b5k^3fa2Kg.Z%oi\u0016\u00148/Z2u_J$R\u0001`AP\u0003CCQa\u0019\u0012A\u0002ICQ!\u001c\u0012A\u0002=\fqbZ3u\u0013:4\u0018\r\\5e!>Lg\u000e^\u0001\fO\u0016$x)Z8nKR\u0014\u00180A\nhKR\u0014u.\u001e8eCJLhj\u001c3f%VdW-\u0001\thKR\u0014u.\u001e8eCJLhj\u001c3fg\u0006\tr-\u001a;C_VtG-\u0019:z!>Lg\u000e^:\u0016\u0005\u0005=\u0006#B%\u00022\u0006m\u0013bAAZ\u0015\n)\u0011I\u001d:bs\u0006Aa-\u001b8e\u000b\u0012<W\r\u0006\u0003\u0002\u001c\u0005e\u0006bBA^Q\u0001\u0007\u0011QC\u0001\u0005Y&tW-A\td_6\u0004X\u000f^3Ta2LG/\u00123hKN$2aZAa\u0011\u001d\t\u0019-\u000ba\u0001\u0003\u000b\f\u0001\"\u001a3hK2L7\u000f\u001e\t\u0007\u0003\u000f\t9-a\u0007\n\t\u0005%\u0017\u0011\u0002\u0002\u0005\u0019&\u001cH/A\u0002bI\u0012$2aZAh\u0011\u0019\t\tN\u000ba\u0001_\u0006\tq-A\u0007bI\u0012\u001cu\u000e\u001c7fGRLwN\u001c\u000b\u0004O\u0006]\u0007bBAmW\u0001\u0007\u00111\\\u0001\u0003O\u000e\u00042\u0001]Ao\u0013\r\ty.\u001d\u0002\u0013\u000f\u0016|W.\u001a;ss\u000e{G\u000e\\3di&|g.\u0001\u0005bI\u0012\u0004v.\u001b8u)\r9\u0017Q\u001d\u0005\b\u0003Od\u0003\u0019AAu\u0003\u0005\u0001\bc\u00019\u0002l&\u0019\u0011Q^9\u0003\u000bA{\u0017N\u001c;\u0002\u001d\u0005$G\rU8ms\u001e|gNU5oOR9q-a=\u0002~\n\u0005\u0001bBA{[\u0001\u0007\u0011q_\u0001\u0003YJ\u00042\u0001]A}\u0013\r\tY0\u001d\u0002\u000b\u0019&tW-\u0019:SS:<\u0007BBA\u0000[\u0001\u0007!+\u0001\u0004do2+g\r\u001e\u0005\u0007\u0005\u0007i\u0003\u0019\u0001*\u0002\u000f\r<(+[4ii\u0006Q\u0011\r\u001a3Q_2Lxm\u001c8\u0015\u0007\u001d\u0014I\u0001C\u0004\u0002h:\u0002\rAa\u0003\u0011\u0007A\u0014i!C\u0002\u0003\u0010E\u0014q\u0001U8ms\u001e|g.A\u0007bI\u0012d\u0015N\\3TiJLgn\u001a\u000b\u0004O\nU\u0001bBA^_\u0001\u0007\u0011QC\u0001\bC\u0012$W\tZ4f)\r9'1\u0004\u0005\b\u0005;\u0001\u0004\u0019AA\u000e\u0003\u0005)GcA4\u0003\"!9!1E\u0019A\u0002\u0005m\u0013A\u00019u\u0003A\u0019w.\u001c9vi\u0016\u001cV\r\u001c4O_\u0012,7\u000f\u0006\u0004\u0003*\t=\"\u0011\b\t\u0005\u0003'\u0013Y#\u0003\u0003\u0003.\u0005U%AE*fO6,g\u000e^%oi\u0016\u00148/Z2u_JDqA!\r3\u0001\u0004\u0011\u0019$\u0001\u0002mSB\u0019\u0001L!\u000e\n\u0007\t]\u0012LA\bMS:,\u0017J\u001c;feN,7\r^8s\u0011\u001d\u0011YD\ra\u0001\u0003O\tAcY8naV$XMU5oON+GN\u001a(pI\u0016\u001cH\u0003\u0003B\u0015\u0005\u007f\u0011\tEa\u0011\t\u000f\tE2\u00071\u0001\u00034!9!1H\u001aA\u0002\u0005\u001d\u0002b\u0002B#g\u0001\u0007\u0011qE\u0001\u0012SN$uN\\3JMB\u0013x\u000e]3s\u0013:$\u0018\u0001G2p[B,H/Z#eO\u0016Le\u000e^3sg\u0016\u001cG/[8ogRA!\u0011\u0006B&\u0005\u001b\u0012y\u0005\u0003\u0004\u0002RR\u0002\r\u0001 \u0005\b\u0005c!\u0004\u0019\u0001B\u001a\u0011\u001d\u0011\t\u0006\u000ea\u0001\u0003O\tQ\"\u001b8dYV$W\r\u0015:pa\u0016\u0014\u0018aC5og\u0016\u0014H\u000fU8j]R$ra\u001aB,\u00053\u0012i\u0006C\u0003dk\u0001\u0007!\u000bC\u0004\u0003\\U\u0002\r!a\u0017\u0002\u000b\r|wN\u001d3\t\r\t}S\u00071\u0001S\u0003)yg\u000eT8dCRLwN\\\u0001\u0014S:\u001cXM\u001d;C_VtG-\u0019:z!>Lg\u000e\u001e\u000b\u0006O\n\u0015$q\r\u0005\u0006GZ\u0002\rA\u0015\u0005\b\u000572\u0004\u0019AA.\u0003a\tG\rZ*fY\u001aLe\u000e^3sg\u0016\u001cG/[8o\u001d>$Wm\u001d\u000b\u0004O\n5\u0004\"B28\u0001\u0004\u0011\u0016aF1eIN+GNZ%oi\u0016\u00148/Z2uS>tgj\u001c3f)\u001d9'1\u000fB;\u0005oBQa\u0019\u001dA\u0002ICqAa\u00179\u0001\u0004\tY\u0006\u0003\u0004\u0003za\u0002\rAU\u0001\u0004Y>\u001cGc\u0001*\u0003~!9!1E\u001dA\u0002\u0005m\u0003")
public class GeometryGraph
extends PlanarGraph {
    private int argIndex;
    private Geometry parentGeom;
    private final BoundaryNodeRule boundaryNodeRule;
    private final HashMap<LineString, Edge> lineEdgeMap;
    private boolean useBoundaryDeterminationRule;
    private Collection<Node> boundaryNodes;
    private boolean hasTooFewPoints;
    private Coordinate invalidPoint;
    private PointOnGeometryLocator areaPtLocator;
    private final PointLocator ptLocator;
    private volatile byte bitmap$init$0;

    public static int determineBoundary(BoundaryNodeRule boundaryNodeRule, int n) {
        return GeometryGraph$.MODULE$.determineBoundary(boundaryNodeRule, n);
    }

    public int argIndex() {
        return this.argIndex;
    }

    public void argIndex_$eq(int x$1) {
        this.argIndex = x$1;
    }

    public Geometry parentGeom() {
        return this.parentGeom;
    }

    public void parentGeom_$eq(Geometry x$1) {
        this.parentGeom = x$1;
    }

    public BoundaryNodeRule boundaryNodeRule() {
        return this.boundaryNodeRule;
    }

    private HashMap<LineString, Edge> lineEdgeMap() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/geomgraph/GeometryGraph.scala: 79");
        }
        return this.lineEdgeMap;
    }

    private boolean useBoundaryDeterminationRule() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/geomgraph/GeometryGraph.scala: 88");
        }
        return this.useBoundaryDeterminationRule;
    }

    private void useBoundaryDeterminationRule_$eq(boolean x$1) {
        this.useBoundaryDeterminationRule = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
    }

    private Collection<Node> boundaryNodes() {
        if ((byte)(this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/geomgraph/GeometryGraph.scala: 89");
        }
        return this.boundaryNodes;
    }

    private void boundaryNodes_$eq(Collection<Node> x$1) {
        this.boundaryNodes = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
    }

    public boolean hasTooFewPoints() {
        if ((byte)(this.bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/geomgraph/GeometryGraph.scala: 90");
        }
        return this.hasTooFewPoints;
    }

    public void hasTooFewPoints_$eq(boolean x$1) {
        this.hasTooFewPoints = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
    }

    private Coordinate invalidPoint() {
        if ((byte)(this.bitmap$init$0 & 0x10) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/geomgraph/GeometryGraph.scala: 91");
        }
        return this.invalidPoint;
    }

    private void invalidPoint_$eq(Coordinate x$1) {
        this.invalidPoint = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x10);
    }

    private PointOnGeometryLocator areaPtLocator() {
        if ((byte)(this.bitmap$init$0 & 0x20) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/geomgraph/GeometryGraph.scala: 92");
        }
        return this.areaPtLocator;
    }

    private void areaPtLocator_$eq(PointOnGeometryLocator x$1) {
        this.areaPtLocator = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x20);
    }

    private final PointLocator ptLocator() {
        if ((byte)(this.bitmap$init$0 & 0x40) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/geomgraph/GeometryGraph.scala: 94");
        }
        return this.ptLocator;
    }

    private SimpleMCSweepLineIntersector createEdgeSetIntersector() {
        return new SimpleMCSweepLineIntersector();
    }

    public Coordinate getInvalidPoint() {
        return this.invalidPoint();
    }

    public Geometry getGeometry() {
        return this.parentGeom();
    }

    public BoundaryNodeRule getBoundaryNodeRule() {
        return this.boundaryNodeRule();
    }

    public Collection<Node> getBoundaryNodes() {
        block0: {
            if (this.boundaryNodes() != null) break block0;
            this.boundaryNodes_$eq(this.nodes().getBoundaryNodes(this.argIndex()));
        }
        return this.boundaryNodes();
    }

    /*
     * WARNING - void declaration
     */
    public Coordinate[] getBoundaryPoints() {
        void var2_2;
        Collection<Node> coll = this.getBoundaryNodes();
        Coordinate[] pts = new Coordinate[coll.size()];
        int i = 0;
        for (Node node : coll) {
            pts[++i - 1] = node.getCoordinate().copy();
        }
        return var2_2;
    }

    public Edge findEdge(LineString line) {
        return this.lineEdgeMap().get(line);
    }

    public void computeSplitEdges(List<Edge> edgelist) {
        for (Edge e : this.edges()) {
            e.eiList().addSplitEdges(edgelist);
        }
    }

    private void add(Geometry g) {
        if (g.isEmpty()) {
            return;
        }
        if (g instanceof MultiPolygon) {
            this.useBoundaryDeterminationRule_$eq(false);
        }
        if (g instanceof Polygon) {
            this.addPolygon((Polygon)g);
        } else if (g instanceof LineString) {
            this.addLineString((LineString)g);
        } else if (g instanceof Point) {
            this.addPoint((Point)g);
        } else if (g instanceof MultiPoint) {
            this.addCollection((MultiPoint)g);
        } else if (g instanceof MultiLineString) {
            this.addCollection((MultiLineString)g);
        } else if (g instanceof MultiPolygon) {
            this.addCollection((MultiPolygon)g);
        } else if (g instanceof GeometryCollection) {
            this.addCollection((GeometryCollection)g);
        } else {
            throw new UnsupportedOperationException(g.getClass().getName());
        }
    }

    private void addCollection(GeometryCollection gc) {
        for (int i = 0; i < gc.getNumGeometries(); ++i) {
            Geometry g = gc.getGeometryN(i);
            this.add(g);
        }
    }

    private void addPoint(Point p) {
        Coordinate coord = p.getCoordinate();
        this.insertPoint(this.argIndex(), coord, Location$.MODULE$.INTERIOR());
    }

    private void addPolygonRing(LinearRing lr, int cwLeft, int cwRight) {
        if (lr.isEmpty()) {
            return;
        }
        Coordinate[] coord = CoordinateArrays$.MODULE$.removeRepeatedPoints(lr.getCoordinates());
        if (coord.length < 4) {
            this.hasTooFewPoints_$eq(true);
            this.invalidPoint_$eq(coord[0]);
            return;
        }
        int left = cwLeft;
        int right = cwRight;
        if (Orientation$.MODULE$.isCCW(coord)) {
            left = cwRight;
            right = cwLeft;
        }
        Edge e = new Edge(coord, new Label(this.argIndex(), Location$.MODULE$.BOUNDARY(), left, right));
        this.lineEdgeMap().put(lr, e);
        this.insertEdge(e);
        this.insertPoint(this.argIndex(), coord[0], Location$.MODULE$.BOUNDARY());
    }

    private void addPolygon(Polygon p) {
        this.addPolygonRing(p.getExteriorRing(), Location$.MODULE$.EXTERIOR(), Location$.MODULE$.INTERIOR());
        for (int i = 0; i < p.getNumInteriorRing(); ++i) {
            LinearRing hole = p.getInteriorRingN(i);
            this.addPolygonRing(hole, Location$.MODULE$.INTERIOR(), Location$.MODULE$.EXTERIOR());
        }
    }

    private void addLineString(LineString line) {
        Coordinate[] coord = CoordinateArrays$.MODULE$.removeRepeatedPoints(line.getCoordinates());
        if (coord.length < 2) {
            this.hasTooFewPoints_$eq(true);
            this.invalidPoint_$eq(coord[0]);
            return;
        }
        Edge e = new Edge(coord, new Label(this.argIndex(), Location$.MODULE$.INTERIOR()));
        this.lineEdgeMap().put(line, e);
        this.insertEdge(e);
        Assert$.MODULE$.isTrue(coord.length >= 2, "found LineString with single point");
        this.insertBoundaryPoint(this.argIndex(), coord[0]);
        this.insertBoundaryPoint(this.argIndex(), coord[coord.length - 1]);
    }

    public void addEdge(Edge e) {
        this.insertEdge(e);
        Coordinate[] coord = e.getCoordinates();
        this.insertPoint(this.argIndex(), coord[0], Location$.MODULE$.BOUNDARY());
        this.insertPoint(this.argIndex(), coord[coord.length - 1], Location$.MODULE$.BOUNDARY());
    }

    public void addPoint(Coordinate pt) {
        this.insertPoint(this.argIndex(), pt, Location$.MODULE$.INTERIOR());
    }

    public SegmentIntersector computeSelfNodes(LineIntersector li, boolean computeRingSelfNodes) {
        return this.computeSelfNodes(li, computeRingSelfNodes, false);
    }

    public SegmentIntersector computeSelfNodes(LineIntersector li, boolean computeRingSelfNodes, boolean isDoneIfProperInt) {
        SegmentIntersector si = new SegmentIntersector(li, true, false);
        si.setIsDoneIfProperInt(isDoneIfProperInt);
        SimpleMCSweepLineIntersector esi = this.createEdgeSetIntersector();
        boolean isRings = this.parentGeom() instanceof LinearRing || this.parentGeom() instanceof Polygon || this.parentGeom() instanceof MultiPolygon;
        boolean computeAllSegments = computeRingSelfNodes || !isRings;
        esi.computeIntersections(this.edges(), si, computeAllSegments);
        this.addSelfIntersectionNodes(this.argIndex());
        return si;
    }

    public SegmentIntersector computeEdgeIntersections(GeometryGraph g, LineIntersector li, boolean includeProper) {
        SegmentIntersector si = new SegmentIntersector(li, includeProper, true);
        si.setBoundaryNodes(this.getBoundaryNodes(), g.getBoundaryNodes());
        SimpleMCSweepLineIntersector esi = this.createEdgeSetIntersector();
        esi.computeIntersections(this.edges(), g.edges(), si);
        return si;
    }

    private void insertPoint(int argIndex, Coordinate coord, int onLocation) {
        Node n = this.nodes().addNode(coord);
        Label lbl = n.getLabel();
        if (lbl == null) {
            n.label_$eq(new Label(argIndex, onLocation));
        } else {
            lbl.setLocation(argIndex, onLocation);
        }
    }

    private void insertBoundaryPoint(int argIndex, Coordinate coord) {
        Node n = this.nodes().addNode(coord);
        Label lbl = n.getLabel();
        int boundaryCount = 1;
        int loc = Location$.MODULE$.NONE();
        loc = lbl.getLocation(argIndex, Position$.MODULE$.ON());
        Object object = loc == Location$.MODULE$.BOUNDARY() ? BoxesRunTime.boxToInteger((int)(++boundaryCount - 1)) : BoxedUnit.UNIT;
        int newLoc = GeometryGraph$.MODULE$.determineBoundary(this.boundaryNodeRule(), boundaryCount);
        lbl.setLocation(argIndex, newLoc);
    }

    private void addSelfIntersectionNodes(int argIndex) {
        for (Edge e : this.edges()) {
            int eLoc = e.getLabel().getLocation(argIndex);
            Iterator<EdgeIntersection> eiIt = e.eiList().iterator();
            while (eiIt.hasNext()) {
                EdgeIntersection ei = eiIt.next();
                this.addSelfIntersectionNode(argIndex, ei.coord(), eLoc);
            }
        }
    }

    private void addSelfIntersectionNode(int argIndex, Coordinate coord, int loc) {
        if (this.isBoundaryNode(argIndex, coord)) {
            return;
        }
        if (loc == Location$.MODULE$.BOUNDARY() && this.useBoundaryDeterminationRule()) {
            this.insertBoundaryPoint(argIndex, coord);
        } else {
            this.insertPoint(argIndex, coord, loc);
        }
    }

    public int locate(Coordinate pt) {
        if (this.parentGeom() instanceof Polygonal && this.parentGeom().getNumGeometries() > 50) {
            if (this.areaPtLocator() == null) {
                this.areaPtLocator_$eq(new IndexedPointInAreaLocator(this.parentGeom()));
            }
            return this.areaPtLocator().locate(pt);
        }
        return this.ptLocator().locate(pt, this.parentGeom());
    }

    public GeometryGraph(int argIndex, Geometry parentGeom, BoundaryNodeRule boundaryNodeRule) {
        this.argIndex = argIndex;
        this.parentGeom = parentGeom;
        this.boundaryNodeRule = boundaryNodeRule;
        this.lineEdgeMap = new HashMap();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        if (this.parentGeom() != null) {
            this.add(this.parentGeom());
        }
        this.useBoundaryDeterminationRule = true;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.boundaryNodes = null;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
        this.hasTooFewPoints = false;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
        this.invalidPoint = null;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x10);
        this.areaPtLocator = null;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x20);
        this.ptLocator = new PointLocator(PointLocator$.MODULE$.$lessinit$greater$default$1());
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x40);
    }

    public GeometryGraph(int argIndex, Geometry parentGeom) {
        this(argIndex, parentGeom, BoundaryNodeRule$.MODULE$.OGC_SFS_BOUNDARY_RULE());
    }
}

