/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geomgraph;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.locationtech.jts.algorithm.Orientation$;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Location$;
import org.locationtech.jts.geomgraph.DirectedEdge;
import org.locationtech.jts.geomgraph.DirectedEdgeStar;
import org.locationtech.jts.geomgraph.Edge;
import org.locationtech.jts.geomgraph.EdgeEnd;
import org.locationtech.jts.geomgraph.Label;
import org.locationtech.jts.geomgraph.Node;
import org.locationtech.jts.geomgraph.NodeFactory;
import org.locationtech.jts.geomgraph.NodeMap;
import org.locationtech.jts.geomgraph.Quadrant$;
import scala.UninitializedFieldError;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005%v!B\u0013'\u0011\u0003yc!B\u0019'\u0011\u0003\u0011\u0004\"B\u001d\u0002\t\u0003Q\u0004\"B\u001e\u0002\t\u0003ad\u0001B\u0019'\u00015C\u0001B\u0014\u0003\u0003\u0002\u0003\u0006Ia\u0014\u0005\u0006s\u0011!\tA\u0015\u0005\b+\u0012\u0001\r\u0011\"\u0005W\u0011\u001diF\u00011A\u0005\u0012yCa!\u0019\u0003!B\u00139\u0006bB!\u0005\u0001\u0004%\tB\u0019\u0005\bM\u0012\u0001\r\u0011\"\u0005h\u0011\u0019IG\u0001)Q\u0005G\"9!\u000e\u0002a\u0001\n#Y\u0007b\u00029\u0005\u0001\u0004%\t\"\u001d\u0005\u0007g\u0012\u0001\u000b\u0015\u00027\t\u000be\"A\u0011\u0001;\t\u000bU$A\u0011\u0001<\t\u000bi$A\u0011A6\t\u000bm$A\u0011\u0001?\t\u000f\u0005mA\u0001\"\u0005\u0002\u001e!9\u00111\u0005\u0003\u0005\u0002\u0005\u0015\u0002bBA\u0015\t\u0011\u0005\u00111\u0006\u0005\b\u0003_!A\u0011AA\u0019\u0011\u001d\t\u0019\u0004\u0002C\u0001\u0003kAq!a\r\u0005\t\u0003\tY\u0004C\u0004\u0002@\u0011!\t!!\u0011\t\u000f\u0005\u0015C\u0001\"\u0001\u0002H!11\b\u0002C\u0001\u0003'Bq!!\u0016\u0005\t\u0003\t\u0019\u0006C\u0004\u0002X\u0011!\t!!\u0017\t\u000f\u0005uC\u0001\"\u0001\u0002`!9\u0011\u0011\u000e\u0003\u0005\u0002\u0005-\u0004bBA9\t\u0011%\u00111\u000f\u0005\b\u0003\u0003#A\u0011AAB\u0011!\t)\n\u0002C\u0001M\u0005]\u0005\u0002CAR\t\u0011\u0005a%!*\u0002\u0017Ac\u0017M\\1s\u000fJ\f\u0007\u000f\u001b\u0006\u0003O!\n\u0011bZ3p[\u001e\u0014\u0018\r\u001d5\u000b\u0005%R\u0013a\u00016ug*\u00111\u0006L\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002[\u0005\u0019qN]4\u0004\u0001A\u0011\u0001'A\u0007\u0002M\tY\u0001\u000b\\1oCJ<%/\u00199i'\t\t1\u0007\u0005\u00025o5\tQGC\u00017\u0003\u0015\u00198-\u00197b\u0013\tATG\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003=\nq\u0003\\5oWJ+7/\u001e7u\t&\u0014Xm\u0019;fI\u0016#w-Z:\u0015\u0005u\u0002\u0005C\u0001\u001b?\u0013\tyTG\u0001\u0003V]&$\b\"B!\u0004\u0001\u0004\u0011\u0015!\u00028pI\u0016\u001c\bcA\"I\u00156\tAI\u0003\u0002F\r\u0006!Q\u000f^5m\u0015\u00059\u0015\u0001\u00026bm\u0006L!!\u0013#\u0003\u0015\r{G\u000e\\3di&|g\u000e\u0005\u00021\u0017&\u0011AJ\n\u0002\u0005\u001d>$Wm\u0005\u0002\u0005g\u0005Aan\u001c3f\r\u0006\u001cG\u000f\u0005\u00021!&\u0011\u0011K\n\u0002\f\u001d>$WMR1di>\u0014\u0018\u0010\u0006\u0002T)B\u0011\u0001\u0007\u0002\u0005\u0006\u001d\u001a\u0001\raT\u0001\u0006K\u0012<Wm]\u000b\u0002/B\u00191\t\u0017.\n\u0005e#%!C!se\u0006LH*[:u!\t\u00014,\u0003\u0002]M\t!Q\tZ4f\u0003%)GmZ3t?\u0012*\u0017\u000f\u0006\u0002>?\"9\u0001\rCA\u0001\u0002\u00049\u0016a\u0001=%c\u00051Q\rZ4fg\u0002*\u0012a\u0019\t\u0003a\u0011L!!\u001a\u0014\u0003\u000f9{G-Z'ba\u0006Ian\u001c3fg~#S-\u001d\u000b\u0003{!Dq\u0001Y\u0006\u0002\u0002\u0003\u00071-\u0001\u0004o_\u0012,7\u000fI\u0001\fK\u0012<W-\u00128e\u0019&\u001cH/F\u0001m!\r\u0019\u0005,\u001c\t\u0003a9L!a\u001c\u0014\u0003\u000f\u0015#w-Z#oI\u0006yQ\rZ4f\u000b:$G*[:u?\u0012*\u0017\u000f\u0006\u0002>e\"9\u0001MDA\u0001\u0002\u0004a\u0017\u0001D3eO\u0016,e\u000e\u001a'jgR\u0004C#A*\u0002\u001f\u001d,G/\u00123hK&#XM]1u_J,\u0012a\u001e\t\u0004\u0007bT\u0016BA=E\u0005!IE/\u001a:bi>\u0014\u0018aC4fi\u0016#w-Z#oIN\fa\"[:C_VtG-\u0019:z\u001d>$W\rF\u0003~\u0003\u0003\tY\u0001\u0005\u00025}&\u0011q0\u000e\u0002\b\u0005>|G.Z1o\u0011\u001d\t\u0019a\u0005a\u0001\u0003\u000b\t\u0011bZ3p[&sG-\u001a=\u0011\u0007Q\n9!C\u0002\u0002\nU\u00121!\u00138u\u0011\u001d\tia\u0005a\u0001\u0003\u001f\tQaY8pe\u0012\u0004B!!\u0005\u0002\u00185\u0011\u00111\u0003\u0006\u0004\u0003+A\u0013\u0001B4f_6LA!!\u0007\u0002\u0014\tQ1i\\8sI&t\u0017\r^3\u0002\u0015%t7/\u001a:u\u000b\u0012<W\rF\u0002~\u0003?Aa!!\t\u0015\u0001\u0004Q\u0016!A3\u0002\u0007\u0005$G\rF\u0002~\u0003OAa!!\t\u0016\u0001\u0004i\u0017aD4fi:{G-Z%uKJ\fGo\u001c:\u0016\u0005\u00055\u0002cA\"y\u0015\u0006Aq-\u001a;O_\u0012,7/F\u0001C\u0003\u001d\tG\r\u001a(pI\u0016$2ASA\u001c\u0011\u0019\tI\u0004\u0007a\u0001\u0015\u0006!an\u001c3f)\rQ\u0015Q\b\u0005\b\u0003\u001bI\u0002\u0019AA\b\u0003\u00111\u0017N\u001c3\u0015\u0007)\u000b\u0019\u0005C\u0004\u0002\u000ei\u0001\r!a\u0004\u0002\u0011\u0005$G-\u00123hKN$2!PA%\u0011\u001d\tYe\u0007a\u0001\u0003\u001b\n!\"\u001a3hKN$v.\u00113e!\u0011\u0019\u0015q\n.\n\u0007\u0005ECI\u0001\u0003MSN$H#A\u001f\u0002)1Lgn[!mY\u0012K'/Z2uK\u0012,EmZ3t\u0003-1\u0017N\u001c3FI\u001e,WI\u001c3\u0015\u00075\fY\u0006\u0003\u0004\u0002\"y\u0001\rAW\u0001\tM&tG-\u00123hKR)!,!\u0019\u0002f!9\u00111M\u0010A\u0002\u0005=\u0011A\u000191\u0011\u001d\t9g\ba\u0001\u0003\u001f\t!\u0001]\u0019\u0002/\u0019Lg\u000eZ#eO\u0016LenU1nK\u0012K'/Z2uS>tG#\u0002.\u0002n\u0005=\u0004bBA2A\u0001\u0007\u0011q\u0002\u0005\b\u0003O\u0002\u0003\u0019AA\b\u0003Qi\u0017\r^2i\u0013:\u001c\u0016-\\3ESJ,7\r^5p]RIQ0!\u001e\u0002x\u0005e\u0014Q\u0010\u0005\b\u0003G\n\u0003\u0019AA\b\u0011\u001d\t9'\ta\u0001\u0003\u001fAq!a\u001f\"\u0001\u0004\ty!A\u0002faBBq!a \"\u0001\u0004\ty!A\u0002faF\n!\u0002\u001d:j]R,EmZ3t)\ri\u0014Q\u0011\u0005\b\u0003\u000f\u0013\u0003\u0019AAE\u0003\ryW\u000f\u001e\t\u0005\u0003\u0017\u000b\t*\u0004\u0002\u0002\u000e*\u0019\u0011q\u0012$\u0002\u0005%|\u0017\u0002BAJ\u0003\u001b\u00131\u0002\u0015:j]R\u001cFO]3b[\u0006QA-\u001a2vOB\u0013\u0018N\u001c;\u0015\u0007u\nI\nC\u0004\u0002\u001c\u000e\u0002\r!!(\u0002\u0003=\u00042\u0001NAP\u0013\r\t\t+\u000e\u0002\u0004\u0003:L\u0018\u0001\u00043fEV<\u0007K]5oi2tGcA\u001f\u0002(\"9\u00111\u0014\u0013A\u0002\u0005u\u0005")
public class PlanarGraph {
    private ArrayList<Edge> edges = new ArrayList();
    private NodeMap nodes;
    private ArrayList<EdgeEnd> edgeEndList;
    private volatile byte bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);

    public ArrayList<Edge> edges() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/geomgraph/PlanarGraph.scala: 71");
        }
        return this.edges;
    }

    public void edges_$eq(ArrayList<Edge> x$1) {
        this.edges = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
    }

    public NodeMap nodes() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/geomgraph/PlanarGraph.scala: 72");
        }
        return this.nodes;
    }

    public void nodes_$eq(NodeMap x$1) {
        this.nodes = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
    }

    public ArrayList<EdgeEnd> edgeEndList() {
        if ((byte)(this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/geomgraph/PlanarGraph.scala: 73");
        }
        return this.edgeEndList;
    }

    public void edgeEndList_$eq(ArrayList<EdgeEnd> x$1) {
        this.edgeEndList = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
    }

    public Iterator<Edge> getEdgeIterator() {
        return this.edges().iterator();
    }

    public ArrayList<EdgeEnd> getEdgeEnds() {
        return this.edgeEndList();
    }

    public boolean isBoundaryNode(int geomIndex, Coordinate coord) {
        Node node = this.nodes().find(coord);
        if (node == null) {
            return false;
        }
        Label label = node.getLabel();
        return label != null && label.getLocation(geomIndex) == Location$.MODULE$.BOUNDARY();
    }

    public boolean insertEdge(Edge e) {
        return this.edges().add(e);
    }

    public boolean add(EdgeEnd e) {
        this.nodes().add(e);
        return this.edgeEndList().add(e);
    }

    public Iterator<Node> getNodeIterator() {
        return this.nodes().iterator();
    }

    public Collection<Node> getNodes() {
        return this.nodes().values();
    }

    public Node addNode(Node node) {
        return this.nodes().addNode(node);
    }

    public Node addNode(Coordinate coord) {
        return this.nodes().addNode(coord);
    }

    public Node find(Coordinate coord) {
        return this.nodes().find(coord);
    }

    public void addEdges(List<Edge> edgesToAdd) {
        for (Edge e : edgesToAdd) {
            this.edges().add(e);
            DirectedEdge de1 = new DirectedEdge(e, true);
            DirectedEdge de2 = new DirectedEdge(e, false);
            de1.setSym(de2);
            de2.setSym(de1);
            this.add(de1);
            this.add(de2);
        }
    }

    public void linkResultDirectedEdges() {
        Iterator<Node> nodeit = this.nodes().iterator();
        while (nodeit.hasNext()) {
            Node node = nodeit.next();
            ((DirectedEdgeStar)node.getEdges()).linkResultDirectedEdges();
        }
    }

    public void linkAllDirectedEdges() {
        Iterator<Node> nodeit = this.nodes().iterator();
        while (nodeit.hasNext()) {
            Node node = nodeit.next();
            ((DirectedEdgeStar)node.getEdges()).linkAllDirectedEdges();
        }
    }

    public EdgeEnd findEdgeEnd(Edge e) {
        for (EdgeEnd ee : this.getEdgeEnds()) {
            if (ee.getEdge() != e) continue;
            return ee;
        }
        return null;
    }

    public Edge findEdge(Coordinate p0, Coordinate p1) {
        for (int i = 0; i < this.edges().size(); ++i) {
            Edge e = this.edges().get(i);
            Coordinate[] eCoord = e.getCoordinates();
            Coordinate coordinate = p0;
            Coordinate coordinate2 = eCoord[0];
            if (coordinate != null ? !((Object)coordinate).equals(coordinate2) : coordinate2 != null) continue;
            Coordinate coordinate3 = p1;
            Coordinate coordinate4 = eCoord[1];
            if (coordinate3 != null ? !((Object)coordinate3).equals(coordinate4) : coordinate4 != null) continue;
            return e;
        }
        return null;
    }

    public Edge findEdgeInSameDirection(Coordinate p0, Coordinate p1) {
        for (int i = 0; i < this.edges().size(); ++i) {
            Edge e = this.edges().get(i);
            Coordinate[] eCoord = e.getCoordinates();
            if (this.matchInSameDirection(p0, p1, eCoord[0], eCoord[1])) {
                return e;
            }
            if (!this.matchInSameDirection(p0, p1, eCoord[eCoord.length - 1], eCoord[eCoord.length - 2])) continue;
            return e;
        }
        return null;
    }

    private boolean matchInSameDirection(Coordinate p0, Coordinate p1, Coordinate ep0, Coordinate ep1) {
        Coordinate coordinate = p0;
        Coordinate coordinate2 = ep0;
        if (coordinate == null ? coordinate2 != null : !((Object)coordinate).equals(coordinate2)) {
            return false;
        }
        return Orientation$.MODULE$.index(p0, p1, ep1) == Orientation$.MODULE$.COLLINEAR() && Quadrant$.MODULE$.quadrant(p0, p1) == Quadrant$.MODULE$.quadrant(ep0, ep1);
    }

    public void printEdges(PrintStream out) {
        out.println("Edges:");
        for (int i = 0; i < this.edges().size(); ++i) {
            out.println(new StringBuilder(6).append("edge ").append(i).append(":").toString());
            Edge e = this.edges().get(i);
            e.print(out);
            e.eiList().print(out);
        }
    }

    public void debugPrint(Object o) {
        System.out.print(o);
    }

    public void debugPrintln(Object o) {
        System.out.println(o);
    }

    public PlanarGraph(NodeFactory nodeFact) {
        this.nodes = new NodeMap(nodeFact);
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.edgeEndList = new ArrayList();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
    }

    public PlanarGraph() {
        this(new NodeFactory());
    }
}

