/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geomgraph.index;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geomgraph.Quadrant$;
import org.locationtech.jts.geomgraph.index.MonotoneChainIndexer$;
import org.locationtech.jts.util.IntArrayList;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005%;Q!\u0003\u0006\t\u0002U1Qa\u0006\u0006\t\u0002aAQaH\u0001\u0005\u0002\u0001BQ!I\u0001\u0005\u0002\t2Aa\u0006\u0006\u0001g!)q\u0004\u0002C\u0001i!)a\u0007\u0002C\u0001o!)\u0011\t\u0002C\u0001\u0005\")A\t\u0002C\u0005\u000b\u0006!Rj\u001c8pi>tWm\u00115bS:Le\u000eZ3yKJT!a\u0003\u0007\u0002\u000b%tG-\u001a=\u000b\u00055q\u0011!C4f_6<'/\u00199i\u0015\ty\u0001#A\u0002kiNT!!\u0005\n\u0002\u00191|7-\u0019;j_:$Xm\u00195\u000b\u0003M\t1a\u001c:h\u0007\u0001\u0001\"AF\u0001\u000e\u0003)\u0011A#T8o_R|g.Z\"iC&t\u0017J\u001c3fq\u0016\u00148CA\u0001\u001a!\tQR$D\u0001\u001c\u0015\u0005a\u0012!B:dC2\f\u0017B\u0001\u0010\u001c\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!F\u0001\u000bi>Le\u000e^!se\u0006LHCA\u0012*!\rQBEJ\u0005\u0003Km\u0011Q!\u0011:sCf\u0004\"AG\u0014\n\u0005!Z\"aA%oi\")!f\u0001a\u0001W\u0005!A.[:u!\ra\u0013GJ\u0007\u0002[)\u0011afL\u0001\u0005kRLGNC\u00011\u0003\u0011Q\u0017M^1\n\u0005Ij#\u0001\u0002'jgR\u001c\"\u0001B\r\u0015\u0003U\u0002\"A\u0006\u0003\u0002)\u001d,Go\u00115bS:\u001cF/\u0019:u\u0013:$\u0017nY3t)\t\u0019\u0003\bC\u0003:\r\u0001\u0007!(A\u0002qiN\u00042A\u0007\u0013<!\tat(D\u0001>\u0015\tqd\"\u0001\u0003hK>l\u0017B\u0001!>\u0005)\u0019un\u001c:eS:\fG/Z\u0001\u0018\u001f2#u-\u001a;DQ\u0006Lgn\u0015;beRLe\u000eZ5dKN$\"aI\"\t\u000be:\u0001\u0019\u0001\u001e\u0002\u0019\u0019Lg\u000eZ\"iC&tWI\u001c3\u0015\u0007\u00192u\tC\u0003:\u0011\u0001\u0007!\bC\u0003I\u0011\u0001\u0007a%A\u0003ti\u0006\u0014H\u000f")
public class MonotoneChainIndexer {
    public static int[] toIntArray(List<Object> list) {
        return MonotoneChainIndexer$.MODULE$.toIntArray(list);
    }

    public int[] getChainStartIndices(Coordinate[] pts) {
        int start = 0;
        IntArrayList startIndexList = new IntArrayList(pts.length / 2);
        startIndexList.add(start);
        do {
            int last = this.findChainEnd(pts, start);
            startIndexList.add(last);
            start = last;
        } while (start < pts.length - 1);
        return startIndexList.toArray();
    }

    public int[] OLDgetChainStartIndices(Coordinate[] pts) {
        int start = 0;
        ArrayList<Object> startIndexList = new ArrayList<Object>();
        startIndexList.add(BoxesRunTime.boxToInteger((int)start));
        do {
            int last = this.findChainEnd(pts, start);
            startIndexList.add(BoxesRunTime.boxToInteger((int)last));
            start = last;
        } while (start < pts.length - 1);
        int[] startIndex = MonotoneChainIndexer$.MODULE$.toIntArray(startIndexList);
        return startIndex;
    }

    private int findChainEnd(Coordinate[] pts, int start) {
        int last;
        int chainQuad = Quadrant$.MODULE$.quadrant(pts[start], pts[start + 1]);
        for (last = start + 1; last < pts.length; ++last) {
            int quad = Quadrant$.MODULE$.quadrant(pts[last - 1], pts[last]);
            if (quad == chainQuad) continue;
            return last - 1;
        }
        return last - 1;
    }
}

