/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.index.strtree;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.locationtech.jts.index.ItemVisitor;
import org.locationtech.jts.index.strtree.AbstractNode;
import org.locationtech.jts.index.strtree.AbstractSTRtree$;
import org.locationtech.jts.index.strtree.Boundable;
import org.locationtech.jts.index.strtree.ItemBoundable;
import org.locationtech.jts.util.Assert$;
import scala.Function1;
import scala.UninitializedFieldError;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\tur!\u0002\u001a4\u0011\u0003qd!\u0002!4\u0011\u0003\t\u0005\"\u0002)\u0002\t\u0003\tfa\u0002*\u0002!\u0003\r\na\u0015\u0005\u0006)\u000e1\t!\u0016\u0005\bA\u0006\u0011\r\u0011\"\u0003b\u0011\u0019)\u0017\u0001)A\u0005E\")a-\u0001C\u0001O\"9q.AA\u0001\n\u0013\u0001h!\u0002!4\u0003\u0003q\b\u0002C@\n\u0005\u0003\u0007I\u0011A1\t\u0015\u0005\u0005\u0011B!a\u0001\n\u0003\t\u0019\u0001C\u0005\u0002\u0010%\u0011\t\u0011)Q\u0005E\"1\u0001+\u0003C\u0001\u0003#A\u0011\"a\u0006\n\u0001\u0004%\t\"!\u0007\t\u0013\u0005\u0005\u0012\u00021A\u0005\u0012\u0005\r\u0002\u0002CA\u0014\u0013\u0001\u0006K!a\u0007\t\u0013\u0005%\u0012\u00021A\u0005\n\u0005-\u0002\"CA\u0017\u0013\u0001\u0007I\u0011BA\u0018\u0011\u001d\t\u0019$\u0003Q!\nYC\u0011\"!\u000e\n\u0001\u0004%I!a\u000e\t\u0013\u0005-\u0013\u00021A\u0005\n\u00055\u0003\u0002CA)\u0013\u0001\u0006K!!\u000f\t\rAKA\u0011AA*\u0011\u001d\t)&\u0003C\u0001\u0003/Bq!!\u0017\n\r#\tY\u0006C\u0004\u0002b%!\t\"a\u0019\t\u000f\u0005U\u0014\u0002\"\u0005\u0002x!9\u0011qP\u0005\u0005\n\u0005\u0005\u0005bBAE\u0013\u0011\u0005\u0011\u0011\u0004\u0005\u0007\u0003\u0017KA\u0011A1\t\u000f\u00055\u0015\u0002\"\u0001\u0002,!1\u0011qR\u0005\u0005\u0012\u0005Dq!a$\n\t#\t\t\n\u0003\u0004\u0002\u0018&!\t\"\u0019\u0005\b\u0003/KA\u0011CAM\u0011\u001d\ti*\u0003C\t\u0003?Cq!!+\n\t#\tY\u000bC\u0004\u0002*&!\t\"a-\t\u000f\u0005\r\u0017B\"\u0005\u0002F\"9\u0011Q]\u0005\u0005\n\u0005\u001d\bbBAs\u0013\u0011%\u0011\u0011\u001f\u0005\b\u0003sLA\u0011AA~\u0011\u001d\tI0\u0003C\u0005\u0003{DqA!\u0001\n\t#\u0011\u0019\u0001C\u0004\u0003\n%!IAa\u0003\t\u000f\t\u0005\u0011\u0002\"\u0003\u0003\u0012!9!\u0011D\u0005\u0005\u0012\tm\u0001b\u0002B\r\u0013\u0011%!q\u0004\u0005\b\u0005cIa\u0011\u0003B\u001a\u0003=\t%m\u001d;sC\u000e$8\u000b\u0016*ue\u0016,'B\u0001\u001b6\u0003\u001d\u0019HO\u001d;sK\u0016T!AN\u001c\u0002\u000b%tG-\u001a=\u000b\u0005aJ\u0014a\u00016ug*\u0011!hO\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002y\u0005\u0019qN]4\u0004\u0001A\u0011q(A\u0007\u0002g\ty\u0011IY:ue\u0006\u001cGo\u0015+SiJ,WmE\u0002\u0002\u0005\"\u0003\"a\u0011$\u000e\u0003\u0011S\u0011!R\u0001\u0006g\u000e\fG.Y\u0005\u0003\u000f\u0012\u0013a!\u00118z%\u00164\u0007CA%O\u001b\u0005Q%BA&M\u0003\tIwNC\u0001N\u0003\u0011Q\u0017M^1\n\u0005=S%\u0001D*fe&\fG.\u001b>bE2,\u0017A\u0002\u001fj]&$h\bF\u0001?\u00051Ie\u000e^3sg\u0016\u001cGo](q'\t\u0019!)\u0001\u0006j]R,'o]3diN$2AV-_!\t\u0019u+\u0003\u0002Y\t\n9!i\\8mK\u0006t\u0007\"\u0002.\u0005\u0001\u0004Y\u0016aB1C_VtGm\u001d\t\u0003\u0007rK!!\u0018#\u0003\u0007\u0005s\u0017\u0010C\u0003`\t\u0001\u00071,A\u0004c\u0005>,h\u000eZ:\u0002+\u0011+e)Q+M)~su\nR#`\u0007\u0006\u0003\u0016iQ%U3V\t!\r\u0005\u0002DG&\u0011A\r\u0012\u0002\u0004\u0013:$\u0018A\u0006#F\r\u0006+F\nV0O\u001f\u0012+ulQ!Q\u0003\u000eKE+\u0017\u0011\u0002\u001d\r|W\u000e]1sK\u0012{WO\u00197fgR\u0019!\r[7\t\u000b%<\u0001\u0019\u00016\u0002\u0003\u0005\u0004\"aQ6\n\u00051$%A\u0002#pk\ndW\rC\u0003o\u000f\u0001\u0007!.A\u0001c\u000319(/\u001b;f%\u0016\u0004H.Y2f)\u0005\t\bC\u0001:v\u001b\u0005\u0019(B\u0001;M\u0003\u0011a\u0017M\\4\n\u0005Y\u001c(AB(cU\u0016\u001cG\u000f\u000b\u0003\u0002qnd\bCA\"z\u0013\tQHI\u0001\tTKJL\u0017\r\u001c,feNLwN\\+J\t\u0006)a/\u00197vKzA!\u001aEN8%P^{\t\u000b\u0003\u0001qnd8cA\u0005C\u0011\u0006aan\u001c3f\u0007\u0006\u0004\u0018mY5us\u0006\u0001bn\u001c3f\u0007\u0006\u0004\u0018mY5us~#S-\u001d\u000b\u0005\u0003\u000b\tY\u0001E\u0002D\u0003\u000fI1!!\u0003E\u0005\u0011)f.\u001b;\t\u0011\u000551\"!AA\u0002\t\f1\u0001\u001f\u00132\u00035qw\u000eZ3DCB\f7-\u001b;zAQ!\u00111CA\u000b!\ty\u0014\u0002C\u0003\u0000\u001b\u0001\u0007!-\u0001\u0003s_>$XCAA\u000e!\ry\u0014QD\u0005\u0004\u0003?\u0019$\u0001D!cgR\u0014\u0018m\u0019;O_\u0012,\u0017\u0001\u0003:p_R|F%Z9\u0015\t\u0005\u0015\u0011Q\u0005\u0005\n\u0003\u001by\u0011\u0011!a\u0001\u00037\tQA]8pi\u0002\nQAY;jYR,\u0012AV\u0001\nEVLG\u000e^0%KF$B!!\u0002\u00022!A\u0011Q\u0002\n\u0002\u0002\u0003\u0007a+\u0001\u0004ck&dG\u000fI\u0001\u000fSR,WNQ8v]\u0012\f'\r\\3t+\t\tI\u0004\u0005\u0004\u0002<\u0005\u0005\u0013QI\u0007\u0003\u0003{Q1!a\u0010M\u0003\u0011)H/\u001b7\n\t\u0005\r\u0013Q\b\u0002\n\u0003J\u0014\u0018-\u001f'jgR\u00042aPA$\u0013\r\tIe\r\u0002\n\u0005>,h\u000eZ1cY\u0016\f!#\u001b;f[\n{WO\u001c3bE2,7o\u0018\u0013fcR!\u0011QAA(\u0011%\ti!FA\u0001\u0002\u0004\tI$A\bji\u0016l'i\\;oI\u0006\u0014G.Z:!)\t\t\u0019\"A\u0003ck&dG\r\u0006\u0002\u0002\u0006\u0005Q1M]3bi\u0016tu\u000eZ3\u0015\t\u0005m\u0011Q\f\u0005\u0007\u0003?J\u0002\u0019\u00012\u0002\u000b1,g/\u001a7\u0002-\r\u0014X-\u0019;f!\u0006\u0014XM\u001c;C_VtG-\u00192mKN$b!!\u001a\u0002h\u0005E\u0004CBA\u001e\u0003\u0003\nY\u0002C\u0004\u0002ji\u0001\r!a\u001b\u0002\u001f\rD\u0017\u000e\u001c3C_VtG-\u00192mKN\u0004b!a\u000f\u0002n\u0005\u0015\u0013\u0002BA8\u0003{\u0011A\u0001T5ti\"1\u00111\u000f\u000eA\u0002\t\f\u0001B\\3x\u0019\u00164X\r\\\u0001\tY\u0006\u001cHOT8eKR!\u00111DA=\u0011\u001d\tYh\u0007a\u0001\u0003{\nQA\\8eKN\u0004b!a\u000f\u0002n\u0005m\u0011AE2sK\u0006$X\rS5hQ\u0016\u0014H*\u001a<fYN$b!a\u0007\u0002\u0004\u0006\u001d\u0005bBAC9\u0001\u0007\u00111N\u0001\u0013E>,h\u000eZ1cY\u0016\u001cxJZ!MKZ,G\u000e\u0003\u0004\u0002`q\u0001\rAY\u0001\bO\u0016$(k\\8u\u0003=9W\r\u001e(pI\u0016\u001c\u0015\r]1dSRL\u0018aB5t\u000b6\u0004H/_\u0001\u0005g&TX\rF\u0002c\u0003'Cq!!&\"\u0001\u0004\tY\"\u0001\u0003o_\u0012,\u0017!\u00023faRDGc\u00012\u0002\u001c\"9\u0011QS\u0012A\u0002\u0005m\u0011AB5og\u0016\u0014H\u000fF\u0003W\u0003C\u000b)\u000b\u0003\u0004\u0002$\u0012\u0002\rAQ\u0001\u0007E>,h\u000eZ:\t\r\u0005\u001dF\u00051\u0001\\\u0003\u0011IG/Z7\u0002\u000bE,XM]=\u0015\t\u00055\u0016q\u0016\t\u0006\u0003w\tig\u0017\u0005\u0007\u0003c+\u0003\u0019A.\u0002\u0019M,\u0017M]2i\u0005>,h\u000eZ:\u0015\r\u0005\u0015\u0011QWA\\\u0011\u0019\t\tL\na\u00017\"9\u0011\u0011\u0018\u0014A\u0002\u0005m\u0016a\u0002<jg&$xN\u001d\t\u0005\u0003{\u000by,D\u00016\u0013\r\t\t-\u000e\u0002\f\u0013R,WNV5tSR|'/A\bhKRLe\u000e^3sg\u0016\u001cGo](q+\t\t9\rE\u0002\u0002J\u000eq1!a3\u0001\u001d\u0011\ti-a9\u000f\t\u0005=\u0017\u0011\u001d\b\u0005\u0003#\fyN\u0004\u0003\u0002T\u0006ug\u0002BAk\u00037l!!a6\u000b\u0007\u0005eW(\u0001\u0004=e>|GOP\u0005\u0002y%\u0011!hO\u0005\u0003qeJ!AN\u001c\n\u0005Q*\u0014!D9vKJL\u0018J\u001c;fe:\fG\u000e\u0006\u0005\u0002\u0006\u0005%\u00181^Aw\u0011\u0019\t\t\f\u000ba\u00017\"9\u0011Q\u0013\u0015A\u0002\u0005m\u0001bBAxQ\u0001\u0007\u0011QV\u0001\b[\u0006$8\r[3t)!\t)!a=\u0002v\u0006]\bBBAYS\u0001\u00071\fC\u0004\u0002\u0016&\u0002\r!a\u0007\t\u000f\u0005e\u0016\u00061\u0001\u0002<\u0006I\u0011\u000e^3ngR\u0013X-Z\u000b\u0003\u0003[#B!!,\u0002\u0000\"9\u0011QS\u0016A\u0002\u0005m\u0011A\u0002:f[>4X\rF\u0003W\u0005\u000b\u00119\u0001\u0003\u0004\u000222\u0002\ra\u0017\u0005\u0007\u0003Oc\u0003\u0019A.\u0002\u0015I,Wn\u001c<f\u0013R,W\u000eF\u0003W\u0005\u001b\u0011y\u0001C\u0004\u0002\u00166\u0002\r!a\u0007\t\r\u0005\u001dV\u00061\u0001\\)\u001d1&1\u0003B\u000b\u0005/Aa!!-/\u0001\u0004Y\u0006bBAK]\u0001\u0007\u00111\u0004\u0005\u0007\u0003Os\u0003\u0019A.\u0002#\t|WO\u001c3bE2,7/\u0011;MKZ,G\u000e\u0006\u0003\u0002:\tu\u0001BBA0_\u0001\u0007!\r\u0006\u0005\u0002\u0006\t\u0005\"1\u0005B\u0014\u0011\u0019\ty\u0006\ra\u0001E\"9!Q\u0005\u0019A\u0002\u0005m\u0011a\u0001;pa\"9!\u0011\u0006\u0019A\u0002\t-\u0012A\u00032pk:$\u0017M\u00197fgB1\u00111\bB\u0017\u0003\u000bJAAa\f\u0002>\tQ1i\u001c7mK\u000e$\u0018n\u001c8\u0002\u001b\u001d,GoQ8na\u0006\u0014\u0018\r^8s+\t\u0011)\u0004\u0005\u0004\u0002<\t]\u0012QI\u0005\u0005\u0005s\tiD\u0001\u0006D_6\u0004\u0018M]1u_JDC!\u0003=|y\u0002")
public abstract class AbstractSTRtree
implements Serializable {
    private static final long serialVersionUID = -3886435814360241337L;
    private int nodeCapacity;
    private AbstractNode root;
    private boolean built;
    private ArrayList<Boundable> itemBoundables;
    private volatile byte bitmap$init$0;

    public static int compareDoubles(double d, double d2) {
        return AbstractSTRtree$.MODULE$.compareDoubles(d, d2);
    }

    public int nodeCapacity() {
        return this.nodeCapacity;
    }

    public void nodeCapacity_$eq(int x$1) {
        this.nodeCapacity = x$1;
    }

    public AbstractNode root() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/index/strtree/AbstractSTRtree.scala: 77");
        }
        return this.root;
    }

    public void root_$eq(AbstractNode x$1) {
        this.root = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
    }

    private boolean built() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/index/strtree/AbstractSTRtree.scala: 78");
        }
        return this.built;
    }

    private void built_$eq(boolean x$1) {
        this.built = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
    }

    private ArrayList<Boundable> itemBoundables() {
        if ((byte)(this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/gpp-jts/gpp-jts/modules/jts/src/main/scala/org/locationtech/jts/index/strtree/AbstractSTRtree.scala: 82");
        }
        return this.itemBoundables;
    }

    private void itemBoundables_$eq(ArrayList<Boundable> x$1) {
        this.itemBoundables = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
    }

    public void build() {
        if (this.built()) {
            return;
        }
        this.root_$eq(this.itemBoundables().isEmpty() ? this.createNode(0) : this.createHigherLevels(this.itemBoundables(), -1));
        this.itemBoundables_$eq(null);
        this.built_$eq(true);
    }

    public abstract AbstractNode createNode(int var1);

    /*
     * WARNING - void declaration
     */
    public ArrayList<AbstractNode> createParentBoundables(List<Boundable> childBoundables, int newLevel) {
        void var3_3;
        Assert$.MODULE$.isTrue(!childBoundables.isEmpty());
        ArrayList<AbstractNode> parentBoundables = new ArrayList<AbstractNode>();
        parentBoundables.add(this.createNode(newLevel));
        ArrayList<Boundable> sortedChildBoundables = new ArrayList<Boundable>(childBoundables);
        Collections.sort(sortedChildBoundables, this.getComparator());
        for (Boundable childBoundable : sortedChildBoundables) {
            Object object = this.lastNode(parentBoundables).getChildBoundables().size() == this.getNodeCapacity() ? BoxesRunTime.boxToBoolean((boolean)parentBoundables.add(this.createNode(newLevel))) : BoxedUnit.UNIT;
            this.lastNode(parentBoundables).addChildBoundable(childBoundable);
        }
        return var3_3;
    }

    public AbstractNode lastNode(List<AbstractNode> nodes) {
        return nodes.get(nodes.size() - 1);
    }

    private AbstractNode createHigherLevels(List<Boundable> boundablesOfALevel, int level) {
        while (true) {
            Assert$.MODULE$.isTrue(!boundablesOfALevel.isEmpty());
            ArrayList<AbstractNode> parentBoundables = this.createParentBoundables(boundablesOfALevel, level + 1);
            if (parentBoundables.size() == 1) {
                return parentBoundables.get(0);
            }
            ++level;
            boundablesOfALevel = CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala(parentBoundables).asScala().map((Function1 & Serializable)x -> x)).asJava();
        }
    }

    public AbstractNode getRoot() {
        this.build();
        return this.root();
    }

    public int getNodeCapacity() {
        return this.nodeCapacity();
    }

    public boolean isEmpty() {
        if (!this.built()) {
            return this.itemBoundables().isEmpty();
        }
        return this.root().isEmpty();
    }

    public int size() {
        if (this.isEmpty()) {
            return 0;
        }
        this.build();
        return this.size(this.root());
    }

    /*
     * WARNING - void declaration
     */
    public int size(AbstractNode node) {
        void var2_2;
        int vsize = 0;
        for (Boundable childBoundable : node.getChildBoundables()) {
            if (childBoundable instanceof AbstractNode) {
                vsize += this.size((AbstractNode)childBoundable);
                continue;
            }
            if (!(childBoundable instanceof ItemBoundable)) continue;
            ++vsize;
        }
        return (int)var2_2;
    }

    public int depth() {
        if (this.isEmpty()) {
            return 0;
        }
        this.build();
        return this.depth(this.root());
    }

    public int depth(AbstractNode node) {
        int maxChildDepth = 0;
        for (Boundable childBoundable : node.getChildBoundables()) {
            int childDepth;
            if (!(childBoundable instanceof AbstractNode) || (childDepth = this.depth((AbstractNode)childBoundable)) <= maxChildDepth) continue;
            maxChildDepth = childDepth;
        }
        return maxChildDepth + 1;
    }

    public boolean insert(Object bounds, Object item) {
        Assert$.MODULE$.isTrue(!this.built(), "Cannot insert items into an STR packed R-tree after it has been built.");
        return this.itemBoundables().add(new ItemBoundable(bounds, item));
    }

    /*
     * WARNING - void declaration
     */
    public List<Object> query(Object searchBounds) {
        void var2_2;
        block1: {
            this.build();
            ArrayList<Object> matches = new ArrayList<Object>();
            if (this.isEmpty()) {
                return matches;
            }
            if (!this.getIntersectsOp().intersects(this.root().getBounds(), searchBounds)) break block1;
            this.queryInternal(searchBounds, this.root(), matches);
        }
        return var2_2;
    }

    public void query(Object searchBounds, ItemVisitor visitor) {
        block1: {
            this.build();
            if (this.isEmpty()) {
                return;
            }
            if (!this.getIntersectsOp().intersects(this.root().getBounds(), searchBounds)) break block1;
            this.queryInternal(searchBounds, this.root(), visitor);
        }
    }

    public abstract IntersectsOp getIntersectsOp();

    private void queryInternal(Object searchBounds, AbstractNode node, List<Object> matches) {
        ArrayList<Boundable> childBoundables = node.getChildBoundables();
        for (int i = 0; i < childBoundables.size(); ++i) {
            Object object;
            Boundable childBoundable = childBoundables.get(i);
            if (this.getIntersectsOp().intersects(childBoundable.getBounds(), searchBounds)) {
                if (childBoundable instanceof AbstractNode) {
                    this.queryInternal(searchBounds, (AbstractNode)childBoundable, matches);
                    object = BoxedUnit.UNIT;
                    continue;
                }
                if (childBoundable instanceof ItemBoundable) {
                    object = BoxesRunTime.boxToBoolean((boolean)matches.add(((ItemBoundable)childBoundable).getItem()));
                    continue;
                }
                Assert$.MODULE$.shouldNeverReachHere();
                object = BoxedUnit.UNIT;
                continue;
            }
            object = BoxedUnit.UNIT;
        }
    }

    private void queryInternal(Object searchBounds, AbstractNode node, ItemVisitor visitor) {
        ArrayList<Boundable> childBoundables = node.getChildBoundables();
        for (int i = 0; i < childBoundables.size(); ++i) {
            Boundable childBoundable = childBoundables.get(i);
            if (!this.getIntersectsOp().intersects(childBoundable.getBounds(), searchBounds)) continue;
            if (childBoundable instanceof AbstractNode) {
                this.queryInternal(searchBounds, (AbstractNode)childBoundable, visitor);
                continue;
            }
            if (childBoundable instanceof ItemBoundable) {
                visitor.visitItem(((ItemBoundable)childBoundable).getItem());
                continue;
            }
            Assert$.MODULE$.shouldNeverReachHere();
        }
    }

    /*
     * WARNING - void declaration
     */
    public List<Object> itemsTree() {
        void var1_1;
        this.build();
        List<Object> valuesTree = this.itemsTree(this.root());
        if (valuesTree == null) {
            return new ArrayList<Object>();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private List<Object> itemsTree(AbstractNode node) {
        void var2_2;
        ArrayList<Object> valuesTreeForNode = new ArrayList<Object>();
        for (Boundable childBoundable : node.getChildBoundables()) {
            Object object;
            if (childBoundable instanceof AbstractNode) {
                List<Object> valuesTreeForChild = this.itemsTree((AbstractNode)childBoundable);
                if (valuesTreeForChild != null) {
                    object = BoxesRunTime.boxToBoolean((boolean)valuesTreeForNode.add(valuesTreeForChild));
                    continue;
                }
                object = BoxedUnit.UNIT;
                continue;
            }
            if (childBoundable instanceof ItemBoundable) {
                object = BoxesRunTime.boxToBoolean((boolean)valuesTreeForNode.add(((ItemBoundable)childBoundable).getItem()));
                continue;
            }
            Assert$.MODULE$.shouldNeverReachHere();
            object = BoxedUnit.UNIT;
        }
        if (valuesTreeForNode.size() <= 0) {
            return null;
        }
        return var2_2;
    }

    public boolean remove(Object searchBounds, Object item) {
        this.build();
        if (this.getIntersectsOp().intersects(this.root().getBounds(), searchBounds)) {
            return this.remove(searchBounds, this.root(), item);
        }
        return false;
    }

    private boolean removeItem(AbstractNode node, Object item) {
        Boundable childToRemove = null;
        for (Boundable childBoundable : node.getChildBoundables()) {
            if (!(childBoundable instanceof ItemBoundable) || !BoxesRunTime.equals((Object)((ItemBoundable)childBoundable).getItem(), (Object)item)) continue;
            childToRemove = childBoundable;
        }
        if (childToRemove != null) {
            node.getChildBoundables().remove(childToRemove);
            return true;
        }
        return false;
    }

    private boolean remove(Object searchBounds, AbstractNode node, Object item) {
        boolean found = this.removeItem(node, item);
        if (found) {
            return true;
        }
        AbstractNode childToPrune = null;
        Iterator<Boundable> i = node.getChildBoundables().iterator();
        boolean shouldBreak = false;
        while (i.hasNext() && !shouldBreak) {
            Boundable childBoundable = i.next();
            if (!this.getIntersectsOp().intersects(childBoundable.getBounds(), searchBounds) || !(childBoundable instanceof AbstractNode) || !(found = this.remove(searchBounds, (AbstractNode)childBoundable, item))) continue;
            childToPrune = (AbstractNode)childBoundable;
            shouldBreak = true;
        }
        Object object = childToPrune != null ? (childToPrune.getChildBoundables().isEmpty() ? BoxesRunTime.boxToBoolean((boolean)node.getChildBoundables().remove(childToPrune)) : BoxedUnit.UNIT) : BoxedUnit.UNIT;
        return found;
    }

    /*
     * WARNING - void declaration
     */
    public ArrayList<Boundable> boundablesAtLevel(int level) {
        void var2_2;
        ArrayList<Boundable> boundables = new ArrayList<Boundable>();
        this.boundablesAtLevel(level, this.root(), boundables);
        return var2_2;
    }

    private void boundablesAtLevel(int level, AbstractNode top, Collection<Boundable> boundables) {
        Assert$.MODULE$.isTrue(level > -2);
        if (top.getLevel() == level) {
            boundables.add(top);
            return;
        }
        for (Boundable boundable : top.getChildBoundables()) {
            Object object;
            if (boundable instanceof AbstractNode) {
                this.boundablesAtLevel(level, (AbstractNode)boundable, boundables);
                object = BoxedUnit.UNIT;
                continue;
            }
            Assert$.MODULE$.isTrue(boundable instanceof ItemBoundable);
            object = level == -1 ? BoxesRunTime.boxToBoolean((boolean)boundables.add(boundable)) : BoxedUnit.UNIT;
        }
    }

    public abstract Comparator<Boundable> getComparator();

    public AbstractSTRtree(int nodeCapacity) {
        this.nodeCapacity = nodeCapacity;
        Assert$.MODULE$.isTrue(this.nodeCapacity() > 1, "Node capacity must be greater than 1");
        this.root = null;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.built = false;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.itemBoundables = new ArrayList();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
    }

    public AbstractSTRtree() {
        this(AbstractSTRtree$.MODULE$.org$locationtech$jts$index$strtree$AbstractSTRtree$$DEFAULT_NODE_CAPACITY());
    }

    public static interface IntersectsOp {
        public boolean intersects(Object var1, Object var2);
    }
}

