/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.index.strtree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.index.ItemVisitor;
import org.locationtech.jts.index.SpatialIndex;
import org.locationtech.jts.index.strtree.AbstractNode;
import org.locationtech.jts.index.strtree.AbstractSTRtree;
import org.locationtech.jts.index.strtree.Boundable;
import org.locationtech.jts.index.strtree.BoundablePair;
import org.locationtech.jts.index.strtree.ItemBoundable;
import org.locationtech.jts.index.strtree.ItemDistance;
import org.locationtech.jts.index.strtree.STRtree$;
import org.locationtech.jts.util.Assert$;
import org.locationtech.jts.util.PriorityQueue;
import scala.Array$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t\u001du!\u0002\u00192\u0011\u0003ad!\u0002 2\u0011\u0003y\u0004\"\u0002(\u0002\t\u0003ye\u0001\u0002)\u0002\u0005EC\u0001\"V\u0002\u0003\u0006\u0004%\tA\u0016\u0005\t5\u000e\u0011\t\u0011)A\u0005/\")aj\u0001C\u00017\")ql\u0001C)A\"9q-\u0001b\u0001\n\u0013A\u0007B\u00027\u0002A\u0003%\u0011\u000eC\u0004}\u0003\t\u0007I\u0011B?\t\u000f\u0005\u0005\u0011\u0001)A\u0005}\"9\u00111A\u0001\u0005\n\u0005\u0015\u0001bBA\t\u0003\u0011%\u00111\u0003\u0005\b\u0003/\tA\u0011BA\r\u0011%\t\u0019#\u0001b\u0001\n\u0013\t)\u0003\u0003\u0005\u0002,\u0005\u0001\u000b\u0011BA\u0014\u0011!\tY$\u0001b\u0001\n\u00131\u0006bBA\u001f\u0003\u0001\u0006Ia\u0016\u0005\b\u0003\u007f\tA\u0011BA!\u0011%\ti&AA\u0001\n\u0013\tyFB\u0003?c\u0001\ty\u0007C\u0005\u0002\u0000U\u0011)\u0019!C\u0001-\"I\u0011\u0011Q\u000b\u0003\u0002\u0003\u0006Ia\u0016\u0005\u0007\u001dV!\t!a!\t\u000f\u0005%U\u0003\"\u0015\u0002\f\"9\u0011\u0011U\u000b\u0005\n\u0005\r\u0006bBAW+\u0011E\u0011q\u0016\u0005\b\u0003O+B\u0011CA[\u0011\u0019qU\u0003\"\u0001\u0002>\"9\u0011qX\u000b\u0005R\u0005\u0005\u0007bBAe+\u0011E\u00131\u001a\u0005\b\u0003W,B\u0011IAw\u0011\u001d\ti0\u0006C!\u0003\u007fDq!!@\u0016\t\u0003\u00129\u0001C\u0004\u0003\u0016U!\tEa\u0006\t\r\tuQ\u0003\"\u0011W\u0011\u0019\u0011y\"\u0006C!-\"9!\u0011E\u000b\u0005R\t\r\u0002b\u0002B\u0013+\u0011\u0005!q\u0005\u0005\b\u0005K)B\u0011\u0001B\u001a\u0011\u001d\u0011)#\u0006C\u0001\u0005{AqA!\n\u0016\t\u0013\u0011)\u0005C\u0004\u0003RU!\tAa\u0015\t\u000f\tES\u0003\"\u0003\u0003d!9!QE\u000b\u0005\u0002\t%\u0004b\u0002B;+\u0011%!q\u000f\u0005\b\u0005k*B\u0011\u0002B?\u0003\u001d\u0019FK\u0015;sK\u0016T!AM\u001a\u0002\u000fM$(\u000f\u001e:fK*\u0011A'N\u0001\u0006S:$W\r\u001f\u0006\u0003m]\n1A\u001b;t\u0015\tA\u0014(\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001;\u0003\ry'oZ\u0002\u0001!\ti\u0014!D\u00012\u0005\u001d\u0019FK\u0015;sK\u0016\u001c2!\u0001!G!\t\tE)D\u0001C\u0015\u0005\u0019\u0015!B:dC2\f\u0017BA#C\u0005\u0019\te.\u001f*fMB\u0011q\tT\u0007\u0002\u0011*\u0011\u0011JS\u0001\u0003S>T\u0011aS\u0001\u0005U\u00064\u0018-\u0003\u0002N\u0011\na1+\u001a:jC2L'0\u00192mK\u00061A(\u001b8jiz\"\u0012\u0001\u0010\u0002\f'R\u0013FO]3f\u001d>$Wm\u0005\u0002\u0004%B\u0011QhU\u0005\u0003)F\u0012A\"\u00112tiJ\f7\r\u001e(pI\u0016\fQ\u0001\\3wK2,\u0012a\u0016\t\u0003\u0003bK!!\u0017\"\u0003\u0007%sG/\u0001\u0004mKZ,G\u000e\t\u000b\u00039z\u0003\"!X\u0002\u000e\u0003\u0005AQ!\u0016\u0004A\u0002]\u000bQbY8naV$XMQ8v]\u0012\u001cX#A1\u0011\u0005\t,W\"A2\u000b\u0005\u0011,\u0014\u0001B4f_6L!AZ2\u0003\u0011\u0015sg/\u001a7pa\u0016\f1\u0002_\"p[B\f'/\u0019;peV\t\u0011NE\u0002k[N4Aa[\u0005\u0001S\naAH]3gS:,W.\u001a8u}\u0005a\u0001pQ8na\u0006\u0014\u0018\r^8sAA\u0011a.]\u0007\u0002_*\u0011\u0001OS\u0001\u0005Y\u0006tw-\u0003\u0002s_\n1qJ\u00196fGR\u00042\u0001^<z\u001b\u0005)(B\u0001<K\u0003\u0011)H/\u001b7\n\u0005a,(AC\"p[B\f'/\u0019;peB\u0011QH_\u0005\u0003wF\u0012\u0011BQ8v]\u0012\f'\r\\3\u0002\u0017e\u001cu.\u001c9be\u0006$xN]\u000b\u0002}J\u0019q0\\:\u0007\t-\\\u0001A`\u0001\rs\u000e{W\u000e]1sCR|'\u000fI\u0001\bG\u0016tGO]3Y)\u0011\t9!!\u0004\u0011\u0007\u0005\u000bI!C\u0002\u0002\f\t\u0013a\u0001R8vE2,\u0007BBA\b\u0019\u0001\u0007\u0011-A\u0001f\u0003\u001d\u0019WM\u001c;sKf#B!a\u0002\u0002\u0016!1\u0011qB\u0007A\u0002\u0005\f1!\u0019<h)\u0019\t9!a\u0007\u0002 !9\u0011Q\u0004\bA\u0002\u0005\u001d\u0011!A1\t\u000f\u0005\u0005b\u00021\u0001\u0002\b\u0005\t!-\u0001\u0007j]R,'o]3diN|\u0005/\u0006\u0002\u0002(I)\u0011\u0011\u0006!\u0002.\u0019)1\u000e\u0005\u0001\u0002(\u0005i\u0011N\u001c;feN,7\r^:Pa\u0002\u0002B!a\f\u000269\u0019Q(!\r\n\u0007\u0005M\u0012'A\bBEN$(/Y2u'R\u0013FO]3f\u0013\u0011\t9$!\u000f\u0003\u0019%sG/\u001a:tK\u000e$8o\u00149\u000b\u0007\u0005M\u0012'A\u000bE\u000b\u001a\u000bU\u000b\u0014+`\u001d>#UiX\"B!\u0006\u001b\u0015\nV-\u0002-\u0011+e)Q+M)~su\nR#`\u0007\u0006\u0003\u0016iQ%U3\u0002\n\u0001bZ3u\u0013R,Wn\u001d\u000b\u0005\u0003\u0007\ny\u0005E\u0003B\u0003\u000b\nI%C\u0002\u0002H\t\u0013Q!\u0011:sCf\u00042!QA&\u0013\r\tiE\u0011\u0002\u0004\u0003:L\bbBA)'\u0001\u0007\u00111K\u0001\u0012W:+\u0017M]3ti:+\u0017n\u001a5c_J\u001c\b\u0003BA+\u00033j!!a\u0016\u000b\u0005Y,\u0014\u0002BA.\u0003/\u0012Q\u0002\u0015:j_JLG/_)vKV,\u0017\u0001D<sSR,'+\u001a9mC\u000e,G#A7)\u000f\u0005\t\u0019'!\u001b\u0002lA\u0019\u0011)!\u001a\n\u0007\u0005\u001d$I\u0001\tTKJL\u0017\r\u001c,feNLwN\\+J\t\u0006)a/\u00197vKzA1!'\u0011x,L\u0010G\u001dK\u0004\u0001\u0003G\nI'a\u001b\u0014\rU\t\t(a\u001eG!\ri\u00141O\u0005\u0004\u0003k\n$aD!cgR\u0014\u0018m\u0019;T)J#(/Z3\u0011\r\u0005e\u00141PA%\u001b\u0005\u0019\u0014bAA?g\ta1\u000b]1uS\u0006d\u0017J\u001c3fq\u0006yan\u001c3f\u0007\u0006\u0004\u0018mY5us\u0006\u0013x-\u0001\to_\u0012,7)\u00199bG&$\u00180\u0011:hAQ!\u0011QQAD!\tiT\u0003\u0003\u0004\u0002\u0000a\u0001\raV\u0001\u0017GJ,\u0017\r^3QCJ,g\u000e\u001e\"pk:$\u0017M\u00197fgR1\u0011QRAJ\u0003;\u0003B\u0001^AH%&\u0019\u0011\u0011S;\u0003\u0013\u0005\u0013(/Y=MSN$\bbBAK3\u0001\u0007\u0011qS\u0001\u0010G\"LG\u000e\u001a\"pk:$\u0017M\u00197fgB!A/!'z\u0013\r\tY*\u001e\u0002\u0005\u0019&\u001cH\u000f\u0003\u0004\u0002 f\u0001\raV\u0001\t]\u0016<H*\u001a<fY\u0006A3M]3bi\u0016\u0004\u0016M]3oi\n{WO\u001c3bE2,7O\u0012:p[Z+'\u000f^5dC2\u001cF.[2fgR1\u0011QRAS\u0003WCq!a*\u001b\u0001\u0004\tI+\u0001\bwKJ$\u0018nY1m'2L7-Z:\u0011\u000b\u0005\u000b)%a&\t\r\u0005}%\u00041\u0001X\u0003\u001d\u001a'/Z1uKB\u000b'/\u001a8u\u0005>,h\u000eZ1cY\u0016\u001chI]8n-\u0016\u0014H/[2bYNc\u0017nY3\u0015\r\u00055\u0015\u0011WAZ\u0011\u001d\t)j\u0007a\u0001\u0003/Ca!a(\u001c\u0001\u00049FCBAU\u0003o\u000bI\fC\u0004\u0002\u0016r\u0001\r!a&\t\r\u0005mF\u00041\u0001X\u0003)\u0019H.[2f\u0007>,h\u000e\u001e\u000b\u0003\u0003\u000b\u000b!b\u0019:fCR,gj\u001c3f)\u0011\t\u0019-a2\u0011\u0007\u0005\u00157A\u0004\u0002>\u0001!)QK\ba\u0001/\u0006yq-\u001a;J]R,'o]3diN|\u0005/\u0006\u0002\u0002NB!\u0011qZA\u001b\u001d\u0011\t\t.!\r\u000f\t\u0005M\u0017\u0011\u001e\b\u0005\u0003+\f9O\u0004\u0003\u0002X\u0006\u0015h\u0002BAm\u0003GtA!a7\u0002b6\u0011\u0011Q\u001c\u0006\u0004\u0003?\\\u0014A\u0002\u001fs_>$h(C\u0001;\u0013\tA\u0014(\u0003\u00027o%\u0011A'N\u0005\u0003eM\na!\u001b8tKJ$HCBAx\u0003k\fI\u0010E\u0002B\u0003cL1!a=C\u0005\u0011)f.\u001b;\t\r\u0005]\b\u00051\u0001b\u0003\u001dIG/Z7F]ZDq!a?!\u0001\u0004\tI%\u0001\u0003ji\u0016l\u0017!B9vKJLH\u0003\u0002B\u0001\u0005\u0007\u0001R\u0001^AM\u0003\u0013BaA!\u0002\"\u0001\u0004\t\u0017!C:fCJ\u001c\u0007.\u00128w)\u0019\tyO!\u0003\u0003\f!1!Q\u0001\u0012A\u0002\u0005DqA!\u0004#\u0001\u0004\u0011y!A\u0004wSNLGo\u001c:\u0011\t\u0005e$\u0011C\u0005\u0004\u0005'\u0019$aC%uK64\u0016n]5u_J\faA]3n_Z,GCBAx\u00053\u0011Y\u0002\u0003\u0004\u0002x\u000e\u0002\r!\u0019\u0005\b\u0003w\u001c\u0003\u0019AA%\u0003\u0011\u0019\u0018N_3\u0002\u000b\u0011,\u0007\u000f\u001e5\u0002\u001b\u001d,GoQ8na\u0006\u0014\u0018\r^8s+\u0005\u0019\u0018\u0001\u00058fCJ,7\u000f\u001e(fS\u001eD'm\\;s)\u0011\t\u0019E!\u000b\t\u000f\t-r\u00051\u0001\u0003.\u0005A\u0011\u000e^3n\t&\u001cH\u000fE\u0002>\u0005_I1A!\r2\u00051IE/Z7ESN$\u0018M\\2f)!\tIE!\u000e\u0003:\tm\u0002B\u0002B\u001cQ\u0001\u0007\u0011-A\u0002f]ZDq!a?)\u0001\u0004\tI\u0005C\u0004\u0003,!\u0002\rA!\f\u0015\r\u0005\r#q\bB\"\u0011\u001d\u0011\t%\u000ba\u0001\u0003\u000b\u000bA\u0001\u001e:fK\"9!1F\u0015A\u0002\t5B\u0003BA\"\u0005\u000fBqA!\u0013+\u0001\u0004\u0011Y%A\u0006j]&$(I\u001c3QC&\u0014\bcA\u001f\u0003N%\u0019!qJ\u0019\u0003\u001b\t{WO\u001c3bE2,\u0007+Y5s\u0003AI7oV5uQ&tG)[:uC:\u001cW\r\u0006\u0005\u0003V\tm#Q\fB0!\r\t%qK\u0005\u0004\u00053\u0012%a\u0002\"p_2,\u0017M\u001c\u0005\b\u0005\u0003Z\u0003\u0019AAC\u0011\u001d\u0011Yc\u000ba\u0001\u0005[AqA!\u0019,\u0001\u0004\t9!A\u0006nCb$\u0015n\u001d;b]\u000e,GC\u0002B+\u0005K\u00129\u0007C\u0004\u0003J1\u0002\rAa\u0013\t\u000f\t\u0005D\u00061\u0001\u0002\bQQ\u00111\tB6\u0005[\u0012yG!\u001d\t\r\t]R\u00061\u0001b\u0011\u001d\tY0\fa\u0001\u0003\u0013BqAa\u000b.\u0001\u0004\u0011i\u0003\u0003\u0004\u0003t5\u0002\raV\u0001\u0002W\u0006\tb.Z1sKN$h*Z5hQ\n|WO]&\u0015\r\u0005\r#\u0011\u0010B>\u0011\u001d\u0011IE\fa\u0001\u0005\u0017BaAa\u001d/\u0001\u00049F\u0003CA\"\u0005\u007f\u0012\tIa!\t\u000f\t%s\u00061\u0001\u0003L!9!\u0011M\u0018A\u0002\u0005\u001d\u0001B\u0002B:_\u0001\u0007q\u000bK\u0004\u0016\u0003G\nI'a\u001b")
public class STRtree
extends AbstractSTRtree
implements SpatialIndex<Object> {
    private static final long serialVersionUID = 259274702368956900L;
    private final int nodeCapacityArg;

    public int nodeCapacityArg() {
        return this.nodeCapacityArg;
    }

    @Override
    public ArrayList<AbstractNode> createParentBoundables(List<Boundable> childBoundables, int newLevel) {
        Assert$.MODULE$.isTrue(!childBoundables.isEmpty());
        int minLeafCount = (int)Math.ceil((double)childBoundables.size() / (double)this.getNodeCapacity());
        ArrayList<Boundable> sortedChildBoundables = new ArrayList<Boundable>(childBoundables);
        Collections.sort(sortedChildBoundables, STRtree$.MODULE$.org$locationtech$jts$index$strtree$STRtree$$xComparator());
        List<Boundable>[] vverticalSlices = this.verticalSlices(sortedChildBoundables, (int)Math.ceil(Math.sqrt(minLeafCount)));
        return this.createParentBoundablesFromVerticalSlices(vverticalSlices, newLevel);
    }

    /*
     * WARNING - void declaration
     */
    private ArrayList<AbstractNode> createParentBoundablesFromVerticalSlices(List<Boundable>[] verticalSlices, int newLevel) {
        void var3_3;
        Assert$.MODULE$.isTrue(verticalSlices.length > 0);
        ArrayList<AbstractNode> parentBoundables = new ArrayList<AbstractNode>();
        for (int i = 0; i < verticalSlices.length; ++i) {
            parentBoundables.addAll(this.createParentBoundablesFromVerticalSlice(verticalSlices[i], newLevel));
        }
        return var3_3;
    }

    public ArrayList<AbstractNode> createParentBoundablesFromVerticalSlice(List<Boundable> childBoundables, int newLevel) {
        return super.createParentBoundables(childBoundables, newLevel);
    }

    public List<Boundable>[] verticalSlices(List<Boundable> childBoundables, int sliceCount) {
        int sliceCapacity = (int)Math.ceil((double)childBoundables.size() / (double)sliceCount);
        List[] slices = new List[sliceCount];
        Iterator<Boundable> i = childBoundables.iterator();
        for (int j = 0; j < sliceCount; ++j) {
            slices[j] = new ArrayList();
            for (int boundablesAddedToSlice = 0; i.hasNext() && boundablesAddedToSlice < sliceCapacity; ++boundablesAddedToSlice) {
                Boundable childBoundable = i.next();
                slices[j].add(childBoundable);
            }
        }
        return slices;
    }

    @Override
    public STRtreeNode createNode(int level) {
        return new STRtreeNode(level);
    }

    @Override
    public AbstractSTRtree.IntersectsOp getIntersectsOp() {
        return STRtree$.MODULE$.org$locationtech$jts$index$strtree$STRtree$$intersectsOp();
    }

    @Override
    public void insert(Envelope itemEnv, Object item) {
        if (itemEnv.isNull()) {
            return;
        }
        super.insert(itemEnv, item);
    }

    @Override
    public List<Object> query(Envelope searchEnv) {
        return super.query(searchEnv);
    }

    @Override
    public void query(Envelope searchEnv, ItemVisitor visitor) {
        super.query(searchEnv, visitor);
    }

    @Override
    public void remove(Envelope itemEnv, Object item) {
        super.remove(itemEnv, item);
    }

    @Override
    public int size() {
        return super.size();
    }

    @Override
    public int depth() {
        return super.depth();
    }

    @Override
    public Comparator<Boundable> getComparator() {
        return STRtree$.MODULE$.org$locationtech$jts$index$strtree$STRtree$$yComparator();
    }

    public Object[] nearestNeighbour(ItemDistance itemDist) {
        if (this.isEmpty()) {
            return null;
        }
        BoundablePair bp = new BoundablePair(this.getRoot(), this.getRoot(), itemDist);
        return this.nearestNeighbour(bp);
    }

    public Object nearestNeighbour(Envelope env, Object item, ItemDistance itemDist) {
        ItemBoundable bnd = new ItemBoundable(env, item);
        BoundablePair bp = new BoundablePair(this.getRoot(), bnd, itemDist);
        return this.nearestNeighbour(bp)[0];
    }

    public Object[] nearestNeighbour(STRtree tree, ItemDistance itemDist) {
        if (this.isEmpty() || tree.isEmpty()) {
            return null;
        }
        BoundablePair bp = new BoundablePair(this.getRoot(), tree.getRoot(), itemDist);
        return this.nearestNeighbour(bp);
    }

    private Object[] nearestNeighbour(BoundablePair initBndPair) {
        double distanceLowerBound = Double.POSITIVE_INFINITY;
        BoundablePair minPair = null;
        PriorityQueue priQ = new PriorityQueue();
        priQ.add(initBndPair);
        while (!priQ.isEmpty() && distanceLowerBound > 0.0) {
            BoundablePair bndPair = priQ.poll();
            double pairDistance = bndPair.getDistance();
            if (pairDistance >= distanceLowerBound) {
                distanceLowerBound = 1.0;
                continue;
            }
            if (bndPair.isLeaves()) {
                distanceLowerBound = pairDistance;
                minPair = bndPair;
                continue;
            }
            bndPair.expandToQueue(priQ, distanceLowerBound);
        }
        if (minPair == null) {
            return null;
        }
        return (Object[])Array$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{((ItemBoundable)minPair.getBoundable(0)).getItem(), ((ItemBoundable)minPair.getBoundable(1)).getItem()}), ClassTag$.MODULE$.Any());
    }

    public boolean isWithinDistance(STRtree tree, ItemDistance itemDist, double maxDistance) {
        BoundablePair bp = new BoundablePair(this.getRoot(), tree.getRoot(), itemDist);
        return this.isWithinDistance(bp, maxDistance);
    }

    private boolean isWithinDistance(BoundablePair initBndPair, double maxDistance) {
        double distanceUpperBound = Double.POSITIVE_INFINITY;
        PriorityQueue priQ = new PriorityQueue();
        priQ.add(initBndPair);
        while (!priQ.isEmpty()) {
            BoundablePair bndPair = priQ.poll();
            double pairDistance = bndPair.getDistance();
            if (pairDistance > maxDistance) {
                return false;
            }
            if (bndPair.maximumDistance() <= maxDistance) {
                return true;
            }
            if (bndPair.isLeaves()) {
                distanceUpperBound = pairDistance;
                if (!(distanceUpperBound <= maxDistance)) continue;
                return true;
            }
            bndPair.expandToQueue(priQ, distanceUpperBound);
        }
        return false;
    }

    public Object[] nearestNeighbour(Envelope env, Object item, ItemDistance itemDist, int k) {
        ItemBoundable bnd = new ItemBoundable(env, item);
        BoundablePair bp = new BoundablePair(this.getRoot(), bnd, itemDist);
        return this.nearestNeighbourK(bp, k);
    }

    private Object[] nearestNeighbourK(BoundablePair initBndPair, int k) {
        return this.nearestNeighbourK(initBndPair, Double.POSITIVE_INFINITY, k);
    }

    private Object[] nearestNeighbourK(BoundablePair initBndPair, double maxDistance, int k) {
        double distanceLowerBound = maxDistance;
        PriorityQueue priQ = new PriorityQueue();
        priQ.add(initBndPair);
        PriorityQueue kNearestNeighbors = new PriorityQueue();
        while (!priQ.isEmpty() && distanceLowerBound >= 0.0) {
            Object object;
            BoundablePair bndPair = priQ.poll();
            double pairDistance = bndPair.getDistance();
            if (pairDistance >= distanceLowerBound) {
                distanceLowerBound = 11.0;
                object = BoxedUnit.UNIT;
                continue;
            }
            if (bndPair.isLeaves()) {
                Object object2;
                if (kNearestNeighbors.size() < k) {
                    object = kNearestNeighbors.add(bndPair);
                    continue;
                }
                BoundablePair bp1 = kNearestNeighbors.peek();
                if (bp1.getDistance() > pairDistance) {
                    kNearestNeighbors.poll();
                    object2 = kNearestNeighbors.add(bndPair);
                } else {
                    object2 = BoxedUnit.UNIT;
                }
                BoundablePair bp2 = kNearestNeighbors.peek();
                distanceLowerBound = bp2.getDistance();
                object = BoxedUnit.UNIT;
                continue;
            }
            bndPair.expandToQueue(priQ, distanceLowerBound);
            object = BoxedUnit.UNIT;
        }
        return STRtree$.MODULE$.org$locationtech$jts$index$strtree$STRtree$$getItems(kNearestNeighbors);
    }

    public STRtree(int nodeCapacityArg) {
        this.nodeCapacityArg = nodeCapacityArg;
        super(nodeCapacityArg);
    }

    public STRtree() {
        this(STRtree$.MODULE$.org$locationtech$jts$index$strtree$STRtree$$DEFAULT_NODE_CAPACITY());
    }

    public static final class STRtreeNode
    extends AbstractNode {
        private final int level;

        public int level() {
            return this.level;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Envelope computeBounds() {
            void var1_1;
            Envelope bounds = null;
            for (Boundable childBoundable : this.getChildBoundables()) {
                if (bounds == null) {
                    bounds = new Envelope((Envelope)childBoundable.getBounds());
                    continue;
                }
                bounds.expandToInclude((Envelope)childBoundable.getBounds());
            }
            return var1_1;
        }

        public STRtreeNode(int level) {
            this.level = level;
            super(level);
        }
    }
}

