/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.math;

public final class Matrix$ {
    public static final Matrix$ MODULE$ = new Matrix$();

    private void swapRows(double[][] m, int i, int j) {
        if (i == j) {
            return;
        }
        for (int col = 0; col < m[0].length; ++col) {
            double temp = m[i][col];
            m[i][col] = m[j][col];
            m[j][col] = temp;
        }
    }

    private void swapRows(double[] m, int i, int j) {
        if (i == j) {
            return;
        }
        double temp = m[i];
        m[i] = m[j];
        m[j] = temp;
    }

    public double[] solve(double[][] a, double[] b) {
        int n = b.length;
        if (a.length != n || a[0].length != n) {
            throw new IllegalArgumentException("Matrix A is incorrectly sized");
        }
        int i = 0;
        while (i < n) {
            int j;
            int maxElementRow = i;
            for (j = i + 1; j < n; ++j) {
                if (!(Math.abs(a[j][i]) > Math.abs(a[maxElementRow][i]))) continue;
                maxElementRow = j;
            }
            if (a[maxElementRow][i] == 0.0) {
                return null;
            }
            this.swapRows(a, i, maxElementRow);
            this.swapRows(b, i, maxElementRow);
            j = i + 1;
            while (j < n) {
                double rowFactor = a[j][i] / a[i][i];
                int k = n - 1;
                while (k >= i) {
                    double[] dArray = a[j];
                    int n2 = k;
                    dArray[n2] = dArray[n2] - a[i][k] * rowFactor;
                }
                --k;
                int n3 = j++;
                b[n3] = b[n3] - b[i] * rowFactor;
            }
            int cfr_ignored_0 = ++i - 1;
        }
        double[] solution = new double[n];
        for (int j = n - 1; j >= 0; --j) {
            double t = 0.0;
            int k = j + 1;
            while (k < n) {
                t += a[j][k] * solution[k];
            }
            ++k;
            solution[j] = (b[j] - t) / a[j][j];
        }
        return solution;
    }

    private Matrix$() {
    }
}

